/*
 * Decompiled with CFR 0.152.
 */
package utils;

import com.xericker.mysteryboxes.compiled.NBTEditor;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;

public class PlayerUtils {
    public static void cleansePlayer(Player player) {
        AttributeInstance attributeInstance = player.getAttribute(Attribute.GENERIC_MAX_HEALTH);
        if (attributeInstance != null) {
            attributeInstance.setBaseValue(attributeInstance.getDefaultValue());
            player.setHealth(attributeInstance.getDefaultValue());
        }
        player.setHealthScaled(false);
        player.setFoodLevel(20);
        player.setSaturation((float)player.getFoodLevel());
        player.setLevel(0);
        player.setExp(0.0f);
        player.setExhaustion(0.0f);
        player.setFireTicks(0);
        player.setFallDistance(0.0f);
        player.setNoDamageTicks(0);
        player.setInvisible(false);
        player.setInvulnerable(false);
        player.setSprinting(false);
        player.setAllowFlight(false);
        player.setFlying(false);
        player.setFlySpeed(0.1f);
        player.setWalkSpeed(0.2f);
        player.closeInventory();
        player.getInventory().clear();
        player.getInventory().setHeldItemSlot(0);
        player.getInventory().setHelmet(null);
        player.getInventory().setChestplate(null);
        player.getInventory().setLeggings(null);
        player.getInventory().setBoots(null);
        player.setPlayerListHeaderFooter("", "");
        player.setPlayerListName(player.getName());
        player.setDisplayName(player.getName());
        player.setGameMode(GameMode.SURVIVAL);
        player.setCompassTarget(player.getLocation());
        player.resetPlayerTime();
        player.resetPlayerWeather();
        player.resetTitle();
        player.setScoreboard(Bukkit.getScoreboardManager().getNewScoreboard());
        for (PotionEffect potionEffect : player.getActivePotionEffects()) {
            player.removePotionEffect(potionEffect.getType());
        }
        Iterator iterator = Bukkit.getBossBars();
        while (iterator.hasNext()) {
            PotionEffect potionEffect;
            potionEffect = (BossBar)iterator.next();
            if (!potionEffect.getPlayers().contains(player)) continue;
            potionEffect.removePlayer(player);
        }
    }

    public static void sendPlayerToServer(Plugin plugin, Player player, String string) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeUTF("Connect");
            dataOutputStream.writeUTF(string);
            player.sendPluginMessage(plugin, "BungeeCord", byteArrayOutputStream.toByteArray());
        }
        catch (Exception exception) {
            player.sendMessage("\u00a7cCould not connect to " + string + "!");
            exception.printStackTrace();
        }
    }

    public static List<Player> getNearbyPlayers(Location location, double d) {
        return PlayerUtils.getNearbyPlayers(location, new ArrayList<Player>(), d);
    }

    public static List<Player> getNearbyPlayers(Location location, Player player, double d) {
        return PlayerUtils.getNearbyPlayers(location, Collections.singletonList(player), d);
    }

    public static List<Player> getNearbyPlayers(Location location, List<Player> list, double d) {
        ArrayList<Player> arrayList = new ArrayList<Player>();
        if (location.getWorld() == null) {
            return arrayList;
        }
        for (Player player : PlayerUtils.getPlayers(location.getWorld())) {
            if (list.contains(player) || !(player.getLocation().distance(location) <= d)) continue;
            arrayList.add(player);
        }
        return arrayList;
    }

    public static Player getNearestPlayer(Location location) {
        return PlayerUtils.getNearestPlayer(location, new ArrayList<Player>());
    }

    public static Player getNearestPlayer(Location location, Player player) {
        return PlayerUtils.getNearestPlayer(location, Collections.singletonList(player));
    }

    public static Player getNearestPlayer(Location location, List<Player> list) {
        Player player = null;
        if (location.getWorld() == null) {
            return null;
        }
        for (Player player2 : PlayerUtils.getPlayers(location.getWorld())) {
            if (list.contains(player2) || player != null && !(player2.getLocation().distance(location) < player.getLocation().distance(location))) continue;
            player = player2;
        }
        return player;
    }

    public static ItemStack parseHead(String string) {
        string = string.replace("player->", "").replace("custom->", "");
        return NBTEditor.getHead(string);
    }

    public static List<Player> getPlayers(World world) {
        ArrayList<Player> arrayList = new ArrayList<Player>();
        if (world == null) {
            return arrayList;
        }
        for (Entity entity : world.getEntities()) {
            if (!(entity instanceof Player)) continue;
            arrayList.add((Player)entity);
        }
        return arrayList;
    }
}

