/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.object.bossbar;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.InternalStructure;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.UUID;
import net.momirealms.customnameplates.CustomNameplates;
import net.momirealms.customnameplates.libs.net.kyori.adventure.text.minimessage.MiniMessage;
import net.momirealms.customnameplates.libs.net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.momirealms.customnameplates.object.DynamicText;
import net.momirealms.customnameplates.object.bossbar.Overlay;
import net.momirealms.customnameplates.object.requirements.Requirement;
import net.momirealms.customnameplates.utils.AdventureUtils;
import org.bukkit.boss.BarColor;
import org.bukkit.entity.Player;

public class BossBarSender {
    private final Player player;
    private final int switch_interval;
    private int timer;
    private int refresh_rate;
    private int current_text_id;
    private final DynamicText[] dynamicTexts;
    private final Requirement[] requirements;
    private final UUID uuid;
    private boolean force;
    private boolean isShown;
    private final Overlay overlay;
    private final BarColor barColor;

    public BossBarSender(int switch_interval, int refreshRate, String[] texts, Requirement[] requirements, Overlay overlay, BarColor barColor, Player player) {
        this.player = player;
        this.switch_interval = switch_interval;
        this.overlay = overlay;
        this.barColor = barColor;
        this.uuid = UUID.randomUUID();
        this.requirements = requirements;
        this.dynamicTexts = new DynamicText[texts.length];
        for (int i = 0; i < texts.length; ++i) {
            this.dynamicTexts[i] = new DynamicText(player, texts[i]);
        }
        this.current_text_id = 0;
        this.refresh_rate = refreshRate;
    }

    public boolean isShown() {
        return this.isShown;
    }

    public boolean canSend() {
        if (this.requirements == null) {
            return true;
        }
        for (Requirement requirement : this.requirements) {
            if (requirement.isConditionMet(this.player)) continue;
            return false;
        }
        return true;
    }

    public void hide() {
        this.sendRemovePacket();
        this.isShown = false;
    }

    public void show() {
        CustomNameplates.getProtocolManager().sendServerPacket(this.player, this.getCreatePacket());
        this.isShown = true;
    }

    public void update() {
        ++this.timer;
        if (this.timer % this.switch_interval == 0) {
            ++this.current_text_id;
            if (this.current_text_id >= this.dynamicTexts.length) {
                this.current_text_id = 0;
            }
            this.force = true;
        }
        if (this.timer % this.refresh_rate == 0 && this.dynamicTexts[this.current_text_id].update() || this.force) {
            this.force = false;
            CustomNameplates.getProtocolManager().sendServerPacket(this.player, this.getUpdatePacket());
        }
    }

    private PacketContainer getCreatePacket() {
        this.dynamicTexts[this.current_text_id].update();
        PacketContainer packet = new PacketContainer(PacketType.Play.Server.BOSS);
        packet.getModifier().write(0, (Object)this.uuid);
        InternalStructure internalStructure = (InternalStructure)packet.getStructures().read(1);
        internalStructure.getChatComponents().write(0, (Object)WrappedChatComponent.fromJson((String)((String)GsonComponentSerializer.gson().serialize(MiniMessage.miniMessage().deserialize(AdventureUtils.replaceLegacy(this.dynamicTexts[this.current_text_id].getLatestValue()))))));
        internalStructure.getFloat().write(0, (Object)Float.valueOf(1.0f));
        internalStructure.getEnumModifier(BarColor.class, 2).write(0, (Object)this.barColor);
        internalStructure.getEnumModifier(Overlay.class, 3).write(0, (Object)this.overlay);
        internalStructure.getModifier().write(4, (Object)false);
        internalStructure.getModifier().write(5, (Object)false);
        internalStructure.getModifier().write(6, (Object)false);
        return packet;
    }

    private PacketContainer getUpdatePacket() {
        PacketContainer packet = new PacketContainer(PacketType.Play.Server.BOSS);
        packet.getModifier().write(0, (Object)this.uuid);
        try {
            Method sMethod = MinecraftReflection.getChatSerializerClass().getMethod("a", String.class);
            sMethod.setAccessible(true);
            Object chatComponent = sMethod.invoke(null, GsonComponentSerializer.gson().serialize(MiniMessage.miniMessage().deserialize(AdventureUtils.replaceLegacy(this.dynamicTexts[this.current_text_id].getLatestValue()))));
            Class<?> packetBossClass = Class.forName("net.minecraft.network.protocol.game.PacketPlayOutBoss$e");
            Constructor<?> packetConstructor = packetBossClass.getDeclaredConstructor(MinecraftReflection.getIChatBaseComponentClass());
            packetConstructor.setAccessible(true);
            Object updatePacket = packetConstructor.newInstance(chatComponent);
            packet.getModifier().write(1, updatePacket);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    private void sendRemovePacket() {
        PacketContainer packet = new PacketContainer(PacketType.Play.Server.BOSS);
        packet.getModifier().write(0, (Object)this.uuid);
        try {
            Class<?> bar = Class.forName("net.minecraft.network.protocol.game.PacketPlayOutBoss");
            Field remove = bar.getDeclaredField("f");
            remove.setAccessible(true);
            packet.getModifier().write(1, remove.get(null));
            CustomNameplates.getProtocolManager().sendServerPacket(this.player, packet);
        }
        catch (ClassNotFoundException e) {
            AdventureUtils.consoleMessage("<red>[CustomNameplates] Failed to remove boss bar for " + this.player.getName());
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

