/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.velocity;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import com.google.inject.Inject;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.connection.PluginMessageEvent;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.event.proxy.ProxyShutdownEvent;
import com.velocitypowered.api.plugin.Dependency;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.messages.ChannelIdentifier;
import com.velocitypowered.api.proxy.messages.MinecraftChannelIdentifier;
import java.time.Duration;
import java.util.Optional;
import net.william278.velocitab.Velocitab;
import net.william278.velocitab.api.VelocitabAPI;
import org.slf4j.Logger;

@Plugin(id="customnameplates", name="CustomNameplates", version="2.2", authors={"XiaoMoMi"}, dependencies={@Dependency(id="velocitab")})
public class CustomNameplatesVC {
    private static CustomNameplatesVC instance;
    private final ProxyServer server;
    private final Logger logger;
    private Velocitab tab;

    @Inject
    public CustomNameplatesVC(ProxyServer server, Logger logger) {
        instance = this;
        this.server = server;
        this.logger = logger;
    }

    public static CustomNameplatesVC getInstance() {
        return instance;
    }

    @Subscribe
    public void onProxyInitialization(ProxyInitializeEvent event) {
        this.server.getChannelRegistrar().register(new ChannelIdentifier[]{MinecraftChannelIdentifier.from((String)"customnameplates:cnp")});
        Optional optContainer = this.server.getPluginManager().getPlugin("velocitab");
        optContainer.ifPresent(pluginContainer -> {
            this.tab = (Velocitab)pluginContainer.getInstance().get();
        });
    }

    @Subscribe
    public void onProxyShutdown(ProxyShutdownEvent event) {
        this.server.getChannelRegistrar().unregister(new ChannelIdentifier[]{MinecraftChannelIdentifier.from((String)"customnameplates:cnp")});
    }

    public ProxyServer getServer() {
        return this.server;
    }

    public Logger getLogger() {
        return this.logger;
    }

    @Subscribe
    public void onPluginMessage(PluginMessageEvent event) {
        if (!event.getIdentifier().getId().equals("customnameplates:cnp")) {
            return;
        }
        ByteArrayDataInput dataInput = ByteStreams.newDataInput((byte[])event.getData());
        String playerName = dataInput.readUTF();
        Optional optPlayer = this.server.getPlayer(playerName);
        if (optPlayer.isEmpty()) {
            return;
        }
        Optional player = VelocitabAPI.getInstance().getUser((Player)optPlayer.get());
        player.ifPresent(presentPlayer -> presentPlayer.getTeamName(this.tab).thenAccept(team -> this.server.getScheduler().buildTask((Object)this, () -> {
            ByteArrayDataOutput byteArrayDataOutput = ByteStreams.newDataOutput();
            byteArrayDataOutput.writeUTF(playerName);
            byteArrayDataOutput.writeUTF(team);
            ((Player)optPlayer.get()).getCurrentServer().ifPresent(it -> it.sendPluginMessage((ChannelIdentifier)MinecraftChannelIdentifier.from((String)"customnameplates:cnp"), byteArrayDataOutput.toByteArray()));
        }).delay(Duration.ofSeconds(1L)).schedule()));
    }
}

