/*
 * Decompiled with CFR 0.152.
 */
package com.ehhthan.happyhud.api.hud.layer.type.texture;

import com.ehhthan.happyhud.HappyHUD;
import com.ehhthan.happyhud.api.HudHolder;
import com.ehhthan.happyhud.api.hud.HudAsset;
import com.ehhthan.happyhud.api.hud.layer.Functional;
import com.ehhthan.happyhud.api.hud.layer.listener.LayerListener;
import com.ehhthan.happyhud.api.hud.layer.type.texture.AbstractTextureLayer;
import com.ehhthan.happyhud.api.resourcepack.texture.file.SplitTexture;
import com.ehhthan.happyhud.api.resourcepack.texture.file.TextureFile;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;

public class FunctionalTextureLayer
extends AbstractTextureLayer
implements Functional {
    private final LayerListener listener;
    private final TextureData textureData;
    private final Map<String, TextureFile> textures = new HashMap<String, TextureFile>();

    public FunctionalTextureLayer(HudAsset hudAsset, ConfigurationSection configurationSection, int n) {
        super(hudAsset, configurationSection, n);
        Preconditions.checkArgument((boolean)configurationSection.isConfigurationSection("function"), (Object)"Function config is not defined.");
        configurationSection = configurationSection.getConfigurationSection("function");
        this.listener = HappyHUD.getInstance().listeners().get(configurationSection.getString("listener", ""));
        Preconditions.checkArgument((this.listener != null ? 1 : 0) != 0, (Object)"Listener does not exist.");
        this.textureData = new TextureData(configurationSection);
        HashSet<String> hashSet = new HashSet<String>(this.getConditions().getPossibleTexturePaths());
        hashSet.add(this.getTexturePath());
        for (String string : hashSet) {
            SplitTexture splitTexture = TextureFile.split(string, this.textureData);
            BufferedImage bufferedImage = splitTexture.getBaseImage();
            int n2 = switch (this.textureData.getOrientation()) {
                default -> throw new IncompatibleClassChangeError();
                case Orientation.HORIZONTAL -> bufferedImage.getWidth();
                case Orientation.VERTICAL -> bufferedImage.getHeight();
            };
            Preconditions.checkArgument((n2 >= this.textureData.getIncrement() ? 1 : 0) != 0, (Object)"Increment is too large for texture.");
            this.textures.put(splitTexture.getPath(), splitTexture);
        }
    }

    @Override
    public LayerListener getListener() {
        return this.listener;
    }

    public TextureData getTextureData() {
        return this.textureData;
    }

    @Override
    public Map<String, TextureFile> getTextures() {
        return this.textures;
    }

    public int getHolderIncrement(HudHolder hudHolder) {
        int n = this.textureData.getIncrement();
        return Ints.constrainToRange((int)((int)Math.ceil(this.listener.getCoefficient(hudHolder) * (double)n)), (int)0, (int)n);
    }

    public static class TextureData {
        private final Orientation orientation;
        private final boolean reversed;
        private final int increment;

        public TextureData(ConfigurationSection configurationSection) {
            this.orientation = Orientation.valueOf(configurationSection.getString("orientation", "HORIZONTAL").toUpperCase());
            this.reversed = configurationSection.getBoolean("reversed", false);
            this.increment = Math.max(configurationSection.getInt("increment", 10), 1);
        }

        public Orientation getOrientation() {
            return this.orientation;
        }

        public boolean isReversed() {
            return this.reversed;
        }

        public int getIncrement() {
            return this.increment;
        }
    }

    public static enum Orientation {
        HORIZONTAL,
        VERTICAL;

    }
}

