/*
 * Decompiled with CFR 0.152.
 */
package com.ehhthan.happyhud.api.hud.util;

import com.ehhthan.happyhud.HappyHUD;
import com.ehhthan.happyhud.api.resourcepack.asset.position.OffsetPosition;
import com.ehhthan.happyhud.api.resourcepack.component.RelativeWidth;
import com.ehhthan.happyhud.api.resourcepack.component.SizedComponent;
import com.ehhthan.libraries.kyori.adventure.text.Component;
import com.ehhthan.libraries.kyori.adventure.text.TextComponent;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum HudAlignment {
    LEFT{

        @Override
        public Component align(SizedComponent sizedComponent) {
            if (HudAlignment.notValid(sizedComponent)) {
                return Component.empty();
            }
            return ((TextComponent.Builder)((TextComponent.Builder)Component.text().append(HudAlignment.space((sizedComponent.getWidth() + 1) * -1))).append(sizedComponent.getComponent())).build();
        }

        @Override
        public RelativeWidth calculateRelativeWidth(int n, OffsetPosition offsetPosition) {
            return new RelativeWidth(n - offsetPosition.getX(), offsetPosition.getX());
        }

        @Override
        public Component relativeAlign(Component component, RelativeWidth relativeWidth) {
            if (relativeWidth != null) {
                int n = relativeWidth.getRight() * -1;
                return ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(HudAlignment.space(n))).append(component)).append(HudAlignment.space(n * -1))).build();
            }
            return component;
        }
    }
    ,
    RIGHT{

        @Override
        public Component align(SizedComponent sizedComponent) {
            if (HudAlignment.notValid(sizedComponent)) {
                return Component.empty();
            }
            return ((TextComponent.Builder)((TextComponent.Builder)Component.text().append(sizedComponent.getComponent())).append(HudAlignment.space((sizedComponent.getWidth() + 1) * -1))).build();
        }

        @Override
        public RelativeWidth calculateRelativeWidth(int n, OffsetPosition offsetPosition) {
            return new RelativeWidth(offsetPosition.getX() * -1, n + offsetPosition.getX());
        }

        @Override
        public Component relativeAlign(Component component, RelativeWidth relativeWidth) {
            if (relativeWidth != null) {
                int n = relativeWidth.getLeft() - 1;
                return ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(HudAlignment.space(n))).append(component)).append(HudAlignment.space(n * -1))).build();
            }
            return component;
        }
    }
    ,
    CENTER{

        @Override
        public Component align(SizedComponent sizedComponent) {
            if (HudAlignment.notValid(sizedComponent)) {
                return Component.empty();
            }
            int n = sizedComponent.getWidth() / 2 * -1;
            return ((TextComponent.Builder)((TextComponent.Builder)Component.text().append(HudAlignment.space(n).append(sizedComponent.getComponent()))).append(HudAlignment.space(n - 1 - sizedComponent.getWidth() % 2))).build();
        }

        @Override
        public RelativeWidth calculateRelativeWidth(int n, OffsetPosition offsetPosition) {
            int n2 = n / 2 * -1;
            return new RelativeWidth(n2 + n % 2, n2);
        }

        @Override
        public Component relativeAlign(Component component, RelativeWidth relativeWidth) {
            if (relativeWidth != null) {
                int n = relativeWidth.getRight();
                int n2 = relativeWidth.getLeft();
                int n3 = n2 > n ? Math.max(0, n2 - n + 1) / 2 : Math.max(0, n - n2 + 1) / 2 * -1;
                return ((TextComponent.Builder)((TextComponent.Builder)Component.text().append(HudAlignment.space(n3).append(component))).append(HudAlignment.space(n3 * -1))).build();
            }
            return component;
        }
    };


    private static boolean notValid(SizedComponent sizedComponent) {
        return sizedComponent == null || sizedComponent.getWidth() == 0;
    }

    public abstract Component align(SizedComponent var1);

    public abstract RelativeWidth calculateRelativeWidth(int var1, OffsetPosition var2);

    public abstract Component relativeAlign(Component var1, RelativeWidth var2);

    private static Component space(int n) {
        return HappyHUD.getInstance().spaces().space(n);
    }
}

