/*
 * Decompiled with CFR 0.152.
 */
package com.ehhthan.happyhud.api.resourcepack.builder;

import com.ehhthan.happyhud.HappyHUD;
import com.ehhthan.happyhud.api.element.ElementHolder;
import com.ehhthan.happyhud.api.element.layout.HudElement;
import com.ehhthan.happyhud.api.element.layout.HudLayout;
import com.ehhthan.happyhud.api.element.popup.HudPopup;
import com.ehhthan.happyhud.api.hud.layer.HudLayer;
import com.ehhthan.happyhud.api.hud.layer.type.text.TextLayer;
import com.ehhthan.happyhud.api.hud.layer.type.texture.FunctionalTextureLayer;
import com.ehhthan.happyhud.api.hud.layer.type.texture.TextureLayer;
import com.ehhthan.happyhud.api.resourcepack.asset.font.provider.BitmapPackProvider;
import com.ehhthan.happyhud.api.resourcepack.asset.font.provider.LegacyUnicodeProvider;
import com.ehhthan.happyhud.api.resourcepack.asset.font.provider.PackProvider;
import com.ehhthan.happyhud.api.resourcepack.asset.font.provider.SpacePackProvider;
import com.ehhthan.happyhud.api.resourcepack.asset.position.OffsetPosition;
import com.ehhthan.happyhud.api.resourcepack.asset.position.PositionContainer;
import com.ehhthan.happyhud.api.resourcepack.asset.position.ScreenPosition;
import com.ehhthan.happyhud.api.resourcepack.asset.position.ShaderInfo;
import com.ehhthan.happyhud.api.resourcepack.builder.BuildableFontFile;
import com.ehhthan.happyhud.api.resourcepack.builder.Incrementable;
import com.ehhthan.happyhud.api.resourcepack.builder.PackNamespace;
import com.ehhthan.happyhud.api.resourcepack.builder.ResourceBundle;
import com.ehhthan.happyhud.api.resourcepack.component.SizedComponent;
import com.ehhthan.happyhud.api.resourcepack.component.key.FontKey;
import com.ehhthan.happyhud.api.resourcepack.component.key.LocaterKey;
import com.ehhthan.happyhud.api.resourcepack.component.key.TextureKey;
import com.ehhthan.happyhud.api.resourcepack.texture.PackTexture;
import com.ehhthan.happyhud.api.resourcepack.texture.SizedImage;
import com.ehhthan.happyhud.api.resourcepack.texture.file.CroppedTexture;
import com.ehhthan.happyhud.api.resourcepack.texture.file.SplitTexture;
import com.ehhthan.happyhud.api.resourcepack.texture.file.TextureFile;
import com.ehhthan.happyhud.api.util.BossBarUtil;
import com.ehhthan.happyhud.file.CopyFileVisitor;
import com.ehhthan.happyhud.file.DeleteFileVisitor;
import com.ehhthan.libraries.kyori.adventure.key.Key;
import com.ehhthan.libraries.kyori.adventure.text.Component;
import com.ehhthan.libraries.kyori.adventure.text.TextComponent;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import org.bukkit.configuration.file.FileConfiguration;

public class BuildablePack {
    private final HappyHUD plugin;
    private final File packDirectory;
    private final File fontDirectory;
    private final File textureDirectory;
    private final PositionContainer positions = new PositionContainer();
    private final List<BuildableElementHolder> holders = new ArrayList<BuildableElementHolder>();

    public BuildablePack(HappyHUD happyHUD) {
        this.plugin = happyHUD;
        this.packDirectory = new File(happyHUD.getDataFolder(), "built-pack");
        this.fontDirectory = new File(this.packDirectory, "happyhud/font");
        this.textureDirectory = new File(this.packDirectory, "happyhud/textures/font");
        for (HudLayout elementHolder : happyHUD.layouts().getLayouts()) {
            this.holders.add(new BuildableElementHolder(elementHolder));
        }
        for (HudPopup hudPopup : happyHUD.popups().getPopups()) {
            this.holders.add(new BuildableElementHolder(hudPopup));
        }
    }

    public ResourceBundle build() {
        HashMap<TextureKey, SizedComponent> hashMap = new HashMap<TextureKey, SizedComponent>();
        HashMap<FontKey, Key> hashMap2 = new HashMap<FontKey, Key>();
        FileConfiguration fileConfiguration = this.plugin.getConfig();
        try {
            if (this.packDirectory.exists()) {
                Files.walkFileTree(this.packDirectory.toPath(), new DeleteFileVisitor());
            }
            this.packDirectory.mkdirs();
            Files.walkFileTree(Path.of(this.plugin.getDataFolder().getPath(), "pack"), new CopyFileVisitor(this.packDirectory.toPath()));
            for (BuildableElementHolder buildableElementHolder : this.holders) {
                ResourceBundle resourceBundle = buildableElementHolder.build();
                hashMap.putAll(resourceBundle.getComponents());
                hashMap2.putAll(resourceBundle.getFonts());
            }
            HashMap hashMap3 = new HashMap();
            hashMap3.put("BOSSBAR_OFFSET", new String[]{String.valueOf(BossBarUtil.getOffset(this.plugin.getConfig().getInt("boss-bar.hud-position", 4)))});
            hashMap3.put("POSITIONS", this.positions.build().toArray(new String[0]));
            BuildablePack.replacePlaceholders(new File(this.packDirectory, "minecraft/shaders/core/rendertype_text.vsh"), hashMap3);
            if (fileConfiguration.getBoolean("copy-resource-pack.enabled", false)) {
                if (fileConfiguration.isConfigurationSection("copy-resource-pack.namespaces")) {
                    PackNamespace.copyNamespaces(fileConfiguration.getConfigurationSection("copy-resource-pack.namespaces"), this.packDirectory);
                } else if (fileConfiguration.isString("copy-resource-pack.path")) {
                    Files.walkFileTree(this.packDirectory.toPath(), new CopyFileVisitor(Path.of(this.plugin.getDataFolder().getParent(), fileConfiguration.getString("copy-resource-pack.path"))));
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return new ResourceBundle(hashMap, hashMap2);
    }

    private static void replacePlaceholders(File file, Map<String, String[]> map) {
        Object object;
        Object object2;
        StringBuilder stringBuilder = new StringBuilder((int)file.length());
        try {
            object2 = new BufferedReader(new FileReader(file));
            try {
                while ((object = ((BufferedReader)object2).readLine()) != null) {
                    stringBuilder.append((String)object).append("\n");
                }
            }
            finally {
                ((BufferedReader)object2).close();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        object2 = stringBuilder.toString();
        for (Map.Entry entry : map.entrySet()) {
            object2 = ((String)object2).replace("%" + (String)entry.getKey() + "%", String.join((CharSequence)"\n", (CharSequence[])entry.getValue()));
        }
        try {
            object = new BufferedWriter(new FileWriter(file));
            try {
                ((Writer)object).write((String)object2);
            }
            finally {
                ((BufferedWriter)object).close();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public class BuildableElementHolder {
        private final ElementHolder elementHolder;
        private final BuildableFontFile textureFont;
        private final Incrementable<Character> character = Incrementable.character('\ue000');
        private final Map<TextureKey, SizedComponent> components = new HashMap<TextureKey, SizedComponent>();
        private final Map<FontKey, Key> fonts = new HashMap<FontKey, Key>();

        public BuildableElementHolder(ElementHolder elementHolder) {
            this.elementHolder = elementHolder;
            this.textureFont = new BuildableFontFile(String.join((CharSequence)"/", elementHolder.getType(), elementHolder.getKey(), "textures.json"));
        }

        public ResourceBundle build() {
            this.components.clear();
            this.character.reset();
            this.textureFont.reset();
            for (HudElement hudElement : this.elementHolder.getElements()) {
                for (HudLayer hudLayer : hudElement.getAsset().getLayers()) {
                    if (hudLayer instanceof TextureLayer) {
                        TextureLayer textureLayer = (TextureLayer)hudLayer;
                        for (TextureFile textureFile : textureLayer.getTextures().values()) {
                            if (textureFile instanceof SplitTexture) {
                                SplitTexture splitTexture = (SplitTexture)textureFile;
                                int n = 1;
                                for (PackTexture packTexture : splitTexture.getTextures()) {
                                    this.texture(textureLayer, packTexture, LocaterKey.textureKey(hudElement, textureFile, n++), hudElement.getScreenPosition());
                                }
                                continue;
                            }
                            if (!(textureFile instanceof CroppedTexture)) continue;
                            CroppedTexture croppedTexture = (CroppedTexture)textureFile;
                            this.texture(textureLayer, croppedTexture.getTexture(), LocaterKey.textureKey(hudElement, textureFile), hudElement.getScreenPosition());
                        }
                        continue;
                    }
                    if (!(hudLayer instanceof TextLayer)) continue;
                    TextLayer textLayer = (TextLayer)hudLayer;
                    Object object = "";
                    if (this.elementHolder instanceof HudLayout) {
                        object = hudElement.getAsset().getKey();
                    } else if (this.elementHolder instanceof HudPopup) {
                        object = hudElement.getKey();
                    }
                    this.text(String.join((CharSequence)"/", new CharSequence[]{this.elementHolder.getType(), this.elementHolder.getKey(), "fonts", object, hudLayer.getKey() + ".json"}), hudElement.getScreenPosition(), hudElement, textLayer);
                }
            }
            try {
                this.textureFont.build(BuildablePack.this.fontDirectory);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return new ResourceBundle(this.components, this.fonts);
        }

        private void text(String string, ScreenPosition screenPosition, HudElement hudElement, TextLayer textLayer) {
            BuildableFontFile buildableFontFile = new BuildableFontFile(string);
            for (PackProvider packProvider : textLayer.getFont().getProviders()) {
                Object object;
                Object object2;
                if (packProvider instanceof BitmapPackProvider) {
                    BitmapPackProvider bitmapPackProvider = (BitmapPackProvider)packProvider;
                    JsonObject jsonObject = bitmapPackProvider.getProvider().deepCopy();
                    Object object3 = ShaderInfo.position(screenPosition.mergeOffset(bitmapPackProvider.getOffset(), textLayer.getOffset())).layer(textLayer).build();
                    jsonObject.addProperty("ascent", (Number)BuildablePack.this.positions.addThenGetAscent((ShaderInfo)object3));
                    buildableFontFile.addProvider(jsonObject);
                    object2 = new File(BuildablePack.this.textureDirectory, bitmapPackProvider.getTexture().getPath());
                    object = ((File)object2).getParentFile();
                    if (object != null) {
                        ((File)object).mkdirs();
                    }
                    try {
                        ImageIO.write((RenderedImage)bitmapPackProvider.getTexture().getBaseImage(), "png", (File)object2);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    continue;
                }
                if (packProvider instanceof SpacePackProvider) {
                    SpacePackProvider spacePackProvider = (SpacePackProvider)packProvider;
                    buildableFontFile.addProvider(spacePackProvider.getProvider());
                    continue;
                }
                if (!(packProvider instanceof LegacyUnicodeProvider)) continue;
                LegacyUnicodeProvider legacyUnicodeProvider = (LegacyUnicodeProvider)packProvider;
                for (Object object3 : legacyUnicodeProvider.getProviders()) {
                    object2 = object3.deepCopy();
                    object = ShaderInfo.position(screenPosition.mergeOffset(textLayer.getOffset())).layer(textLayer).build();
                    object2.addProperty("ascent", (Number)BuildablePack.this.positions.addThenGetAscent((ShaderInfo)object));
                    buildableFontFile.addProvider((JsonObject)object2);
                }
            }
            this.fonts.put(LocaterKey.fontKey(hudElement, textLayer), buildableFontFile.getFont());
            try {
                buildableFontFile.build(BuildablePack.this.fontDirectory);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        private void texture(TextureLayer textureLayer, PackTexture packTexture, TextureKey textureKey, ScreenPosition screenPosition) {
            OffsetPosition offsetPosition;
            Object object;
            FunctionalTextureLayer functionalTextureLayer;
            char c = this.character.next().charValue();
            SizedImage sizedImage = packTexture.getSizedImage();
            if (textureLayer instanceof FunctionalTextureLayer) {
                functionalTextureLayer = (FunctionalTextureLayer)textureLayer;
                int n = 0;
                int n2 = 0;
                BufferedImage bufferedImage = ((TextureFile)textureKey.getProperty()).getBaseImage();
                object = functionalTextureLayer.getTextureData();
                if (((FunctionalTextureLayer.TextureData)object).isReversed() && ((FunctionalTextureLayer.TextureData)object).getOrientation() == FunctionalTextureLayer.Orientation.HORIZONTAL) {
                    n = bufferedImage.getWidth() - sizedImage.getWidth();
                } else if (((FunctionalTextureLayer.TextureData)object).getOrientation() == FunctionalTextureLayer.Orientation.VERTICAL) {
                    n = sizedImage.getX();
                    if (!((FunctionalTextureLayer.TextureData)object).isReversed()) {
                        n2 = (bufferedImage.getHeight() - sizedImage.getHeight()) * -1;
                    }
                }
                offsetPosition = new OffsetPosition(n, n2, 0);
            } else {
                offsetPosition = OffsetPosition.EMPTY;
            }
            functionalTextureLayer = new JsonObject();
            functionalTextureLayer.addProperty("type", "bitmap");
            functionalTextureLayer.addProperty("file", "happyhud:font/" + packTexture.getPackPath());
            functionalTextureLayer.addProperty("height", sizedImage.getHeight());
            ShaderInfo shaderInfo = ShaderInfo.position(screenPosition.mergeOffset(offsetPosition, textureLayer.getOffset())).layer(textureLayer).build();
            functionalTextureLayer.addProperty("ascent", BuildablePack.this.positions.addThenGetAscent(shaderInfo));
            JsonArray jsonArray = new JsonArray();
            jsonArray.add(String.valueOf(c));
            functionalTextureLayer.add("chars", (JsonElement)jsonArray);
            this.textureFont.addProvider((JsonObject)functionalTextureLayer);
            int n = sizedImage.getWidth();
            this.components.put(textureKey, new SizedComponent(((TextComponent)Component.text(c).color(textureLayer.getColor())).font(this.textureFont.getFont()), n, textureLayer.getAlignment().calculateRelativeWidth(n, textureLayer.getOffset())));
            object = new File(BuildablePack.this.textureDirectory, packTexture.getPackPath());
            File file = ((File)object).getParentFile();
            if (file != null) {
                file.mkdirs();
            }
            try {
                ImageIO.write((RenderedImage)sizedImage.getImage(), "png", (File)object);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

