/*
 * Decompiled with CFR 0.152.
 */
package com.ehhthan.happyhud.api.resourcepack.texture.file;

import com.ehhthan.happyhud.api.resourcepack.texture.PackTexture;
import com.ehhthan.happyhud.api.resourcepack.texture.SizedImage;
import com.ehhthan.happyhud.api.resourcepack.texture.file.AbstractTextureFile;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.Objects;

public class TiledTexture
extends AbstractTextureFile {
    private final SizedImage[][] tiles;
    private final int rows;
    private final int columns;
    private final int tileWidth;
    private final int tileHeight;
    private final PackTexture texture;

    protected TiledTexture(String string, BufferedImage bufferedImage, SizedImage[][] sizedImageArray) {
        super(string, bufferedImage);
        this.tiles = sizedImageArray;
        this.rows = sizedImageArray.length;
        this.columns = sizedImageArray[0].length;
        this.tileWidth = bufferedImage.getWidth() / this.columns;
        this.tileHeight = bufferedImage.getHeight() / this.rows;
        this.texture = new PackTexture(string, bufferedImage);
    }

    public SizedImage[][] getTiles() {
        return this.tiles;
    }

    public int getRows() {
        return this.rows;
    }

    public int getColumns() {
        return this.columns;
    }

    public int getTileWidth() {
        return this.tileWidth;
    }

    public int getTileHeight() {
        return this.tileHeight;
    }

    public PackTexture getTexture() {
        return this.texture;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        TiledTexture tiledTexture = (TiledTexture)object;
        return this.rows == tiledTexture.rows && this.columns == tiledTexture.columns && this.tileWidth == tiledTexture.tileWidth && this.tileHeight == tiledTexture.tileHeight && Arrays.deepEquals((Object[])this.tiles, (Object[])tiledTexture.tiles) && Objects.equals(this.texture, tiledTexture.texture);
    }

    public int hashCode() {
        int n = Objects.hash(this.rows, this.columns, this.tileWidth, this.tileHeight, this.texture);
        n = 31 * n + Arrays.deepHashCode((Object[])this.tiles);
        return n;
    }
}

