/*
 * Decompiled with CFR 0.152.
 */
package com.ehhthan.happyhud.api.util;

import com.ehhthan.happyhud.HappyHUD;
import java.text.DecimalFormat;
import java.util.Optional;

public class MathUtil {
    private static final DecimalFormat FORMAT = new DecimalFormat(HappyHUD.getInstance().getConfig().getString("decimal-format", "#.##"));

    public static Optional<Double> toDouble(String string) {
        Double d;
        if (string == null) {
            d = null;
        } else {
            string = MathUtil.clean(string);
            try {
                d = Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                d = null;
            }
        }
        return Optional.ofNullable(d);
    }

    public static boolean isNumeric(String string) {
        try {
            Double.parseDouble(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static String toFormatted(Number number) {
        return FORMAT.format(number);
    }

    private static String clean(String string) {
        return string.replace(',', '.').replace("%", "").replace(" ", "");
    }
}

