/*
 * Decompiled with CFR 0.152.
 */
package com.ehhthan.happyhud.manager;

import com.ehhthan.happyhud.HappyHUD;
import com.ehhthan.happyhud.api.element.layout.HudLayout;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.configuration.file.YamlConfiguration;

public class LayoutManager {
    private final Map<String, HudLayout> layouts = new HashMap<String, HudLayout>();
    private final List<HudLayout> defaults = new ArrayList<HudLayout>();

    public void reload(HappyHUD happyHUD) {
        String string2;
        this.layouts.clear();
        File[] fileArray = new File(happyHUD.getDataFolder(), "layout").listFiles((file, string) -> string.endsWith(".yml"));
        if (fileArray != null) {
            for (File file2 : fileArray) {
                YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file2);
                for (String string3 : yamlConfiguration.getKeys(false)) {
                    if (!yamlConfiguration.isConfigurationSection(string3)) continue;
                    try {
                        HudLayout illegalArgumentException = new HudLayout(yamlConfiguration.getConfigurationSection(string3));
                        this.layouts.put(illegalArgumentException.getKey(), illegalArgumentException);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        happyHUD.getLogger().log(Level.WARNING, String.format("Could not load layout '%s': %s", string3, illegalArgumentException.getMessage()));
                    }
                }
            }
        }
        this.defaults.clear();
        String string4 = "layout.default";
        if (happyHUD.getConfig().isList("layout.default")) {
            for (String string5 : happyHUD.getConfig().getStringList("layout.default")) {
                if (string5 == null || !this.has(string5)) continue;
                this.defaults.add(this.get(string5));
            }
        } else if (happyHUD.getConfig().isString("layout.default") && (string2 = happyHUD.getConfig().getString("layout.default")) != null && this.has(string2)) {
            this.defaults.add(this.get(string2));
        }
    }

    public boolean has(String string) {
        return string != null && this.layouts.containsKey(string.toLowerCase(Locale.ROOT));
    }

    public HudLayout get(String string) {
        return this.layouts.get(string.toLowerCase(Locale.ROOT));
    }

    public Collection<HudLayout> getDefaults() {
        return this.defaults;
    }

    public Collection<HudLayout> getLayouts() {
        return this.layouts.values();
    }
}

