/*
 * Decompiled with CFR 0.152.
 */
package com.ehhthan.libraries.kyori.adventure.util;

import com.ehhthan.libraries.kyori.adventure.internal.properties.AdventureProperties;
import com.ehhthan.libraries.kyori.adventure.util.Services0;
import java.util.Iterator;
import java.util.Optional;
import java.util.ServiceLoader;
import org.jetbrains.annotations.NotNull;

public final class Services {
    private static final boolean SERVICE_LOAD_FAILURES_ARE_FATAL = Boolean.TRUE.equals(AdventureProperties.SERVICE_LOAD_FAILURES_ARE_FATAL.value());

    private Services() {
    }

    @NotNull
    public static <P> Optional<P> service(@NotNull Class<P> clazz) {
        ServiceLoader<P> serviceLoader = Services0.loader(clazz);
        Iterator<P> iterator = serviceLoader.iterator();
        while (iterator.hasNext()) {
            P p;
            try {
                p = iterator.next();
            }
            catch (Throwable throwable) {
                if (!SERVICE_LOAD_FAILURES_ARE_FATAL) continue;
                throw new IllegalStateException("Encountered an exception loading service " + clazz, throwable);
            }
            if (iterator.hasNext()) {
                throw new IllegalStateException("Expected to find one service " + clazz + ", found multiple");
            }
            return Optional.of(p);
        }
        return Optional.empty();
    }

    @NotNull
    public static <P> Optional<P> serviceWithFallback(@NotNull Class<P> clazz) {
        ServiceLoader<P> serviceLoader = Services0.loader(clazz);
        Iterator<P> iterator = serviceLoader.iterator();
        Object t = null;
        while (iterator.hasNext()) {
            P p;
            try {
                p = iterator.next();
            }
            catch (Throwable throwable) {
                if (!SERVICE_LOAD_FAILURES_ARE_FATAL) continue;
                throw new IllegalStateException("Encountered an exception loading service " + clazz, throwable);
            }
            if (p instanceof Fallback) {
                if (t != null) continue;
                t = p;
                continue;
            }
            return Optional.of(p);
        }
        return Optional.ofNullable(t);
    }

    public static interface Fallback {
    }
}

