/*
 * Decompiled with CFR 0.152.
 */
package Handlers;

import Zombies.GameArena;
import Zombies.Main;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.server.ServerListPingEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class PlayerHandler
implements Listener {
    @EventHandler
    public void joinPlayer(PlayerJoinEvent playerJoinEvent) {
        Object object2;
        if (Main.getInstance().getConfiguration().getBoolean("MultiArena.Enabled").booleanValue()) {
            return;
        }
        final Player player = playerJoinEvent.getPlayer();
        playerJoinEvent.setJoinMessage(null);
        player.setMaxHealth(20.0);
        player.setHealth(20.0);
        for (Object object2 : player.getActivePotionEffects()) {
            player.removePotionEffect(object2.getType());
        }
        player.setGameMode(GameMode.ADVENTURE);
        player.getInventory().setArmorContents(null);
        player.getInventory().clear();
        player.setExp(0.0f);
        player.setLevel(0);
        player.setFoodLevel(20);
        player.setFlying(false);
        player.setAllowFlight(false);
        if (Main.getInstance().getConfiguration().getGameArena(player) == null) {
            return;
        }
        Main.getInstance().getConfiguration().getGameArena(player).addPlayer(player);
        FileConfiguration fileConfiguration = Main.getInstance().getConfiguration().getGameArena(player).getFileConfiguration();
        object2 = fileConfiguration.getString("LobbyLocation");
        if (object2 == null) {
            return;
        }
        final Location location = new Location(Bukkit.getWorld((String)((String)object2).split(":")[0]), Double.valueOf(((String)object2).split(":")[1]).doubleValue(), Double.valueOf(((String)object2).split(":")[2]).doubleValue(), Double.valueOf(((String)object2).split(":")[3]).doubleValue());
        location.setYaw(Float.valueOf(((String)object2).split(":")[4]).floatValue());
        location.setPitch(Float.valueOf(((String)object2).split(":")[5]).floatValue());
        if (player.hasPlayedBefore()) {
            player.teleport(location);
        } else {
            new BukkitRunnable(){

                public void run() {
                    player.teleport(location);
                }
            }.runTaskLater((Plugin)Main.getInstance(), 5L);
        }
    }

    @EventHandler
    public void quitPlayer(PlayerQuitEvent playerQuitEvent) {
        Player player = playerQuitEvent.getPlayer();
        GameArena gameArena = Main.getInstance().getConfiguration().getGameArena(player);
        if (gameArena == null) {
            return;
        }
        gameArena.removePlayer(player);
        if (Main.getInstance().getConfiguration().getBoolean("MultiArena.Enabled").booleanValue()) {
            return;
        }
        playerQuitEvent.setQuitMessage(null);
    }

    @EventHandler
    public void kickPlayer(PlayerKickEvent playerKickEvent) {
        Player player = playerKickEvent.getPlayer();
        GameArena gameArena = Main.getInstance().getConfiguration().getGameArena(player);
        if (gameArena == null) {
            return;
        }
        gameArena.removePlayer(player);
        if (Main.getInstance().getConfiguration().getBoolean("MultiArena.Enabled").booleanValue()) {
            return;
        }
        playerKickEvent.setLeaveMessage(null);
    }

    @EventHandler
    public void login(PlayerLoginEvent playerLoginEvent) {
        if (Main.getInstance().getConfiguration().getBoolean("MultiArena.Enabled").booleanValue()) {
            return;
        }
        Player player = playerLoginEvent.getPlayer();
        GameArena gameArena = Main.getInstance().getConfiguration().getGameArena((Player)null);
        if (gameArena != null) {
            if (!gameArena.hasStarted()) {
                if (gameArena.getDisplayedPlayers().size() >= gameArena.getMaxPlayers()) {
                    if (Main.getInstance().getConfiguration().getBoolean("PremiumKickEnabled").booleanValue()) {
                        Player player2 = gameArena.getKickedPlayer(player);
                        if (player2 == null) {
                            playerLoginEvent.disallow(null, Main.getInstance().getConfiguration().getMessage("BungeeKickFullArena"));
                        } else {
                            player2.kickPlayer(Main.getInstance().getConfiguration().getMessage("Messages.PremiumKick"));
                            playerLoginEvent.allow();
                        }
                    } else {
                        playerLoginEvent.disallow(null, Main.getInstance().getConfiguration().getMessage("BungeeKickFullArena"));
                    }
                }
            } else {
                playerLoginEvent.allow();
            }
        }
    }

    @EventHandler
    public void clickInventory(InventoryClickEvent inventoryClickEvent) {
        Player player = (Player)inventoryClickEvent.getWhoClicked();
        if (Main.getInstance().getConfiguration().getGameArena(player) == null) {
            return;
        }
        inventoryClickEvent.setCancelled(true);
    }

    @EventHandler
    public void gameStateDisplay(ServerListPingEvent serverListPingEvent) {
        if (Main.getInstance().getConfiguration().getBoolean("MultiArena.Enabled").booleanValue()) {
            return;
        }
        if (Main.getInstance().getConfiguration().getBoolean("MotdDisplay.Enabled").booleanValue()) {
            if (Main.getInstance().getConfiguration().getGameArena((Player)null) != null) {
                serverListPingEvent.setMotd(Main.getInstance().getConfiguration().getGameArena((Player)null).getState());
            }
        } else if (Main.getInstance().getConfiguration().getBoolean("MotdDisplay.Custom").booleanValue() && Main.getInstance().getConfiguration().getGameArena((Player)null) != null) {
            String string = serverListPingEvent.getMotd();
            string = string.replace("%map%", Main.getInstance().getConfiguration().getGameArena((Player)null).getName()).replace("%time%", String.valueOf(Main.getInstance().getConfiguration().getGameArena((Player)null).getLobbyTime())).replace("%state%", Main.getInstance().getConfiguration().getGameArena((Player)null).getState()).replace("%players%", String.valueOf(Main.getInstance().getConfiguration().getGameArena((Player)null).getPlayers().size()));
            serverListPingEvent.setMotd(string);
        }
    }
}

