/*
 * Decompiled with CFR 0.152.
 */
package HologramAPI;

import HologramAPI.Hologram;
import Utils.LocationUtils;
import Weapons.Weapon;
import Zombies.Main;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class UltimateMachineHologram {
    private Hologram hologram;
    private List<Location> locations;
    private Player player;
    private boolean activated;
    private String message;
    private int gold;

    public UltimateMachineHologram(Player player) {
        this.player = player;
        if (Main.getInstance().getConfiguration().getGameArena(player) == null) {
            return;
        }
        FileConfiguration fileConfiguration = Main.getInstance().getConfiguration().getGameArena(player).getFileConfiguration();
        this.gold = fileConfiguration.getInt("UltimateMachine.Gold");
        String[] stringArray = fileConfiguration.getString("UltimateMachine.Pos1").split(":");
        String[] stringArray2 = fileConfiguration.getString("UltimateMachine.Pos2").split(":");
        String[] stringArray3 = fileConfiguration.getString("UltimateMachine.Hologram").split(":");
        Location location = new Location(Bukkit.getWorld((String)stringArray[0]), (double)Integer.valueOf(stringArray[1]).intValue(), (double)Integer.valueOf(stringArray[2]).intValue(), (double)Integer.valueOf(stringArray[3]).intValue());
        Location location2 = new Location(Bukkit.getWorld((String)stringArray2[0]), (double)Integer.valueOf(stringArray2[1]).intValue(), (double)Integer.valueOf(stringArray2[2]).intValue(), (double)Integer.valueOf(stringArray2[3]).intValue());
        Location location3 = new Location(Bukkit.getWorld((String)stringArray3[0]), Double.valueOf(stringArray3[1]).doubleValue(), Double.valueOf(stringArray3[2]).doubleValue(), Double.valueOf(stringArray3[3]).doubleValue());
        this.locations = LocationUtils.getBlocks(location, location2);
        this.hologram = new Hologram(location3);
        this.message = Main.getInstance().getConfiguration().getMessage("UltimateMachine.HologramHeader").replace("%goldValue%", String.valueOf(this.gold));
        this.hologram.setCleanLines(this.message, Main.getInstance().getConfiguration().getMessage("UltimateMachine.InactiveHologramFooter").replace("%goldValue%", String.valueOf(this.gold)));
        this.hologram.show(player);
    }

    public void restore(Player player) {
        this.hologram.show(player);
    }

    public List<Location> getLocations() {
        return this.locations;
    }

    public Player getPlayer() {
        return this.player;
    }

    public int getGold() {
        return this.gold;
    }

    public void setActivated() {
        this.activated = true;
        String string = Main.getInstance().getConfiguration().getMessage("UltimateMachine.ActiveHologramFooter").replace("%goldValue%", String.valueOf(this.gold));
        this.hologram.destroyFrom(this.player);
        this.hologram.setCleanLines(this.message, string);
        this.hologram.show(this.player);
    }

    public boolean purchase(Player player) {
        if (Main.getInstance().getConfiguration().getGameArena(player) == null) {
            return false;
        }
        if (!this.isActivated()) {
            player.sendMessage(Main.getInstance().getConfiguration().getMessage("UltimateMachine.RequiresPower"));
            player.playSound(player.getEyeLocation(), Sound.valueOf((String)Main.getInstance().getConfiguration().getSound("NotEnoughGold")), 1.0f, Main.getInstance().getConfiguration().convertDouble("SoundPitch.NotEnoughGold"));
            return false;
        }
        int n = player.getInventory().getHeldItemSlot();
        ItemStack itemStack = player.getInventory().getItem(n);
        if (itemStack == null) {
            player.sendMessage(Main.getInstance().getConfiguration().getMessage("UltimateMachine.HoldingInvalidWeapon"));
            return false;
        }
        Weapon weapon = Weapon.getWeapon(itemStack);
        if (weapon == null) {
            player.sendMessage(Main.getInstance().getConfiguration().getMessage("UltimateMachine.HoldingInvalidWeapon"));
            return false;
        }
        boolean bl = weapon.isUltimate();
        if (bl) {
            player.sendMessage(Main.getInstance().getConfiguration().getMessage("UltimateMachine.AlreadyUpgraded"));
            return false;
        }
        if (Main.getInstance().getConfiguration().getGameArena(player).getGold(player) < this.getGold()) {
            player.sendMessage(Main.getInstance().getConfiguration().getMessage("NotEnoughGold"));
            player.playSound(player.getEyeLocation(), Sound.valueOf((String)Main.getInstance().getConfiguration().getSound("NotEnoughGold")), 1.0f, Main.getInstance().getConfiguration().convertDouble("SoundPitch.NotEnoughGold"));
            return false;
        }
        Main.getInstance().getConfiguration().getGameArena(player).removeGold(player, this.getGold());
        Main.getInstance().getWeaponHandler().unloadWeapon(player, n, weapon);
        weapon.setUltimate(true);
        weapon.updateLores();
        player.getInventory().setItem(n, weapon.getItemStack());
        Main.getInstance().getWeaponHandler().loadWeaponAmmo(player, weapon);
        player.sendMessage(Main.getInstance().getConfiguration().getMessage("UltimateMachine.Upgraded").replace("%weaponName%", ChatColor.stripColor((String)weapon.getDisplayName())));
        player.playSound(player.getEyeLocation(), Sound.valueOf((String)Main.getInstance().getConfiguration().getSound("UltimateMachineUpgrade")), 1.0f, Main.getInstance().getConfiguration().convertDouble("SoundPitch.UltimateMachineUpgrade"));
        return true;
    }

    public boolean isActivated() {
        return this.activated;
    }

    public Hologram getHologram() {
        return this.hologram;
    }
}

