/*
 * Decompiled with CFR 0.152.
 */
package HologramAPI;

import HologramAPI.Hologram;
import HologramAPI.ItemHologram;
import Utils.LocationUtils;
import Weapons.Weapon;
import Zombies.Configuration;
import Zombies.Main;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class WeaponHologram {
    private Hologram hologram;
    private ItemHologram itemHologram;
    private List<Location> locations;
    private Player player;
    private int weaponGold;
    private int ammoGold;
    private Weapon weapon;
    private String weaponGoldMessage;
    private String ammoGoldMessage;
    private boolean unlocked;

    public WeaponHologram(Player player, String string) {
        this.player = player;
        if (Main.getInstance().getConfiguration().getGameArena(player) == null) {
            return;
        }
        FileConfiguration fileConfiguration = Main.getInstance().getConfiguration().getGameArena(player).getFileConfiguration();
        this.weaponGold = fileConfiguration.getInt("WeaponShop.Position." + string + ".WeaponGold");
        this.ammoGold = fileConfiguration.getInt("WeaponShop.Position." + string + ".AmmoGold");
        this.weapon = Main.getInstance().getConfiguration().getWeapon(fileConfiguration.getString("WeaponShop.Position." + string + ".WeaponName"));
        String[] stringArray = fileConfiguration.getString("WeaponShop.Position." + string + ".Pos1").split(":");
        String[] stringArray2 = fileConfiguration.getString("WeaponShop.Position." + string + ".Pos2").split(":");
        String[] stringArray3 = fileConfiguration.getString("WeaponShop.Position." + string + ".Hologram").split(":");
        Location location = new Location(Bukkit.getWorld((String)stringArray[0]), (double)Integer.valueOf(stringArray[1]).intValue(), (double)Integer.valueOf(stringArray[2]).intValue(), (double)Integer.valueOf(stringArray[3]).intValue());
        Location location2 = new Location(Bukkit.getWorld((String)stringArray2[0]), (double)Integer.valueOf(stringArray2[1]).intValue(), (double)Integer.valueOf(stringArray2[2]).intValue(), (double)Integer.valueOf(stringArray2[3]).intValue());
        Location location3 = new Location(Bukkit.getWorld((String)stringArray3[0]), Double.valueOf(stringArray3[1]).doubleValue(), Double.valueOf(stringArray3[2]).doubleValue(), Double.valueOf(stringArray3[3]).doubleValue());
        this.locations = LocationUtils.getBlocks(location, location2);
        this.itemHologram = new ItemHologram(location3.clone().add(0.0, 0.73, 0.0));
        this.hologram = new Hologram(location3);
        this.weaponGoldMessage = Main.getInstance().getConfiguration().getMessage("Shop.Weapon.NotUnlocked").replace("%goldValue%", String.valueOf(this.getWeaponGold()));
        this.ammoGoldMessage = Main.getInstance().getConfiguration().getMessage("Shop.Weapon.NotUnlocked").replace("%goldValue%", String.valueOf(this.getAmmoGold()));
        ItemStack itemStack = this.weapon.getItemStack().clone();
        itemStack.setAmount(1);
        this.hologram.setCleanLines(Main.getInstance().getConfiguration().getMessage("Shop.Weapon.Name").replace("%weaponName%", ChatColor.stripColor((String)this.weapon.getDisplayName())), this.weaponGoldMessage);
        this.itemHologram.setCleanItems(itemStack);
        this.itemHologram.show(player);
        this.hologram.show(player);
    }

    public void restore(Player player) {
        this.itemHologram.show(player);
        this.hologram.show(player);
    }

    public Weapon getWeapon() {
        return this.weapon;
    }

    public List<Location> getLocations() {
        return this.locations;
    }

    public Player getPlayer() {
        return this.player;
    }

    public int getWeaponGold() {
        return this.weaponGold;
    }

    public int getAmmoGold() {
        return this.ammoGold;
    }

    public boolean isFullAmmo(Weapon weapon) {
        int n = Main.getInstance().getWeaponHandler().getWeaponAmmo(this.getPlayer(), weapon);
        return n >= (weapon.isUltimate() ? weapon.getUltimateAmmo() : weapon.getAmmo());
    }

    public int getEmptyWeaponSlot() {
        for (int n : Main.getInstance().getWeaponHandler().getWeaponSlots(this.player)) {
            Weapon weapon = Weapon.getWeapon(this.player.getInventory().getItem(n));
            if (weapon != null) continue;
            return n;
        }
        return -1;
    }

    public void setUnlocked(boolean bl) {
        this.unlocked = bl;
        if (bl) {
            this.hologram.destroyFrom(this.player);
            this.hologram.setCleanLines(Main.getInstance().getConfiguration().getMessage("Shop.Weapon.AmmoName").replace("%weaponName%", ChatColor.stripColor((String)this.weapon.getDisplayName())), this.ammoGoldMessage);
            this.hologram.show(this.player);
        } else {
            this.hologram.destroyFrom(this.player);
            this.hologram.setCleanLines(Main.getInstance().getConfiguration().getMessage("Shop.Weapon.Name").replace("%weaponName%", ChatColor.stripColor((String)this.weapon.getDisplayName())), this.weaponGoldMessage);
            this.hologram.show(this.player);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean purchase(Player player) {
        if (Main.getInstance().getConfiguration().getGameArena(player) == null) {
            return false;
        }
        if (this.isUnlocked()) {
            Weapon weapon;
            if (Main.getInstance().getConfiguration().getGameArena(player).getGold(player) < this.getAmmoGold()) {
                player.sendMessage(Main.getInstance().getConfiguration().getMessage("NotEnoughGold"));
                player.playSound(player.getEyeLocation(), Sound.valueOf((String)Main.getInstance().getConfiguration().getSound("NotEnoughGold")), 1.0f, Main.getInstance().getConfiguration().convertDouble("SoundPitch.NotEnoughGold"));
                return false;
            }
            int n = player.getInventory().getHeldItemSlot();
            ItemStack itemStack = player.getInventory().getItem(n);
            if (itemStack != null && itemStack.hasItemMeta() && (weapon = Weapon.getWeapon(itemStack)) != null && this.weapon.getWeaponName().equals(weapon.getWeaponName())) {
                if (this.isFullAmmo(weapon)) {
                    player.sendMessage(Main.getInstance().getConfiguration().getMessage("Shop.Weapon.AlreadyMaxAmmo"));
                    return false;
                }
                Main.getInstance().getWeaponHandler().loadWeaponAmmo(player, weapon);
                player.playSound(player.getEyeLocation(), Sound.valueOf((String)Main.getInstance().getConfiguration().getSound("ShopItemBought")), 1.0f, Main.getInstance().getConfiguration().convertDouble("SoundPitch.ShopItemBought"));
                Main.getInstance().getConfiguration().getGameArena(player).removeGold(player, this.getAmmoGold());
                player.sendMessage(Main.getInstance().getConfiguration().getMessage("Shop.Weapon.Purchase").replace("%weaponName%", ChatColor.stripColor((String)this.weapon.getDisplayName())));
                return true;
            }
            player.sendMessage(Main.getInstance().getConfiguration().getMessage("Shop.Weapon.SwapWeapon"));
            return false;
        }
        if (Main.getInstance().getConfiguration().getGameArena(player).getGold(player) < this.getWeaponGold()) {
            player.sendMessage(Main.getInstance().getConfiguration().getMessage("NotEnoughGold"));
            player.playSound(player.getEyeLocation(), Sound.valueOf((String)Main.getInstance().getConfiguration().getSound("NotEnoughGold")), 1.0f, Main.getInstance().getConfiguration().convertDouble("SoundPitch.NotEnoughGold"));
            return false;
        }
        int n = player.getInventory().getHeldItemSlot();
        int n2 = this.getEmptyWeaponSlot();
        if (n2 == -1) {
            if (Main.getInstance().getWeaponHandler().getWeaponSlots(player).contains(n)) {
                Weapon weapon;
                ItemStack itemStack = player.getInventory().getItem(n);
                if (itemStack == null || (weapon = Weapon.getWeapon(itemStack)) == null) return false;
                this.setUnlocked(true);
                player.playSound(player.getEyeLocation(), Sound.valueOf((String)Main.getInstance().getConfiguration().getSound("ShopItemBought")), 1.0f, Main.getInstance().getConfiguration().convertDouble("SoundPitch.ShopItemBought"));
                Main.getInstance().getConfiguration().getGameArena(player).removeGold(player, this.getWeaponGold());
                player.sendMessage(Main.getInstance().getConfiguration().getMessage("Shop.Weapon.Purchase").replace("%weaponName%", ChatColor.stripColor((String)this.weapon.getDisplayName())));
                Main.getInstance().getWeaponHandler().unloadWeapon(player, n, weapon);
                player.getInventory().setItem(n, this.weapon.getItemStack());
                Main.getInstance().getWeaponHandler().loadWeaponAmmo(player, this.weapon);
                for (WeaponHologram weaponHologram : Main.getInstance().getConfiguration().getGameArena(player).getWeaponHolograms(player)) {
                    if (weaponHologram.equals(this) || !weaponHologram.getWeapon().getWeaponName().equals(weapon.getWeaponName())) continue;
                    weaponHologram.setUnlocked(false);
                }
                return true;
            }
            player.playSound(player.getEyeLocation(), Sound.valueOf((String)Main.getInstance().getConfiguration().getSound("NotEnoughGold")), 1.0f, Main.getInstance().getConfiguration().convertDouble("SoundPitch.NotEnoughGold"));
            player.sendMessage(Main.getInstance().getConfiguration().getMessage("Shop.Weapon.WrongClick"));
            return false;
        }
        this.setUnlocked(true);
        player.playSound(player.getEyeLocation(), Sound.valueOf((String)Main.getInstance().getConfiguration().getSound("ShopItemBought")), 1.0f, Main.getInstance().getConfiguration().convertDouble("SoundPitch.ShopItemBought"));
        Main.getInstance().getConfiguration().getGameArena(player).removeGold(player, this.getWeaponGold());
        player.sendMessage(Main.getInstance().getConfiguration().getMessage("Shop.Weapon.Purchase").replace("%weaponName%", ChatColor.stripColor((String)this.weapon.getDisplayName())));
        player.getInventory().setItem(n2, this.weapon.getItemStack());
        Main.getInstance().getWeaponHandler().loadWeaponAmmo(player, this.weapon);
        if (this.weapon.getDamage() > 0.0) {
            player.sendMessage(Main.getInstance().getConfiguration().getPrefix() + Configuration.translateTextCodes(Main.getInstance().getConfig().getString("WeaponBuilder.Damage").replace("%damageValue%", String.valueOf(this.weapon.getDamage()))));
        }
        if (this.weapon.getAmmo() > 0) {
            player.sendMessage(Main.getInstance().getConfiguration().getPrefix() + Configuration.translateTextCodes(Main.getInstance().getConfig().getString("WeaponBuilder.Ammo").replace("%ammoValue%", String.valueOf(this.weapon.getAmmo()))));
        }
        if (this.weapon.getClipAmmo() > 0) {
            player.sendMessage(Main.getInstance().getConfiguration().getPrefix() + Configuration.translateTextCodes(Main.getInstance().getConfig().getString("WeaponBuilder.ClipAmmo").replace("%clipAmmoValue%", String.valueOf(this.weapon.getClipAmmo()))));
        }
        if (this.weapon.getFireRate() > 0.0) {
            player.sendMessage(Main.getInstance().getConfiguration().getPrefix() + Configuration.translateTextCodes(Main.getInstance().getConfig().getString("WeaponBuilder.FireRate").replace("%fireRateValue%", String.valueOf(this.weapon.getFireRate()))));
        }
        if (this.weapon.getReload() > 0.0) {
            player.sendMessage(Main.getInstance().getConfiguration().getPrefix() + Configuration.translateTextCodes(Main.getInstance().getConfig().getString("WeaponBuilder.Reload").replace("%reloadValue%", String.valueOf(this.weapon.getReload()))));
        }
        if (this.weapon.getAffectedEnemies() > 0) {
            player.sendMessage(Main.getInstance().getConfiguration().getPrefix() + Configuration.translateTextCodes(Main.getInstance().getConfig().getString("WeaponBuilder.AffectedEnemies").replace("%affectedEnemiesValue%", String.valueOf(this.weapon.getAffectedEnemies()))));
        }
        if (!(this.weapon.getCooldown() > 0.0)) return true;
        player.sendMessage(Main.getInstance().getConfiguration().getPrefix() + Configuration.translateTextCodes(Main.getInstance().getConfig().getString("WeaponBuilder.Cooldown").replace("%cooldownValue%", String.valueOf(this.weapon.getCooldown()))));
        return true;
    }

    public boolean isUnlocked() {
        return this.unlocked;
    }

    public ItemHologram getItemHologram() {
        return this.itemHologram;
    }

    public Hologram getHologram() {
        return this.hologram;
    }
}

