/*
 * Decompiled with CFR 0.152.
 */
package HologramAPI;

import HologramAPI.Hologram;
import HologramAPI.ItemHologram;
import HologramAPI.WeaponHologram;
import Powerups.PowerupType;
import Weapons.Weapon;
import WeaponsChest.WeaponsChestBlock;
import WeaponsChest.WeaponsChestLocation;
import Zombies.Configuration;
import Zombies.GameArena;
import Zombies.Main;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class WeaponsChestHologram {
    private Hologram hologram;
    private ItemHologram itemHologram;
    private int weaponsChestGold;
    private int weaponsChestShoppingSpreeGold;
    private List<String> inactiveHologramMessage;
    private List<String> activeHologramMessage;
    private List<String> activeFinishedHologramMessage;
    private List<WeaponsChestLocation> weaponsChestLocations;
    private List<Location> locations;
    private WeaponsChestLocation currentWeaponsChestLocation;
    private boolean rolling;
    private boolean finished;
    private Player roller;
    private Weapon finalWeapon;
    private List<BukkitTask> bukkitTasks;
    private GameArena gameArena;

    public WeaponsChestHologram(GameArena gameArena) {
        this.gameArena = gameArena;
        this.weaponsChestLocations = new ArrayList<WeaponsChestLocation>();
        this.bukkitTasks = new ArrayList<BukkitTask>();
        this.locations = new ArrayList<Location>();
        this.weaponsChestGold = Main.getInstance().getConfiguration().getFileConfiguration().getInt("WeaponsChest.GoldPrice");
        this.weaponsChestShoppingSpreeGold = Main.getInstance().getConfiguration().getFileConfiguration().getInt("WeaponsChest.ShoppingSpree.GoldPrice");
        this.inactiveHologramMessage = new ArrayList<String>();
        this.activeHologramMessage = new ArrayList<String>();
        this.activeFinishedHologramMessage = new ArrayList<String>();
        for (String string : Main.getInstance().getConfiguration().getFileConfiguration().getStringList("Messages.WeaponsChest.Inactive.Hologram")) {
            this.inactiveHologramMessage.add(Configuration.translateTextCodes(string).replace("%goldValue%", String.valueOf(this.weaponsChestGold)));
        }
        for (String string : Main.getInstance().getConfiguration().getFileConfiguration().getStringList("Messages.WeaponsChest.Active.Hologram")) {
            this.activeHologramMessage.add(Configuration.translateTextCodes(string).replace("%goldValue%", String.valueOf(this.weaponsChestGold)));
        }
        for (String string : Main.getInstance().getConfiguration().getFileConfiguration().getStringList("Messages.WeaponsChest.ActiveFinished.Hologram")) {
            this.activeFinishedHologramMessage.add(Configuration.translateTextCodes(string).replace("%goldValue%", String.valueOf(this.weaponsChestGold)));
        }
    }

    public List<BukkitTask> getBukkitTasks() {
        return this.bukkitTasks;
    }

    public List<Location> getLocations() {
        return this.locations;
    }

    public void addLocation(WeaponsChestLocation weaponsChestLocation) {
        this.weaponsChestLocations.add(weaponsChestLocation);
    }

    public WeaponsChestLocation getCurrentWeaponsChestLocation() {
        return this.currentWeaponsChestLocation;
    }

    public void loadWeaponsChestLocations() {
        Collections.shuffle(this.weaponsChestLocations);
        this.loadRandomChestLocation();
        for (WeaponsChestLocation weaponsChestLocation : this.weaponsChestLocations) {
            this.locations.addAll(weaponsChestLocation.getLocations());
        }
    }

    public void loadRandomChestLocation() {
        if (!this.weaponsChestLocations.isEmpty()) {
            if (this.currentWeaponsChestLocation != null) {
                for (int i = 0; i < this.weaponsChestLocations.size(); ++i) {
                    Collections.shuffle(this.weaponsChestLocations);
                    WeaponsChestLocation weaponsChestLocation = this.weaponsChestLocations.get(0);
                    if (this.currentWeaponsChestLocation.equals(weaponsChestLocation)) continue;
                    this.currentWeaponsChestLocation = weaponsChestLocation;
                    i = 100;
                }
            } else if (this.weaponsChestLocations.size() > 0) {
                this.currentWeaponsChestLocation = this.weaponsChestLocations.get(0);
            }
        }
    }

    public void loadHolograms(WeaponsChestLocation weaponsChestLocation) {
        if (weaponsChestLocation == null) {
            return;
        }
        if (this.hologram != null) {
            this.hologram.destroy();
        }
        if (this.itemHologram != null) {
            this.itemHologram.destroyFromAll(this.gameArena);
        }
        this.itemHologram = new ItemHologram(weaponsChestLocation.getHologramLocation().clone().add(0.0, -0.73, 0.0));
        this.hologram = new Hologram(weaponsChestLocation.getHologramLocation());
        this.hologram.setCleanLines(this.inactiveHologramMessage);
        this.itemHologram.show(this.gameArena);
        this.hologram.spawn();
    }

    public void restore(Player player) {
        this.itemHologram.show(player);
    }

    public void updateGold() {
        this.inactiveHologramMessage = new ArrayList<String>();
        this.activeHologramMessage = new ArrayList<String>();
        this.activeFinishedHologramMessage = new ArrayList<String>();
        for (String string : Main.getInstance().getConfiguration().getFileConfiguration().getStringList("Messages.WeaponsChest.Inactive.Hologram")) {
            this.inactiveHologramMessage.add(Configuration.translateTextCodes(string).replace("%goldValue%", String.valueOf(this.getWeaponsChestGold())));
        }
        for (String string : Main.getInstance().getConfiguration().getFileConfiguration().getStringList("Messages.WeaponsChest.Active.Hologram")) {
            this.activeHologramMessage.add(Configuration.translateTextCodes(string).replace("%goldValue%", String.valueOf(this.getWeaponsChestGold())));
        }
        for (String string : Main.getInstance().getConfiguration().getFileConfiguration().getStringList("Messages.WeaponsChest.ActiveFinished.Hologram")) {
            this.activeFinishedHologramMessage.add(Configuration.translateTextCodes(string).replace("%goldValue%", String.valueOf(this.getWeaponsChestGold())));
        }
        if (!this.isRolling()) {
            this.hologram.setCleanLines(this.inactiveHologramMessage);
            this.hologram.destroy();
            this.hologram.spawn();
            ArrayList arrayList = new ArrayList();
            int n = 1;
            for (String string : this.inactiveHologramMessage) {
                arrayList.add(string);
                this.hologram.changeTexts(string, n);
                ++n;
            }
            this.hologram.setCleanLines(arrayList);
        }
    }

    public int getWeaponsChestGold() {
        if (Main.getInstance().getPowerupHandler().isActive(this.gameArena, PowerupType.SHOPPING_SPREE)) {
            return this.weaponsChestShoppingSpreeGold;
        }
        return this.weaponsChestGold;
    }

    public int getEmptyWeaponSlot(Player player) {
        for (int n : Main.getInstance().getWeaponHandler().getWeaponSlots(player)) {
            Weapon weapon = Weapon.getWeapon(player.getInventory().getItem(n));
            if (weapon != null) continue;
            return n;
        }
        return -1;
    }

    public void setRolling(boolean bl) {
        this.rolling = bl;
    }

    public boolean isRolling() {
        return this.rolling;
    }

    public void setFinished(boolean bl) {
        this.finished = bl;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void setRoller(Player player) {
        this.roller = player;
    }

    public Player getRoller() {
        return this.roller;
    }

    public void move() {
        int n;
        if (this.weaponsChestLocations.size() > 1 && (n = ThreadLocalRandom.current().nextInt(0, 100)) >= 40) {
            if (this.gameArena == null) {
                return;
            }
            this.gameArena.sendMessage(Main.getInstance().getConfiguration().getMessage("WeaponsChest.Moved"));
            this.loadRandomChestLocation();
            this.loadHolograms(this.getCurrentWeaponsChestLocation());
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public void claim() {
        if (this.isFinished() && this.isRolling()) {
            Player player = this.getRoller();
            if (player == null) {
                return;
            }
            if (Main.getInstance().getConfiguration().getGameArena(player) == null) {
                return;
            }
            int n = this.getEmptyWeaponSlot(player);
            if (n == -1) {
                int n2 = player.getInventory().getHeldItemSlot();
                if (!Main.getInstance().getWeaponHandler().getWeaponSlots(player).contains(n2)) {
                    player.sendMessage(Main.getInstance().getConfiguration().getMessage("WeaponsChest.WrongClick"));
                    return;
                }
                if (Main.getInstance().getWeaponHandler().hasWeapon(player, this.finalWeapon)) {
                    player.sendMessage(Main.getInstance().getConfiguration().getMessage("WeaponsChest.AlreadyAvailable"));
                    return;
                }
                Weapon weapon = Weapon.getWeapon(player.getInventory().getItem(n2));
                if (weapon != null) {
                    Main.getInstance().getWeaponHandler().unloadWeapon(player, n2, weapon);
                }
                for (WeaponHologram weaponHologram : Main.getInstance().getConfiguration().getGameArena(player).getWeaponHolograms(player)) {
                    if (weaponHologram.equals(this) || !weaponHologram.getWeapon().getWeaponName().equals(weapon.getWeaponName())) continue;
                    weaponHologram.setUnlocked(false);
                }
                player.getInventory().setItem(n2, this.finalWeapon.getItemStack());
                Main.getInstance().getWeaponHandler().loadWeaponAmmo(player, this.finalWeapon);
                if (this.finalWeapon.getDamage() > 0.0) {
                    player.sendMessage(Main.getInstance().getConfiguration().getPrefix() + Configuration.translateTextCodes(Main.getInstance().getConfig().getString("WeaponBuilder.Damage").replace("%damageValue%", String.valueOf(this.finalWeapon.getDamage()))));
                }
                if (this.finalWeapon.getAmmo() > 0) {
                    player.sendMessage(Main.getInstance().getConfiguration().getPrefix() + Configuration.translateTextCodes(Main.getInstance().getConfig().getString("WeaponBuilder.Ammo").replace("%ammoValue%", String.valueOf(this.finalWeapon.getAmmo()))));
                }
                if (this.finalWeapon.getClipAmmo() > 0) {
                    player.sendMessage(Main.getInstance().getConfiguration().getPrefix() + Configuration.translateTextCodes(Main.getInstance().getConfig().getString("WeaponBuilder.ClipAmmo").replace("%clipAmmoValue%", String.valueOf(this.finalWeapon.getClipAmmo()))));
                }
                if (this.finalWeapon.getFireRate() > 0.0) {
                    player.sendMessage(Main.getInstance().getConfiguration().getPrefix() + Configuration.translateTextCodes(Main.getInstance().getConfig().getString("WeaponBuilder.FireRate").replace("%fireRateValue%", String.valueOf(this.finalWeapon.getFireRate()))));
                }
                if (this.finalWeapon.getReload() > 0.0) {
                    player.sendMessage(Main.getInstance().getConfiguration().getPrefix() + Configuration.translateTextCodes(Main.getInstance().getConfig().getString("WeaponBuilder.Reload").replace("%reloadValue%", String.valueOf(this.finalWeapon.getReload()))));
                }
                if (this.finalWeapon.getAffectedEnemies() > 0) {
                    player.sendMessage(Main.getInstance().getConfiguration().getPrefix() + Configuration.translateTextCodes(Main.getInstance().getConfig().getString("WeaponBuilder.AffectedEnemies").replace("%affectedEnemiesValue%", String.valueOf(this.finalWeapon.getAffectedEnemies()))));
                }
                if (this.finalWeapon.getCooldown() > 0.0) {
                    player.sendMessage(Main.getInstance().getConfiguration().getPrefix() + Configuration.translateTextCodes(Main.getInstance().getConfig().getString("WeaponBuilder.Cooldown").replace("%cooldownValue%", String.valueOf(this.finalWeapon.getCooldown()))));
                }
                player.sendMessage(Main.getInstance().getConfiguration().getMessage("WeaponsChest.Claimed").replace("%weaponName%", this.finalWeapon.getDisplayName()));
            } else {
                if (Main.getInstance().getWeaponHandler().hasWeapon(player, this.finalWeapon)) {
                    player.sendMessage(Main.getInstance().getConfiguration().getMessage("WeaponsChest.AlreadyAvailable"));
                    return;
                }
                player.getInventory().setItem(n, this.finalWeapon.getItemStack());
                Main.getInstance().getWeaponHandler().loadWeaponAmmo(player, this.finalWeapon);
                player.sendMessage(Main.getInstance().getConfiguration().getMessage("WeaponsChest.Claimed").replace("%weaponName%", this.finalWeapon.getDisplayName()));
            }
            for (BukkitTask bukkitTask : this.bukkitTasks) {
                bukkitTask.cancel();
            }
            new WeaponsChestBlock().changeState(this.gameArena, this.getCurrentWeaponsChestLocation().getLocations().get(0), false);
            this.bukkitTasks.clear();
            this.setFinished(false);
            this.setRolling(false);
            this.itemHologram.destroyFromAll(this.gameArena);
            this.setRoller(null);
            this.hologram.setCleanLines(this.inactiveHologramMessage);
            this.hologram.destroy();
            this.hologram.spawn();
            ArrayList arrayList = new ArrayList();
            boolean bl = true;
            for (String string : this.inactiveHologramMessage) {
                void var4_9;
                arrayList.add(string);
                this.hologram.changeTexts(string, (int)var4_9);
                ++var4_9;
            }
            this.hologram.setCleanLines(arrayList);
            this.move();
        }
    }

    public void closeChest() {
        Location location;
        if (this.gameArena == null) {
            return;
        }
        if (this.getCurrentWeaponsChestLocation() == null) {
            return;
        }
        if (this.getCurrentWeaponsChestLocation().getLocations().size() > 0 && (location = this.getCurrentWeaponsChestLocation().getLocations().get(0)) != null) {
            new WeaponsChestBlock().changeState(this.gameArena, location, false);
        }
    }

    public boolean roll(final Player player) {
        if (this.isRolling()) {
            return false;
        }
        if (Main.getInstance().getConfiguration().getGameArena(player) == null) {
            return false;
        }
        if (Main.getInstance().getConfiguration().getGameArena(player).getGold(player) < this.getWeaponsChestGold()) {
            player.sendMessage(Main.getInstance().getConfiguration().getMessage("NotEnoughGold"));
            player.playSound(player.getEyeLocation(), Sound.valueOf((String)Main.getInstance().getConfiguration().getSound("NotEnoughGold")), 1.0f, Main.getInstance().getConfiguration().convertDouble("SoundPitch.NotEnoughGold"));
            return false;
        }
        Main.getInstance().getConfiguration().getGameArena(player).removeGold(player, this.getWeaponsChestGold());
        this.setRoller(player);
        this.setRolling(true);
        new WeaponsChestBlock().changeState(this.gameArena, this.getCurrentWeaponsChestLocation().getLocations().get(0), true);
        final ArrayList<Weapon> arrayList = new ArrayList<Weapon>();
        for (Weapon weapon : Main.getInstance().getConfiguration().getWeapons()) {
            if (!weapon.isWeaponsChest()) continue;
            arrayList.add(weapon);
        }
        Collections.shuffle(arrayList);
        BukkitTask bukkitTask = new BukkitRunnable(){
            int ticksBetweenRolling = 1;
            int currentTicks = 0;
            int activeTicks = 0;
            int maxTicks = 200 + ThreadLocalRandom.current().nextInt(60);
            Weapon currentWeapon = null;
            int currentWeaponId = 0;
            boolean updated = false;
            double pitch = 0.8;
            boolean pitchDownwards = false;

            public void run() {
                if (this.currentTicks >= this.maxTicks) {
                    WeaponsChestHologram.this.finalWeapon = this.currentWeapon;
                    WeaponsChestHologram.this.setFinished(true);
                    for (Player player2 : Main.getInstance().getConfiguration().getGameArena(player).getPlayers()) {
                        if (!player2.equals(player)) {
                            player2.sendMessage(Main.getInstance().getConfiguration().getMessage("WeaponsChest.FoundWeapon").replace("%displayName%", player.getDisplayName()).replace("%playerName%", player.getName()).replace("%weaponName%", WeaponsChestHologram.this.finalWeapon.getDisplayName()).replace("%claimDuration%", String.valueOf(Main.getInstance().getConfiguration().getFileConfiguration().getDouble("WeaponsChest.ClaimDuration"))));
                            continue;
                        }
                        player2.sendMessage(Main.getInstance().getConfiguration().getMessage("WeaponsChest.PersonalFoundWeapon").replace("%weaponName%", WeaponsChestHologram.this.finalWeapon.getDisplayName()).replace("%claimDuration%", String.valueOf(Main.getInstance().getConfiguration().getFileConfiguration().getDouble("WeaponsChest.ClaimDuration"))));
                    }
                    BukkitTask bukkitTask = new BukkitRunnable(){
                        DecimalFormat decimalFormat = new DecimalFormat("0.0");
                        double claimTime = Main.getInstance().getConfiguration().getFileConfiguration().getDouble("WeaponsChest.ClaimDuration");
                        boolean updatedClaim = false;
                        boolean updatedFinished = false;

                        public void run() {
                            if (this.claimTime <= 0.0) {
                                WeaponsChestHologram.this.itemHologram.destroyFromAll(WeaponsChestHologram.this.gameArena);
                                if (!this.updatedClaim) {
                                    WeaponsChestHologram.this.hologram.setCleanLines(WeaponsChestHologram.this.inactiveHologramMessage);
                                    this.updatedClaim = true;
                                    WeaponsChestHologram.this.hologram.destroy();
                                    WeaponsChestHologram.this.hologram.spawn();
                                }
                                ArrayList<String> arrayList = new ArrayList<String>();
                                int n = 1;
                                for (String string : WeaponsChestHologram.this.inactiveHologramMessage) {
                                    arrayList.add(string);
                                    WeaponsChestHologram.this.hologram.changeTexts(string, n);
                                    ++n;
                                }
                                WeaponsChestHologram.this.hologram.setCleanLines(arrayList);
                                WeaponsChestHologram.this.setFinished(false);
                                WeaponsChestHologram.this.setRolling(false);
                                new WeaponsChestBlock().changeState(WeaponsChestHologram.this.gameArena, WeaponsChestHologram.this.getCurrentWeaponsChestLocation().getLocations().get(0), false);
                                WeaponsChestHologram.this.setRoller(null);
                                WeaponsChestHologram.this.move();
                                this.cancel();
                                return;
                            }
                            if (!this.updatedFinished) {
                                WeaponsChestHologram.this.hologram.setCleanLines(WeaponsChestHologram.this.activeFinishedHologramMessage);
                                this.updatedFinished = true;
                                WeaponsChestHologram.this.hologram.destroy();
                                WeaponsChestHologram.this.hologram.spawn();
                            }
                            ArrayList<String> arrayList = new ArrayList<String>();
                            int n = 1;
                            for (String string : WeaponsChestHologram.this.activeFinishedHologramMessage) {
                                arrayList.add(string.replace("%time%", this.decimalFormat.format(this.claimTime).replace(",", ".")).replace("%weaponName%", currentWeapon.getDisplayName()).replace("%displayName%", player.getDisplayName()).replace("%playerName%", player.getName()));
                                WeaponsChestHologram.this.hologram.changeTexts(string.replace("%time%", this.decimalFormat.format(this.claimTime).replace(",", ".")).replace("%weaponName%", currentWeapon.getDisplayName()).replace("%displayName%", player.getDisplayName()).replace("%playerName%", player.getName()), n);
                                ++n;
                            }
                            this.claimTime -= 0.1;
                            WeaponsChestHologram.this.hologram.setCleanLines(arrayList);
                        }
                    }.runTaskTimer((Plugin)Main.getInstance(), 2L, 2L);
                    WeaponsChestHologram.this.bukkitTasks.add(bukkitTask);
                    this.cancel();
                    return;
                }
                if (this.activeTicks % this.ticksBetweenRolling == 0) {
                    if (this.currentWeaponId >= arrayList.size()) {
                        this.currentWeaponId = 0;
                    }
                    if (!arrayList.isEmpty()) {
                        this.currentWeapon = (Weapon)arrayList.get(this.currentWeaponId);
                    }
                    ++this.currentWeaponId;
                    ItemStack itemStack = null;
                    if (this.currentWeapon != null) {
                        itemStack = this.currentWeapon.getItemStack().clone();
                    }
                    itemStack.setAmount(1);
                    WeaponsChestHologram.this.itemHologram.setCleanItems(itemStack);
                    if (!this.updated) {
                        WeaponsChestHologram.this.hologram.setCleanLines(WeaponsChestHologram.this.activeHologramMessage);
                        this.updated = true;
                        WeaponsChestHologram.this.hologram.destroy();
                        WeaponsChestHologram.this.hologram.spawn();
                    }
                    ArrayList<String> arrayList2 = new ArrayList<String>();
                    int n = 1;
                    for (String string : WeaponsChestHologram.this.activeHologramMessage) {
                        arrayList2.add(string.replace("%weaponName%", this.currentWeapon.getDisplayName()).replace("%displayName%", player.getDisplayName()).replace("%playerName%", player.getName()));
                        WeaponsChestHologram.this.hologram.changeTexts(string.replace("%weaponName%", this.currentWeapon.getDisplayName()).replace("%displayName%", player.getDisplayName()).replace("%playerName%", player.getName()), n);
                        ++n;
                    }
                    WeaponsChestHologram.this.hologram.setCleanLines(arrayList2);
                    ++this.ticksBetweenRolling;
                    this.activeTicks = 0;
                    WeaponsChestHologram.this.itemHologram.destroyFromAll(WeaponsChestHologram.this.gameArena);
                    WeaponsChestHologram.this.itemHologram.show(WeaponsChestHologram.this.gameArena);
                    Location location = WeaponsChestHologram.this.getCurrentWeaponsChestLocation().getHologramLocation();
                    location.getWorld().playSound(location, Sound.valueOf((String)Main.getInstance().getConfiguration().getSound("WeaponsChestRolling")), 1.0f, (float)this.pitch);
                    this.pitch = this.pitchDownwards ? (this.pitch -= 0.1) : (this.pitch += 0.1);
                    if (this.pitch >= 0.9) {
                        this.pitchDownwards = true;
                    }
                    if (this.pitch <= 0.7) {
                        this.pitchDownwards = false;
                    }
                }
                ++this.currentTicks;
                ++this.activeTicks;
            }
        }.runTaskTimer((Plugin)Main.getInstance(), 0L, 0L);
        this.bukkitTasks.add(bukkitTask);
        return true;
    }

    public ItemHologram getItemHologram() {
        return this.itemHologram;
    }

    public Hologram getHologram() {
        return this.hologram;
    }
}

