/*
 * Decompiled with CFR 0.152.
 */
package ScoreboardUtils;

import ScoreboardUtils.BoardLine;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;

public class GameScoreboard {
    private Scoreboard scoreboard = Bukkit.getScoreboardManager().getNewScoreboard();
    private Objective objective = this.scoreboard.registerNewObjective("board-" + this.boardId, "dummy");
    private List<String> textLines;
    private List<BoardLine> boardLines;
    private int boardId = 0;

    public GameScoreboard(String string) {
        this.objective.setDisplaySlot(DisplaySlot.SIDEBAR);
        this.boardLines = new ArrayList<BoardLine>();
        this.textLines = new ArrayList<String>();
        this.setTitle(string);
        ++this.boardId;
    }

    public void setTitle(String string) {
        this.objective.setDisplayName(string);
    }

    public void setLines(List<String> list) {
        this.textLines = list;
    }

    public void setScoreboard(Player player) {
        player.setScoreboard(this.scoreboard);
    }

    public void reset() {
        for (BoardLine boardLine : this.boardLines) {
            boardLine.getTeam().unregister();
        }
        this.boardLines = new ArrayList<BoardLine>();
        this.textLines = new ArrayList<String>();
        this.objective = this.scoreboard.registerNewObjective("board-" + this.boardId, "dummy");
        this.objective.setDisplaySlot(DisplaySlot.SIDEBAR);
        ++this.boardId;
    }

    public void update() {
        if (this.boardLines.isEmpty()) {
            int n = this.textLines.size();
            for (String string : this.textLines) {
                BoardLine boardLine = new BoardLine(this, string);
                this.objective.getScore((OfflinePlayer)boardLine.addPlayer(n)).setScore(n);
                this.boardLines.add(boardLine);
                --n;
            }
        } else {
            int n = 0;
            for (String string : this.textLines) {
                if (this.boardLines.size() <= n) continue;
                BoardLine boardLine = this.boardLines.get(n);
                if (boardLine != null) {
                    boardLine.updateSettings(string);
                }
                ++n;
            }
        }
    }

    public Scoreboard getScoreboard() {
        return this.scoreboard;
    }
}

