/*
 * Decompiled with CFR 0.152.
 */
package Utils;

import Zombies.GameArena;
import Zombies.Main;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class GameEntity {
    private Entity entity;
    private GameArena gameArena;
    private Player targetPlayer;
    private Location targetLocation;
    private double entitySpeed;
    private double entityRange;
    private Object entityNavigation;
    private Object entityInsentient;
    private boolean appliedAttributes;

    public GameEntity(Entity entity, Object object, Object object2, GameArena gameArena) {
        this.entity = entity;
        this.entityNavigation = object;
        this.entityInsentient = object2;
        this.gameArena = gameArena;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public GameEntity setTargetPlayer(Player player) {
        this.targetPlayer = player;
        return this;
    }

    public GameEntity setTargetLocation(Location location) {
        this.targetLocation = location;
        return this;
    }

    public GameEntity setEntitySpeed(double d) {
        this.entitySpeed = d;
        return this;
    }

    public GameEntity setEntityRange(double d) {
        this.entityRange = d;
        return this;
    }

    public GameArena getGameArena() {
        return this.gameArena;
    }

    public Object getEntityNavigation() {
        return this.entityNavigation;
    }

    public Object getEntityInsentient() {
        return this.entityInsentient;
    }

    public boolean applyAttributes() {
        if (this.appliedAttributes) {
            return false;
        }
        this.appliedAttributes = true;
        return true;
    }

    public Location getLocation() {
        if (this.targetPlayer == null) {
            return this.targetLocation;
        }
        return this.targetPlayer.getLocation();
    }

    public Location getTargetLocation() {
        return this.targetLocation;
    }

    public Player getTargetPlayer() {
        if (this.targetPlayer != null) {
            GameArena gameArena = Main.getInstance().getConfiguration().getGameArena(this.targetPlayer);
            if (gameArena == null) {
                return null;
            }
            if (!this.targetPlayer.isOnline()) {
                return null;
            }
            if (gameArena.getName().equalsIgnoreCase(this.gameArena.getName())) {
                if (this.gameArena.isRevivedPlayer(this.targetPlayer) || this.gameArena.isDead(this.targetPlayer)) {
                    return null;
                }
                return this.targetPlayer;
            }
            return null;
        }
        return null;
    }

    public double getEntitySpeed() {
        return this.entitySpeed;
    }

    public double getEntityRange() {
        return this.entityRange;
    }
}

