/*
 * Decompiled with CFR 0.152.
 */
package Utils;

import Events.ArenaLooseEvent;
import Events.ArenaPlayerKillEnemyEvent;
import Events.ArenaStartEvent;
import Events.ArenaWinEvent;
import MySQL.PlayerStats;
import MySQL.StatsField;
import Utils.PrivateStatsHologram;
import Zombies.Main;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class StatsHandler
implements Listener {
    private Map<String, PrivateStatsHologram> hologramList = new HashMap<String, PrivateStatsHologram>();
    private Map<String, Map<String, PrivateStatsHologram>> playersHolograms = new HashMap<String, Map<String, PrivateStatsHologram>>();
    private List<BukkitTask> tasks = new ArrayList<BukkitTask>();

    public StatsHandler() {
        BukkitTask bukkitTask = new BukkitRunnable(){

            public void run() {
                if (!Main.getInstance().getStats().isEnabled()) {
                    return;
                }
                StatsHandler.this.hologramList = new HashMap();
                ConfigurationSection configurationSection = Main.getInstance().getConfig().getConfigurationSection("Stats");
                if (configurationSection != null) {
                    for (String string : configurationSection.getKeys(false)) {
                        String string2 = Main.getInstance().getConfig().getString("Stats." + string + ".World");
                        double d = Main.getInstance().getConfig().getDouble("Stats." + string + ".X");
                        double d2 = Main.getInstance().getConfig().getDouble("Stats." + string + ".Y");
                        double d3 = Main.getInstance().getConfig().getDouble("Stats." + string + ".Z");
                        StatsField statsField = StatsField.valueOf(Main.getInstance().getConfig().getString("Stats." + string + ".StatsField"));
                        String string3 = Main.getInstance().getConfig().getString("Stats." + string + ".MapName");
                        boolean bl = Main.getInstance().getConfig().getBoolean("Stats." + string + ".Global");
                        int n = Main.getInstance().getConfig().getInt("Stats." + string + ".Amount");
                        List list = Main.getInstance().getConfig().getStringList("Stats." + string + ".Messages");
                        PrivateStatsHologram privateStatsHologram = new PrivateStatsHologram(statsField, string, string3, bl, list, new Location(Bukkit.getWorld((String)string2), d, d2, d3)).colorize().replace("%mapName%", string3);
                        Map<Integer, PlayerStats> map = statsField == StatsField.FASTEST_WIN_TIME ? (bl ? Main.getInstance().getStatsUtils().getLowestValues(statsField, n) : Main.getInstance().getStatsUtils().getLowestValues(string3, statsField, n)) : (bl ? Main.getInstance().getStatsUtils().getHighestValues(statsField, n) : Main.getInstance().getStatsUtils().getHighestValues(string3, statsField, n));
                        for (int i = 1; i <= n; ++i) {
                            if (map.containsKey(i)) {
                                String string4 = "?";
                                Player player = Bukkit.getPlayer((UUID)UUID.fromString(map.get(i).getUniqueId()));
                                if (player != null) {
                                    string4 = player.getName();
                                } else {
                                    OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)UUID.fromString(map.get(i).getUniqueId()));
                                    if (offlinePlayer != null) {
                                        string4 = offlinePlayer.getName();
                                    }
                                }
                                if (string4 == null) {
                                    privateStatsHologram.replace("%playerStats_" + i + "%", "").replace("%playerName_" + i + "%", "");
                                    continue;
                                }
                                if (string4.equals("?")) {
                                    privateStatsHologram.replace("%playerStats_" + i + "%", "").replace("%playerName_" + i + "%", "");
                                    continue;
                                }
                                privateStatsHologram.replace("%playerStats_" + i + "%", String.valueOf(map.get(i).getStats(statsField))).replace("%playerName_" + i + "%", string4);
                                continue;
                            }
                            privateStatsHologram.replace("%playerStats_" + i + "%", "").replace("%playerName_" + i + "%", "");
                        }
                        StatsHandler.this.hologramList.put(string, privateStatsHologram);
                    }
                }
                for (String string : StatsHandler.this.playersHolograms.keySet()) {
                    for (Map.Entry entry : ((Map)StatsHandler.this.playersHolograms.get(string)).entrySet()) {
                        Player player = Bukkit.getPlayer((UUID)UUID.fromString(string));
                        if (player == null) continue;
                        ((PrivateStatsHologram)entry.getValue()).getHologram().destroyFrom(player);
                    }
                }
                StatsHandler.this.playersHolograms = new HashMap();
                StatsHandler.this.runUpdate();
            }
        }.runTaskTimerAsynchronously((Plugin)Main.getInstance(), 100L, (long)Main.getInstance().getConfiguration().getInteger("DelayedUpdateTicks").intValue());
        BukkitTask bukkitTask2 = new BukkitRunnable(){

            public void run() {
                StatsHandler.this.runUpdate();
            }
        }.runTaskTimerAsynchronously((Plugin)Main.getInstance(), 150L, 20L);
        this.tasks.add(bukkitTask);
        this.tasks.add(bukkitTask2);
    }

    public void runUpdate() {
        if (!Main.getInstance().getStats().isEnabled()) {
            return;
        }
        ArrayList<PrivateStatsHologram> arrayList = new ArrayList<PrivateStatsHologram>();
        for (PrivateStatsHologram privateStatsHologram : this.hologramList.values()) {
            arrayList.add(privateStatsHologram);
        }
        for (PrivateStatsHologram privateStatsHologram : Bukkit.getOnlinePlayers()) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                PrivateStatsHologram privateStatsHologram2;
                PrivateStatsHologram privateStatsHologram3 = privateStatsHologram2 = (PrivateStatsHologram)iterator.next();
                if (privateStatsHologram.getWorld().equals(privateStatsHologram3.getLocation().getWorld())) {
                    if (privateStatsHologram.getLocation().distance(privateStatsHologram3.getLocation()) < 32.0) {
                        Object object;
                        PlayerStats playerStats;
                        Object object2;
                        PrivateStatsHologram privateStatsHologram4;
                        if (!this.playersHolograms.containsKey(privateStatsHologram.getUniqueId().toString())) {
                            this.playersHolograms.put(privateStatsHologram.getUniqueId().toString(), new HashMap());
                        }
                        if (this.playersHolograms.get(privateStatsHologram.getUniqueId().toString()).containsKey(privateStatsHologram3.getName())) {
                            privateStatsHologram4 = this.playersHolograms.get(privateStatsHologram.getUniqueId().toString()).get(privateStatsHologram3.getName());
                            if (System.currentTimeMillis() <= privateStatsHologram4.getTimeout()) continue;
                            privateStatsHologram4.getHologram().destroyFrom((Player)privateStatsHologram);
                            object2 = privateStatsHologram3.clone();
                            ((PrivateStatsHologram)object2).setTimeout(120000L);
                            playerStats = Main.getInstance().getStatsUtils().getMapPlayerStats(privateStatsHologram.getUniqueId().toString(), privateStatsHologram3.getMapName());
                            object = Main.getInstance().getStatsUtils().getGlobalPlayerStats(privateStatsHologram.getUniqueId().toString(), privateStatsHologram3.getStatsField());
                            String string = privateStatsHologram3.isGlobalStats() ? String.valueOf(((PlayerStats)object).getStats(privateStatsHologram3.getStatsField())) : String.valueOf(playerStats.getStats(privateStatsHologram3.getStatsField()));
                            ((PrivateStatsHologram)object2).replace("%personalStats%", string);
                            ((PrivateStatsHologram)object2).send((Player)privateStatsHologram);
                            this.playersHolograms.get(privateStatsHologram.getUniqueId().toString()).put(privateStatsHologram3.getName(), (PrivateStatsHologram)object2);
                            continue;
                        }
                        privateStatsHologram4 = privateStatsHologram3.clone();
                        privateStatsHologram4.setTimeout(120000L);
                        if (privateStatsHologram3 != null && privateStatsHologram3.getHologram() != null) {
                            privateStatsHologram3.getHologram().destroyFrom((Player)privateStatsHologram);
                        }
                        object2 = Main.getInstance().getStatsUtils().getMapPlayerStats(privateStatsHologram.getUniqueId().toString(), privateStatsHologram3.getMapName());
                        playerStats = Main.getInstance().getStatsUtils().getGlobalPlayerStats(privateStatsHologram.getUniqueId().toString(), privateStatsHologram3.getStatsField());
                        object = privateStatsHologram3.isGlobalStats() ? String.valueOf(playerStats.getStats(privateStatsHologram3.getStatsField())) : String.valueOf(((PlayerStats)object2).getStats(privateStatsHologram3.getStatsField()));
                        privateStatsHologram4.replace("%personalStats%", (String)object);
                        privateStatsHologram4.send((Player)privateStatsHologram);
                        if (!this.playersHolograms.containsKey(privateStatsHologram.getUniqueId().toString())) {
                            this.playersHolograms.put(privateStatsHologram.getUniqueId().toString(), new HashMap());
                        }
                        if (!this.playersHolograms.containsKey(privateStatsHologram.getUniqueId().toString())) continue;
                        this.playersHolograms.get(privateStatsHologram.getUniqueId().toString()).put(privateStatsHologram3.getName(), privateStatsHologram4);
                        continue;
                    }
                    if (!this.playersHolograms.containsKey(privateStatsHologram.getUniqueId().toString()) || !this.playersHolograms.get(privateStatsHologram.getUniqueId().toString()).containsKey(privateStatsHologram3.getName())) continue;
                    this.playersHolograms.get(privateStatsHologram.getUniqueId().toString()).get(privateStatsHologram3.getName()).getHologram().destroyFrom((Player)privateStatsHologram);
                    this.playersHolograms.get(privateStatsHologram.getUniqueId().toString()).remove(privateStatsHologram3.getName());
                    continue;
                }
                if (!this.playersHolograms.containsKey(privateStatsHologram.getUniqueId().toString()) || !this.playersHolograms.get(privateStatsHologram.getUniqueId().toString()).containsKey(privateStatsHologram3.getName())) continue;
                this.playersHolograms.get(privateStatsHologram.getUniqueId().toString()).get(privateStatsHologram3.getName()).getHologram().destroyFrom((Player)privateStatsHologram);
                this.playersHolograms.get(privateStatsHologram.getUniqueId().toString()).remove(privateStatsHologram3.getName());
            }
        }
    }

    public void removeStats() {
        for (String string : this.playersHolograms.keySet()) {
            for (Map.Entry<String, PrivateStatsHologram> entry : this.playersHolograms.get(string).entrySet()) {
                Player player = Bukkit.getPlayer((UUID)UUID.fromString(string));
                if (player == null) continue;
                entry.getValue().getHologram().destroyFrom(player);
            }
        }
    }

    public void cancelTasks() {
        for (BukkitTask bukkitTask : this.tasks) {
            bukkitTask.cancel();
        }
    }

    @EventHandler
    public void quitPlayer(PlayerQuitEvent playerQuitEvent) {
        Player player = playerQuitEvent.getPlayer();
        if (this.playersHolograms.containsKey(player.getUniqueId().toString())) {
            for (Map.Entry<String, PrivateStatsHologram> entry : this.playersHolograms.get(player.getUniqueId().toString()).entrySet()) {
                entry.getValue().getHologram().destroyFrom(player);
            }
            this.playersHolograms.remove(player.getUniqueId().toString());
        }
    }

    @EventHandler
    public void kickPlayer(PlayerKickEvent playerKickEvent) {
        Player player = playerKickEvent.getPlayer();
        if (this.playersHolograms.containsKey(player.getUniqueId().toString())) {
            for (Map.Entry<String, PrivateStatsHologram> entry : this.playersHolograms.get(player.getUniqueId().toString()).entrySet()) {
                entry.getValue().getHologram().destroyFrom(player);
            }
            this.playersHolograms.remove(player.getUniqueId().toString());
        }
    }

    @EventHandler
    public void respawn(PlayerRespawnEvent playerRespawnEvent) {
        Player player = playerRespawnEvent.getPlayer();
        if (this.playersHolograms.containsKey(player.getUniqueId().toString())) {
            for (Map.Entry<String, PrivateStatsHologram> entry : this.playersHolograms.get(player.getUniqueId().toString()).entrySet()) {
                entry.getValue().getHologram().destroyFrom(player);
            }
            this.playersHolograms.remove(player.getUniqueId().toString());
        }
    }

    @EventHandler
    public void arenaWin(ArenaWinEvent arenaWinEvent) {
        for (String string : arenaWinEvent.getGameArena().getPlayersUUID()) {
            PlayerStats playerStats = Main.getInstance().getStatsUtils().getStats(arenaWinEvent.getArenaName(), string);
            if (playerStats == null) continue;
            int n = playerStats.getWins();
            Main.getInstance().getStatsUtils().updateStats(arenaWinEvent.getArenaName(), StatsField.WINS, string, ++n);
        }
    }

    @EventHandler
    public void arenaLoose(ArenaLooseEvent arenaLooseEvent) {
        for (String string : arenaLooseEvent.getGameArena().getPlayersUUID()) {
            PlayerStats playerStats = Main.getInstance().getStatsUtils().getStats(arenaLooseEvent.getArenaName(), string);
            if (playerStats == null) continue;
            int n = playerStats.getLooses();
            Main.getInstance().getStatsUtils().updateStats(arenaLooseEvent.getArenaName(), StatsField.LOOSES, string, ++n);
        }
    }

    @EventHandler
    public void arenaKill(ArenaPlayerKillEnemyEvent arenaPlayerKillEnemyEvent) {
        Player player = arenaPlayerKillEnemyEvent.getPlayer();
        PlayerStats playerStats = Main.getInstance().getStatsUtils().getStats(arenaPlayerKillEnemyEvent.getArenaName(), player.getUniqueId().toString());
        if (playerStats != null) {
            int n = playerStats.getKills();
            Main.getInstance().getStatsUtils().updateStats(arenaPlayerKillEnemyEvent.getArenaName(), StatsField.KILLS, player.getUniqueId().toString(), ++n);
        }
    }

    @EventHandler
    public void arenaStart(ArenaStartEvent arenaStartEvent) {
        for (Player player : arenaStartEvent.getGameArena().getPlayers()) {
            PlayerStats playerStats = Main.getInstance().getStatsUtils().getStats(arenaStartEvent.getArenaName(), player.getUniqueId().toString());
            if (playerStats == null) continue;
            int n = playerStats.getGamesPlayed();
            Main.getInstance().getStatsUtils().updateStats(arenaStartEvent.getArenaName(), StatsField.GAMES_PLAYED, player.getUniqueId().toString(), ++n);
        }
    }
}

