/*
 * Decompiled with CFR 0.152.
 */
package Zombies;

import ActionBarAPI.ActionBar;
import Events.ArenaLoadEvent;
import Events.ArenaLooseEvent;
import Events.ArenaPlayerJoinEvent;
import Events.ArenaPlayerKillEnemyEvent;
import Events.ArenaPlayerQuitEvent;
import Events.ArenaPlayerRespawnEvent;
import Events.ArenaPlayerReviveEvent;
import Events.ArenaPreStartEvent;
import Events.ArenaPreStopEvent;
import Events.ArenaPreTickEvent;
import Events.ArenaRestartEvent;
import Events.ArenaStartEvent;
import Events.ArenaStateChangeEvent;
import Events.ArenaStopEvent;
import Events.ArenaUpdateRoundEvent;
import Events.ArenaWinEvent;
import Handlers.MultiArenaHandler;
import HologramAPI.ArmorHologram;
import HologramAPI.Hologram;
import HologramAPI.PerkHologram;
import HologramAPI.PowerSwitchHologram;
import HologramAPI.PowerupHologram;
import HologramAPI.TeamMachineHologram;
import HologramAPI.UltimateMachineHologram;
import HologramAPI.WeaponHologram;
import HologramAPI.WeaponsChestHologram;
import MySQL.PlayerStats;
import MySQL.StatsField;
import Perks.PerkType;
import Powerups.PowerupType;
import Revive.RevivePlayer;
import ScoreboardUtils.GameScoreboard;
import TitleAPI.Title;
import Utils.EntityUtils;
import Utils.InventoryItem;
import Utils.ItemStackUtils;
import Utils.LocationUtils;
import Utils.PlayerDisplayer;
import Utils.PlayerSettings;
import Utils.Reflection;
import Utils.WorldReset;
import Utils.ZombieType;
import Weapons.Weapon;
import WeaponsChest.WeaponsChestLocation;
import Zombies.Configuration;
import Zombies.Main;
import java.io.File;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Sign;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Blaze;
import org.bukkit.entity.CaveSpider;
import org.bukkit.entity.Endermite;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Guardian;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.PigZombie;
import org.bukkit.entity.Player;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.Spider;
import org.bukkit.entity.Witch;
import org.bukkit.entity.Wither;
import org.bukkit.entity.Wolf;
import org.bukkit.entity.Zombie;
import org.bukkit.event.Event;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Vector;

public class GameArena {
    private FileConfiguration fileConfiguration;
    private final String mapName;
    private final int minPlayers;
    private final int maxPlayers;
    private int lobbyTime;
    private final int fullLobbyTime;
    private int restartTime;
    private String inGameTime;
    private int round;
    private String state;
    private String gameState;
    private int zombiesLeft;
    private int totalkills;
    private int normalZombies;
    private int normalStrongZombies;
    private int normalProtectedZombies;
    private int pigZombies;
    private int tntZombies;
    private int empoweredZombies;
    private int ironZombies;
    private int ironProtectedZombies;
    private int glowingZombies;
    private int magmaZombies;
    private int guardianZombies;
    private int skeletons;
    private int wolfes;
    private int endermites;
    private int blazes;
    private int soldiers;
    private int witches;
    private int caveSpiders;
    private int spiders;
    private int witherZombies;
    private int slimeZombies;
    private int santaHelperZombies;
    private int easterBunnyZombies;
    private int mosquitos;
    private int clowns;
    private int penguins;
    private int enderZombies;
    private int infernos;
    private int bombies;
    private int theBroodmothers;
    private int kingSlimes;
    private int kingWithers;
    private int herobrines;
    private int santaClaus;
    private int pennywise;
    private boolean started;
    private boolean stopped;
    private boolean inGame;
    private final boolean endlessMode;
    private final int difficulty;
    private String gameDifficulty;
    private boolean powerSwitchActivated;
    private Location spawnLocation;
    private Location lobbyLocation;
    private final List<BukkitTask> bukkitTasks = new ArrayList<BukkitTask>();
    private final Map<Location, Long> resetFireLocations = new HashMap<Location, Long>();
    private final Map<Player, GameScoreboard> gameScoreboards = new HashMap<Player, GameScoreboard>();
    private final Map<String, Integer> playerGold = new HashMap<String, Integer>();
    private final Map<String, Integer> playerKills = new HashMap<String, Integer>();
    private final Map<String, List<Location>> unlockedDoorSpawners = new HashMap<String, List<Location>>();
    private final Map<String, List<Location>> doorLocations = new HashMap<String, List<Location>>();
    private final Map<String, Hologram> doorHolograms = new HashMap<String, Hologram>();
    private final Map<String, List<Location>> windowBlockLocations = new HashMap<String, List<Location>>();
    private final Map<String, List<Location>> windowZombieLocations = new HashMap<String, List<Location>>();
    private final Map<String, List<Location>> windowPlayerLocations = new HashMap<String, List<Location>>();
    private final Map<Player, String> repairingWindows = new HashMap<Player, String>();
    private final Map<Location, BlockData> oldMaterialData = new HashMap<Location, BlockData>();
    private final Map<Location, List<Location>> connectedLocations = new HashMap<Location, List<Location>>();
    private final Map<String, List<Hologram>> connectedDoors = new HashMap<String, List<Hologram>>();
    private final Map<String, Boolean> powerSwitchDoors = new HashMap<String, Boolean>();
    private final Map<Player, RevivePlayer> revivePlayers = new HashMap<Player, RevivePlayer>();
    private List<String> alivePlayers = new ArrayList<String>();
    private List<String> players = new ArrayList<String>();
    private final List<String> quitPlayers = new ArrayList<String>();
    private List<String> displayedPlayers = new ArrayList<String>();
    private final Map<String, List<ArmorHologram>> armorHolograms = new HashMap<String, List<ArmorHologram>>();
    private final Map<String, List<WeaponHologram>> weaponHolograms = new HashMap<String, List<WeaponHologram>>();
    private final Map<String, List<PerkHologram>> perkHolograms = new HashMap<String, List<PerkHologram>>();
    private final Map<String, List<PowerSwitchHologram>> powerSwitchHolograms = new HashMap<String, List<PowerSwitchHologram>>();
    private final Map<String, List<UltimateMachineHologram>> ultimateMachineHolograms = new HashMap<String, List<UltimateMachineHologram>>();
    private final Map<String, List<PowerupHologram>> powerupHolograms = new HashMap<String, List<PowerupHologram>>();
    private final Map<String, List<TeamMachineHologram>> teamMachineHolograms = new HashMap<String, List<TeamMachineHologram>>();
    private WeaponsChestHologram weaponsChestHologram;
    private final Map<String, ItemStack[]> storedInventory = new HashMap<String, ItemStack[]>();
    private Inventory spectatorInventory;
    private final Map<String, PlayerSettings> settings = new HashMap<String, PlayerSettings>();
    private final GameArena arena;
    private BukkitTask lobbyTask;
    private long startTime;
    private Hologram statsHologram;
    private boolean enemyDetectorEnabled;
    private int enemyDetectorSlot;
    private final Map<String, Map<Integer, InventoryItem>> inventoryItems = new HashMap<String, Map<Integer, InventoryItem>>();
    private boolean practiceDummyEnabled;
    private final List<Zombie> practiceZombies = new ArrayList<Zombie>();
    private final List<Location> practiceDummyLocation = new ArrayList<Location>();
    private final List<Hologram> practiceNameHologram = new ArrayList<Hologram>();
    private final List<Hologram> practiceHologram = new ArrayList<Hologram>();
    private static final int versionId = Integer.parseInt(Bukkit.getBukkitVersion().split("-")[0].replace(".", "#").split("#")[1]);
    private final Map<Player, Long> playerRepairDelay = new HashMap<Player, Long>();

    public GameArena(File file) {
        Object object;
        Object object2;
        String string;
        Map<Integer, InventoryItem> map;
        List list;
        this.arena = this;
        this.mapName = file.getName().replace(".yml", "");
        this.fileConfiguration = YamlConfiguration.loadConfiguration((File)file);
        this.practiceDummyEnabled = this.fileConfiguration.getBoolean("PracticeDummyEnabled");
        if (this.practiceDummyEnabled) {
            list = this.fileConfiguration.getStringList("PracticeDummys");
            for (String string2 : list) {
                map = string2.split(":")[0];
                string = string2.split(":")[1];
                String string3 = string2.split(":")[2];
                String string4 = string2.split(":")[3];
                String string5 = string2.split(":")[4];
                object2 = string2.split(":")[5];
                object = new Location(Bukkit.getWorld((String)((Object)map)), Double.parseDouble(string), Double.parseDouble(string3), Double.parseDouble(string4));
                object.setYaw(Float.parseFloat(string5));
                object.setPitch(Float.parseFloat((String)object2));
                this.practiceDummyLocation.add((Location)object);
            }
        }
        this.minPlayers = this.fileConfiguration.getInt("MinPlayers");
        this.maxPlayers = this.fileConfiguration.getInt("MaxPlayers");
        this.fullLobbyTime = this.lobbyTime = Main.getInstance().getConfiguration().getInteger("LobbyTimer").intValue();
        this.restartTime = Main.getInstance().getConfiguration().getInteger("RestartTimer");
        this.endlessMode = this.fileConfiguration.getBoolean("EndlessMode");
        this.difficulty = this.fileConfiguration.getInt("Difficulty");
        switch (this.difficulty) {
            case 0: {
                this.gameDifficulty = Main.getInstance().getConfiguration().getMessage("Difficulty.Normal");
                break;
            }
            case 1: {
                this.gameDifficulty = Main.getInstance().getConfiguration().getMessage("Difficulty.Hard");
                break;
            }
            case 2: {
                this.gameDifficulty = Main.getInstance().getConfiguration().getMessage("Difficulty.RIP");
            }
        }
        this.loadLobby();
        list = this.fileConfiguration.getConfigurationSection("InventoryItems");
        if (list != null) {
            for (String string2 : list.getKeys(false)) {
                if (!string2.equals("Lobby") && !string2.equals("Spectator") && !string2.equals("InGame") && !string2.equals("Finish")) continue;
                map = new HashMap();
                if (this.inventoryItems.containsKey(string2)) {
                    map = this.inventoryItems.get(string2);
                }
                if ((string = this.fileConfiguration.getConfigurationSection("InventoryItems." + string2)) != null) {
                    for (String string4 : string.getKeys(false)) {
                        ItemStack itemStack;
                        String string6;
                        boolean bl = this.fileConfiguration.getBoolean("InventoryItems." + string2 + "." + string4 + ".Enabled");
                        if (!bl) continue;
                        object2 = this.fileConfiguration.getStringList("InventoryItems." + string2 + "." + string4 + ".Lores");
                        object = new ArrayList();
                        Iterator iterator = object2.iterator();
                        while (iterator.hasNext()) {
                            String string7 = (String)iterator.next();
                            object.add(Configuration.translateTextCodes(string7));
                        }
                        int n = 1;
                        int n2 = this.fileConfiguration.getInt("InventoryItems." + string2 + "." + string4 + ".DataId");
                        String string8 = Configuration.translateTextCodes(this.fileConfiguration.getString("InventoryItems." + string2 + "." + string4 + ".DisplayName"));
                        int n3 = this.fileConfiguration.getInt("InventoryItems." + string2 + "." + string4 + ".InventorySlot");
                        List list2 = this.fileConfiguration.getStringList("InventoryItems." + string2 + "." + string4 + ".PerformedCommands");
                        ConfigurationSection configurationSection = this.fileConfiguration.getConfigurationSection("InventoryItems." + string2 + "." + string4 + ".Sites");
                        if (string4.equals("EnemyDetector")) {
                            this.enemyDetectorEnabled = true;
                            this.enemyDetectorSlot = n3;
                        }
                        if (configurationSection != null) {
                            string6 = Configuration.translateTextCodes(this.fileConfiguration.getString("InventoryItems." + string2 + "." + string4 + ".Title"));
                            String string9 = Configuration.translateTextCodes(this.fileConfiguration.getString("InventoryItems." + string2 + "." + string4 + ".Author"));
                            ArrayList<String> arrayList = new ArrayList<String>();
                            for (String string10 : configurationSection.getKeys(false)) {
                                List list3 = this.fileConfiguration.getStringList("InventoryItems." + string2 + "." + string4 + ".Sites." + string10 + ".MessageList");
                                StringBuilder stringBuilder = new StringBuilder();
                                for (String string11 : list3) {
                                    stringBuilder.append(Configuration.translateTextCodes(string11)).append("\u00a7r\n");
                                }
                                arrayList.add(stringBuilder.toString());
                            }
                            itemStack = ItemStackUtils.getBookItem(string8, string6, string9, (List<String>)object, arrayList);
                        } else {
                            string6 = Material.valueOf((String)this.fileConfiguration.getString("InventoryItems." + string2 + "." + string4 + ".Material"));
                            itemStack = ItemStackUtils.getNBTItem((Material)string6, n, n2, string8, "{Path:\"" + string2 + '\"' + "}", (List<String>)object);
                        }
                        map.put(n3, new InventoryItem(itemStack, list2, string2));
                    }
                }
                this.inventoryItems.put(string2, map);
            }
        }
        Bukkit.getPluginManager().callEvent((Event)new ArenaLoadEvent(this.arena));
        BukkitTask bukkitTask = new BukkitRunnable(){

            public void run() {
                for (Player player : GameArena.this.getDisplayedPlayers()) {
                    PlayerDisplayer.handleArenaPlayers(player, GameArena.this.arena);
                }
            }
        }.runTaskTimer((Plugin)Main.getInstance(), 40L, 40L);
        this.bukkitTasks.add(bukkitTask);
    }

    private void loadStats() {
        String string = this.fileConfiguration.getString("StatsHologram");
        if (string != null && Main.getInstance().getStats().isEnabled()) {
            if (Bukkit.getWorld((String)string.split(":")[0]) == null) {
                return;
            }
            Location location = new Location(Bukkit.getWorld((String)string.split(":")[0]), Double.parseDouble(string.split(":")[1]), Double.parseDouble(string.split(":")[2]), Double.parseDouble(string.split(":")[3]));
            this.statsHologram = new Hologram(location);
            Map<Integer, PlayerStats> map = this.endlessMode ? Main.getInstance().getStatsUtils().getHighestValues(this.getName(), StatsField.SURVIVED_ROUNDS, 10) : Main.getInstance().getStatsUtils().getLowestValues(this.getName(), StatsField.FASTEST_WIN_TIME, 10);
            ArrayList<String> arrayList = new ArrayList<String>();
            TimeZone timeZone = TimeZone.getTimeZone("UTC");
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss");
            simpleDateFormat.setTimeZone(timeZone);
            String string2 = Main.getInstance().getConfiguration().getMessage("StatsHologram.Players");
            for (String object : Main.getInstance().getConfiguration().getMessageList("StatsHologram.Header")) {
                arrayList.add(Configuration.translateTextCodes(object.replace("%mapName%", this.getName())));
            }
            for (int i = 1; i <= 10; ++i) {
                PlayerStats playerStats;
                if (map.get(i) == null || ((playerStats = map.get(i)).getFastestWinTime() <= 0L || this.isEndlessMode()) && (!this.isEndlessMode() || playerStats.getSurvivedRounds() <= 0)) continue;
                Player player = Bukkit.getPlayer((UUID)UUID.fromString(playerStats.getUniqueId()));
                if (player != null) {
                    player.getName();
                    arrayList.add(string2.replace("%placeId%", String.valueOf(i)).replace("%name%", player.getName()).replace("%rounds%", String.valueOf(playerStats.getSurvivedRounds())).replace("%time%", simpleDateFormat.format(playerStats.getFastestWinTime())));
                    continue;
                }
                OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)UUID.fromString(playerStats.getUniqueId()));
                if (offlinePlayer.getName() != null) {
                    arrayList.add(string2.replace("%placeId%", String.valueOf(i)).replace("%name%", offlinePlayer.getName()).replace("%rounds%", String.valueOf(playerStats.getSurvivedRounds())).replace("%time%", simpleDateFormat.format(playerStats.getFastestWinTime())));
                    continue;
                }
                arrayList.add(string2.replace("%placeId%", String.valueOf(i)).replace("%name%", offlinePlayer.getUniqueId().toString()).replace("%rounds%", String.valueOf(playerStats.getSurvivedRounds())).replace("%time%", simpleDateFormat.format(playerStats.getFastestWinTime())));
            }
            if (arrayList.size() == Main.getInstance().getConfiguration().getMessageList("StatsHologram.Header").size()) {
                arrayList.add("\u00a7cN/A");
            }
            this.statsHologram.setCleanLines(arrayList);
        }
    }

    private void handlePracticeDummy() {
        if (this.practiceDummyEnabled) {
            for (Location location : this.practiceDummyLocation) {
                Object object;
                Object object2;
                Zombie zombie = (Zombie)location.getWorld().spawn(location, Zombie.class);
                zombie.setMetadata("PracticeDummy", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)this.getName()));
                zombie.setRemoveWhenFarAway(false);
                zombie.getEquipment().clear();
                zombie.setBaby(false);
                EntityUtils.teleport((Entity)zombie, location);
                if (versionId <= 15) {
                    try {
                        object2 = Reflection.getNMSClass("NBTTagCompound");
                        object = Reflection.getCraftClass("entity.CraftEntity");
                        Method method = ((Class)object).getDeclaredMethod("getHandle", new Class[0]);
                        Object t = ((Class)object2).newInstance();
                        Object object3 = method.invoke((Object)zombie, new Object[0]);
                        Method method2 = object3.getClass().getMethod("c", new Class[]{object2});
                        Method method3 = ((Class)object2).getDeclaredMethod("setByte", String.class, Byte.TYPE);
                        Method method4 = object3.getClass().getMethod("f", new Class[]{object2});
                        method2.invoke(object3, t);
                        method3.invoke(t, "NoAI", (byte)1);
                        method4.invoke(object3, t);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                } else {
                    zombie.setAI(false);
                }
                object2 = new Hologram(zombie.getEyeLocation().add(0.0, 0.5, 0.0));
                object = new Hologram(zombie.getEyeLocation().add(0.0, 1.5, 0.0));
                this.practiceNameHologram.add((Hologram)object2);
                this.practiceHologram.add((Hologram)object);
                ((Hologram)object2).setCleanLines(Main.getInstance().getConfiguration().getMessage("PracticeDummy.Name"));
                ((Hologram)object).setCleanLines(Main.getInstance().getConfiguration().getMessage("PracticeDummy.HologramName"));
                this.practiceZombies.add(zombie);
            }
        }
    }

    private void loadLobby() {
        this.gameState = Main.getInstance().getConfiguration().getMessage("State.Lobby");
        Bukkit.getPluginManager().callEvent((Event)new ArenaStateChangeEvent(this.arena, this.gameState));
        String string = this.fileConfiguration.getString("SpawnLocation");
        assert (string != null);
        String string2 = string.split(":")[0];
        if (Bukkit.getWorld((String)string2) == null) {
            Bukkit.createWorld((WorldCreator)new WorldCreator(string2));
        }
        this.spawnLocation = new Location(Bukkit.getWorld((String)string2), Double.parseDouble(string.split(":")[1]), Double.parseDouble(string.split(":")[2]), Double.parseDouble(string.split(":")[3]));
        this.spawnLocation.setYaw(Float.parseFloat(string.split(":")[4]));
        this.spawnLocation.setPitch(Float.parseFloat(string.split(":")[5]));
        String string3 = this.fileConfiguration.getString("LobbyLocation");
        assert (string3 != null);
        String string4 = string3.split(":")[0];
        if (Bukkit.getWorld((String)string4) == null) {
            Bukkit.createWorld((WorldCreator)new WorldCreator(string4));
        }
        this.lobbyLocation = new Location(Bukkit.getWorld((String)string4), Double.parseDouble(string3.split(":")[1]), Double.parseDouble(string3.split(":")[2]), Double.parseDouble(string3.split(":")[3]));
        this.lobbyLocation.setYaw(Float.parseFloat(string3.split(":")[4]));
        this.lobbyLocation.setPitch(Float.parseFloat(string3.split(":")[5]));
        if (!Main.getInstance().getConfiguration().getBoolean("MultiArena.Enabled").booleanValue()) {
            this.spawnLocation.getWorld().setTime(14000L);
            this.spawnLocation.getWorld().setGameRuleValue("doDaylightCycle", "false");
        }
        this.handlePracticeDummy();
        this.loadStats();
        this.spectatorInventory = Bukkit.createInventory(null, (int)27, (String)Main.getInstance().getConfiguration().getMessage("Spectator.Teleporter.InventoryName"));
        this.lobbyTask = new BukkitRunnable(){
            final Title title = new Title();
            boolean started = false;

            public void run() {
                GameArena.this.updateScoreboard();
                if (GameArena.this.getPlayers().size() >= GameArena.this.minPlayers) {
                    if (!this.started) {
                        this.started = true;
                        Bukkit.getPluginManager().callEvent((Event)new ArenaPreStartEvent(GameArena.this.arena));
                    }
                    if (GameArena.this.lobbyTime == 0) {
                        GameArena.this.startGame();
                        this.cancel();
                        return;
                    }
                    this.title.setFadeIn(5);
                    this.title.setStay(20);
                    this.title.setFadeOut(5);
                    if (GameArena.this.lobbyTime == 10) {
                        this.title.setTitle(Main.getInstance().getConfiguration().getMessage("GameStartTitlePrefixHigh") + GameArena.this.lobbyTime);
                        this.title.sendTimes(GameArena.this.getPlayers());
                        this.title.sendTitle(GameArena.this.getPlayers());
                        GameArena.this.sendMessage(Main.getInstance().getConfiguration().getMessage("GameStartCountdown").replace("%time%", Main.getInstance().getConfiguration().getMessage("GameStartChatPrefixHigh") + GameArena.this.lobbyTime));
                    }
                    if (GameArena.this.lobbyTime <= 5 && GameArena.this.lobbyTime > 3) {
                        this.title.setTitle(Main.getInstance().getConfiguration().getMessage("GameStartTitlePrefixMedium") + GameArena.this.lobbyTime);
                        this.title.sendTimes(GameArena.this.getPlayers());
                        this.title.sendTitle(GameArena.this.getPlayers());
                        GameArena.this.sendMessage(Main.getInstance().getConfiguration().getMessage("GameStartCountdown").replace("%time%", Main.getInstance().getConfiguration().getMessage("GameStartChatPrefixMedium") + GameArena.this.lobbyTime));
                    }
                    if (GameArena.this.lobbyTime <= 3 && GameArena.this.lobbyTime > 0) {
                        this.title.setTitle(Main.getInstance().getConfiguration().getMessage("GameStartTitlePrefixLow") + GameArena.this.lobbyTime);
                        this.title.sendTimes(GameArena.this.getPlayers());
                        this.title.sendTitle(GameArena.this.getPlayers());
                        GameArena.this.sendMessage(Main.getInstance().getConfiguration().getMessage("GameStartCountdown").replace("%time%", Main.getInstance().getConfiguration().getMessage("GameStartChatPrefixLow") + GameArena.this.lobbyTime));
                    }
                    if (GameArena.this.lobbyTime <= 10) {
                        for (Player player : GameArena.this.getPlayers()) {
                            player.playSound(player.getEyeLocation(), Sound.valueOf((String)Main.getInstance().getConfiguration().getSound("Countdown")), 1.0f, 1.0f);
                        }
                    }
                    Bukkit.getPluginManager().callEvent((Event)new ArenaPreTickEvent(GameArena.this.arena, GameArena.this.lobbyTime));
                    GameArena.this.lobbyTime -= 1;
                } else {
                    if (this.started) {
                        Bukkit.getPluginManager().callEvent((Event)new ArenaPreStopEvent(GameArena.this.arena));
                    }
                    this.started = false;
                    GameArena.this.lobbyTime = GameArena.this.fullLobbyTime;
                }
            }
        }.runTaskTimer((Plugin)Main.getInstance(), 20L, 20L);
    }

    private void runUpdate() {
        BukkitTask bukkitTask = new BukkitRunnable(){

            public void run() {
                GameArena.this.updateScoreboard();
            }
        }.runTaskTimer((Plugin)Main.getInstance(), 0L, 20L);
        this.bukkitTasks.add(bukkitTask);
    }

    private void runTime() {
        BukkitTask bukkitTask = new BukkitRunnable(){
            int hours;
            int minutes;
            int seconds;

            public void run() {
                if (this.minutes >= 59 && this.seconds >= 60) {
                    ++this.hours;
                    this.minutes = 0;
                    this.seconds = 0;
                }
                if (this.seconds >= 60) {
                    this.seconds = 0;
                    ++this.minutes;
                }
                String string = "";
                if (this.hours > 0) {
                    string = this.hours < 10 ? string + "0" + this.hours : string + this.hours;
                    string = string + ":";
                }
                string = this.minutes < 10 ? string + "0" + this.minutes : string + this.minutes;
                string = string + ":";
                string = this.seconds < 10 ? string + "0" + this.seconds : string + this.seconds;
                GameArena.this.inGameTime = string;
                ++this.seconds;
            }
        }.runTaskTimer((Plugin)Main.getInstance(), 0L, 20L);
        this.bukkitTasks.add(bukkitTask);
    }

    public String getInGameTime() {
        if (this.inGameTime == null) {
            return String.valueOf(this.lobbyTime);
        }
        return this.inGameTime;
    }

    public int getZombiesLeft() {
        return this.zombiesLeft;
    }

    public void setZombiesLeft(int n) {
        this.zombiesLeft = n;
        if (n == 0) {
            this.nextRound();
        }
    }

    public int getRound() {
        return this.round;
    }

    /*
     * WARNING - void declaration
     */
    public void nextRound() {
        if (this.stopped) {
            return;
        }
        int n = this.fileConfiguration.getInt("Rounds");
        if (this.round == n && !this.isEndlessMode()) {
            long l = System.currentTimeMillis() - this.startTime;
            for (Player player : this.getPlayers()) {
                long l2 = Main.getInstance().getStatsUtils().getStats(this.getName(), player.getUniqueId().toString()).getFastestWinTime();
                if (l >= l2) continue;
                Main.getInstance().getStatsUtils().updateStats(this.getName(), StatsField.FASTEST_WIN_TIME, player.getUniqueId().toString(), l);
            }
            Bukkit.getPluginManager().callEvent((Event)new ArenaWinEvent(this.arena));
            this.endGame();
            return;
        }
        Bukkit.getPluginManager().callEvent((Event)new ArenaUpdateRoundEvent(this.arena, this.round, this.round + 1));
        for (Player player : this.getPlayers()) {
            if (!this.isDead(player) && !this.isRevivedPlayer(player)) continue;
            if (this.isRevivedPlayer(player)) {
                RevivePlayer object3 = this.revivePlayers.get(player);
                object3.resetStatus();
            }
            this.setAlive(player);
            Bukkit.getPluginManager().callEvent((Event)new ArenaPlayerRespawnEvent(player, this.arena));
            if (this.spawnLocation == null) continue;
            player.teleport(this.spawnLocation);
        }
        if (Main.getInstance().getConfig().getBoolean("Rewards.Enabled")) {
            List list = Main.getInstance().getConfig().getStringList("Rewards.Rounds." + this.round);
            for (Player player : this.getPlayers()) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)string.replace("%player%", player.getName()));
                }
            }
        }
        ++this.round;
        for (String string : this.doorLocations.keySet()) {
            int n2;
            String string2 = this.fileConfiguration.getString("Door." + string + ".UnlockedRound");
            if (string2 == null || (n2 = this.fileConfiguration.getInt("Door." + string + ".UnlockedRound")) != this.round) continue;
            this.unlockDoor(null, string);
        }
        if (this.round > n) {
            void var3_23;
            this.normalZombies = this.fileConfiguration.getInt("EMode.Default.NormalZombie");
            this.normalStrongZombies = this.fileConfiguration.getInt("EMode.Default.NormalStrongZombie");
            this.normalProtectedZombies = this.fileConfiguration.getInt("EMode.Default.NormalProtectedZombie");
            this.pigZombies = this.fileConfiguration.getInt("EMode.Default.PigZombie");
            this.tntZombies = this.fileConfiguration.getInt("EMode.Default.TNTZombie");
            this.empoweredZombies = this.fileConfiguration.getInt("EMode.Default.EmpoweredZombie");
            this.ironZombies = this.fileConfiguration.getInt("EMode.Default.IronZombie");
            this.ironProtectedZombies = this.fileConfiguration.getInt("EMode.Default.IronProtectedZombie");
            this.glowingZombies = this.fileConfiguration.getInt("EMode.Default.GlowingZombie");
            this.magmaZombies = this.fileConfiguration.getInt("EMode.Default.MagmaZombie");
            this.guardianZombies = this.fileConfiguration.getInt("EMode.Default.GuardianZombie");
            this.skeletons = this.fileConfiguration.getInt("EMode.Default.Skeleton");
            this.wolfes = this.fileConfiguration.getInt("EMode.Default.Wolf");
            this.endermites = this.fileConfiguration.getInt("EMode.Default.Endermite");
            this.blazes = this.fileConfiguration.getInt("EMode.Default.Blaze");
            this.soldiers = this.fileConfiguration.getInt("EMode.Default.Soldier");
            this.witches = this.fileConfiguration.getInt("EMode.Default.Witch");
            this.caveSpiders = this.fileConfiguration.getInt("EMode.Default.CaveSpider");
            this.spiders = this.fileConfiguration.getInt("EMode.Default.Spider");
            this.witherZombies = this.fileConfiguration.getInt("EMode.Default.WitherZombie");
            this.slimeZombies = this.fileConfiguration.getInt("EMode.Default.SlimeZombie");
            this.santaHelperZombies = this.fileConfiguration.getInt("EMode.Default.SantaHelperZombie");
            this.easterBunnyZombies = this.fileConfiguration.getInt("EMode.Default.EasterBunnyZombie");
            this.mosquitos = this.fileConfiguration.getInt("EMode.Default.Mosquito");
            this.clowns = this.fileConfiguration.getInt("EMode.Default.Clown");
            this.penguins = this.fileConfiguration.getInt("EMode.Default.Penguin");
            this.enderZombies = this.fileConfiguration.getInt("EMode.Default.EnderZombie");
            this.infernos = this.fileConfiguration.getInt("EMode.Default.Inferno");
            this.bombies = this.fileConfiguration.getInt("EMode.Default.Bombie");
            this.theBroodmothers = this.fileConfiguration.getInt("EMode.Default.TheBroodmother");
            this.kingSlimes = this.fileConfiguration.getInt("EMode.Default.KingSlime");
            this.kingWithers = this.fileConfiguration.getInt("EMode.Default.KingWither");
            this.herobrines = this.fileConfiguration.getInt("EMode.Default.Herobrine");
            this.santaClaus = this.fileConfiguration.getInt("EMode.Default.SantaClaus");
            this.pennywise = this.fileConfiguration.getInt("EMode.Default.Pennywise");
            int n3 = this.round - n;
            boolean bl = true;
            while (var3_23 <= n3) {
                this.normalZombies += this.fileConfiguration.getInt("EMode.RoundMultiplicator.NormalZombie");
                this.normalStrongZombies += this.fileConfiguration.getInt("EMode.RoundMultiplicator.NormalStrongZombie");
                this.normalProtectedZombies += this.fileConfiguration.getInt("EMode.RoundMultiplicator.NormalProtectedZombie");
                this.pigZombies += this.fileConfiguration.getInt("EMode.RoundMultiplicator.PigZombie");
                this.tntZombies += this.fileConfiguration.getInt("EMode.RoundMultiplicator.TNTZombie");
                this.empoweredZombies += this.fileConfiguration.getInt("EMode.RoundMultiplicator.EmpoweredZombie");
                this.ironZombies += this.fileConfiguration.getInt("EMode.RoundMultiplicator.IronZombie");
                this.ironProtectedZombies += this.fileConfiguration.getInt("EMode.RoundMultiplicator.IronProtectedZombie");
                this.glowingZombies += this.fileConfiguration.getInt("EMode.RoundMultiplicator.GlowingZombie");
                this.magmaZombies += this.fileConfiguration.getInt("EMode.RoundMultiplicator.MagmaZombie");
                this.guardianZombies += this.fileConfiguration.getInt("EMode.RoundMultiplicator.GuardianZombie");
                this.skeletons += this.fileConfiguration.getInt("EMode.RoundMultiplicator.Skeleton");
                this.wolfes += this.fileConfiguration.getInt("EMode.RoundMultiplicator.Wolf");
                this.endermites += this.fileConfiguration.getInt("EMode.RoundMultiplicator.Endermite");
                this.blazes += this.fileConfiguration.getInt("EMode.RoundMultiplicator.Blaze");
                this.soldiers += this.fileConfiguration.getInt("EMode.RoundMultiplicator.Soldier");
                this.witches += this.fileConfiguration.getInt("EMode.RoundMultiplicator.Witch");
                this.caveSpiders += this.fileConfiguration.getInt("EMode.RoundMultiplicator.CaveSpider");
                this.spiders += this.fileConfiguration.getInt("EMode.RoundMultiplicator.Spider");
                this.witherZombies += this.fileConfiguration.getInt("EMode.RoundMultiplicator.WitherZombie");
                this.slimeZombies += this.fileConfiguration.getInt("EMode.RoundMultiplicator.SlimeZombie");
                this.santaHelperZombies += this.fileConfiguration.getInt("EMode.RoundMultiplicator.SantaHelperZombie");
                this.easterBunnyZombies += this.fileConfiguration.getInt("EMode.RoundMultiplicator.EasterBunnyZombie");
                this.mosquitos += this.fileConfiguration.getInt("EMode.RoundMultiplicator.Mosquito");
                this.clowns += this.fileConfiguration.getInt("EMode.RoundMultiplicator.Clown");
                this.penguins += this.fileConfiguration.getInt("EMode.RoundMultiplicator.Penguin");
                this.enderZombies += this.fileConfiguration.getInt("EMode.RoundMultiplicator.EnderZombie");
                this.infernos += this.fileConfiguration.getInt("EMode.RoundMultiplicator.Inferno");
                this.bombies += this.fileConfiguration.getInt("EMode.RoundMultiplicator.Bombie");
                this.theBroodmothers += this.fileConfiguration.getInt("EMode.RoundMultiplicator.TheBroodmother");
                this.kingSlimes += this.fileConfiguration.getInt("EMode.RoundMultiplicator.KingSlime");
                this.kingWithers += this.fileConfiguration.getInt("EMode.RoundMultiplicator.KingWither");
                this.herobrines += this.fileConfiguration.getInt("EMode.RoundMultiplicator.Herobrine");
                this.santaClaus += this.fileConfiguration.getInt("EMode.RoundMultiplicator.SantaClaus");
                this.pennywise += this.fileConfiguration.getInt("EMode.RoundMultiplicator.Pennywise");
                ++var3_23;
            }
        } else {
            this.normalZombies = this.fileConfiguration.getInt("Round." + this.round + ".Entities.NormalZombie");
            this.normalStrongZombies = this.fileConfiguration.getInt("Round." + this.round + ".Entities.NormalStrongZombie");
            this.normalProtectedZombies = this.fileConfiguration.getInt("Round." + this.round + ".Entities.NormalProtectedZombie");
            this.pigZombies = this.fileConfiguration.getInt("Round." + this.round + ".Entities.PigZombie");
            this.tntZombies = this.fileConfiguration.getInt("Round." + this.round + ".Entities.TNTZombie");
            this.empoweredZombies = this.fileConfiguration.getInt("Round." + this.round + ".Entities.EmpoweredZombie");
            this.ironZombies = this.fileConfiguration.getInt("Round." + this.round + ".Entities.IronZombie");
            this.ironProtectedZombies = this.fileConfiguration.getInt("Round." + this.round + ".Entities.IronProtectedZombie");
            this.glowingZombies = this.fileConfiguration.getInt("Round." + this.round + ".Entities.GlowingZombie");
            this.magmaZombies = this.fileConfiguration.getInt("Round." + this.round + ".Entities.MagmaZombie");
            this.guardianZombies = this.fileConfiguration.getInt("Round." + this.round + ".Entities.GuardianZombie");
            this.skeletons = this.fileConfiguration.getInt("Round." + this.round + ".Entities.Skeleton");
            this.wolfes = this.fileConfiguration.getInt("Round." + this.round + ".Entities.Wolf");
            this.endermites = this.fileConfiguration.getInt("Round." + this.round + ".Entities.Endermite");
            this.blazes = this.fileConfiguration.getInt("Round." + this.round + ".Entities.Blaze");
            this.soldiers = this.fileConfiguration.getInt("Round." + this.round + ".Entities.Soldier");
            this.witches = this.fileConfiguration.getInt("Round." + this.round + ".Entities.Witch");
            this.caveSpiders = this.fileConfiguration.getInt("Round." + this.round + ".Entities.CaveSpider");
            this.spiders = this.fileConfiguration.getInt("Round." + this.round + ".Entities.Spider");
            this.witherZombies = this.fileConfiguration.getInt("Round." + this.round + ".Entities.WitherZombie");
            this.slimeZombies = this.fileConfiguration.getInt("Round." + this.round + ".Entities.SlimeZombie");
            this.santaHelperZombies = this.fileConfiguration.getInt("Round." + this.round + ".Entities.SantaHelperZombie");
            this.easterBunnyZombies = this.fileConfiguration.getInt("Round." + this.round + ".Entities.EasterBunnyZombie");
            this.mosquitos = this.fileConfiguration.getInt("Round." + this.round + ".Entities.Mosquito");
            this.clowns = this.fileConfiguration.getInt("Round." + this.round + ".Entities.Clown");
            this.penguins = this.fileConfiguration.getInt("Round." + this.round + ".Entities.Penguin");
            this.enderZombies = this.fileConfiguration.getInt("Round." + this.round + ".Entities.EnderZombie");
            this.infernos = this.fileConfiguration.getInt("Round." + this.round + ".Entities.Inferno");
            this.bombies = this.fileConfiguration.getInt("Round." + this.round + ".Entities.Bombie");
            this.theBroodmothers = this.fileConfiguration.getInt("Round." + this.round + ".Entities.TheBroodmother");
            this.kingSlimes = this.fileConfiguration.getInt("Round." + this.round + ".Entities.KingSlime");
            this.kingWithers = this.fileConfiguration.getInt("Round." + this.round + ".Entities.KingWither");
            this.herobrines = this.fileConfiguration.getInt("Round." + this.round + ".Entities.Herobrine");
            this.santaClaus = this.fileConfiguration.getInt("Round." + this.round + ".Entities.SantaClaus");
            this.pennywise = this.fileConfiguration.getInt("Round." + this.round + ".Entities.Pennywise");
        }
        this.zombiesLeft = this.normalZombies + this.normalStrongZombies + this.normalProtectedZombies + this.pigZombies + this.tntZombies + this.empoweredZombies + this.ironZombies + this.ironProtectedZombies + this.glowingZombies + this.magmaZombies + this.guardianZombies + this.skeletons + this.wolfes + this.endermites + this.blazes + this.soldiers + this.witches + this.caveSpiders + this.spiders + this.witherZombies + this.slimeZombies + this.santaHelperZombies + this.easterBunnyZombies + this.mosquitos + this.clowns + this.penguins + this.enderZombies + this.infernos + this.bombies + this.theBroodmothers + this.kingWithers + this.kingSlimes + this.herobrines + this.santaClaus + this.pennywise;
        this.state = Main.getInstance().getConfiguration().getMessage("Round").replace("%round%", String.valueOf(this.round));
        Title title = new Title();
        title.setTitle(this.state);
        title.setFadeIn(5);
        title.setStay(50);
        title.setFadeOut(5);
        title.sendTimes(this.getDisplayedPlayers());
        title.sendTitle(this.getDisplayedPlayers());
    }

    public void startGame() {
        Object object;
        Location location;
        Object object22;
        Object object3;
        Object object4;
        Object object5;
        String string2;
        if (this.hasStarted()) {
            return;
        }
        if (Main.getInstance().getConfiguration().getBoolean("StartMessage").booleanValue()) {
            for (Player object62 : this.getPlayers()) {
                for (String string2 : Main.getInstance().getConfiguration().getMessageList("StartMessage")) {
                    if (string2 == null || string2.isEmpty()) continue;
                    object62.sendMessage(string2);
                }
            }
        }
        for (Zombie zombie : this.practiceZombies) {
            if (zombie == null) continue;
            zombie.remove();
        }
        Bukkit.getPluginManager().callEvent((Event)new ArenaStartEvent(this.arena));
        this.lobbyTask.cancel();
        this.startTime = System.currentTimeMillis();
        this.gameState = Main.getInstance().getConfiguration().getMessage("State.InGame");
        Bukkit.getPluginManager().callEvent((Event)new ArenaStateChangeEvent(this.arena, this.gameState));
        this.state = Main.getInstance().getConfiguration().getMessage("Round").replace("%round%", String.valueOf(this.round));
        this.inGameTime = "00:00";
        this.runTime();
        this.runUpdate();
        this.started = true;
        this.inGame = true;
        ConfigurationSection configurationSection = this.fileConfiguration.getConfigurationSection("WeaponsChest.Position");
        this.weaponsChestHologram = new WeaponsChestHologram(this);
        if (configurationSection != null) {
            for (String string3 : configurationSection.getKeys(false)) {
                this.weaponsChestHologram.addLocation(new WeaponsChestLocation(this, string3));
            }
        }
        this.weaponsChestHologram.loadWeaponsChestLocations();
        this.weaponsChestHologram.loadHolograms(this.weaponsChestHologram.getCurrentWeaponsChestLocation());
        for (Player player : this.getPlayers()) {
            this.applyScoreboard(player);
        }
        this.loadPlayerSettings(this.getPlayers());
        ArrayList<Location> arrayList = new ArrayList<Location>();
        for (String string2 : this.fileConfiguration.getStringList("DefaultSpawners")) {
            object5 = new Location(Bukkit.getWorld((String)string2.split(":")[0]), (double)Integer.parseInt(string2.split(":")[1]), (double)Integer.parseInt(string2.split(":")[2]), (double)Integer.parseInt(string2.split(":")[3]));
            arrayList.add((Location)object5);
        }
        if (!arrayList.isEmpty()) {
            this.unlockedDoorSpawners.put(null, arrayList);
        }
        if (this.fileConfiguration.getConfigurationSection("Door") != null) {
            for (String string2 : this.fileConfiguration.getConfigurationSection("Door").getKeys(false)) {
                object5 = this.fileConfiguration.getString("Door." + string2 + ".Pos1");
                object4 = this.fileConfiguration.getString("Door." + string2 + ".Pos2");
                object3 = this.fileConfiguration.getString("Door." + string2 + ".Hologram");
                int n = this.fileConfiguration.getInt("Door." + string2 + ".Gold");
                int n2 = this.fileConfiguration.getBoolean("Door." + string2 + ".PowerSwitch") ? 1 : 0;
                this.powerSwitchDoors.put(string2, n2 != 0);
                assert (object5 != null);
                Location location2 = new Location(Bukkit.getWorld((String)((String)object5).split(":")[0]), (double)Integer.parseInt(((String)object5).split(":")[1]), (double)Integer.parseInt(((String)object5).split(":")[2]), (double)Integer.parseInt(((String)object5).split(":")[3]));
                assert (object4 != null);
                object22 = new Location(Bukkit.getWorld((String)object4.split(":")[0]), (double)Integer.parseInt(object4.split(":")[1]), (double)Integer.parseInt(object4.split(":")[2]), (double)Integer.parseInt(object4.split(":")[3]));
                location = LocationUtils.getBlocks(location2, (Location)object22);
                this.doorLocations.put(string2, (List<Location>)location);
                assert (object3 != null);
                object = new Location(Bukkit.getWorld((String)((String)object3).split(":")[0]), Double.parseDouble(((String)object3).split(":")[1]), Double.parseDouble(((String)object3).split(":")[2]), Double.parseDouble(((String)object3).split(":")[3]));
                object.setYaw(Float.parseFloat(((String)object3).split(":")[4]));
                object.setPitch(Float.parseFloat(((String)object3).split(":")[5]));
                ArrayList<String> arrayList2 = new ArrayList<String>();
                for (String string4 : Main.getInstance().getConfiguration().getMessageList("DoorHologram")) {
                    arrayList2.add(Configuration.translateTextCodes(string4.replace("%doorName%", this.getFakeName(string2).replace("_", " ")).replace("%gold%", String.valueOf(n))));
                }
                Hologram hologram = new Hologram((Location)object, arrayList2.toArray(new String[0]));
                hologram.show(this);
                this.doorHolograms.put(string2, hologram);
            }
        }
        if (this.fileConfiguration.getConfigurationSection("Door") != null) {
            for (String string2 : this.fileConfiguration.getConfigurationSection("Door").getKeys(false)) {
                object5 = this.fileConfiguration.getString("Door." + string2 + ".Doors");
                if (object5 == null) continue;
                object4 = ((String)object5).split(",");
                object3 = new ArrayList();
                for (Object object22 : object4) {
                    if (!this.doorHolograms.containsKey(object22)) continue;
                    object3.add(this.doorHolograms.get(object22));
                }
                this.connectedDoors.put(string2, (List<Hologram>)object3);
            }
        }
        if (this.fileConfiguration.getConfigurationSection("Window") != null) {
            for (String string2 : this.fileConfiguration.getConfigurationSection("Window").getKeys(false)) {
                String string5;
                Object object6;
                object5 = this.fileConfiguration.getString("Window." + string2 + ".Block.Pos1");
                object4 = this.fileConfiguration.getString("Window." + string2 + ".Block.Pos2");
                if (object5 != null && object4 != null) {
                    object3 = new Location(Bukkit.getWorld((String)((String)object5).split(":")[0]), (double)Integer.parseInt(((String)object5).split(":")[1]), (double)Integer.parseInt(((String)object5).split(":")[2]), (double)Integer.parseInt(((String)object5).split(":")[3]));
                    Location location3 = new Location(Bukkit.getWorld((String)object4.split(":")[0]), (double)Integer.parseInt(object4.split(":")[1]), (double)Integer.parseInt(object4.split(":")[2]), (double)Integer.parseInt(object4.split(":")[3]));
                    object6 = LocationUtils.getBlocks((Location)object3, location3);
                    this.windowBlockLocations.put(string2, (List<Location>)object6);
                }
                object3 = this.fileConfiguration.getString("Window." + string2 + ".Zombie.Pos1");
                String string6 = this.fileConfiguration.getString("Window." + string2 + ".Zombie.Pos2");
                if (object3 != null && string6 != null) {
                    object6 = new Location(Bukkit.getWorld((String)((String)object3).split(":")[0]), (double)Integer.parseInt(((String)object3).split(":")[1]), (double)Integer.parseInt(((String)object3).split(":")[2]), (double)Integer.parseInt(((String)object3).split(":")[3]));
                    string5 = new Location(Bukkit.getWorld((String)string6.split(":")[0]), (double)Integer.parseInt(string6.split(":")[1]), (double)Integer.parseInt(string6.split(":")[2]), (double)Integer.parseInt(string6.split(":")[3]));
                    object22 = LocationUtils.getBlocks((Location)object6, (Location)string5);
                    this.windowZombieLocations.put(string2, (List<Location>)object22);
                }
                object6 = this.fileConfiguration.getString("Window." + string2 + ".Player.Pos1");
                string5 = this.fileConfiguration.getString("Window." + string2 + ".Player.Pos2");
                if (object6 == null || string5 == null) continue;
                object22 = new Location(Bukkit.getWorld((String)((String)object6).split(":")[0]), (double)Integer.parseInt(((String)object6).split(":")[1]), (double)Integer.parseInt(((String)object6).split(":")[2]), (double)Integer.parseInt(((String)object6).split(":")[3]));
                location = new Location(Bukkit.getWorld((String)string5.split(":")[0]), (double)Integer.parseInt(string5.split(":")[1]), (double)Integer.parseInt(string5.split(":")[2]), (double)Integer.parseInt(string5.split(":")[3]));
                object = LocationUtils.getBlocks((Location)object22, location);
                this.windowPlayerLocations.put(string2, (List<Location>)object);
            }
        }
        if (this.fileConfiguration.getConfigurationSection("Spawner") != null) {
            for (String string2 : this.fileConfiguration.getConfigurationSection("Spawner").getKeys(false)) {
                object5 = this.fileConfiguration.getString("Spawner." + string2 + ".Window");
                object4 = this.fileConfiguration.getString("Spawner." + string2 + ".Position");
                if (object4 == null || object5 == null) continue;
                object3 = new Location(Bukkit.getWorld((String)object4.split(":")[0]), (double)Integer.parseInt(object4.split(":")[1]), (double)Integer.parseInt(object4.split(":")[2]), (double)Integer.parseInt(object4.split(":")[3]));
                this.connectedLocations.put((Location)object3, this.getWindowBlockLocations((String)object5));
            }
        }
        BukkitTask bukkitTask = new BukkitRunnable(){
            boolean oldInstaKillActive;
            boolean oldDoubleGoldActive;
            boolean oldShoppingSpreeActive;

            public void run() {
                boolean bl = Main.getInstance().getPowerupHandler().isActive(GameArena.this.arena, PowerupType.INSTA_KILL);
                boolean bl2 = Main.getInstance().getPowerupHandler().isActive(GameArena.this.arena, PowerupType.DOUBLE_GOLD);
                boolean bl3 = Main.getInstance().getPowerupHandler().isActive(GameArena.this.arena, PowerupType.SHOPPING_SPREE);
                if (this.oldInstaKillActive && !bl || this.oldDoubleGoldActive && !bl2 || this.oldShoppingSpreeActive && !bl3) {
                    for (Player player : GameArena.this.getDisplayedPlayers()) {
                        Main.getInstance().getDisplayBar().removeBar(player);
                    }
                }
                this.oldInstaKillActive = bl;
                this.oldDoubleGoldActive = bl2;
                this.oldShoppingSpreeActive = bl3;
                if (bl || bl2 || bl3) {
                    if (bl && bl2 && bl3) {
                        for (Player player : GameArena.this.getDisplayedPlayers()) {
                            Main.getInstance().getDisplayBar().sendBar(player, Main.getInstance().getConfiguration().getMessage("Powerups.INSTA_KILL.BarTag").replace("%instaKillDuration%", Main.getInstance().getPowerupHandler().getTimeLeft(GameArena.this.arena, PowerupType.INSTA_KILL)) + " \u00a78| " + Main.getInstance().getConfiguration().getMessage("Powerups.DOUBLE_GOLD.BarTag").replace("%doubleGoldDuration%", Main.getInstance().getPowerupHandler().getTimeLeft(GameArena.this.arena, PowerupType.DOUBLE_GOLD)) + " \u00a78| " + Main.getInstance().getConfiguration().getMessage("Powerups.SHOPPING_SPREE.BarTag").replace("%shoppingSpreeDuration%", Main.getInstance().getPowerupHandler().getTimeLeft(GameArena.this.arena, PowerupType.SHOPPING_SPREE)));
                        }
                        return;
                    }
                    if (bl && bl2) {
                        for (Player player : GameArena.this.getDisplayedPlayers()) {
                            Main.getInstance().getDisplayBar().sendBar(player, Main.getInstance().getConfiguration().getMessage("Powerups.INSTA_KILL.BarTag").replace("%instaKillDuration%", Main.getInstance().getPowerupHandler().getTimeLeft(GameArena.this.arena, PowerupType.INSTA_KILL)) + " \u00a78| " + Main.getInstance().getConfiguration().getMessage("Powerups.DOUBLE_GOLD.BarTag").replace("%doubleGoldDuration%", Main.getInstance().getPowerupHandler().getTimeLeft(GameArena.this.arena, PowerupType.DOUBLE_GOLD)));
                        }
                        return;
                    }
                    if (bl && bl3) {
                        for (Player player : GameArena.this.getDisplayedPlayers()) {
                            Main.getInstance().getDisplayBar().sendBar(player, Main.getInstance().getConfiguration().getMessage("Powerups.INSTA_KILL.BarTag").replace("%instaKillDuration%", Main.getInstance().getPowerupHandler().getTimeLeft(GameArena.this.arena, PowerupType.INSTA_KILL)) + " \u00a78| " + Main.getInstance().getConfiguration().getMessage("Powerups.SHOPPING_SPREE.BarTag").replace("%shoppingSpreeDuration%", Main.getInstance().getPowerupHandler().getTimeLeft(GameArena.this.arena, PowerupType.SHOPPING_SPREE)));
                        }
                        return;
                    }
                    if (bl2 && bl3) {
                        for (Player player : GameArena.this.getDisplayedPlayers()) {
                            Main.getInstance().getDisplayBar().sendBar(player, Main.getInstance().getConfiguration().getMessage("Powerups.DOUBLE_GOLD.BarTag").replace("%doubleGoldDuration%", Main.getInstance().getPowerupHandler().getTimeLeft(GameArena.this.arena, PowerupType.DOUBLE_GOLD)) + " \u00a78| " + Main.getInstance().getConfiguration().getMessage("Powerups.SHOPPING_SPREE.BarTag").replace("%shoppingSpreeDuration%", Main.getInstance().getPowerupHandler().getTimeLeft(GameArena.this.arena, PowerupType.SHOPPING_SPREE)));
                        }
                        return;
                    }
                    if (bl) {
                        for (Player player : GameArena.this.getDisplayedPlayers()) {
                            Main.getInstance().getDisplayBar().sendBar(player, Main.getInstance().getConfiguration().getMessage("Powerups.INSTA_KILL.BarTag").replace("%instaKillDuration%", Main.getInstance().getPowerupHandler().getTimeLeft(GameArena.this.arena, PowerupType.INSTA_KILL)));
                        }
                        return;
                    }
                    if (bl2) {
                        for (Player player : GameArena.this.getDisplayedPlayers()) {
                            Main.getInstance().getDisplayBar().sendBar(player, Main.getInstance().getConfiguration().getMessage("Powerups.DOUBLE_GOLD.BarTag").replace("%doubleGoldDuration%", Main.getInstance().getPowerupHandler().getTimeLeft(GameArena.this.arena, PowerupType.DOUBLE_GOLD)));
                        }
                    }
                    if (bl3) {
                        for (Player player : GameArena.this.getDisplayedPlayers()) {
                            Main.getInstance().getDisplayBar().sendBar(player, Main.getInstance().getConfiguration().getMessage("Powerups.SHOPPING_SPREE.BarTag").replace("%shoppingSpreeDuration%", Main.getInstance().getPowerupHandler().getTimeLeft(GameArena.this.arena, PowerupType.SHOPPING_SPREE)));
                        }
                    }
                }
            }
        }.runTaskTimer((Plugin)Main.getInstance(), 0L, 0L);
        this.bukkitTasks.add(bukkitTask);
        string2 = new BukkitRunnable(){

            public void run() {
                ArrayList arrayList = new ArrayList(GameArena.this.revivePlayers.keySet());
                for (Player player : arrayList) {
                    Object object;
                    RevivePlayer revivePlayer = (RevivePlayer)GameArena.this.revivePlayers.get(player);
                    if (!player.isInsideVehicle() && (object = revivePlayer.getInvisibleArmorStand()) != null && object.isValid()) {
                        object.setPassenger((Entity)player);
                    }
                    object = revivePlayer.getLocation().getWorld().getNearbyEntities(revivePlayer.getLocation(), 2.5, 2.5, 2.5);
                    Player player2 = null;
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        Player player3;
                        Entity entity = (Entity)iterator.next();
                        if (!(entity instanceof Player) || !GameArena.this.isAlive(player3 = (Player)entity) || !player3.isSneaking() || GameArena.this.isRevivedPlayer(player3)) continue;
                        if (player2 == null) {
                            player2 = player3;
                            continue;
                        }
                        if (!(player3.getLocation().distanceSquared(revivePlayer.getLocation()) < player2.getLocation().distanceSquared(revivePlayer.getLocation()))) continue;
                        player2 = player3;
                    }
                    if (player2 != null) {
                        if (Main.getInstance().getPerkHandler().hasPerk(player2, PerkType.FAST_REVIVE) && revivePlayer.getSneakTime() > 0.5) {
                            revivePlayer.setSneakTime(player2, 0.5);
                        }
                        revivePlayer.setSneakTime(player2, revivePlayer.getSneakTime() - 0.1);
                        continue;
                    }
                    revivePlayer.setReviveTime(revivePlayer.getReviveTime() - 0.1);
                }
            }
        }.runTaskTimer((Plugin)Main.getInstance(), 2L, 2L);
        this.bukkitTasks.add((BukkitTask)string2);
        object5 = new BukkitRunnable(){

            public void run() {
                for (World world : Bukkit.getWorlds()) {
                    for (Entity entity : world.getEntitiesByClass(Zombie.class)) {
                        if (!entity.hasMetadata("Bombie")) continue;
                        entity.getWorld().createExplosion(entity.getLocation().getX(), entity.getLocation().getY(), entity.getLocation().getZ(), 2.0f, false, false);
                    }
                }
            }
        }.runTaskTimer((Plugin)Main.getInstance(), 80L, 80L);
        this.bukkitTasks.add((BukkitTask)object5);
        object4 = new BukkitRunnable(){

            public void run() {
                for (World world : Bukkit.getWorlds()) {
                    for (Entity entity : world.getEntitiesByClass(Zombie.class)) {
                        if (!entity.hasMetadata("Inferno") || GameArena.this.resetFireLocations.containsKey(entity.getLocation()) || entity.getLocation().getBlock().getType() != Material.AIR) continue;
                        GameArena.this.oldMaterialData.put(entity.getLocation().getBlock().getLocation(), entity.getLocation().getBlock().getBlockData());
                        for (Player player : GameArena.this.getDisplayedPlayers()) {
                            player.sendBlockChange(entity.getLocation().getBlock().getLocation(), Material.FIRE, (byte)0);
                        }
                        GameArena.this.resetFireLocations.put(entity.getLocation().getBlock().getLocation(), System.currentTimeMillis() + 5000L);
                    }
                }
            }
        }.runTaskTimer((Plugin)Main.getInstance(), 5L, 5L);
        this.bukkitTasks.add((BukkitTask)object4);
        object3 = new BukkitRunnable(){

            public void run() {
                ArrayList arrayList = new ArrayList(GameArena.this.resetFireLocations.keySet());
                for (Location location : arrayList) {
                    if (System.currentTimeMillis() <= (Long)GameArena.this.resetFireLocations.get(location)) continue;
                    BlockData blockData = (BlockData)GameArena.this.oldMaterialData.get(location);
                    for (Player player : GameArena.this.getDisplayedPlayers()) {
                        player.sendBlockChange(location, Material.AIR, (byte)0);
                    }
                    if (versionId >= 13 && blockData != null && location != null) {
                        location.getBlock().setBlockData(blockData);
                    }
                    GameArena.this.oldMaterialData.remove(location);
                    GameArena.this.resetFireLocations.remove(location);
                }
                for (Location location : GameArena.this.resetFireLocations.keySet()) {
                    for (Entity entity : location.getWorld().getNearbyEntities(location, 1.0, 1.0, 1.0)) {
                        Player player;
                        if (!(entity instanceof Player)) continue;
                        player = (Player)entity;
                        GameArena gameArena = Main.getInstance().getConfiguration().getGameArena(player);
                        if (gameArena == null || !gameArena.isAlive(player)) continue;
                        player.setFireTicks(140);
                    }
                }
            }
        }.runTaskTimer((Plugin)Main.getInstance(), 20L, 20L);
        this.bukkitTasks.add((BukkitTask)object3);
        BukkitTask bukkitTask2 = new BukkitRunnable(){

            public void run() {
                for (Player player : GameArena.this.getPlayers()) {
                    if (GameArena.this.isRevivedPlayer(player) || GameArena.this.isDead(player) || GameArena.this.isRepairing(player)) continue;
                    if (player.isSneaking()) {
                        GameArena.this.repairWindow(player);
                        continue;
                    }
                    GameArena.this.sendRepairWindowInformation(player);
                }
            }
        }.runTaskTimer((Plugin)Main.getInstance(), 30L, 30L);
        this.bukkitTasks.add(bukkitTask2);
        BukkitTask bukkitTask3 = new BukkitRunnable(){

            public void run() {
                GameArena.this.repairWindow();
            }
        }.runTaskTimer((Plugin)Main.getInstance(), 1L, 1L);
        this.bukkitTasks.add(bukkitTask3);
        BukkitTask bukkitTask4 = new BukkitRunnable(){

            public void run() {
                for (String string : GameArena.this.getWindowNames()) {
                    Entity entity2;
                    List<Location> list = GameArena.this.getWindowZombieLocations(string);
                    boolean bl = false;
                    for (Location location : list) {
                        for (Entity entity2 : location.getWorld().getNearbyEntities(location, 1.0, 1.0, 1.0)) {
                            if (!entity2.hasMetadata("Zombies")) continue;
                            bl = true;
                        }
                    }
                    if (!bl) continue;
                    List<Location> list2 = GameArena.this.getWindowBlockLocations(string);
                    boolean bl2 = false;
                    for (int i = 0; i < list2.size(); ++i) {
                        entity2 = (Location)list2.get(i);
                        if ((Main.getInstance().getConfiguration().getBoolean("Window.BarrierWall").booleanValue() || entity2.getBlock().getType() == Material.AIR || bl2) && (!Main.getInstance().getConfiguration().getBoolean("Window.BarrierWall").booleanValue() || entity2.getBlock().getType() == Material.BARRIER || entity2.getBlock().getType() == Material.AIR || bl2)) continue;
                        GameArena.this.oldMaterialData.put(entity2, entity2.getBlock().getBlockData());
                        if (!list2.contains(entity2.getBlock().getRelative(BlockFace.DOWN).getLocation())) {
                            entity2.getBlock().setType(Material.AIR);
                        } else {
                            entity2.getBlock().setType(Main.getInstance().getConfiguration().getBoolean("Window.BarrierWall") != false ? Material.BARRIER : Material.AIR);
                        }
                        entity2.getWorld().playSound((Location)entity2, Sound.valueOf((String)Main.getInstance().getConfiguration().getSound("BreakWindow")), 1.0f, Main.getInstance().getConfiguration().convertDouble("SoundPitch.BreakWindow"));
                        bl2 = true;
                    }
                    if (bl2 || !Main.getInstance().getConfiguration().getBoolean("Window.BarrierWall").booleanValue()) continue;
                    Iterator iterator = list2.iterator();
                    while (iterator.hasNext()) {
                        entity2 = (Location)iterator.next();
                        if (entity2.getBlock().getType() != Material.BARRIER) continue;
                        entity2.getBlock().setType(Material.AIR);
                    }
                }
            }
        }.runTaskTimer((Plugin)Main.getInstance(), 40L, 40L);
        this.bukkitTasks.add(bukkitTask4);
        final int n = Main.getInstance().getConfiguration().getInteger("EntitySpawnDelay.Start");
        final int n3 = Main.getInstance().getConfiguration().getInteger("EntitySpawnDelay.Round");
        if (n > 0) {
            new BukkitRunnable(){
                final long time = System.currentTimeMillis();

                public void run() {
                    if (System.currentTimeMillis() > this.time + (long)n) {
                        BukkitTask bukkitTask = new BukkitRunnable(){
                            int currentRound = 1;
                            long currentTime = System.currentTimeMillis();
                            boolean paused = false;
                            BukkitTask waitTask = null;

                            public void run() {
                                if (GameArena.this.round > this.currentRound && n3 > 0) {
                                    if (this.waitTask != null) {
                                        this.waitTask.cancel();
                                    }
                                    this.currentRound = GameArena.this.round;
                                    this.currentTime = System.currentTimeMillis();
                                    this.paused = true;
                                    this.waitTask = new BukkitRunnable(){

                                        public void run() {
                                            if (System.currentTimeMillis() > currentTime + (long)n3) {
                                                paused = false;
                                                this.cancel();
                                            }
                                        }
                                    }.runTaskTimer((Plugin)Main.getInstance(), 5L, 5L);
                                }
                                if (!this.paused) {
                                    GameArena.this.spawnEntity();
                                }
                            }
                        }.runTaskTimer((Plugin)Main.getInstance(), 50L, 150L);
                        GameArena.this.bukkitTasks.add(bukkitTask);
                        this.cancel();
                    }
                }
            }.runTaskTimer((Plugin)Main.getInstance(), 5L, 5L);
        } else {
            object = new BukkitRunnable(){
                int currentRound = 1;
                long currentTime = System.currentTimeMillis();
                boolean paused = false;
                BukkitTask waitTask = null;

                public void run() {
                    if (GameArena.this.round > this.currentRound && n3 > 0) {
                        if (this.waitTask != null) {
                            this.waitTask.cancel();
                        }
                        this.currentRound = GameArena.this.round;
                        this.currentTime = System.currentTimeMillis();
                        this.paused = true;
                        this.waitTask = new BukkitRunnable(){

                            public void run() {
                                if (System.currentTimeMillis() > currentTime + (long)n3) {
                                    paused = false;
                                    this.cancel();
                                }
                            }
                        }.runTaskTimer((Plugin)Main.getInstance(), 5L, 5L);
                    }
                    if (!this.paused) {
                        GameArena.this.spawnEntity();
                    }
                }
            }.runTaskTimer((Plugin)Main.getInstance(), 50L, 150L);
            this.bukkitTasks.add((BukkitTask)object);
        }
        this.checkGameEnd();
        this.nextRound();
        MultiArenaHandler.update(this.getSignLocations(), this.arena);
    }

    /*
     * Could not resolve type clashes
     */
    private void repairWindow() {
        ArrayList<Player> arrayList = new ArrayList<Player>();
        ArrayList<Player> arrayList2 = new ArrayList<Player>(this.repairingWindows.keySet());
        for (Player player : arrayList2) {
            Object object;
            if (!this.playerRepairDelay.containsKey(player)) {
                this.playerRepairDelay.put(player, System.currentTimeMillis() + (long)Main.getInstance().getConfiguration().getInteger("Window.RepairDelay").intValue());
                continue;
            }
            long l = this.playerRepairDelay.get(player);
            if (System.currentTimeMillis() <= l) continue;
            this.playerRepairDelay.put(player, System.currentTimeMillis() + (long)Main.getInstance().getConfiguration().getInteger("Window.RepairDelay").intValue());
            if (!this.repairingWindows.containsKey(player)) continue;
            String string = this.repairingWindows.get(player);
            List<Location> list = this.getWindowPlayerLocations(string);
            boolean bl = false;
            for (Object object2 : list) {
                if (bl || !LocationUtils.isSimilar((Location)object2, player.getLocation())) continue;
                bl = true;
            }
            if (!bl && Main.getInstance().getConfiguration().getGameArena(player) != null) {
                Object object2;
                boolean bl2 = Main.getInstance().getConfiguration().getGameArena(player).stopRepairWindow(player);
                if (bl2 && (object2 = Main.getInstance().getConfiguration().getMessage("WindowRepairStopped")) != null && !((String)object2).isEmpty()) {
                    player.sendMessage((String)object2);
                }
                string = null;
            }
            if (string == null) continue;
            if (EntityUtils.isNearbyEnemy(player.getLocation(), 2)) {
                object = Main.getInstance().getConfiguration().getMessage("WindowRepairFailed");
                if (object == null || ((String)object).isEmpty()) continue;
                player.sendMessage((String)object);
                continue;
            }
            object = this.getWindowBlockLocations(string);
            boolean bl3 = true;
            boolean bl4 = false;
            for (int i = 0; i < object.size(); ++i) {
                BlockData blockData;
                Location location = (Location)object.get(i);
                if ((location.getBlock().getType() == Material.AIR && !bl4 || Main.getInstance().getConfiguration().getBoolean("Window.BarrierWall").booleanValue() && location.getBlock().getType() == Material.BARRIER && !bl4) && (blockData = this.oldMaterialData.get(location)) != null) {
                    if (versionId >= 13) {
                        location.getBlock().setBlockData(blockData);
                    }
                    if (Main.getInstance().getConfiguration().getBoolean("Window.BarrierWall").booleanValue()) {
                        Iterator iterator = object.iterator();
                        while (iterator.hasNext()) {
                            Location location2 = (Location)iterator.next();
                            if (location2.getBlock().getType() != Material.AIR || !object.contains(location2.getBlock().getRelative(BlockFace.DOWN).getLocation())) continue;
                            location2.getBlock().setType(Material.BARRIER, true);
                        }
                    }
                    location.getWorld().playSound(location, Sound.valueOf((String)Main.getInstance().getConfiguration().getSound("RepairWindow")), 1.0f, Main.getInstance().getConfiguration().convertDouble("SoundPitch.RepairWindow"));
                    this.addGold(player, this.getFileConfiguration().getInt("Gold.RepairWindow"));
                    bl4 = true;
                    this.oldMaterialData.remove(location);
                }
                if (location.getBlock().getType() != Material.AIR && (!Main.getInstance().getConfiguration().getBoolean("Window.BarrierWall").booleanValue() || location.getBlock().getType() != Material.BARRIER)) continue;
                bl3 = false;
            }
            if (!bl3) continue;
            player.getWorld().playSound(player.getLocation(), Sound.valueOf((String)Main.getInstance().getConfiguration().getSound("RepairedWindow")), 1.0f, Main.getInstance().getConfiguration().convertDouble("SoundPitch.RepairedWindow"));
            String string2 = Main.getInstance().getConfiguration().getMessage("WindowRepaired");
            if (string2 != null && !string2.isEmpty()) {
                player.sendMessage(string2);
            }
            arrayList.add(player);
        }
        for (Player player : arrayList) {
            this.repairingWindows.remove(player);
            this.playerRepairDelay.remove(player);
        }
    }

    public void spawnEntity() {
        Collection<List<Location>> collection = this.unlockedDoorSpawners.values();
        ArrayList<Location> arrayList = new ArrayList<Location>();
        for (List<Location> object2 : collection) {
            if (object2 == null) continue;
            arrayList.addAll(object2);
        }
        ArrayList arrayList2 = new ArrayList();
        for (Object object : this.fileConfiguration.getStringList("BossSpawns.Default")) {
            World location = Bukkit.getWorld((String)((String)object).split(":")[0]);
            double list = Double.parseDouble(((String)object).split(":")[1]);
            double enum_ = Double.parseDouble(((String)object).split(":")[2]);
            double zombie = Double.parseDouble(((String)object).split(":")[3]);
            arrayList2.add(new Location(location, list, enum_, zombie));
        }
        Collections.shuffle(arrayList2);
        HashMap hashMap = new HashMap();
        for (Object object : ZombieType.values()) {
            if (!object.isBossEntity()) continue;
            ArrayList<Location> arrayList3 = new ArrayList<Location>();
            for (String string : this.fileConfiguration.getStringList("BossSpawns." + (Object)object)) {
                World d = Bukkit.getWorld((String)string.split(":")[0]);
                double d2 = Double.parseDouble(string.split(":")[1]);
                double d3 = Double.parseDouble(string.split(":")[2]);
                double d4 = Double.parseDouble(string.split(":")[3]);
                arrayList3.add(new Location(d, d2, d3, d4));
            }
            if (arrayList3.isEmpty()) continue;
            Collections.shuffle(arrayList3);
            hashMap.put(object, arrayList3);
        }
        Collections.shuffle(arrayList);
        for (Location location : arrayList) {
            Object object;
            List<Location> list = this.connectedLocations.get(location);
            if (list == null) continue;
            object = new HashMap();
            object.put(ZombieType.NORMAL_ZOMBIE, this.normalZombies);
            object.put(ZombieType.NORMAL_STRONG_ZOMBIE, this.normalStrongZombies);
            object.put(ZombieType.NORMAL_PROTECTED_ZOMBIE, this.normalProtectedZombies);
            object.put(ZombieType.PIG_ZOMBIE, this.pigZombies);
            object.put(ZombieType.TNT_ZOMBIE, this.tntZombies);
            object.put(ZombieType.EMPOWERED_ZOMBIE, this.empoweredZombies);
            object.put(ZombieType.IRON_ZOMBIE, this.ironZombies);
            object.put(ZombieType.IRON_PROTECTED_ZOMBIE, this.ironProtectedZombies);
            object.put(ZombieType.GLOWING_ZOMBIE, this.glowingZombies);
            object.put(ZombieType.MAGMA_ZOMBIE, this.magmaZombies);
            object.put(ZombieType.GUARDIAN_ZOMBIE, this.guardianZombies);
            object.put(ZombieType.SKELETON, this.skeletons);
            object.put(ZombieType.WOLF, this.wolfes);
            object.put(ZombieType.ENDERMITE, this.endermites);
            object.put(ZombieType.BLAZE, this.blazes);
            object.put(ZombieType.SOLDIER_ZOMBIE, this.soldiers);
            object.put(ZombieType.WITCH, this.witches);
            object.put(ZombieType.CAVE_SPIDER, this.caveSpiders);
            object.put(ZombieType.SPIDER, this.spiders);
            object.put(ZombieType.WITHER_ZOMBIE, this.witherZombies);
            object.put(ZombieType.SLIME_ZOMBIE, this.slimeZombies);
            object.put(ZombieType.SANTA_HELPER, this.santaHelperZombies);
            object.put(ZombieType.EASTER_BUNNY, this.easterBunnyZombies);
            object.put(ZombieType.MOSQUITO, this.mosquitos);
            object.put(ZombieType.CLOWN, this.clowns);
            object.put(ZombieType.PENGUIN, this.penguins);
            object.put(ZombieType.ENDER_ZOMBIE, this.enderZombies);
            object.put(ZombieType.INFERNO, this.infernos);
            object.put(ZombieType.BOMBIE, this.bombies);
            object.put(ZombieType.THE_BROODMOTHER, this.theBroodmothers);
            object.put(ZombieType.KING_WITHER, this.kingWithers);
            object.put(ZombieType.KING_SLIME, this.kingSlimes);
            object.put(ZombieType.HEROBRINE, this.herobrines);
            object.put(ZombieType.SANTA_CLAUS, this.santaClaus);
            object.put(ZombieType.PENNYWISE, this.pennywise);
            Enum enum_ = null;
            ArrayList arrayList4 = new ArrayList();
            for (ZombieType zombieType : object.keySet()) {
                if ((Integer)object.get((Object)zombieType) <= 0) continue;
                arrayList4.add(zombieType);
            }
            if (!arrayList4.isEmpty()) {
                enum_ = (ZombieType)((Object)arrayList4.get(ThreadLocalRandom.current().nextInt(arrayList4.size())));
            }
            if (enum_ == null) continue;
            switch (18.$SwitchMap$Utils$ZombieType[enum_.ordinal()]) {
                case 1: {
                    Zombie zombie = (Zombie)location.getWorld().spawn(location, Zombie.class);
                    zombie.setPersistent(true);
                    double d = this.fileConfiguration.getDouble("Health.NormalZombie");
                    if (d <= 0.0) {
                        d = 20.0;
                    }
                    zombie.setMaxHealth(d);
                    zombie.setHealth(d);
                    zombie.getEquipment().clear();
                    zombie.setBaby(false);
                    zombie.setRemoveWhenFarAway(false);
                    zombie.getEquipment().setLeggings(ItemStackUtils.colorize(ItemStackUtils.getItem(Material.LEATHER_LEGGINGS, 1, 0, "", new String[0]), Color.BLACK));
                    zombie.getEquipment().setItemInHand(ItemStackUtils.getItem(versionId >= 13 ? Material.WOODEN_AXE : Material.getMaterial((String)"WOOD_AXE"), 1, 0, "", new String[0]));
                    zombie.setMetadata("Arena", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)this.getName()));
                    zombie.setMetadata("Zombies", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)this.fileConfiguration.getDouble("Gold.NormalZombie")));
                    zombie.setMetadata("ZombieName", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)Configuration.translateTextCodes(this.fileConfiguration.getString("Name.NormalZombie"))));
                    Player player = EntityUtils.getNearbyPlayer((Entity)zombie);
                    zombie.setTarget((LivingEntity)player);
                    if (this.isEndlessMode() && this.round >= this.fileConfiguration.getInt("Rounds")) {
                        EntityUtils.walk(this.arena, (Entity)zombie, player, this.fileConfiguration.getDouble("EMode.Speed.NormalZombie"));
                    } else {
                        EntityUtils.walk(this.arena, (Entity)zombie, player, this.fileConfiguration.getDouble("Round." + this.getRound() + ".Speed.NormalZombie"));
                    }
                    EntityUtils.teleport((Entity)zombie, location);
                    --this.normalZombies;
                    break;
                }
                case 2: {
                    Zombie zombie = (Zombie)location.getWorld().spawn(location, Zombie.class);
                    zombie.setPersistent(true);
                    double d = this.fileConfiguration.getDouble("Health.NormalStrongZombie");
                    if (d <= 0.0) {
                        d = 20.0;
                    }
                    zombie.setMaxHealth(d);
                    zombie.setHealth(d);
                    zombie.getEquipment().clear();
                    zombie.setBaby(false);
                    zombie.setRemoveWhenFarAway(false);
                    zombie.getEquipment().setChestplate(ItemStackUtils.colorize(ItemStackUtils.getItem(Material.LEATHER_CHESTPLATE, 1, 0, "", new String[0]), Color.BLACK));
                    zombie.getEquipment().setLeggings(ItemStackUtils.colorize(ItemStackUtils.getItem(Material.LEATHER_LEGGINGS, 1, 0, "", new String[0]), Color.BLACK));
                    zombie.getEquipment().setBoots(ItemStackUtils.colorize(ItemStackUtils.getItem(Material.LEATHER_BOOTS, 1, 0, "", new String[0]), Color.BLACK));
                    zombie.getEquipment().setItemInHand(ItemStackUtils.getItem(Material.STONE_AXE, 1, 0, "", new String[0]));
                    zombie.setMetadata("Arena", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)this.getName()));
                    zombie.setMetadata("Zombies", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)this.fileConfiguration.getDouble("Gold.NormalStrongZombie")));
                    zombie.setMetadata("ZombieName", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)Configuration.translateTextCodes(this.fileConfiguration.getString("Name.NormalStrongZombie"))));
                    Player player = EntityUtils.getNearbyPlayer((Entity)zombie);
                    zombie.setTarget((LivingEntity)player);
                    if (this.isEndlessMode() && this.round >= this.fileConfiguration.getInt("Rounds")) {
                        EntityUtils.walk(this.arena, (Entity)zombie, player, this.fileConfiguration.getDouble("EMode.Speed.NormalStrongZombie"));
                    } else {
                        EntityUtils.walk(this.arena, (Entity)zombie, player, this.fileConfiguration.getDouble("Round." + this.getRound() + ".Speed.NormalStrongZombie"));
                    }
                    EntityUtils.teleport((Entity)zombie, location);
                    --this.normalStrongZombies;
                    break;
                }
                case 3: {
                    Zombie zombie = (Zombie)location.getWorld().spawn(location, Zombie.class);
                    zombie.setPersistent(true);
                    double d = this.fileConfiguration.getDouble("Health.NormalProtectedZombie");
                    if (d <= 0.0) {
                        d = 20.0;
                    }
                    zombie.setMaxHealth(d);
                    zombie.setHealth(d);
                    zombie.getEquipment().clear();
                    zombie.setBaby(false);
                    zombie.setRemoveWhenFarAway(false);
                    zombie.getEquipment().setChestplate(ItemStackUtils.getItem(Material.CHAINMAIL_CHESTPLATE, 1, 0, "", new String[0]));
                    zombie.getEquipment().setLeggings(ItemStackUtils.colorize(ItemStackUtils.getItem(Material.LEATHER_LEGGINGS, 1, 0, "", new String[0]), Color.BLACK));
                    zombie.getEquipment().setBoots(ItemStackUtils.colorize(ItemStackUtils.getItem(Material.LEATHER_BOOTS, 1, 0, "", new String[0]), Color.BLACK));
                    zombie.getEquipment().setItemInHand(ItemStackUtils.getItem(versionId >= 13 ? Material.WOODEN_AXE : Material.getMaterial((String)"WOOD_AXE"), 1, 0, "", new String[0]));
                    zombie.setMetadata("Arena", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)this.getName()));
                    zombie.setMetadata("Zombies", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)this.fileConfiguration.getDouble("Gold.NormalProtectedZombie")));
                    zombie.setMetadata("ZombieName", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)Configuration.translateTextCodes(this.fileConfiguration.getString("Name.NormalProtectedZombie"))));
                    Player player = EntityUtils.getNearbyPlayer((Entity)zombie);
                    zombie.setTarget((LivingEntity)player);
                    if (this.isEndlessMode() && this.round >= this.fileConfiguration.getInt("Rounds")) {
                        EntityUtils.walk(this.arena, (Entity)zombie, player, this.fileConfiguration.getDouble("EMode.Speed.NormalProtectedZombie"));
                    } else {
                        EntityUtils.walk(this.arena, (Entity)zombie, player, this.fileConfiguration.getDouble("Round." + this.getRound() + ".Speed.NormalProtectedZombie"));
                    }
                    EntityUtils.teleport((Entity)zombie, location);
                    --this.normalProtectedZombies;
                    break;
                }
                case 4: {
                    PigZombie pigZombie = (PigZombie)location.getWorld().spawn(location, PigZombie.class);
                    pigZombie.setPersistent(true);
                    double d = this.fileConfiguration.getDouble("Health.PigZombie");
                    if (d <= 0.0) {
                        d = 20.0;
                    }
                    pigZombie.setMaxHealth(d);
                    pigZombie.setHealth(d);
                    pigZombie.getEquipment().clear();
                    pigZombie.setBaby(false);
                    pigZombie.setRemoveWhenFarAway(false);
                    pigZombie.getEquipment().setChestplate(ItemStackUtils.getItem(versionId >= 13 ? Material.GOLDEN_CHESTPLATE : Material.getMaterial((String)"GOLD_CHESTPLATE"), 1, 0, "", new String[0]));
                    pigZombie.getEquipment().setLeggings(ItemStackUtils.getItem(versionId >= 13 ? Material.GOLDEN_LEGGINGS : Material.getMaterial((String)"GOLD_LEGGINGS"), 1, 0, "", new String[0]));
                    pigZombie.getEquipment().setBoots(ItemStackUtils.getItem(versionId >= 13 ? Material.GOLDEN_BOOTS : Material.getMaterial((String)"GOLD_BOOTS"), 1, 0, "", new String[0]));
                    pigZombie.getEquipment().setItemInHand(ItemStackUtils.getItem(versionId >= 13 ? Material.GOLDEN_SWORD : Material.getMaterial((String)"GOLD_SWORD"), 1, 0, "", new String[0]));
                    pigZombie.setMetadata("Arena", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)this.getName()));
                    pigZombie.setMetadata("Zombies", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)this.fileConfiguration.getDouble("Gold.PigZombie")));
                    pigZombie.setMetadata("ZombieName", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)Configuration.translateTextCodes(this.fileConfiguration.getString("Name.PigZombie"))));
                    pigZombie.setMetadata("FireResistant", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)""));
                    Player player = EntityUtils.getNearbyPlayer((Entity)pigZombie);
                    pigZombie.setTarget((LivingEntity)player);
                    if (this.isEndlessMode() && this.round >= this.fileConfiguration.getInt("Rounds")) {
                        EntityUtils.walk(this.arena, (Entity)pigZombie, player, this.fileConfiguration.getDouble("EMode.Speed.PigZombie"));
                    } else {
                        EntityUtils.walk(this.arena, (Entity)pigZombie, player, this.fileConfiguration.getDouble("Round." + this.getRound() + ".Speed.PigZombie"));
                    }
                    EntityUtils.teleport((Entity)pigZombie, location);
                    --this.pigZombies;
                    break;
                }
                case 5: {
                    Zombie zombie = (Zombie)location.getWorld().spawn(location, Zombie.class);
                    zombie.setPersistent(true);
                    double d = this.fileConfiguration.getDouble("Health.TNTZombie");
                    if (d <= 0.0) {
                        d = 20.0;
                    }
                    zombie.setMaxHealth(d);
                    zombie.setHealth(d);
                    zombie.getEquipment().clear();
                    zombie.setBaby(true);
                    zombie.setRemoveWhenFarAway(false);
                    zombie.getEquipment().setHelmet(new ItemStack(Material.TNT));
                    zombie.getEquipment().setChestplate(ItemStackUtils.colorize(ItemStackUtils.getItem(Material.LEATHER_CHESTPLATE, 1, 0, "", new String[0]), Color.BLACK));
                    zombie.getEquipment().setLeggings(ItemStackUtils.colorize(ItemStackUtils.getItem(Material.LEATHER_LEGGINGS, 1, 0, "", new String[0]), Color.BLACK));
                    zombie.getEquipment().setBoots(ItemStackUtils.colorize(ItemStackUtils.getItem(Material.LEATHER_BOOTS, 1, 0, "", new String[0]), Color.PURPLE));
                    zombie.setMetadata("Arena", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)this.getName()));
                    zombie.setMetadata("Zombies", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)this.fileConfiguration.getDouble("Gold.TNTZombie")));
                    zombie.setMetadata("ZombieName", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)Configuration.translateTextCodes(this.fileConfiguration.getString("Name.TNTZombie"))));
                    Player player = EntityUtils.getNearbyPlayer((Entity)zombie);
                    zombie.setTarget((LivingEntity)player);
                    if (this.isEndlessMode() && this.round >= this.fileConfiguration.getInt("Rounds")) {
                        EntityUtils.walk(this.arena, (Entity)zombie, player, this.fileConfiguration.getDouble("EMode.Speed.TNTZombie"));
                    } else {
                        EntityUtils.walk(this.arena, (Entity)zombie, player, this.fileConfiguration.getDouble("Round." + this.getRound() + ".Speed.TNTZombie"));
                    }
                    EntityUtils.teleport((Entity)zombie, location);
                    --this.tntZombies;
                    break;
                }
                case 6: {
                    Wolf wolf = (Wolf)location.getWorld().spawn(location, Wolf.class);
                    wolf.setPersistent(true);
                    double d = this.fileConfiguration.getDouble("Health.Wolf");
                    if (d <= 0.0) {
                        d = 8.0;
                    }
                    wolf.setMaxHealth(d);
                    wolf.setHealth(d);
                    wolf.setAngry(true);
                    wolf.setRemoveWhenFarAway(false);
                    wolf.setMetadata("Arena", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)this.getName()));
                    wolf.setMetadata("Zombies", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)this.fileConfiguration.getDouble("Gold.Wolf")));
                    wolf.setMetadata("ZombieName", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)Configuration.translateTextCodes(this.fileConfiguration.getString("Name.Wolf"))));
                    Player player = EntityUtils.getNearbyPlayer((Entity)wolf);
                    wolf.setTarget((LivingEntity)player);
                    if (this.isEndlessMode() && this.round >= this.fileConfiguration.getInt("Rounds")) {
                        EntityUtils.walk(this.arena, (Entity)wolf, player, this.fileConfiguration.getDouble("EMode.Speed.Wolf"));
                    } else {
                        EntityUtils.walk(this.arena, (Entity)wolf, player, this.fileConfiguration.getDouble("Round." + this.getRound() + ".Speed.Wolf"));
                    }
                    EntityUtils.teleport((Entity)wolf, location);
                    --this.wolfes;
                    break;
                }
                case 7: {
                    Zombie zombie = (Zombie)location.getWorld().spawn(location, Zombie.class);
                    zombie.setPersistent(true);
                    double d = this.fileConfiguration.getDouble("Health.EmpoweredZombie");
                    if (d <= 0.0) {
                        d = 20.0;
                    }
                    zombie.setMaxHealth(d);
                    zombie.setHealth(d);
                    zombie.getEquipment().clear();
                    zombie.setBaby(false);
                    zombie.setRemoveWhenFarAway(false);
                    zombie.getEquipment().setItemInHand(ItemStackUtils.getItem(Material.DIAMOND_AXE, 1, 0, "", new String[0]));
                    zombie.getEquipment().setChestplate(ItemStackUtils.colorize(ItemStackUtils.getItem(Material.LEATHER_CHESTPLATE, 1, 0, "", new String[0]), Color.RED));
                    zombie.getEquipment().setLeggings(ItemStackUtils.colorize(ItemStackUtils.getItem(Material.LEATHER_LEGGINGS, 1, 0, "", new String[0]), Color.RED));
                    zombie.getEquipment().setBoots(ItemStackUtils.colorize(ItemStackUtils.getItem(Material.LEATHER_BOOTS, 1, 0, "", new String[0]), Color.RED));
                    zombie.setMetadata("Arena", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)this.getName()));
                    zombie.setMetadata("Zombies", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)this.fileConfiguration.getDouble("Gold.EmpoweredZombie")));
                    zombie.setMetadata("ZombieName", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)Configuration.translateTextCodes(this.fileConfiguration.getString("Name.EmpoweredZombie"))));
                    Player player = EntityUtils.getNearbyPlayer((Entity)zombie);
                    zombie.setTarget((LivingEntity)player);
                    if (this.isEndlessMode() && this.round >= this.fileConfiguration.getInt("Rounds")) {
                        EntityUtils.walk(this.arena, (Entity)zombie, player, this.fileConfiguration.getDouble("EMode.Speed.EmpoweredZombie"));
                    } else {
                        EntityUtils.walk(this.arena, (Entity)zombie, player, this.fileConfiguration.getDouble("Round." + this.getRound() + ".Speed.EmpoweredZombie"));
                    }
                    EntityUtils.teleport((Entity)zombie, location);
                    --this.empoweredZombies;
                    break;
                }
                case 8: {
                    Zombie zombie = (Zombie)location.getWorld().spawn(location, Zombie.class);
                    zombie.setPersistent(true);
                    double d = this.fileConfiguration.getDouble("Health.IronZombie");
                    if (d <= 0.0) {
                        d = 20.0;
                    }
                    zombie.setMaxHealth(d);
                    zombie.setHealth(d);
                    zombie.getEquipment().clear();
                    zombie.setBaby(false);
                    zombie.setRemoveWhenFarAway(false);
                    zombie.getEquipment().setItemInHand(ItemStackUtils.getItem(Material.IRON_AXE, 1, 0, "", new String[0]));
                    zombie.getEquipment().setChestplate(ItemStackUtils.getItem(Material.IRON_CHESTPLATE, 1, 0, "", new String[0]));
                    zombie.getEquipment().setLeggings(ItemStackUtils.getItem(Material.CHAINMAIL_LEGGINGS, 1, 0, "", new String[0]));
                    zombie.getEquipment().setBoots(ItemStackUtils.getItem(Material.CHAINMAIL_BOOTS, 1, 0, "", new String[0]));
                    zombie.setMetadata("Arena", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)this.getName()));
                    zombie.setMetadata("Zombies", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)this.fileConfiguration.getDouble("Gold.IronZombie")));
                    zombie.setMetadata("ZombieName", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)Configuration.translateTextCodes(this.fileConfiguration.getString("Name.IronZombie"))));
                    Player player = EntityUtils.getNearbyPlayer((Entity)zombie);
                    zombie.setTarget((LivingEntity)player);
                    if (this.isEndlessMode() && this.round >= this.fileConfiguration.getInt("Rounds")) {
                        EntityUtils.walk(this.arena, (Entity)zombie, player, this.fileConfiguration.getDouble("EMode.Speed.IronZombie"));
                    } else {
                        EntityUtils.walk(this.arena, (Entity)zombie, player, this.fileConfiguration.getDouble("Round." + this.getRound() + ".Speed.IronZombie"));
                    }
                    EntityUtils.teleport((Entity)zombie, location);
                    --this.ironZombies;
                    break;
                }
                case 9: {
                    Zombie zombie = (Zombie)location.getWorld().spawn(location, Zombie.class);
                    zombie.setPersistent(true);
                    double d = this.fileConfiguration.getDouble("Health.IronProtectedZombie");
                    if (d <= 0.0) {
                        d = 20.0;
                    }
                    zombie.setMaxHealth(d);
                    zombie.setHealth(d);
                    zombie.getEquipment().clear();
                    zombie.setBaby(false);
                    zombie.setRemoveWhenFarAway(false);
                    zombie.getEquipment().setItemInHand(ItemStackUtils.getItem(Material.IRON_AXE, 1, 0, "", new String[0]));
                    zombie.getEquipment().setChestplate(ItemStackUtils.getItem(Material.IRON_CHESTPLATE, 1, 0, "", new String[0]));
                    zombie.getEquipment().setLeggings(ItemStackUtils.getItem(Material.IRON_LEGGINGS, 1, 0, "", new String[0]));
                    zombie.getEquipment().setBoots(ItemStackUtils.getItem(Material.IRON_BOOTS, 1, 0, "", new String[0]));
                    zombie.setMetadata("Arena", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)this.getName()));
                    zombie.setMetadata("Zombies", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)this.fileConfiguration.getDouble("Gold.IronProtectedZombie")));
                    zombie.setMetadata("ZombieName", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)Configuration.translateTextCodes(this.fileConfiguration.getString("Name.IronProtectedZombie"))));
                    Player player = EntityUtils.getNearbyPlayer((Entity)zombie);
                    zombie.setTarget((LivingEntity)player);
                    if (this.isEndlessMode() && this.round >= this.fileConfiguration.getInt("Rounds")) {
                        EntityUtils.walk(this.arena, (Entity)zombie, player, this.fileConfiguration.getDouble("EMode.Speed.IronProtectedZombie"));
                    } else {
                        EntityUtils.walk(this.arena, (Entity)zombie, player, this.fileConfiguration.getDouble("Round." + this.getRound() + ".Speed.IronProtectedZombie"));
                    }
                    EntityUtils.teleport((Entity)zombie, location);
                    --this.ironProtectedZombies;
                    break;
                }
                case 10: {
                    Zombie zombie = (Zombie)location.getWorld().spawn(location, Zombie.class);
                    zombie.setPersistent(true);
                    double d = this.fileConfiguration.getDouble("Health.GlowingZombie");
                    if (d <= 0.0) {
                        d = 20.0;
                    }
                    zombie.setMaxHealth(d);
                    zombie.setHealth(d);
                    zombie.getEquipment().clear();
                    zombie.setBaby(false);
                    zombie.setRemoveWhenFarAway(false);
                    zombie.getEquipment().setItemInHand(ItemStackUtils.enchant(ItemStackUtils.getItem(Material.BLAZE_ROD, 1, 0, "", new String[0]), Enchantment.FIRE_ASPECT, 1));
                    zombie.getEquipment().setChestplate(ItemStackUtils.enchant(ItemStackUtils.colorize(ItemStackUtils.getItem(Material.LEATHER_CHESTPLATE, 1, 0, "", new String[0]), Color.YELLOW), Enchantment.PROTECTION_PROJECTILE, 1));
                    zombie.getEquipment().setLeggings(ItemStackUtils.enchant(ItemStackUtils.colorize(ItemStackUtils.getItem(Material.LEATHER_LEGGINGS, 1, 0, "", new String[0]), Color.YELLOW), Enchantment.PROTECTION_PROJECTILE, 1));
                    zombie.getEquipment().setBoots(ItemStackUtils.enchant(ItemStackUtils.colorize(ItemStackUtils.getItem(Material.LEATHER_BOOTS, 1, 0, "", new String[0]), Color.YELLOW), Enchantment.PROTECTION_PROJECTILE, 1));
                    zombie.setMetadata("Arena", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)this.getName()));
                    zombie.setMetadata("Zombies", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)this.fileConfiguration.getDouble("Gold.GlowingZombie")));
                    zombie.setMetadata("ZombieName", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)Configuration.translateTextCodes(this.fileConfiguration.getString("Name.GlowingZombie"))));
                    zombie.setMetadata("FireResistant", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)""));
                    Player player = EntityUtils.getNearbyPlayer((Entity)zombie);
                    zombie.setTarget((LivingEntity)player);
                    if (this.isEndlessMode() && this.round >= this.fileConfiguration.getInt("Rounds")) {
                        EntityUtils.walk(this.arena, (Entity)zombie, player, this.fileConfiguration.getDouble("EMode.Speed.GlowingZombie"));
                    } else {
                        EntityUtils.walk(this.arena, (Entity)zombie, player, this.fileConfiguration.getDouble("Round." + this.getRound() + ".Speed.GlowingZombie"));
                    }
                    EntityUtils.teleport((Entity)zombie, location);
                    --this.glowingZombies;
                    break;
                }
                case 11: {
                    Zombie zombie = (Zombie)location.getWorld().spawn(location, Zombie.class);
                    zombie.setPersistent(true);
                    double d = this.fileConfiguration.getDouble("Health.MagmaZombie");
                    if (d <= 0.0) {
                        d = 20.0;
                    }
                    zombie.setMaxHealth(d);
                    zombie.setHealth(d);
                    zombie.getEquipment().clear();
                    zombie.setBaby(false);
                    zombie.setRemoveWhenFarAway(false);
                    zombie.getEquipment().setItemInHand(ItemStackUtils.getItem(versionId >= 13 ? Material.GOLDEN_SWORD : Material.getMaterial((String)"GOLD_SWORD"), 1, 0, "", new String[0]));
                    zombie.getEquipment().setHelmet(ItemStackUtils.getTexturedItem(1, "", "eyJ0aW1lc3RhbXAiOjE0OTk3MTAwODQ4OTEsInByb2ZpbGVJZCI6IjA5NzJiZGQxNGI4NjQ5ZmI5ZWNjYTM1M2Y4NDkxYTUxIiwicHJvZmlsZU5hbWUiOiJNSEZfTGF2YVNsaW1lIiwic2lnbmF0dXJlUmVxdWlyZWQiOnRydWUsInRleHR1cmVzIjp7IlNLSU4iOnsidXJsIjoiaHR0cDovL3RleHR1cmVzLm1pbmVjcmFmdC5uZXQvdGV4dHVyZS8zODk1N2Q1MDIzYzkzN2M0YzQxYWEyNDEyZDQzNDEwYmRhMjNjZjc5YTlmNmFiMzZiNzZmZWYyZDdjNDI5In19fQ=="));
                    zombie.getEquipment().setChestplate(ItemStackUtils.colorize(ItemStackUtils.getItem(Material.LEATHER_CHESTPLATE, 1, 0, "", new String[0]), Color.YELLOW));
                    zombie.getEquipment().setLeggings(ItemStackUtils.colorize(ItemStackUtils.getItem(Material.LEATHER_LEGGINGS, 1, 0, "", new String[0]), Color.YELLOW));
                    zombie.getEquipment().setBoots(ItemStackUtils.colorize(ItemStackUtils.getItem(Material.LEATHER_BOOTS, 1, 0, "", new String[0]), Color.YELLOW));
                    zombie.setMetadata("Arena", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)this.getName()));
                    zombie.setMetadata("Zombies", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)this.fileConfiguration.getDouble("Gold.MagmaZombie")));
                    zombie.setMetadata("ZombieName", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)Configuration.translateTextCodes(this.fileConfiguration.getString("Name.MagmaZombie"))));
                    zombie.setMetadata("FireResistant", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)""));
                    Player player = EntityUtils.getNearbyPlayer((Entity)zombie);
                    zombie.setTarget((LivingEntity)player);
                    if (this.isEndlessMode() && this.round >= this.fileConfiguration.getInt("Rounds")) {
                        EntityUtils.walk(this.arena, (Entity)zombie, player, this.fileConfiguration.getDouble("EMode.Speed.MagmaZombie"));
                    } else {
                        EntityUtils.walk(this.arena, (Entity)zombie, player, this.fileConfiguration.getDouble("Round." + this.getRound() + ".Speed.MagmaZombie"));
                    }
                    EntityUtils.teleport((Entity)zombie, location);
                    --this.magmaZombies;
                    break;
                }
                case 12: {
                    Zombie zombie = (Zombie)location.getWorld().spawn(location, Zombie.class);
                    zombie.setPersistent(true);
                    double d = this.fileConfiguration.getDouble("Health.GuardianZombie");
                    if (d <= 0.0) {
                        d = 20.0;
                    }
                    zombie.setMaxHealth(d);
                    zombie.setHealth(d);
                    zombie.getEquipment().clear();
                    zombie.setBaby(false);
                    zombie.setRemoveWhenFarAway(false);
                    zombie.getEquipment().setItemInHand(ItemStackUtils.getItem(versionId >= 13 ? Material.GOLDEN_SWORD : Material.getMaterial((String)"GOLD_SWORD"), 1, 0, "", new String[0]));
                    zombie.getEquipment().setHelmet(ItemStackUtils.getTexturedItem(1, "", "eyJ0aW1lc3RhbXAiOjE0OTk3MDk5NTU5NzUsInByb2ZpbGVJZCI6IjQwMDVjYWMxYTE2YTQ1YWE5ZTcyN2ZiNTE0MzM1NzE3IiwicHJvZmlsZU5hbWUiOiJNSEZfR3VhcmRpYW4iLCJzaWduYXR1cmVSZXF1aXJlZCI6dHJ1ZSwidGV4dHVyZXMiOnsiU0tJTiI6eyJ1cmwiOiJodHRwOi8vdGV4dHVyZXMubWluZWNyYWZ0Lm5ldC90ZXh0dXJlLzkzMmMyNDUyNGM4MmFiM2IzZTU3YzIwNTJjNTMzZjEzZGQ4YzBiZWI4YmRkMDYzNjliYjI1NTRkYTg2YzEyMyJ9fX0="));
                    zombie.getEquipment().setChestplate(ItemStackUtils.colorize(ItemStackUtils.getItem(Material.LEATHER_CHESTPLATE, 1, 0, "", new String[0]), Color.AQUA));
                    zombie.getEquipment().setLeggings(ItemStackUtils.colorize(ItemStackUtils.getItem(Material.LEATHER_LEGGINGS, 1, 0, "", new String[0]), Color.AQUA));
                    zombie.getEquipment().setBoots(ItemStackUtils.colorize(ItemStackUtils.getItem(Material.LEATHER_BOOTS, 1, 0, "", new String[0]), Color.AQUA));
                    zombie.setMetadata("Arena", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)this.getName()));
                    zombie.setMetadata("Zombies", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)this.fileConfiguration.getDouble("Gold.GuardianZombie")));
                    zombie.setMetadata("ZombieName", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)Configuration.translateTextCodes(this.fileConfiguration.getString("Name.GuardianZombie"))));
                    Player player = EntityUtils.getNearbyPlayer((Entity)zombie);
                    zombie.setTarget((LivingEntity)player);
                    Guardian guardian = (Guardian)location.getWorld().spawn(location, Guardian.class);
                    guardian.setMetadata("Unknown", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)""));
                    guardian.setMetadata("Arena", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)this.getName()));
                    guardian.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, Integer.MAX_VALUE, 1, true, false));
                    guardian.setTarget((LivingEntity)player);
                    zombie.setPassenger((Entity)guardian);
                    if (this.isEndlessMode() && this.round >= this.fileConfiguration.getInt("Rounds")) {
                        EntityUtils.walk(this.arena, (Entity)zombie, player, this.fileConfiguration.getDouble("EMode.Speed.GuardianZombie"));
                    } else {
                        EntityUtils.walk(this.arena, (Entity)zombie, player, this.fileConfiguration.getDouble("Round." + this.getRound() + ".Speed.GuardianZombie"));
                    }
                    EntityUtils.teleport((Entity)zombie, location);
                    --this.guardianZombies;
                    break;
                }
                case 13: {
                    Skeleton skeleton = (Skeleton)location.getWorld().spawn(location, Skeleton.class);
                    skeleton.setPersistent(true);
                    double d = this.fileConfiguration.getDouble("Health.Skeleton");
                    if (d <= 0.0) {
                        d = 20.0;
                    }
                    skeleton.setMaxHealth(d);
                    skeleton.setHealth(d);
                    skeleton.getEquipment().clear();
                    skeleton.setRemoveWhenFarAway(false);
                    skeleton.getEquipment().setItemInHand(ItemStackUtils.enchant(ItemStackUtils.getItem(Material.BOW, 1, 0, "", new String[0]), Enchantment.ARROW_DAMAGE, 1));
                    skeleton.getEquipment().setHelmet(ItemStackUtils.getTexturedItem(1, "", "eyJ0aW1lc3RhbXAiOjE0OTk3MTAzMzMxMjksInByb2ZpbGVJZCI6ImY1ZjIwOTk3MjE3ZjQ0MjY4YWI5YzZkYjZjY2UwMjNmIiwicHJvZmlsZU5hbWUiOiJNSEZfVmV4Iiwic2lnbmF0dXJlUmVxdWlyZWQiOnRydWUsInRleHR1cmVzIjp7IlNLSU4iOnsidXJsIjoiaHR0cDovL3RleHR1cmVzLm1pbmVjcmFmdC5uZXQvdGV4dHVyZS9mMjZiOWIxMWRjOTEzODllYjlhNWY4NDk3OGI1ZjU3MzBkMThjYTM2ZWYxNzFiN2MyOGQzY2Y0Yjk5MjQzIn19fQ=="));
                    skeleton.getEquipment().setChestplate(ItemStackUtils.colorize(ItemStackUtils.getItem(Material.LEATHER_CHESTPLATE, 1, 0, "", new String[0]), Color.SILVER));
                    skeleton.getEquipment().setBoots(ItemStackUtils.colorize(ItemStackUtils.getItem(Material.LEATHER_LEGGINGS, 1, 0, "", new String[0]), Color.SILVER));
                    skeleton.getEquipment().setBoots(ItemStackUtils.colorize(ItemStackUtils.getItem(Material.LEATHER_BOOTS, 1, 0, "", new String[0]), Color.SILVER));
                    skeleton.setMetadata("Arena", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)this.getName()));
                    skeleton.setMetadata("Zombies", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)this.fileConfiguration.getDouble("Gold.Skeleton")));
                    skeleton.setMetadata("ZombieName", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)Configuration.translateTextCodes(this.fileConfiguration.getString("Name.Skeleton"))));
                    Player player = EntityUtils.getNearbyPlayer((Entity)skeleton);
                    skeleton.setTarget((LivingEntity)player);
                    if (this.isEndlessMode() && this.round >= this.fileConfiguration.getInt("Rounds")) {
                        EntityUtils.walk(this.arena, (Entity)skeleton, player, this.fileConfiguration.getDouble("EMode.Speed.Skeleton"));
                    } else {
                        EntityUtils.walk(this.arena, (Entity)skeleton, player, this.fileConfiguration.getDouble("Round." + this.getRound() + ".Speed.Skeleton"));
                    }
                    EntityUtils.teleport((Entity)skeleton, location);
                    --this.skeletons;
                    break;
                }
                case 14: {
                    Endermite endermite = (Endermite)location.getWorld().spawn(location, Endermite.class);
                    endermite.setPersistent(true);
                    double d = this.fileConfiguration.getDouble("Health.Endermite");
                    if (d <= 0.0) {
                        d = 8.0;
                    }
                    endermite.setMaxHealth(d);
                    endermite.setHealth(d);
                    endermite.getEquipment().clear();
                    endermite.setRemoveWhenFarAway(false);
                    endermite.setMetadata("Arena", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)this.getName()));
                    endermite.setMetadata("Zombies", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)this.fileConfiguration.getDouble("Gold.Endermite")));
                    endermite.setMetadata("ZombieName", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)Configuration.translateTextCodes(this.fileConfiguration.getString("Name.Endermite"))));
                    Player player = EntityUtils.getNearbyPlayer((Entity)endermite);
                    endermite.setTarget((LivingEntity)player);
                    if (this.isEndlessMode() && this.round >= this.fileConfiguration.getInt("Rounds")) {
                        EntityUtils.walk(this.arena, (Entity)endermite, player, this.fileConfiguration.getDouble("EMode.Speed.Endermite"));
                    } else {
                        EntityUtils.walk(this.arena, (Entity)endermite, player, this.fileConfiguration.getDouble("Round." + this.getRound() + ".Speed.Endermite"));
                    }
                    EntityUtils.teleport((Entity)endermite, location);
                    --this.endermites;
                    break;
                }
                case 15: {
                    Blaze blaze = (Blaze)location.getWorld().spawn(location, Blaze.class);
                    blaze.setPersistent(true);
                    double d = this.fileConfiguration.getDouble("Health.Blaze");
                    if (d <= 0.0) {
                        d = 20.0;
                    }
                    blaze.setMaxHealth(d);
                    blaze.setHealth(d);
                    blaze.setRemoveWhenFarAway(false);
                    blaze.setMetadata("Arena", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)this.getName()));
                    blaze.setMetadata("Zombies", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)this.fileConfiguration.getDouble("Gold.Blaze")));
                    blaze.setMetadata("ZombieName", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)Configuration.translateTextCodes(this.fileConfiguration.getString("Name.Blaze"))));
                    Player player = EntityUtils.getNearbyPlayer((Entity)blaze);
                    blaze.setTarget((LivingEntity)player);
                    if (this.isEndlessMode() && this.round >= this.fileConfiguration.getInt("Rounds")) {
                        EntityUtils.walk(this.arena, (Entity)blaze, player, this.fileConfiguration.getDouble("EMode.Speed.Blaze"));
                    } else {
                        EntityUtils.walk(this.arena, (Entity)blaze, player, this.fileConfiguration.getDouble("Round." + this.getRound() + ".Speed.Blaze"));
                    }
                    EntityUtils.teleport((Entity)blaze, location);
                    --this.blazes;
                    break;
                }
                case 16: {
                    Zombie zombie = (Zombie)location.getWorld().spawn(location, Zombie.class);
                    zombie.setPersistent(true);
                    zombie.setBaby(false);
                    double d = this.fileConfiguration.getDouble("Health.Soldier");
                    if (d <= 0.0) {
                        d = 20.0;
                    }
                    zombie.setMaxHealth(d);
                    zombie.setHealth(d);
                    zombie.setRemoveWhenFarAway(false);
                    zombie.getEquipment().setItemInHand(ItemStackUtils.enchant(ItemStackUtils.getItem(Material.IRON_AXE, 1, 0, "", new String[0]), Enchantment.DAMAGE_ALL, 3));
                    zombie.getEquipment().setHelmet(ItemStackUtils.getTexturedItem(1, "", "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvM2FiNTZkNWZjZGUzZWJmMjg1YWQ5OTk3ZmY4OWEwYzhjYjU3MWU2ZjQxODI5YWUzODczYjVkNTIzOWM2MGM0NiJ9fX0="));
                    zombie.getEquipment().setChestplate(ItemStackUtils.enchant(ItemStackUtils.colorize(ItemStackUtils.getItem(Material.LEATHER_CHESTPLATE, 1, 0, "", new String[0]), Color.fromRGB((int)104, (int)44, (int)25)), Enchantment.PROTECTION_ENVIRONMENTAL, 3));
                    zombie.getEquipment().setLeggings(ItemStackUtils.enchant(ItemStackUtils.colorize(ItemStackUtils.getItem(Material.LEATHER_LEGGINGS, 1, 0, "", new String[0]), Color.fromRGB((int)104, (int)44, (int)25)), Enchantment.PROTECTION_ENVIRONMENTAL, 3));
                    zombie.getEquipment().setBoots(ItemStackUtils.enchant(ItemStackUtils.colorize(ItemStackUtils.getItem(Material.LEATHER_BOOTS, 1, 0, "", new String[0]), Color.fromRGB((int)104, (int)44, (int)25)), Enchantment.PROTECTION_ENVIRONMENTAL, 3));
                    zombie.setMetadata("Arena", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)this.getName()));
                    zombie.setMetadata("Zombies", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)this.fileConfiguration.getDouble("Gold.Soldier")));
                    zombie.setMetadata("ZombieName", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)Configuration.translateTextCodes(this.fileConfiguration.getString("Name.Soldier"))));
                    Player player = EntityUtils.getNearbyPlayer((Entity)zombie);
                    zombie.setTarget((LivingEntity)player);
                    if (this.isEndlessMode() && this.round >= this.fileConfiguration.getInt("Rounds")) {
                        EntityUtils.walk(this.arena, (Entity)zombie, player, this.fileConfiguration.getDouble("EMode.Speed.Soldier"));
                    } else {
                        EntityUtils.walk(this.arena, (Entity)zombie, player, this.fileConfiguration.getDouble("Round." + this.getRound() + ".Speed.Soldier"));
                    }
                    EntityUtils.teleport((Entity)zombie, location);
                    --this.soldiers;
                    break;
                }
                case 17: {
                    Witch witch = (Witch)location.getWorld().spawn(location, Witch.class);
                    witch.setPersistent(true);
                    double d = this.fileConfiguration.getDouble("Health.Witch");
                    if (d <= 0.0) {
                        d = 26.0;
                    }
                    witch.setMaxHealth(d);
                    witch.setHealth(d);
                    witch.setRemoveWhenFarAway(false);
                    witch.setMetadata("Arena", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)this.getName()));
                    witch.setMetadata("Zombies", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)this.fileConfiguration.getDouble("Gold.Witch")));
                    witch.setMetadata("ZombieName", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)Configuration.translateTextCodes(this.fileConfiguration.getString("Name.Witch"))));
                    Player player = EntityUtils.getNearbyPlayer((Entity)witch);
                    witch.setTarget((LivingEntity)player);
                    if (this.isEndlessMode() && this.round >= this.fileConfiguration.getInt("Rounds")) {
                        EntityUtils.walk(this.arena, (Entity)witch, player, this.fileConfiguration.getDouble("EMode.Speed.Witch"));
                    } else {
                        EntityUtils.walk(this.arena, (Entity)witch, player, this.fileConfiguration.getDouble("Round." + this.getRound() + ".Speed.Witch"));
                    }
                    EntityUtils.teleport((Entity)witch, location);
                    --this.witches;
                    break;
                }
                case 18: {
                    CaveSpider caveSpider = (CaveSpider)location.getWorld().spawn(location, CaveSpider.class);
                    caveSpider.setPersistent(true);
                    double d = this.fileConfiguration.getDouble("Health.CaveSpider");
                    if (d <= 0.0) {
                        d = 12.0;
                    }
                    caveSpider.setMaxHealth(d);
                    caveSpider.setHealth(d);
                    caveSpider.setPassenger(null);
                    caveSpider.setRemoveWhenFarAway(false);
                    caveSpider.setMetadata("Arena", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)this.getName()));
                    caveSpider.setMetadata("Zombies", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)this.fileConfiguration.getDouble("Gold.CaveSpider")));
                    caveSpider.setMetadata("ZombieName", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)Configuration.translateTextCodes(this.fileConfiguration.getString("Name.CaveSpider"))));
                    Player player = EntityUtils.getNearbyPlayer((Entity)caveSpider);
                    caveSpider.setTarget((LivingEntity)player);
                    if (this.isEndlessMode() && this.round >= this.fileConfiguration.getInt("Rounds")) {
                        EntityUtils.walk(this.arena, (Entity)caveSpider, player, this.fileConfiguration.getDouble("EMode.Speed.CaveSpider"));
                    } else {
                        EntityUtils.walk(this.arena, (Entity)caveSpider, player, this.fileConfiguration.getDouble("Round." + this.getRound() + ".Speed.CaveSpider"));
                    }
                    EntityUtils.teleport((Entity)caveSpider, location);
                    --this.caveSpiders;
                    break;
                }
                case 19: {
                    Spider spider = (Spider)location.getWorld().spawn(location, Spider.class);
                    spider.setPersistent(true);
                    double d = this.fileConfiguration.getDouble("Health.Spider");
                    if (d <= 0.0) {
                        d = 16.0;
                    }
                    spider.setMaxHealth(d);
                    spider.setHealth(d);
                    spider.setRemoveWhenFarAway(false);
                    spider.setMetadata("Arena", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)this.getName()));
                    spider.setMetadata("Zombies", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)this.fileConfiguration.getDouble("Gold.Spider")));
                    spider.setMetadata("ZombieName", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)Configuration.translateTextCodes(this.fileConfiguration.getString("Name.Spider"))));
                    Player player = EntityUtils.getNearbyPlayer((Entity)spider);
                    spider.setTarget((LivingEntity)player);
                    if (this.isEndlessMode() && this.round >= this.fileConfiguration.getInt("Rounds")) {
                        EntityUtils.walk(this.arena, (Entity)spider, player, this.fileConfiguration.getDouble("EMode.Speed.Spider"));
                    } else {
                        EntityUtils.walk(this.arena, (Entity)spider, player, this.fileConfiguration.getDouble("Round." + this.getRound() + ".Speed.Spider"));
                    }
                    EntityUtils.teleport((Entity)spider, location);
                    --this.spiders;
                    break;
                }
                case 20: {
                    Zombie zombie = (Zombie)location.getWorld().spawn(location, Zombie.class);
                    zombie.setPersistent(true);
                    double d = this.fileConfiguration.getDouble("Health.WitherZombie");
                    if (d <= 0.0) {
                        d = 20.0;
                    }
                    zombie.setMaxHealth(d);
                    zombie.setHealth(d);
                    zombie.setRemoveWhenFarAway(false);
                    zombie.setMetadata("Arena", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)this.getName()));
                    zombie.setMetadata("Zombies", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)this.fileConfiguration.getDouble("Gold.WitherZombie")));
                    zombie.setMetadata("ZombieName", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)Configuration.translateTextCodes(this.fileConfiguration.getString("Name.WitherZombie"))));
                    zombie.getEquipment().setItemInHand(ItemStackUtils.getItem(Material.DIAMOND_SWORD, 1, 0, "", new String[0]));
                    zombie.getEquipment().setHelmet(ItemStackUtils.getTexturedItem(1, "", "eyJ0aW1lc3RhbXAiOjE1MDg2MjEwMDQ5MzcsInByb2ZpbGVJZCI6IjM5YWY2ODQ0NjgwOTRkMmY4YmE0N2U5MmQwODdiZTE4IiwicHJvZmlsZU5hbWUiOiJNSEZfV2l0aGVyIiwic2lnbmF0dXJlUmVxdWlyZWQiOnRydWUsInRleHR1cmVzIjp7IlNLSU4iOnsidXJsIjoiaHR0cDovL3RleHR1cmVzLm1pbmVjcmFmdC5uZXQvdGV4dHVyZS9jZGY3NGUzMjNlZDQxNDM2OTY1ZjVjNTdkZGYyODE1ZDUzMzJmZTk5OWU2OGZiYjlkNmNmNWM4YmQ0MTM5ZiJ9fX0="));
                    zombie.getEquipment().setChestplate(ItemStackUtils.colorize(ItemStackUtils.getItem(Material.LEATHER_CHESTPLATE, 1, 0, "", new String[0]), Color.BLACK));
                    zombie.getEquipment().setLeggings(ItemStackUtils.colorize(ItemStackUtils.getItem(Material.LEATHER_LEGGINGS, 1, 0, "", new String[0]), Color.BLACK));
                    zombie.getEquipment().setBoots(ItemStackUtils.colorize(ItemStackUtils.getItem(Material.LEATHER_BOOTS, 1, 0, "", new String[0]), Color.BLACK));
                    Player player = EntityUtils.getNearbyPlayer((Entity)zombie);
                    zombie.setTarget((LivingEntity)player);
                    if (this.isEndlessMode() && this.round >= this.fileConfiguration.getInt("Rounds")) {
                        EntityUtils.walk(this.arena, (Entity)zombie, player, this.fileConfiguration.getDouble("EMode.Speed.WitherZombie"));
                    } else {
                        EntityUtils.walk(this.arena, (Entity)zombie, player, this.fileConfiguration.getDouble("Round." + this.getRound() + ".Speed.WitherZombie"));
                    }
                    EntityUtils.teleport((Entity)zombie, location);
                    --this.witherZombies;
                    break;
                }
                case 21: {
                    Zombie zombie = (Zombie)location.getWorld().spawn(location, Zombie.class);
                    zombie.setPersistent(true);
                    double d = this.fileConfiguration.getDouble("Health.SlimeZombie");
                    if (d <= 0.0) {
                        d = 20.0;
                    }
                    zombie.setMaxHealth(d);
                    zombie.setHealth(d);
                    zombie.setBaby(false);
                    zombie.setRemoveWhenFarAway(false);
                    zombie.setMetadata("Arena", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)this.getName()));
                    zombie.setMetadata("Zombies", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)this.fileConfiguration.getDouble("Gold.SlimeZombie")));
                    zombie.setMetadata("ZombieName", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)Configuration.translateTextCodes(this.fileConfiguration.getString("Name.SlimeZombie"))));
                    zombie.getEquipment().setItemInHand(ItemStackUtils.enchant(ItemStackUtils.getItem(Material.SLIME_BALL, 1, 0, "", new String[0]), Enchantment.DAMAGE_ALL, 2));
                    zombie.getEquipment().setHelmet(ItemStackUtils.getTexturedItem(1, "", "eyJ0aW1lc3RhbXAiOjE1MDg2MjA3MDk5NTMsInByb2ZpbGVJZCI6Ijg3MGFiYTkzNDBlODQ4YjM4OWM1MzJlY2UwMGQ2NjMwIiwicHJvZmlsZU5hbWUiOiJNSEZfU2xpbWUiLCJzaWduYXR1cmVSZXF1aXJlZCI6dHJ1ZSwidGV4dHVyZXMiOnsiU0tJTiI6eyJ1cmwiOiJodHRwOi8vdGV4dHVyZXMubWluZWNyYWZ0Lm5ldC90ZXh0dXJlL2IwY2MzNTk3ZjI1ZDYyYjdmNTc0OGNlYzIyZTJmYmVkMjM2MDQwZjFjMjcwNDdhZmVhMWY1MGY3NjhhOCJ9fX0="));
                    zombie.getEquipment().setChestplate(ItemStackUtils.colorize(ItemStackUtils.getItem(Material.LEATHER_CHESTPLATE, 1, 0, "", new String[0]), Color.GREEN));
                    zombie.getEquipment().setLeggings(ItemStackUtils.colorize(ItemStackUtils.getItem(Material.LEATHER_LEGGINGS, 1, 0, "", new String[0]), Color.GREEN));
                    zombie.getEquipment().setBoots(ItemStackUtils.colorize(ItemStackUtils.getItem(Material.LEATHER_BOOTS, 1, 0, "", new String[0]), Color.GREEN));
                    Player player = EntityUtils.getNearbyPlayer((Entity)zombie);
                    zombie.setTarget((LivingEntity)player);
                    if (this.isEndlessMode() && this.round >= this.fileConfiguration.getInt("Rounds")) {
                        EntityUtils.walk(this.arena, (Entity)zombie, player, this.fileConfiguration.getDouble("EMode.Speed.SlimeZombie"));
                    } else {
                        EntityUtils.walk(this.arena, (Entity)zombie, player, this.fileConfiguration.getDouble("Round." + this.getRound() + ".Speed.SlimeZombie"));
                    }
                    EntityUtils.teleport((Entity)zombie, location);
                    --this.slimeZombies;
                    break;
                }
                case 22: {
                    Zombie zombie = (Zombie)location.getWorld().spawn(location, Zombie.class);
                    zombie.setPersistent(true);
                    double d = this.fileConfiguration.getDouble("Health.SantaHelperZombie");
                    if (d <= 0.0) {
                        d = 20.0;
                    }
                    zombie.setMaxHealth(d);
                    zombie.setHealth(d);
                    zombie.setBaby(true);
                    zombie.setRemoveWhenFarAway(false);
                    zombie.setMetadata("Arena", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)this.getName()));
                    zombie.setMetadata("Zombies", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)this.fileConfiguration.getDouble("Gold.SantaHelperZombie")));
                    zombie.setMetadata("ZombieName", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)Configuration.translateTextCodes(this.fileConfiguration.getString("Name.SantaHelperZombie"))));
                    zombie.getEquipment().setItemInHand(ItemStackUtils.enchant(ItemStackUtils.getTexturedItem(1, "", "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMmM2YWY2YWQxOGUxM2YyNWE1Yjc0NDcyNTJiNWU5YWI4MTgwYzA1ZGU1OTg1ZmJhZjdiNGZjNGUxZDI0MTY2In19fQ=="), Enchantment.DAMAGE_ALL, 3));
                    zombie.getEquipment().setHelmet(ItemStackUtils.getTexturedItem(1, "", ThreadLocalRandom.current().nextBoolean() ? "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNzBmYjg4MGI5YjM3OGVhMzU5MGJlNWY3ZDJkYzQ1NzI0ZDJhZjlkN2NkYmI3ZTM3MDNjYjQzZjg4ZjYzZmIifX19" : "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYjI3Yjc5NjBmY2Q1MjUxOGFlMjNlMmRhOGE2YzZmMjI1NTBlNWUzMzFiOTYzZmMzNTEzNjU2ODc2ZjNmNmVhIn19fQ=="));
                    zombie.getEquipment().setChestplate(ItemStackUtils.colorize(ItemStackUtils.getItem(Material.LEATHER_CHESTPLATE, 1, 0, "", new String[0]), Color.fromRGB((int)55, (int)147, (int)68)));
                    zombie.getEquipment().setLeggings(ItemStackUtils.colorize(ItemStackUtils.getItem(Material.LEATHER_LEGGINGS, 1, 0, "", new String[0]), Color.fromRGB((int)55, (int)147, (int)68)));
                    zombie.getEquipment().setBoots(ItemStackUtils.colorize(ItemStackUtils.getItem(Material.LEATHER_BOOTS, 1, 0, "", new String[0]), Color.fromRGB((int)82, (int)24, (int)27)));
                    Player player = EntityUtils.getNearbyPlayer((Entity)zombie);
                    zombie.setTarget((LivingEntity)player);
                    if (this.isEndlessMode() && this.round >= this.fileConfiguration.getInt("Rounds")) {
                        EntityUtils.walk(this.arena, (Entity)zombie, player, this.fileConfiguration.getDouble("EMode.Speed.SantaHelperZombie"));
                    } else {
                        EntityUtils.walk(this.arena, (Entity)zombie, player, this.fileConfiguration.getDouble("Round." + this.getRound() + ".Speed.SantaHelperZombie"));
                    }
                    EntityUtils.teleport((Entity)zombie, location);
                    --this.santaHelperZombies;
                    break;
                }
                case 23: {
                    Zombie zombie = (Zombie)location.getWorld().spawn(location, Zombie.class);
                    zombie.setPersistent(true);
                    double d = this.fileConfiguration.getDouble("Health.EasterBunnyZombie");
                    if (d <= 0.0) {
                        d = 20.0;
                    }
                    zombie.setMaxHealth(d);
                    zombie.setHealth(d);
                    zombie.setBaby(false);
                    zombie.setRemoveWhenFarAway(false);
                    zombie.addPotionEffect(new PotionEffect(PotionEffectType.JUMP, Integer.MAX_VALUE, 1, true, false));
                    zombie.setMetadata("Arena", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)this.getName()));
                    zombie.setMetadata("Zombies", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)this.fileConfiguration.getDouble("Gold.EasterBunnyZombie")));
                    zombie.setMetadata("ZombieName", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)Configuration.translateTextCodes(this.fileConfiguration.getString("Name.EasterBunnyZombie"))));
                    zombie.getEquipment().setItemInHand(ItemStackUtils.enchant(ItemStackUtils.getTexturedItem(1, "", ThreadLocalRandom.current().nextBoolean() ? "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYzQ3Mzc1YzBhYzNlMjdhZGUyMTkzMDJhZGExODhkZDgzOTkyMTUxYTJhYzhhNGY0OWVlZjQxODk1YWQzNzU2In19fQ==" : "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZjUwOTM3YjIxNTlmMGNlZWU0ZmFjZGQ0YWJmMzU4M2FjNTVkMjQ4NGNkMjUzNDc2MjE1MzU0ZDNkN2ZlNDUifX19"), Enchantment.DAMAGE_ALL, 3));
                    zombie.getEquipment().setHelmet(ItemStackUtils.getTexturedItem(1, "", "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvY2Q0ZmRhZDVhNjEwNGFhNTQ5ZDFlNzZkNzNhM2M2ZmUzYzY3MjRiZjA5ZjdmZmNjMDJmMzNmOWVkZTdmYWRlIn19fQ=="));
                    zombie.getEquipment().setChestplate(ItemStackUtils.colorize(ItemStackUtils.getItem(Material.LEATHER_CHESTPLATE, 1, 0, "", new String[0]), Color.fromRGB((int)190, (int)190, (int)190)));
                    zombie.getEquipment().setLeggings(ItemStackUtils.colorize(ItemStackUtils.getItem(Material.LEATHER_LEGGINGS, 1, 0, "", new String[0]), Color.fromRGB((int)190, (int)190, (int)190)));
                    zombie.getEquipment().setBoots(ItemStackUtils.colorize(ItemStackUtils.getItem(Material.LEATHER_BOOTS, 1, 0, "", new String[0]), Color.fromRGB((int)190, (int)190, (int)190)));
                    Player player = EntityUtils.getNearbyPlayer((Entity)zombie);
                    zombie.setTarget((LivingEntity)player);
                    if (this.isEndlessMode() && this.round >= this.fileConfiguration.getInt("Rounds")) {
                        EntityUtils.walk(this.arena, (Entity)zombie, player, this.fileConfiguration.getDouble("EMode.Speed.EasterBunnyZombie"));
                    } else {
                        EntityUtils.walk(this.arena, (Entity)zombie, player, this.fileConfiguration.getDouble("Round." + this.getRound() + ".Speed.EasterBunnyZombie"));
                    }
                    EntityUtils.teleport((Entity)zombie, location);
                    --this.easterBunnyZombies;
                    break;
                }
                case 24: {
                    Zombie zombie = (Zombie)location.getWorld().spawn(location, Zombie.class);
                    zombie.setPersistent(true);
                    double d = this.fileConfiguration.getDouble("Health.Mosquito");
                    if (d <= 0.0) {
                        d = 20.0;
                    }
                    zombie.setMaxHealth(d);
                    zombie.setHealth(d);
                    zombie.setBaby(true);
                    zombie.setRemoveWhenFarAway(false);
                    zombie.setMetadata("Arena", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)this.getName()));
                    zombie.setMetadata("Zombies", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)this.fileConfiguration.getDouble("Gold.Mosquito")));
                    zombie.setMetadata("ZombieName", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)Configuration.translateTextCodes(this.fileConfiguration.getString("Name.Mosquito"))));
                    zombie.getEquipment().setItemInHand(ItemStackUtils.enchant(ItemStackUtils.getItem(Material.ARROW, 1, 0, "Thorn", new String[0]), Enchantment.DAMAGE_ALL, 3));
                    zombie.getEquipment().setHelmet(ItemStackUtils.getTexturedItem(1, "", "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZTMwYWMxZjljNjQ5Yzk5Y2Q2MGU0YmZhNTMzNmNjMTg1MGYyNzNlYWI5ZjViMGI3OTQwZDRkNGQ3ZGM4MjVkYyJ9fX0="));
                    zombie.getEquipment().setChestplate(ItemStackUtils.colorize(ItemStackUtils.getItem(Material.LEATHER_CHESTPLATE, 1, 0, "", new String[0]), Color.fromRGB((int)102, (int)87, (int)68)));
                    zombie.getEquipment().setLeggings(ItemStackUtils.colorize(ItemStackUtils.getItem(Material.LEATHER_LEGGINGS, 1, 0, "", new String[0]), Color.fromRGB((int)88, (int)77, (int)63)));
                    zombie.getEquipment().setBoots(ItemStackUtils.colorize(ItemStackUtils.getItem(Material.LEATHER_BOOTS, 1, 0, "", new String[0]), Color.fromRGB((int)60, (int)53, (int)44)));
                    Player player = EntityUtils.getNearbyPlayer((Entity)zombie);
                    zombie.setTarget((LivingEntity)player);
                    if (this.isEndlessMode() && this.round >= this.fileConfiguration.getInt("Rounds")) {
                        EntityUtils.walk(this.arena, (Entity)zombie, player, this.fileConfiguration.getDouble("EMode.Speed.Mosquito"));
                    } else {
                        EntityUtils.walk(this.arena, (Entity)zombie, player, this.fileConfiguration.getDouble("Round." + this.getRound() + ".Speed.Mosquito"));
                    }
                    EntityUtils.teleport((Entity)zombie, location);
                    --this.mosquitos;
                    break;
                }
                case 25: {
                    Zombie zombie = (Zombie)location.getWorld().spawn(location, Zombie.class);
                    zombie.setPersistent(true);
                    double d = this.fileConfiguration.getDouble("Health.Clown");
                    if (d <= 0.0) {
                        d = 20.0;
                    }
                    zombie.setMaxHealth(d);
                    zombie.setHealth(d);
                    zombie.setBaby(false);
                    zombie.setRemoveWhenFarAway(false);
                    zombie.setMetadata("Arena", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)this.getName()));
                    zombie.setMetadata("Zombies", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)this.fileConfiguration.getDouble("Gold.Clown")));
                    zombie.setMetadata("ZombieName", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)Configuration.translateTextCodes(this.fileConfiguration.getString("Name.Clown"))));
                    zombie.getEquipment().setItemInHand(ItemStackUtils.enchant(ItemStackUtils.getItem(Material.STICK, 1, 0, "Mic", new String[0]), Enchantment.DAMAGE_ALL, 3));
                    zombie.getEquipment().setHelmet(ItemStackUtils.getTexturedItem(1, "", "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZTcyMjU5N2E5ODllODFlY2U3ODZkZDU4Zjk0NTU0ZjI5OGQ5ZTAzM2MwZWE5YzVmNDMyMjAxOTM4Y2ZjOTJjIn19fQ=="));
                    zombie.getEquipment().setChestplate(ItemStackUtils.colorize(ItemStackUtils.getItem(Material.LEATHER_CHESTPLATE, 1, 0, "", new String[0]), Color.fromRGB((int)211, (int)0, (int)241)));
                    zombie.getEquipment().setLeggings(ItemStackUtils.colorize(ItemStackUtils.getItem(Material.LEATHER_LEGGINGS, 1, 0, "", new String[0]), Color.fromRGB((int)3, (int)199, (int)114)));
                    zombie.getEquipment().setBoots(ItemStackUtils.colorize(ItemStackUtils.getItem(Material.LEATHER_BOOTS, 1, 0, "", new String[0]), Color.fromRGB((int)185, (int)12, (int)29)));
                    Player player = EntityUtils.getNearbyPlayer((Entity)zombie);
                    zombie.setTarget((LivingEntity)player);
                    if (this.isEndlessMode() && this.round >= this.fileConfiguration.getInt("Rounds")) {
                        EntityUtils.walk(this.arena, (Entity)zombie, player, this.fileConfiguration.getDouble("EMode.Speed.Clown"));
                    } else {
                        EntityUtils.walk(this.arena, (Entity)zombie, player, this.fileConfiguration.getDouble("Round." + this.getRound() + ".Speed.Clown"));
                    }
                    EntityUtils.teleport((Entity)zombie, location);
                    --this.clowns;
                    break;
                }
                case 26: {
                    Zombie zombie = (Zombie)location.getWorld().spawn(location, Zombie.class);
                    zombie.setPersistent(true);
                    double d = this.fileConfiguration.getDouble("Health.Penguin");
                    if (d <= 0.0) {
                        d = 20.0;
                    }
                    zombie.setMaxHealth(d);
                    zombie.setHealth(d);
                    zombie.setBaby(false);
                    zombie.setRemoveWhenFarAway(false);
                    zombie.setMetadata("Arena", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)this.getName()));
                    zombie.setMetadata("Zombies", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)this.fileConfiguration.getDouble("Gold.Penguin")));
                    zombie.setMetadata("ZombieName", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)Configuration.translateTextCodes(this.fileConfiguration.getString("Name.Penguin"))));
                    zombie.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, Integer.MAX_VALUE, 2));
                    zombie.getEquipment().setItemInHand(ItemStackUtils.enchant(ItemStackUtils.getItem(Material.valueOf((String)(versionId < 13 ? "SNOW_BALL" : "SNOWBALL")), 1, 0, "Snowball", new String[0]), Enchantment.KNOCKBACK, 1));
                    zombie.getEquipment().setHelmet(ItemStackUtils.getTexturedItem(1, "", "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvOGE1YTdlZjBmOWQ4ODZmNzQ2ODA4NmU0N2I4OTM5Y2ZkMWE5MTEwZDFmOTk0NjZjYjhlYTMzY2ViZjhhYTg2In19fQ=="));
                    zombie.getEquipment().setChestplate(ItemStackUtils.colorize(ItemStackUtils.getItem(Material.LEATHER_CHESTPLATE, 1, 0, "", new String[0]), Color.fromRGB((int)19, (int)21, (int)16)));
                    zombie.getEquipment().setLeggings(ItemStackUtils.colorize(ItemStackUtils.getItem(Material.LEATHER_LEGGINGS, 1, 0, "", new String[0]), Color.fromRGB((int)19, (int)21, (int)16)));
                    zombie.getEquipment().setBoots(ItemStackUtils.colorize(ItemStackUtils.getItem(Material.LEATHER_BOOTS, 1, 0, "", new String[0]), Color.fromRGB((int)198, (int)93, (int)0)));
                    Player player = EntityUtils.getNearbyPlayer((Entity)zombie);
                    zombie.setTarget((LivingEntity)player);
                    if (this.isEndlessMode() && this.round >= this.fileConfiguration.getInt("Rounds")) {
                        EntityUtils.walk(this.arena, (Entity)zombie, player, this.fileConfiguration.getDouble("EMode.Speed.Penguin"));
                    } else {
                        EntityUtils.walk(this.arena, (Entity)zombie, player, this.fileConfiguration.getDouble("Round." + this.getRound() + ".Speed.Penguin"));
                    }
                    EntityUtils.teleport((Entity)zombie, location);
                    --this.penguins;
                    break;
                }
                case 27: {
                    Zombie zombie = (Zombie)location.getWorld().spawn(location, Zombie.class);
                    zombie.setPersistent(true);
                    double d = this.fileConfiguration.getDouble("Health.EnderZombie");
                    if (d <= 0.0) {
                        d = 20.0;
                    }
                    zombie.setMaxHealth(d);
                    zombie.setHealth(d);
                    zombie.setBaby(false);
                    zombie.setRemoveWhenFarAway(false);
                    zombie.setMetadata("Arena", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)this.getName()));
                    zombie.setMetadata("Zombies", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)this.fileConfiguration.getDouble("Gold.EnderZombie")));
                    zombie.setMetadata("ZombieName", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)Configuration.translateTextCodes(this.fileConfiguration.getString("Name.EnderZombie"))));
                    zombie.getEquipment().setItemInHand(ItemStackUtils.enchant(ItemStackUtils.getItem(Material.SOUL_SAND, 1, 0, "Soul Sand", new String[0]), Enchantment.DAMAGE_ALL, 1));
                    zombie.getEquipment().setHelmet(ItemStackUtils.getTexturedItem(1, "", "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvN2E1OWJiMGE3YTMyOTY1YjNkOTBkOGVhZmE4OTlkMTgzNWY0MjQ1MDllYWRkNGU2YjcwOWFkYTUwYjljZiJ9fX0="));
                    zombie.getEquipment().setChestplate(ItemStackUtils.colorize(ItemStackUtils.getItem(Material.LEATHER_CHESTPLATE, 1, 0, "", new String[0]), Color.fromRGB((int)28, (int)0, (int)47)));
                    zombie.getEquipment().setLeggings(ItemStackUtils.colorize(ItemStackUtils.getItem(Material.LEATHER_LEGGINGS, 1, 0, "", new String[0]), Color.fromRGB((int)28, (int)0, (int)47)));
                    zombie.getEquipment().setBoots(ItemStackUtils.colorize(ItemStackUtils.getItem(Material.LEATHER_BOOTS, 1, 0, "", new String[0]), Color.fromRGB((int)28, (int)0, (int)47)));
                    Player player = EntityUtils.getNearbyPlayer((Entity)zombie);
                    zombie.setTarget((LivingEntity)player);
                    if (this.isEndlessMode() && this.round >= this.fileConfiguration.getInt("Rounds")) {
                        EntityUtils.walk(this.arena, (Entity)zombie, player, this.fileConfiguration.getDouble("EMode.Speed.EnderZombie"));
                    } else {
                        EntityUtils.walk(this.arena, (Entity)zombie, player, this.fileConfiguration.getDouble("Round." + this.getRound() + ".Speed.EnderZombie"));
                    }
                    EntityUtils.teleport((Entity)zombie, location);
                    EntityUtils.spawnEndermites(this.arena, (Entity)zombie);
                    --this.enderZombies;
                    break;
                }
                case 28: {
                    Location location2 = location;
                    if (hashMap.containsKey((Object)ZombieType.INFERNO)) {
                        location2 = (Location)((List)hashMap.get((Object)ZombieType.INFERNO)).get(ThreadLocalRandom.current().nextInt(((List)hashMap.get((Object)ZombieType.INFERNO)).size()));
                    } else if (!arrayList2.isEmpty()) {
                        location2 = (Location)arrayList2.get(ThreadLocalRandom.current().nextInt(arrayList2.size()));
                    }
                    location2.getWorld().strikeLightningEffect(location2);
                    Zombie zombie = (Zombie)location2.getWorld().spawn(location2, Zombie.class);
                    zombie.setPersistent(true);
                    zombie.getEquipment().clear();
                    zombie.setBaby(false);
                    zombie.setRemoveWhenFarAway(false);
                    zombie.getEquipment().setItemInHand(ItemStackUtils.getItem(versionId >= 13 ? Material.GOLDEN_SWORD : Material.getMaterial((String)"GOLD_SWORD"), 1, 0, "", new String[0]));
                    zombie.getEquipment().setHelmet(ItemStackUtils.getTexturedItem(1, "", "eyJ0aW1lc3RhbXAiOjE0OTk3MTAzNjk1MTEsInByb2ZpbGVJZCI6IjRjMzhlZDExNTk2YTRmZDRhYjFkMjZmMzg2YzFjYmFjIiwicHJvZmlsZU5hbWUiOiJNSEZfQmxhemUiLCJzaWduYXR1cmVSZXF1aXJlZCI6dHJ1ZSwidGV4dHVyZXMiOnsiU0tJTiI6eyJ1cmwiOiJodHRwOi8vdGV4dHVyZXMubWluZWNyYWZ0Lm5ldC90ZXh0dXJlL2I3OGVmMmU0Y2YyYzQxYTJkMTRiZmRlOWNhZmYxMDIxOWY1YjFiZjViMzVhNDllYjUxYzY0Njc4ODJjYjVmMCJ9fX0="));
                    zombie.getEquipment().setChestplate(ItemStackUtils.colorize(ItemStackUtils.getItem(Material.LEATHER_CHESTPLATE, 1, 0, "", new String[0]), Color.YELLOW));
                    zombie.getEquipment().setLeggings(ItemStackUtils.colorize(ItemStackUtils.getItem(Material.LEATHER_LEGGINGS, 1, 0, "", new String[0]), Color.RED));
                    zombie.getEquipment().setBoots(ItemStackUtils.colorize(ItemStackUtils.getItem(Material.LEATHER_BOOTS, 1, 0, "", new String[0]), Color.RED));
                    zombie.setMetadata("Arena", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)this.getName()));
                    zombie.setMetadata("Zombies", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)this.fileConfiguration.getDouble("Gold.Inferno")));
                    zombie.setMetadata("Inferno", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)Main.getInstance().getConfiguration().getMessage("InfernoName")));
                    zombie.setMetadata("ZombieName", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)Configuration.translateTextCodes(this.fileConfiguration.getString("Name.Inferno"))));
                    zombie.setMetadata("FireResistant", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)""));
                    zombie.setMetadata("BossHealth", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)this.fileConfiguration.getDouble("Health.Inferno")));
                    Player player = EntityUtils.getNearbyPlayer((Entity)zombie);
                    zombie.setTarget((LivingEntity)player);
                    zombie.setMaxHealth(((MetadataValue)zombie.getMetadata("BossHealth").get(0)).asDouble());
                    zombie.setHealth(((MetadataValue)zombie.getMetadata("BossHealth").get(0)).asDouble());
                    ArmorStand armorStand = (ArmorStand)zombie.getWorld().spawn(location2, ArmorStand.class);
                    armorStand.setMetadata("Unknown", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)""));
                    armorStand.setMetadata("Arena", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)this.getName()));
                    armorStand.setVisible(false);
                    armorStand.setSmall(true);
                    armorStand.setCustomName("\u00a78[\u00a7c||||||||||||||||||||\u00a78]");
                    armorStand.setCustomNameVisible(true);
                    zombie.setPassenger((Entity)armorStand);
                    zombie.setCustomName(Main.getInstance().getConfiguration().getMessage("InfernoName"));
                    zombie.setCustomNameVisible(true);
                    if (this.isEndlessMode() && this.round >= this.fileConfiguration.getInt("Rounds")) {
                        EntityUtils.walk(this.arena, (Entity)zombie, player, this.fileConfiguration.getDouble("EMode.Speed.Inferno"));
                    } else {
                        EntityUtils.walk(this.arena, (Entity)zombie, player, this.fileConfiguration.getDouble("Round." + this.getRound() + ".Speed.Inferno"));
                    }
                    EntityUtils.teleport((Entity)zombie, location);
                    this.sendMessage(Main.getInstance().getConfiguration().getMessage("BossSpawn").replace("%name%", Main.getInstance().getConfiguration().getMessage("InfernoName")));
                    --this.infernos;
                    break;
                }
                case 29: {
                    Location location3 = location;
                    if (hashMap.containsKey((Object)ZombieType.BOMBIE)) {
                        location3 = (Location)((List)hashMap.get((Object)ZombieType.BOMBIE)).get(ThreadLocalRandom.current().nextInt(((List)hashMap.get((Object)ZombieType.BOMBIE)).size()));
                    } else if (!arrayList2.isEmpty()) {
                        location3 = (Location)arrayList2.get(ThreadLocalRandom.current().nextInt(arrayList2.size()));
                    }
                    location3.getWorld().strikeLightningEffect(location3);
                    Zombie zombie = (Zombie)location3.getWorld().spawn(location3, Zombie.class);
                    zombie.setPersistent(true);
                    zombie.getEquipment().clear();
                    zombie.setBaby(false);
                    zombie.setRemoveWhenFarAway(false);
                    zombie.getEquipment().setHelmet(ItemStackUtils.getItem(Material.TNT, 1, 0, "", new String[0]));
                    zombie.getEquipment().setChestplate(ItemStackUtils.colorize(ItemStackUtils.getItem(Material.LEATHER_CHESTPLATE, 1, 0, "", new String[0]), Color.BLACK));
                    zombie.getEquipment().setLeggings(ItemStackUtils.colorize(ItemStackUtils.getItem(Material.LEATHER_LEGGINGS, 1, 0, "", new String[0]), Color.BLACK));
                    zombie.getEquipment().setBoots(ItemStackUtils.colorize(ItemStackUtils.enchant(ItemStackUtils.getItem(Material.LEATHER_BOOTS, 1, 0, "", new String[0]), Enchantment.PROTECTION_FALL, 1), Color.BLACK));
                    zombie.setMetadata("Arena", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)this.getName()));
                    zombie.setMetadata("Zombies", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)this.fileConfiguration.getDouble("Gold.Bombie")));
                    zombie.setMetadata("Bombie", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)Main.getInstance().getConfiguration().getMessage("BombieName")));
                    zombie.setMetadata("ZombieName", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)Configuration.translateTextCodes(this.fileConfiguration.getString("Name.Bombie"))));
                    zombie.setMetadata("BossHealth", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)this.fileConfiguration.getDouble("Health.Bombie")));
                    Player player = EntityUtils.getNearbyPlayer((Entity)zombie);
                    zombie.setTarget((LivingEntity)player);
                    zombie.setMaxHealth(((MetadataValue)zombie.getMetadata("BossHealth").get(0)).asDouble());
                    zombie.setHealth(((MetadataValue)zombie.getMetadata("BossHealth").get(0)).asDouble());
                    ArmorStand armorStand = (ArmorStand)zombie.getWorld().spawn(location3, ArmorStand.class);
                    armorStand.setMetadata("Unknown", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)""));
                    armorStand.setMetadata("Arena", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)this.getName()));
                    armorStand.setVisible(false);
                    armorStand.setSmall(true);
                    armorStand.setCustomName("\u00a78[\u00a7c||||||||||||||||||||\u00a78]");
                    armorStand.setCustomNameVisible(true);
                    zombie.setPassenger((Entity)armorStand);
                    zombie.setCustomName(Main.getInstance().getConfiguration().getMessage("BombieName"));
                    zombie.setCustomNameVisible(true);
                    if (this.isEndlessMode() && this.round >= this.fileConfiguration.getInt("Rounds")) {
                        EntityUtils.walk(this.arena, (Entity)zombie, player, this.fileConfiguration.getDouble("EMode.Speed.Bombie"));
                    } else {
                        EntityUtils.walk(this.arena, (Entity)zombie, player, this.fileConfiguration.getDouble("Round." + this.getRound() + ".Speed.Bombie"));
                    }
                    EntityUtils.teleport((Entity)zombie, location);
                    this.sendMessage(Main.getInstance().getConfiguration().getMessage("BossSpawn").replace("%name%", Main.getInstance().getConfiguration().getMessage("BombieName")));
                    --this.bombies;
                    break;
                }
                case 30: {
                    Location location4 = location;
                    if (hashMap.containsKey((Object)ZombieType.THE_BROODMOTHER)) {
                        location4 = (Location)((List)hashMap.get((Object)ZombieType.THE_BROODMOTHER)).get(ThreadLocalRandom.current().nextInt(((List)hashMap.get((Object)ZombieType.THE_BROODMOTHER)).size()));
                    } else if (!arrayList2.isEmpty()) {
                        location4 = (Location)arrayList2.get(ThreadLocalRandom.current().nextInt(arrayList2.size()));
                    }
                    location4.getWorld().strikeLightningEffect(location4);
                    Zombie zombie = (Zombie)location4.getWorld().spawn(location4, Zombie.class);
                    zombie.setPersistent(true);
                    zombie.getEquipment().clear();
                    zombie.setBaby(false);
                    zombie.setRemoveWhenFarAway(false);
                    zombie.getEquipment().setItemInHand(ItemStackUtils.getItem(versionId >= 13 ? Material.GOLDEN_SWORD : Material.getMaterial((String)"GOLD_SWORD"), 1, 0, "", new String[0]));
                    zombie.getEquipment().setHelmet(ItemStackUtils.getTexturedItem(1, "", "eyJ0aW1lc3RhbXAiOjE0OTk3MDk5NTU5NzUsInByb2ZpbGVJZCI6IjQwMDVjYWMxYTE2YTQ1YWE5ZTcyN2ZiNTE0MzM1NzE3IiwicHJvZmlsZU5hbWUiOiJNSEZfR3VhcmRpYW4iLCJzaWduYXR1cmVSZXF1aXJlZCI6dHJ1ZSwidGV4dHVyZXMiOnsiU0tJTiI6eyJ1cmwiOiJodHRwOi8vdGV4dHVyZXMubWluZWNyYWZ0Lm5ldC90ZXh0dXJlLzkzMmMyNDUyNGM4MmFiM2IzZTU3YzIwNTJjNTMzZjEzZGQ4YzBiZWI4YmRkMDYzNjliYjI1NTRkYTg2YzEyMyJ9fX0="));
                    zombie.getEquipment().setChestplate(ItemStackUtils.getItem(versionId >= 13 ? Material.GOLDEN_CHESTPLATE : Material.getMaterial((String)"GOLD_CHESTPLATE"), 1, 0, "", new String[0]));
                    zombie.getEquipment().setLeggings(ItemStackUtils.getItem(versionId >= 13 ? Material.GOLDEN_LEGGINGS : Material.getMaterial((String)"GOLD_LEGGINGS"), 1, 0, "", new String[0]));
                    zombie.getEquipment().setBoots(ItemStackUtils.getItem(versionId >= 13 ? Material.GOLDEN_BOOTS : Material.getMaterial((String)"GOLD_BOOTS"), 1, 0, "", new String[0]));
                    zombie.setMetadata("Arena", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)this.getName()));
                    zombie.setMetadata("Zombies", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)this.fileConfiguration.getDouble("Gold.TheBroodmother")));
                    zombie.setMetadata("TheBroodmother", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)Main.getInstance().getConfiguration().getMessage("TheBroodmotherName")));
                    zombie.setMetadata("ZombieName", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)Configuration.translateTextCodes(this.fileConfiguration.getString("Name.TheBroodmother"))));
                    zombie.setMetadata("BossHealth", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)this.fileConfiguration.getDouble("Health.TheBroodmother")));
                    Player player = EntityUtils.getNearbyPlayer((Entity)zombie);
                    zombie.setTarget((LivingEntity)player);
                    zombie.setMaxHealth(((MetadataValue)zombie.getMetadata("BossHealth").get(0)).asDouble());
                    zombie.setHealth(((MetadataValue)zombie.getMetadata("BossHealth").get(0)).asDouble());
                    Guardian guardian = (Guardian)zombie.getWorld().spawn(location4, Guardian.class);
                    guardian.setRemoveWhenFarAway(false);
                    guardian.setMetadata("Unknown", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)""));
                    guardian.setMetadata("Arena", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)this.getName()));
                    guardian.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, Integer.MAX_VALUE, 1, true, false));
                    guardian.setTarget((LivingEntity)player);
                    zombie.setPassenger((Entity)guardian);
                    ArmorStand armorStand = (ArmorStand)zombie.getWorld().spawn(location4, ArmorStand.class);
                    armorStand.setMetadata("Unknown", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)""));
                    armorStand.setMetadata("Arena", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)this.getName()));
                    armorStand.setVisible(false);
                    armorStand.setMarker(true);
                    armorStand.setCustomName("\u00a78[\u00a7c||||||||||||||||||||\u00a78]");
                    armorStand.setCustomNameVisible(true);
                    guardian.setPassenger((Entity)armorStand);
                    zombie.setCustomName(Main.getInstance().getConfiguration().getMessage("TheBroodmotherName"));
                    zombie.setCustomNameVisible(true);
                    if (this.isEndlessMode() && this.round >= this.fileConfiguration.getInt("Rounds")) {
                        EntityUtils.walk(this.arena, (Entity)zombie, player, this.fileConfiguration.getDouble("EMode.Speed.TheBroodmother"));
                    } else {
                        EntityUtils.walk(this.arena, (Entity)zombie, player, this.fileConfiguration.getDouble("Round." + this.getRound() + ".Speed.TheBroodmother"));
                    }
                    EntityUtils.teleport((Entity)zombie, location);
                    this.sendMessage(Main.getInstance().getConfiguration().getMessage("BossSpawn").replace("%name%", Main.getInstance().getConfiguration().getMessage("TheBroodmotherName")));
                    --this.theBroodmothers;
                    break;
                }
                case 31: {
                    Location location5 = location;
                    if (hashMap.containsKey((Object)ZombieType.KING_SLIME)) {
                        location5 = (Location)((List)hashMap.get((Object)ZombieType.KING_SLIME)).get(ThreadLocalRandom.current().nextInt(((List)hashMap.get((Object)ZombieType.KING_SLIME)).size()));
                    } else if (!arrayList2.isEmpty()) {
                        location5 = (Location)arrayList2.get(ThreadLocalRandom.current().nextInt(arrayList2.size()));
                    }
                    location5.getWorld().strikeLightningEffect(location5);
                    Zombie zombie = (Zombie)location5.getWorld().spawn(location5, Zombie.class);
                    zombie.setPersistent(true);
                    zombie.getEquipment().clear();
                    zombie.setBaby(false);
                    zombie.setRemoveWhenFarAway(false);
                    zombie.getEquipment().setItemInHand(ItemStackUtils.enchant(ItemStackUtils.getItem(Material.SLIME_BALL, 1, 0, "", new String[0]), Enchantment.DAMAGE_ALL, 6));
                    zombie.getEquipment().setHelmet(ItemStackUtils.getTexturedItem(1, "", "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvODJkYzRiY2I5NzY3ZDNmMTMzNjI5OWFiMjQ2OTBiMzRhNGM2ZTVhNDI3ZWM1YzM4MWQ2YzU5ODk4YTVlZjEifX19"));
                    zombie.getEquipment().setChestplate(ItemStackUtils.enchant(ItemStackUtils.colorize(ItemStackUtils.getItem(Material.LEATHER_CHESTPLATE, 1, 0, "", new String[0]), Color.GREEN), Enchantment.PROTECTION_PROJECTILE, 4));
                    zombie.getEquipment().setLeggings(ItemStackUtils.enchant(ItemStackUtils.colorize(ItemStackUtils.getItem(Material.LEATHER_LEGGINGS, 1, 0, "", new String[0]), Color.GREEN), Enchantment.PROTECTION_PROJECTILE, 4));
                    zombie.getEquipment().setBoots(ItemStackUtils.enchant(ItemStackUtils.colorize(ItemStackUtils.getItem(Material.LEATHER_BOOTS, 1, 0, "", new String[0]), Color.GREEN), Enchantment.PROTECTION_PROJECTILE, 4));
                    zombie.setMetadata("Arena", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)this.getName()));
                    zombie.setMetadata("Zombies", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)this.fileConfiguration.getDouble("Gold.KingSlime")));
                    zombie.setMetadata("KingSlime", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)Main.getInstance().getConfiguration().getMessage("KingSlimeName")));
                    zombie.setMetadata("ZombieName", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)Configuration.translateTextCodes(this.fileConfiguration.getString("Name.KingSlime"))));
                    zombie.setMetadata("BossHealth", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)this.fileConfiguration.getDouble("Health.KingSlime")));
                    Player player = EntityUtils.getNearbyPlayer((Entity)zombie);
                    zombie.setTarget((LivingEntity)player);
                    zombie.setMaxHealth(((MetadataValue)zombie.getMetadata("BossHealth").get(0)).asDouble());
                    zombie.setHealth(((MetadataValue)zombie.getMetadata("BossHealth").get(0)).asDouble());
                    ArmorStand armorStand = (ArmorStand)zombie.getWorld().spawn(location5, ArmorStand.class);
                    armorStand.setMetadata("Unknown", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)""));
                    armorStand.setMetadata("Arena", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)this.getName()));
                    armorStand.setVisible(false);
                    armorStand.setSmall(true);
                    armorStand.setCustomName("\u00a78[\u00a7c||||||||||||||||||||\u00a78]");
                    armorStand.setCustomNameVisible(true);
                    zombie.setPassenger((Entity)armorStand);
                    zombie.setCustomName(Main.getInstance().getConfiguration().getMessage("KingSlimeName"));
                    zombie.setCustomNameVisible(true);
                    if (this.isEndlessMode() && this.round >= this.fileConfiguration.getInt("Rounds")) {
                        EntityUtils.walk(this.arena, (Entity)zombie, player, this.fileConfiguration.getDouble("EMode.Speed.KingSlime"));
                    } else {
                        EntityUtils.walk(this.arena, (Entity)zombie, player, this.fileConfiguration.getDouble("Round." + this.getRound() + ".Speed.KingSlime"));
                    }
                    EntityUtils.teleport((Entity)zombie, location);
                    this.sendMessage(Main.getInstance().getConfiguration().getMessage("BossSpawn").replace("%name%", Main.getInstance().getConfiguration().getMessage("KingSlimeName")));
                    --this.kingSlimes;
                    break;
                }
                case 32: {
                    Location location6 = location;
                    if (hashMap.containsKey((Object)ZombieType.KING_WITHER)) {
                        location6 = (Location)((List)hashMap.get((Object)ZombieType.KING_WITHER)).get(ThreadLocalRandom.current().nextInt(((List)hashMap.get((Object)ZombieType.KING_WITHER)).size()));
                    } else if (!arrayList2.isEmpty()) {
                        location6 = (Location)arrayList2.get(ThreadLocalRandom.current().nextInt(arrayList2.size()));
                    }
                    location6.getWorld().strikeLightningEffect(location6);
                    Wither wither = (Wither)location6.getWorld().spawn(location6, Wither.class);
                    wither.setPersistent(true);
                    wither.getEquipment().clear();
                    wither.setRemoveWhenFarAway(false);
                    wither.setMetadata("Arena", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)this.getName()));
                    wither.setMetadata("Zombies", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)this.fileConfiguration.getDouble("Gold.KingWither")));
                    wither.setMetadata("KingWither", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)Main.getInstance().getConfiguration().getMessage("KingWitherName")));
                    wither.setMetadata("ZombieName", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)Configuration.translateTextCodes(this.fileConfiguration.getString("Name.KingWither"))));
                    wither.setMetadata("BossHealth", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)this.fileConfiguration.getDouble("Health.KingWither")));
                    Player player = EntityUtils.getNearbyPlayer((Entity)wither);
                    wither.setTarget((LivingEntity)player);
                    wither.setMaxHealth(((MetadataValue)wither.getMetadata("BossHealth").get(0)).asDouble());
                    wither.setHealth(((MetadataValue)wither.getMetadata("BossHealth").get(0)).asDouble());
                    ArmorStand armorStand = (ArmorStand)wither.getWorld().spawn(location6, ArmorStand.class);
                    armorStand.setMetadata("Unknown", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)""));
                    armorStand.setMetadata("Arena", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)this.getName()));
                    armorStand.setVisible(false);
                    armorStand.setSmall(true);
                    armorStand.setCustomName("\u00a78[\u00a7c||||||||||||||||||||\u00a78]");
                    armorStand.setCustomNameVisible(true);
                    wither.setPassenger((Entity)armorStand);
                    wither.setCustomName(Main.getInstance().getConfiguration().getMessage("KingWitherName"));
                    wither.setCustomNameVisible(true);
                    if (this.isEndlessMode() && this.round >= this.fileConfiguration.getInt("Rounds")) {
                        EntityUtils.walk(this.arena, (Entity)wither, player, this.fileConfiguration.getDouble("EMode.Speed.KingWither"));
                    } else {
                        EntityUtils.walk(this.arena, (Entity)wither, player, this.fileConfiguration.getDouble("Round." + this.getRound() + ".Speed.KingWither"));
                    }
                    EntityUtils.teleport((Entity)wither, location);
                    this.sendMessage(Main.getInstance().getConfiguration().getMessage("BossSpawn").replace("%name%", Main.getInstance().getConfiguration().getMessage("KingWitherName")));
                    --this.kingWithers;
                    break;
                }
                case 33: {
                    Location location7 = location;
                    if (hashMap.containsKey((Object)ZombieType.HEROBRINE)) {
                        location7 = (Location)((List)hashMap.get((Object)ZombieType.HEROBRINE)).get(ThreadLocalRandom.current().nextInt(((List)hashMap.get((Object)ZombieType.HEROBRINE)).size()));
                    } else if (!arrayList2.isEmpty()) {
                        location7 = (Location)arrayList2.get(ThreadLocalRandom.current().nextInt(arrayList2.size()));
                    }
                    location7.getWorld().strikeLightningEffect(location7);
                    Zombie zombie = (Zombie)location7.getWorld().spawn(location7, Zombie.class);
                    zombie.setPersistent(true);
                    zombie.getEquipment().clear();
                    zombie.setBaby(false);
                    zombie.setRemoveWhenFarAway(false);
                    zombie.getEquipment().setItemInHand(ItemStackUtils.enchant(ItemStackUtils.getItem(Material.DIAMOND_SWORD, 1, 0, "", new String[0]), Enchantment.DAMAGE_ALL, 2));
                    zombie.getEquipment().setHelmet(ItemStackUtils.getTexturedItem(1, "", "eyJ0aW1lc3RhbXAiOjE1MDg2MjExNjU4MTAsInByb2ZpbGVJZCI6ImY4NGM2YTc5MGE0ZTQ1ZTA4NzliY2Q0OWViZDRjNGUyIiwicHJvZmlsZU5hbWUiOiJIZXJvYnJpbmUiLCJzaWduYXR1cmVSZXF1aXJlZCI6dHJ1ZSwidGV4dHVyZXMiOnsiU0tJTiI6eyJ1cmwiOiJodHRwOi8vdGV4dHVyZXMubWluZWNyYWZ0Lm5ldC90ZXh0dXJlL2JkZDNjYzhhZTI5YTRkZmU1NjVkZGNkN2E2NjMzODhkOGVhZDdmNWJjOGRiYTVhNDkzMTQ4YjI0NTk4NGQifX19"));
                    zombie.getEquipment().setChestplate(ItemStackUtils.getItem(Material.DIAMOND_CHESTPLATE, 1, 0, "", new String[0]));
                    zombie.getEquipment().setLeggings(ItemStackUtils.getItem(Material.DIAMOND_LEGGINGS, 1, 0, "", new String[0]));
                    zombie.getEquipment().setBoots(ItemStackUtils.getItem(Material.DIAMOND_BOOTS, 1, 0, "", new String[0]));
                    zombie.setMetadata("Arena", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)this.getName()));
                    zombie.setMetadata("Zombies", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)this.fileConfiguration.getDouble("Gold.Herobrine")));
                    zombie.setMetadata("Herobrine", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)Main.getInstance().getConfiguration().getMessage("HerobrineName")));
                    zombie.setMetadata("ZombieName", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)Configuration.translateTextCodes(this.fileConfiguration.getString("Name.Herobrine"))));
                    zombie.setMetadata("BossHealth", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)this.fileConfiguration.getDouble("Health.Herobrine")));
                    Player player = EntityUtils.getNearbyPlayer((Entity)zombie);
                    zombie.setTarget((LivingEntity)player);
                    zombie.setMaxHealth(((MetadataValue)zombie.getMetadata("BossHealth").get(0)).asDouble());
                    zombie.setHealth(((MetadataValue)zombie.getMetadata("BossHealth").get(0)).asDouble());
                    ArmorStand armorStand = (ArmorStand)zombie.getWorld().spawn(location7, ArmorStand.class);
                    armorStand.setMetadata("Unknown", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)""));
                    armorStand.setMetadata("Arena", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)this.getName()));
                    armorStand.setVisible(false);
                    armorStand.setSmall(true);
                    armorStand.setCustomName("\u00a78[\u00a7c||||||||||||||||||||\u00a78]");
                    armorStand.setCustomNameVisible(true);
                    zombie.setPassenger((Entity)armorStand);
                    zombie.setCustomName(Main.getInstance().getConfiguration().getMessage("HerobrineName"));
                    zombie.setCustomNameVisible(true);
                    if (this.isEndlessMode() && this.round >= this.fileConfiguration.getInt("Rounds")) {
                        EntityUtils.walk(this.arena, (Entity)zombie, player, this.fileConfiguration.getDouble("EMode.Speed.Herobrine"));
                    } else {
                        EntityUtils.walk(this.arena, (Entity)zombie, player, this.fileConfiguration.getDouble("Round." + this.getRound() + ".Speed.Herobrine"));
                    }
                    EntityUtils.teleport((Entity)zombie, location);
                    this.sendMessage(Main.getInstance().getConfiguration().getMessage("BossSpawn").replace("%name%", Main.getInstance().getConfiguration().getMessage("HerobrineName")));
                    --this.herobrines;
                    break;
                }
                case 34: {
                    Location location8 = location;
                    if (hashMap.containsKey((Object)ZombieType.SANTA_CLAUS)) {
                        location8 = (Location)((List)hashMap.get((Object)ZombieType.SANTA_CLAUS)).get(ThreadLocalRandom.current().nextInt(((List)hashMap.get((Object)ZombieType.SANTA_CLAUS)).size()));
                    } else if (!arrayList2.isEmpty()) {
                        location8 = (Location)arrayList2.get(ThreadLocalRandom.current().nextInt(arrayList2.size()));
                    }
                    location8.getWorld().strikeLightningEffect(location8);
                    Zombie zombie = (Zombie)location8.getWorld().spawn(location8, Zombie.class);
                    zombie.setPersistent(true);
                    zombie.getEquipment().clear();
                    zombie.setBaby(false);
                    zombie.setRemoveWhenFarAway(false);
                    zombie.getEquipment().setItemInHand(ItemStackUtils.enchant(ItemStackUtils.getTexturedItem(1, "", "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNTMzYTViZmM4YTJhM2ExNTJkNjQ2YTViZWE2OTRhNDI1YWI3OWRiNjk0YjIxNGYxNTZjMzdjNzE4M2FhIn19fQ=="), Enchantment.FIRE_ASPECT, 1));
                    zombie.getEquipment().setHelmet(ItemStackUtils.getTexturedItem(1, "", "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYzhhYzE5OGI4ODUwMWM5NDhhOTMzZDUyYjExMzNlM2Y2NTAyY2M1ZmY1YWNlM2Q1YzYwYWNlYjU0NDk3NzZkIn19fQ=="));
                    zombie.getEquipment().setChestplate(ItemStackUtils.enchant(ItemStackUtils.colorize(ItemStackUtils.getItem(Material.LEATHER_CHESTPLATE, 1, 0, "", new String[0]), Color.fromRGB((int)156, (int)24, (int)27)), Enchantment.PROTECTION_ENVIRONMENTAL, 3));
                    zombie.getEquipment().setLeggings(ItemStackUtils.enchant(ItemStackUtils.colorize(ItemStackUtils.getItem(Material.LEATHER_LEGGINGS, 1, 0, "", new String[0]), Color.fromRGB((int)156, (int)24, (int)27)), Enchantment.PROTECTION_ENVIRONMENTAL, 3));
                    zombie.getEquipment().setBoots(ItemStackUtils.enchant(ItemStackUtils.colorize(ItemStackUtils.getItem(Material.LEATHER_BOOTS, 1, 0, "", new String[0]), Color.fromRGB((int)156, (int)24, (int)27)), Enchantment.PROTECTION_ENVIRONMENTAL, 3));
                    zombie.setMetadata("Arena", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)this.getName()));
                    zombie.setMetadata("Zombies", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)this.fileConfiguration.getDouble("Gold.SantaClaus")));
                    zombie.setMetadata("SantaClaus", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)Main.getInstance().getConfiguration().getMessage("SantaClausName")));
                    zombie.setMetadata("ZombieName", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)Configuration.translateTextCodes(this.fileConfiguration.getString("Name.SantaClaus"))));
                    zombie.setMetadata("BossHealth", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)this.fileConfiguration.getDouble("Health.SantaClaus")));
                    Player player = EntityUtils.getNearbyPlayer((Entity)zombie);
                    zombie.setTarget((LivingEntity)player);
                    zombie.setMaxHealth(((MetadataValue)zombie.getMetadata("BossHealth").get(0)).asDouble());
                    zombie.setHealth(((MetadataValue)zombie.getMetadata("BossHealth").get(0)).asDouble());
                    ArmorStand armorStand = (ArmorStand)zombie.getWorld().spawn(location8, ArmorStand.class);
                    armorStand.setMetadata("Unknown", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)""));
                    armorStand.setMetadata("Arena", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)this.getName()));
                    armorStand.setVisible(false);
                    armorStand.setSmall(true);
                    armorStand.setCustomName("\u00a78[\u00a7c||||||||||||||||||||\u00a78]");
                    armorStand.setCustomNameVisible(true);
                    zombie.setPassenger((Entity)armorStand);
                    zombie.setCustomName(Main.getInstance().getConfiguration().getMessage("SantaClausName"));
                    zombie.setCustomNameVisible(true);
                    if (this.isEndlessMode() && this.round >= this.fileConfiguration.getInt("Rounds")) {
                        EntityUtils.walk(this.arena, (Entity)zombie, player, this.fileConfiguration.getDouble("EMode.Speed.SantaClaus"));
                    } else {
                        EntityUtils.walk(this.arena, (Entity)zombie, player, this.fileConfiguration.getDouble("Round." + this.getRound() + ".Speed.SantaClaus"));
                    }
                    EntityUtils.teleport((Entity)zombie, location);
                    this.sendMessage(Main.getInstance().getConfiguration().getMessage("BossSpawn").replace("%name%", Main.getInstance().getConfiguration().getMessage("SantaClausName")));
                    --this.santaClaus;
                    break;
                }
                case 35: {
                    Location location9 = location;
                    if (hashMap.containsKey((Object)ZombieType.PENNYWISE)) {
                        location9 = (Location)((List)hashMap.get((Object)ZombieType.PENNYWISE)).get(ThreadLocalRandom.current().nextInt(((List)hashMap.get((Object)ZombieType.PENNYWISE)).size()));
                    } else if (!arrayList2.isEmpty()) {
                        location9 = (Location)arrayList2.get(ThreadLocalRandom.current().nextInt(arrayList2.size()));
                    }
                    location9.getWorld().strikeLightningEffect(location9);
                    Zombie zombie = (Zombie)location9.getWorld().spawn(location9, Zombie.class);
                    zombie.setPersistent(true);
                    zombie.getEquipment().clear();
                    zombie.setBaby(false);
                    zombie.setRemoveWhenFarAway(false);
                    zombie.getEquipment().setItemInHand(ItemStackUtils.enchant(ItemStackUtils.getTexturedItem(1, "", "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNTJkZDExZGEwNDI1MmY3NmI2OTM0YmMyNjYxMmY1NGYyNjRmMzBlZWQ3NGRmODk5NDEyMDllMTkxYmViYzBhMiJ9fX0="), Enchantment.DAMAGE_ALL, 3));
                    zombie.getEquipment().setHelmet(ItemStackUtils.getTexturedItem(1, "", "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZmJmMjc3ZDY1YTJiMWFhYTliN2M5MGYwZTNhOGIzZTZiM2Y2NDllMjc4ZDA4ZmJjYjlkMjQ5Yzg4MGQ3M2MyNyJ9fX0="));
                    zombie.getEquipment().setChestplate(ItemStackUtils.enchant(ItemStackUtils.colorize(ItemStackUtils.getItem(Material.LEATHER_CHESTPLATE, 1, 0, "", new String[0]), Color.fromRGB((int)255, (int)249, (int)249)), Enchantment.PROTECTION_ENVIRONMENTAL, 3));
                    zombie.getEquipment().setLeggings(ItemStackUtils.enchant(ItemStackUtils.colorize(ItemStackUtils.getItem(Material.LEATHER_LEGGINGS, 1, 0, "", new String[0]), Color.fromRGB((int)255, (int)249, (int)249)), Enchantment.PROTECTION_ENVIRONMENTAL, 3));
                    zombie.getEquipment().setBoots(ItemStackUtils.enchant(ItemStackUtils.colorize(ItemStackUtils.getItem(Material.LEATHER_BOOTS, 1, 0, "", new String[0]), Color.fromRGB((int)255, (int)249, (int)249)), Enchantment.PROTECTION_ENVIRONMENTAL, 3));
                    zombie.setMetadata("Arena", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)this.getName()));
                    zombie.setMetadata("Zombies", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)this.fileConfiguration.getDouble("Gold.Pennywise")));
                    zombie.setMetadata("Pennywise", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)Main.getInstance().getConfiguration().getMessage("PennywiseName")));
                    zombie.setMetadata("ZombieName", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)Configuration.translateTextCodes(this.fileConfiguration.getString("Name.Pennywise"))));
                    zombie.setMetadata("BossHealth", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)this.fileConfiguration.getDouble("Health.Pennywise")));
                    Player player = EntityUtils.getNearbyPlayer((Entity)zombie);
                    zombie.setTarget((LivingEntity)player);
                    zombie.setMaxHealth(((MetadataValue)zombie.getMetadata("BossHealth").get(0)).asDouble());
                    zombie.setHealth(((MetadataValue)zombie.getMetadata("BossHealth").get(0)).asDouble());
                    ArmorStand armorStand = (ArmorStand)zombie.getWorld().spawn(location9, ArmorStand.class);
                    armorStand.setMetadata("Unknown", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)""));
                    armorStand.setMetadata("Arena", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)this.getName()));
                    armorStand.setVisible(false);
                    armorStand.setSmall(true);
                    armorStand.setCustomName("\u00a78[\u00a7c||||||||||||||||||||\u00a78]");
                    armorStand.setCustomNameVisible(true);
                    zombie.setPassenger((Entity)armorStand);
                    zombie.setCustomName(Main.getInstance().getConfiguration().getMessage("PennywiseName"));
                    zombie.setCustomNameVisible(true);
                    if (this.isEndlessMode() && this.round >= this.fileConfiguration.getInt("Rounds")) {
                        EntityUtils.walk(this.arena, (Entity)zombie, player, this.fileConfiguration.getDouble("EMode.Speed.Pennywise"));
                    } else {
                        EntityUtils.walk(this.arena, (Entity)zombie, player, this.fileConfiguration.getDouble("Round." + this.getRound() + ".Speed.Pennywise"));
                    }
                    EntityUtils.teleport((Entity)zombie, location);
                    this.sendMessage(Main.getInstance().getConfiguration().getMessage("BossSpawn").replace("%name%", Main.getInstance().getConfiguration().getMessage("PennywiseName")));
                    --this.pennywise;
                }
            }
        }
    }

    public boolean isEnemyDetectorEnabled() {
        return this.enemyDetectorEnabled;
    }

    public int getEnemyDetectorSlot() {
        return this.enemyDetectorSlot;
    }

    public void finishGame() {
        for (Player object : this.getDisplayedPlayers()) {
            Main.getInstance().getDisplayBar().removeBar(object);
        }
        for (Player player : this.getDisplayedPlayers()) {
            for (PotionEffect potionEffect : player.getActivePotionEffects()) {
                player.removePotionEffect(potionEffect.getType());
            }
            this.resetPlayer(player);
            PlayerDisplayer.unHandleArenaPlayers(player, this);
        }
        this.removeHolograms();
        this.repair();
        for (RevivePlayer revivePlayer : this.revivePlayers.values()) {
            revivePlayer.resetStatus();
        }
        if (this.weaponsChestHologram != null) {
            this.bukkitTasks.addAll(this.weaponsChestHologram.getBukkitTasks());
        }
        for (BukkitTask bukkitTask : this.bukkitTasks) {
            bukkitTask.cancel();
        }
        if (this.lobbyTask != null) {
            this.lobbyTask.cancel();
        }
        Main.getInstance().clearZombies(this);
        MultiArenaHandler.update(this.getSignLocations(), this.arena);
        WorldReset.reset(this.getSpawnLocation().getWorld());
    }

    public void checkGameEnd() {
        BukkitTask bukkitTask = new BukkitRunnable(){

            public void run() {
                if (GameArena.this.getPlayers().size() <= 0) {
                    GameArena.this.endGame();
                }
            }
        }.runTaskTimer((Plugin)Main.getInstance(), 50L, 50L);
        this.bukkitTasks.add(bukkitTask);
    }

    public void endGame() {
        if (this.stopped) {
            return;
        }
        Bukkit.getPluginManager().callEvent((Event)new ArenaStopEvent(this.arena));
        this.stopped = true;
        this.gameState = Main.getInstance().getConfiguration().getMessage("State.Restarting");
        Bukkit.getPluginManager().callEvent((Event)new ArenaStateChangeEvent(this.arena, this.gameState));
        if (Main.getInstance().getConfiguration().getBoolean("MultiArena.Enabled").booleanValue()) {
            MultiArenaHandler.update(this.getSignLocations(), this.arena);
        }
        if (this.weaponsChestHologram != null) {
            this.bukkitTasks.addAll(this.weaponsChestHologram.getBukkitTasks());
        }
        for (BukkitTask object : this.bukkitTasks) {
            object.cancel();
        }
        if (this.lobbyTask != null) {
            this.lobbyTask.cancel();
        }
        for (Player player : this.getDisplayedPlayers()) {
            Main.getInstance().getDisplayBar().removeBar(player);
        }
        Main.getInstance().clearZombies(this);
        this.repair();
        if (this.endlessMode) {
            int n = this.round;
            if (this.zombiesLeft > 0) {
                --n;
            }
            for (Player player : this.getDisplayedPlayers()) {
                int n2 = Main.getInstance().getStatsUtils().getStats(this.getName(), player.getUniqueId().toString()).getSurvivedRounds();
                if (n <= n2) continue;
                Main.getInstance().getStatsUtils().updateStats(this.getName(), StatsField.SURVIVED_ROUNDS, player.getUniqueId().toString(), n);
            }
        }
        new BukkitRunnable(){

            public void run() {
                String string;
                Iterator iterator;
                Object object;
                for (Player object22 : GameArena.this.getDisplayedPlayers()) {
                    object22.getInventory().clear();
                    for (Map.Entry entry : ((Map)GameArena.this.inventoryItems.get("Finish")).entrySet()) {
                        object22.getInventory().setItem(((Integer)entry.getKey()).intValue(), ((InventoryItem)entry.getValue()).getItemStack());
                    }
                }
                ArrayList arrayList = new ArrayList(GameArena.this.revivePlayers.keySet());
                Iterator iterator2 = arrayList.iterator();
                while (iterator2.hasNext()) {
                    object = (Player)iterator2.next();
                    GameArena.this.removeRevivePlayer((Player)object, true);
                    GameArena.this.setDead((Player)object);
                }
                GameArena.this.removeHolograms();
                Title title = new Title();
                if (GameArena.this.round == GameArena.this.fileConfiguration.getInt("Rounds") && GameArena.this.zombiesLeft <= 0 && !GameArena.this.endlessMode) {
                    if (Main.getInstance().getConfig().getBoolean("Rewards.Enabled")) {
                        object = Main.getInstance().getConfig().getStringList("Rewards.GameWin");
                        for (Object object2 : GameArena.this.getPlayers()) {
                            iterator = object.iterator();
                            while (iterator.hasNext()) {
                                string = (String)iterator.next();
                                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)string.replace("%player%", object2.getName()));
                            }
                        }
                    }
                    title.setTitle(Main.getInstance().getConfiguration().getMessage("TitleWin").replace("%round%", String.valueOf(GameArena.this.round)));
                    title.setSubTitle(Main.getInstance().getConfiguration().getMessage("SubTitleWin").replace("%round%", String.valueOf(GameArena.this.round)));
                } else {
                    Bukkit.getPluginManager().callEvent((Event)new ArenaLooseEvent(GameArena.this.arena));
                    if (Main.getInstance().getConfig().getBoolean("Rewards.Enabled") && !GameArena.this.endlessMode) {
                        object = Main.getInstance().getConfig().getStringList("Rewards.GameLoose");
                        for (Object object2 : GameArena.this.getPlayers()) {
                            iterator = object.iterator();
                            while (iterator.hasNext()) {
                                string = (String)iterator.next();
                                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)string.replace("%player%", object2.getName()));
                            }
                        }
                    }
                    title.setTitle(Main.getInstance().getConfiguration().getMessage("TitleLoose").replace("%round%", String.valueOf(GameArena.this.round)));
                    title.setSubTitle(Main.getInstance().getConfiguration().getMessage("SubTitleLoose").replace("%round%", String.valueOf(GameArena.this.round)));
                }
                title.setFadeIn(5);
                title.setStay(150);
                title.setFadeOut(5);
                title.sendTimes(GameArena.this.getDisplayedPlayers());
                title.sendTitle(GameArena.this.getDisplayedPlayers());
                title.sendSubTitle(GameArena.this.getDisplayedPlayers());
                GameArena.this.state = Main.getInstance().getConfiguration().getMessage("GameOver");
                GameArena.this.updateScoreboard();
                object = new ArrayList(GameArena.this.playerGold.keySet());
                Iterator iterator3 = object.iterator();
                while (iterator3.hasNext()) {
                    Object object2;
                    object2 = (String)iterator3.next();
                    GameArena.this.resetGold((String)object2);
                }
                new BukkitRunnable(){

                    public void run() {
                        if (GameArena.this.restartTime == 0) {
                            if (Main.getInstance().getConfiguration().getBoolean("MultiArena.Enabled").booleanValue()) {
                                for (Player player : GameArena.this.getDisplayedPlayers()) {
                                    for (PotionEffect potionEffect : player.getActivePotionEffects()) {
                                        player.removePotionEffect(potionEffect.getType());
                                    }
                                    GameArena.this.resetPlayer(player);
                                    PlayerDisplayer.unHandleArenaPlayers(player, GameArena.this.arena);
                                }
                                new BukkitRunnable(){

                                    public void run() {
                                        Bukkit.getPluginManager().callEvent((Event)new ArenaRestartEvent(GameArena.this.arena));
                                        WorldReset.reset(GameArena.this.getSpawnLocation().getWorld());
                                        GameArena gameArena = Main.getInstance().getConfiguration().refreshArena(GameArena.this.arena);
                                        MultiArenaHandler.update(GameArena.this.getSignLocations(), gameArena);
                                    }
                                }.runTaskLater((Plugin)Main.getInstance(), 50L);
                            } else {
                                Bukkit.getPluginManager().callEvent((Event)new ArenaRestartEvent(GameArena.this.arena));
                                Bukkit.shutdown();
                            }
                            this.cancel();
                            return;
                        }
                        if (GameArena.this.restartTime == 10) {
                            GameArena.this.sendMessage(Main.getInstance().getConfiguration().getMessage("GameStopCountdown").replace("%time%", Main.getInstance().getConfiguration().getMessage("GameStopChatPrefixHigh") + GameArena.this.restartTime));
                        }
                        if (GameArena.this.restartTime <= 5 && GameArena.this.restartTime > 0) {
                            GameArena.this.sendMessage(Main.getInstance().getConfiguration().getMessage("GameStopCountdown").replace("%time%", Main.getInstance().getConfiguration().getMessage("GameStopChatPrefixLow") + GameArena.this.restartTime));
                        }
                        GameArena.this.restartTime -= 1;
                    }
                }.runTaskTimer((Plugin)Main.getInstance(), 20L, 20L);
            }
        }.runTaskLater((Plugin)Main.getInstance(), 15L);
    }

    public int getGold(Player player) {
        if (this.playerGold.containsKey(player.getUniqueId().toString())) {
            return this.playerGold.get(player.getUniqueId().toString());
        }
        return 0;
    }

    public int getGold(String string) {
        if (this.playerGold.containsKey(string)) {
            return this.playerGold.get(string);
        }
        return 0;
    }

    public int getKills(Player player) {
        if (this.playerKills.containsKey(player.getUniqueId().toString())) {
            return this.playerKills.get(player.getUniqueId().toString());
        }
        return 0;
    }

    public boolean checkRemovePlayer(Player player) {
        if (Main.getInstance().getConfiguration().getBoolean("PremiumKickEnabled").booleanValue() && player.hasPermission("zombies.fulljoin") && !this.hasStarted() && this.getDisplayedPlayers().size() >= this.getMaxPlayers()) {
            Player player2 = this.getKickedPlayer(player);
            if (player2 == null) {
                return false;
            }
            String string = Main.getInstance().getConfiguration().getMessage("Messages.PremiumKick");
            if (string != null && !string.isEmpty()) {
                player2.sendMessage(string);
            }
            this.removePlayer(player2);
            return true;
        }
        return false;
    }

    public Player getKickedPlayer(Player player) {
        Player player2 = null;
        if (player.hasPermission("zombies.fulljoin")) {
            for (Player player3 : this.getDisplayedPlayers()) {
                if (player.equals(player3) || player3.hasPermission("zombies.fulljoin")) continue;
                player2 = player3;
            }
        }
        return player2;
    }

    public boolean addPlayer(final Player player) {
        if (!this.hasStarted() && this.getDisplayedPlayers().size() >= this.getMaxPlayers()) {
            return false;
        }
        Bukkit.getPluginManager().callEvent((Event)new ArenaPlayerJoinEvent(player, this.arena));
        new BukkitRunnable(){
            PlayerSettings playerSettings = null;

            public void run() {
                Object object2;
                if (GameArena.this.settings.containsKey(player.getUniqueId().toString())) {
                    this.playerSettings = (PlayerSettings)GameArena.this.settings.get(player.getUniqueId().toString());
                }
                GameArena.this.settings.put(player.getUniqueId().toString(), new PlayerSettings(player, GameArena.this.arena));
                if (!GameArena.this.hasStarted()) {
                    new BukkitRunnable(){

                        public void run() {
                            if (GameArena.this.statsHologram != null) {
                                GameArena.this.statsHologram.show(player);
                            }
                            for (Hologram hologram : GameArena.this.practiceNameHologram) {
                                hologram.show(player);
                            }
                            for (Hologram hologram : GameArena.this.practiceHologram) {
                                hologram.show(player);
                            }
                        }
                    }.runTaskLater((Plugin)Main.getInstance(), 40L);
                    GameArena.this.players.add(player.getUniqueId().toString());
                    ItemStack itemStack = ItemStackUtils.getTexturedItem(1, player.getDisplayName(), player.getName());
                    if (!GameArena.this.spectatorInventory.contains(itemStack)) {
                        GameArena.this.spectatorInventory.addItem(new ItemStack[]{itemStack});
                    }
                    object2 = GameArena.this.spectatorInventory.getContents();
                    GameArena.this.spectatorInventory.clear();
                    for (ItemStack itemStack2 : object2) {
                        if (itemStack2 == null || GameArena.this.spectatorInventory.contains(itemStack2)) continue;
                        GameArena.this.spectatorInventory.addItem(new ItemStack[]{itemStack2});
                    }
                }
                boolean bl = false;
                if (GameArena.this.quitPlayers.contains(player.getUniqueId().toString())) {
                    GameArena.this.players.add(player.getUniqueId().toString());
                    object2 = ItemStackUtils.getTexturedItem(1, player.getDisplayName(), player.getName());
                    if (!GameArena.this.spectatorInventory.contains((ItemStack)object2)) {
                        GameArena.this.spectatorInventory.addItem(new ItemStack[]{object2});
                    }
                    ItemStack[] itemStackArray = GameArena.this.spectatorInventory.getContents();
                    GameArena.this.spectatorInventory.clear();
                    for (ItemStack itemStack : itemStackArray) {
                        if (itemStack == null || GameArena.this.spectatorInventory.contains(itemStack)) continue;
                        GameArena.this.spectatorInventory.addItem(new ItemStack[]{itemStack});
                    }
                    bl = true;
                }
                if (Main.getInstance().getConfiguration().getBoolean("MultiArena.Enabled").booleanValue()) {
                    player.setFlying(false);
                    player.setAllowFlight(false);
                    player.setGameMode(GameMode.ADVENTURE);
                    player.setLevel(0);
                    player.setExp(0.0f);
                    player.setFoodLevel(20);
                    player.getInventory().setArmorContents(null);
                    player.getInventory().clear();
                    for (Map.Entry entry : ((Map)GameArena.this.inventoryItems.get("Lobby")).entrySet()) {
                        player.getInventory().setItem(((Integer)entry.getKey()).intValue(), ((InventoryItem)entry.getValue()).getItemStack());
                    }
                    if (GameArena.this.practiceDummyEnabled) {
                        object2 = Main.getInstance().getConfiguration().getWeapon("PracticeGun");
                        player.getInventory().addItem(new ItemStack[]{((Weapon)object2).getItemStack()});
                    }
                    player.setMaxHealth(20.0);
                    player.setHealth(20.0);
                    for (PotionEffect potionEffect : player.getActivePotionEffects()) {
                        player.removePotionEffect(potionEffect.getType());
                    }
                    GameArena.this.addDisplayedPlayer(player);
                    GameArena.this.applyScoreboard(player);
                    if (GameArena.this.lobbyLocation != null) {
                        player.teleport(GameArena.this.lobbyLocation);
                    } else if (GameArena.this.spawnLocation != null) {
                        player.teleport(GameArena.this.spawnLocation);
                    }
                    if (GameArena.this.hasStarted() && !GameArena.this.quitPlayers.contains(player.getUniqueId().toString()) && !Main.getInstance().getConfiguration().getBoolean("FillEmptySlots").booleanValue()) {
                        player.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, Integer.MAX_VALUE, 0, true, false));
                        PlayerDisplayer.handleArenaPlayers(player, GameArena.this.arena);
                        player.setAllowFlight(true);
                        player.setFlying(true);
                        player.getInventory().clear();
                        for (Map.Entry entry : ((Map)GameArena.this.inventoryItems.get("Spectator")).entrySet()) {
                            player.getInventory().setItem(((Integer)entry.getKey()).intValue(), ((InventoryItem)entry.getValue()).getItemStack());
                        }
                        player.getInventory().setItem(0, ItemStackUtils.getItem(Material.COMPASS, 1, 0, Main.getInstance().getConfiguration().getMessage("Spectator.Teleporter.ItemName"), new String[0]));
                        for (RevivePlayer revivePlayer : GameArena.this.getRevivePlayers().values()) {
                            revivePlayer.sendUpdateStatus(player);
                        }
                    } else {
                        if (GameArena.this.quitPlayers.contains(player.getUniqueId().toString()) && GameArena.this.getPlayers().size() <= GameArena.this.getMaxPlayers() && bl) {
                            if (this.playerSettings != null) {
                                this.playerSettings.restoreDefaultSettings();
                            }
                            GameArena.this.reloadHolograms(player);
                            for (RevivePlayer revivePlayer : GameArena.this.getRevivePlayers().values()) {
                                revivePlayer.sendUpdateStatus(player);
                            }
                            GameArena.this.quitPlayers.remove(player.getUniqueId().toString());
                        } else if (!GameArena.this.quitPlayers.contains(player.getUniqueId().toString()) && GameArena.this.hasStarted() && GameArena.this.getPlayers().size() < GameArena.this.getMaxPlayers() && !bl) {
                            GameArena.this.reloadHolograms(player);
                            for (RevivePlayer revivePlayer : GameArena.this.getRevivePlayers().values()) {
                                revivePlayer.sendUpdateStatus(player);
                            }
                            if (Main.getInstance().getConfiguration().getBoolean("FillEmptySlots").booleanValue()) {
                                GameArena.this.players.add(player.getUniqueId().toString());
                                object2 = ItemStackUtils.getTexturedItem(1, player.getDisplayName(), player.getName());
                                if (!GameArena.this.spectatorInventory.contains((ItemStack)object2)) {
                                    GameArena.this.spectatorInventory.addItem(new ItemStack[]{object2});
                                }
                                ItemStack[] itemStackArray = GameArena.this.spectatorInventory.getContents();
                                GameArena.this.spectatorInventory.clear();
                                for (ItemStack itemStack : itemStackArray) {
                                    if (itemStack == null || GameArena.this.spectatorInventory.contains(itemStack)) continue;
                                    GameArena.this.spectatorInventory.addItem(new ItemStack[]{itemStack});
                                }
                                GameArena.this.loadPlayerSettings(Collections.singletonList(player));
                            }
                        } else if (GameArena.this.hasStarted()) {
                            player.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, Integer.MAX_VALUE, 0, true, false));
                            PlayerDisplayer.handleArenaPlayers(player, GameArena.this.arena);
                            player.setAllowFlight(true);
                            player.setFlying(true);
                            player.getInventory().clear();
                            for (Map.Entry entry : ((Map)GameArena.this.inventoryItems.get("Spectator")).entrySet()) {
                                player.getInventory().setItem(((Integer)entry.getKey()).intValue(), ((InventoryItem)entry.getValue()).getItemStack());
                            }
                            player.getInventory().setItem(0, ItemStackUtils.getItem(Material.COMPASS, 1, 0, Main.getInstance().getConfiguration().getMessage("Spectator.Teleporter.ItemName"), new String[0]));
                            for (RevivePlayer revivePlayer : GameArena.this.getRevivePlayers().values()) {
                                revivePlayer.sendUpdateStatus(player);
                            }
                        }
                        PlayerDisplayer.handleArenaPlayers(player, GameArena.this.arena);
                    }
                } else {
                    GameArena.this.addDisplayedPlayer(player);
                    GameArena.this.applyScoreboard(player);
                    if (GameArena.this.hasStarted() && !GameArena.this.quitPlayers.contains(player.getUniqueId().toString()) && !Main.getInstance().getConfiguration().getBoolean("FillEmptySlots").booleanValue()) {
                        player.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, Integer.MAX_VALUE, 0, true, false));
                        PlayerDisplayer.handleArenaPlayers(player, GameArena.this.arena);
                        player.setAllowFlight(true);
                        player.setFlying(true);
                        player.getInventory().setArmorContents(null);
                        player.getInventory().clear();
                        for (Map.Entry entry : ((Map)GameArena.this.inventoryItems.get("Spectator")).entrySet()) {
                            player.getInventory().setItem(((Integer)entry.getKey()).intValue(), ((InventoryItem)entry.getValue()).getItemStack());
                        }
                        player.getInventory().setItem(0, ItemStackUtils.getItem(Material.COMPASS, 1, 0, Main.getInstance().getConfiguration().getMessage("Spectator.Teleporter.ItemName"), new String[0]));
                        for (RevivePlayer revivePlayer : GameArena.this.getRevivePlayers().values()) {
                            revivePlayer.sendUpdateStatus(player);
                        }
                    } else {
                        if (GameArena.this.quitPlayers.contains(player.getUniqueId().toString()) && GameArena.this.getPlayers().size() <= GameArena.this.getMaxPlayers() && bl) {
                            if (this.playerSettings != null) {
                                this.playerSettings.restoreDefaultSettings();
                            }
                            GameArena.this.reloadHolograms(player);
                            for (RevivePlayer revivePlayer : GameArena.this.getRevivePlayers().values()) {
                                revivePlayer.sendUpdateStatus(player);
                            }
                            GameArena.this.quitPlayers.remove(player.getUniqueId().toString());
                        } else if (!GameArena.this.quitPlayers.contains(player.getUniqueId().toString()) && GameArena.this.hasStarted() && GameArena.this.getPlayers().size() < GameArena.this.getMaxPlayers() && !bl) {
                            GameArena.this.reloadHolograms(player);
                            for (RevivePlayer revivePlayer : GameArena.this.getRevivePlayers().values()) {
                                revivePlayer.sendUpdateStatus(player);
                            }
                            if (Main.getInstance().getConfiguration().getBoolean("FillEmptySlots").booleanValue()) {
                                GameArena.this.players.add(player.getUniqueId().toString());
                                object2 = ItemStackUtils.getTexturedItem(1, player.getDisplayName(), player.getName());
                                if (!GameArena.this.spectatorInventory.contains((ItemStack)object2)) {
                                    GameArena.this.spectatorInventory.addItem(new ItemStack[]{object2});
                                }
                                ItemStack[] itemStackArray = GameArena.this.spectatorInventory.getContents();
                                GameArena.this.spectatorInventory.clear();
                                for (ItemStack itemStack : itemStackArray) {
                                    if (itemStack == null || GameArena.this.spectatorInventory.contains(itemStack)) continue;
                                    GameArena.this.spectatorInventory.addItem(new ItemStack[]{itemStack});
                                }
                                GameArena.this.loadPlayerSettings(Collections.singletonList(player));
                            }
                        } else if (GameArena.this.hasStarted()) {
                            player.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, Integer.MAX_VALUE, 0, true, false));
                            PlayerDisplayer.handleArenaPlayers(player, GameArena.this.arena);
                            player.setAllowFlight(true);
                            player.setFlying(true);
                            player.getInventory().clear();
                            for (Map.Entry entry : ((Map)GameArena.this.inventoryItems.get("Spectator")).entrySet()) {
                                player.getInventory().setItem(((Integer)entry.getKey()).intValue(), ((InventoryItem)entry.getValue()).getItemStack());
                            }
                            player.getInventory().setItem(0, ItemStackUtils.getItem(Material.COMPASS, 1, 0, Main.getInstance().getConfiguration().getMessage("Spectator.Teleporter.ItemName"), new String[0]));
                            for (RevivePlayer revivePlayer : GameArena.this.getRevivePlayers().values()) {
                                revivePlayer.sendUpdateStatus(player);
                            }
                        } else {
                            for (Map.Entry entry : ((Map)GameArena.this.inventoryItems.get("Lobby")).entrySet()) {
                                player.getInventory().setItem(((Integer)entry.getKey()).intValue(), ((InventoryItem)entry.getValue()).getItemStack());
                            }
                            if (GameArena.this.practiceDummyEnabled) {
                                object2 = Main.getInstance().getConfiguration().getWeapon("PracticeGun");
                                player.getInventory().addItem(new ItemStack[]{((Weapon)object2).getItemStack()});
                            }
                        }
                        PlayerDisplayer.handleArenaPlayers(player, GameArena.this.arena);
                    }
                }
                MultiArenaHandler.update(GameArena.this.getSignLocations(), GameArena.this.arena);
            }
        }.runTaskLater((Plugin)Main.getInstance(), 1L);
        return true;
    }

    public void loadPlayerSettings(List<Player> list) {
        for (Player object : list) {
            Object object22;
            Object object3;
            Object object42;
            Object object52;
            Object object6;
            Object object72;
            Object object82;
            Object object92;
            if (this.statsHologram != null) {
                this.statsHologram.destroyFrom(object);
            }
            for (Hologram hologram : this.practiceNameHologram) {
                hologram.destroyFrom(object);
            }
            for (Hologram hologram : this.practiceHologram) {
                hologram.destroyFrom(object);
            }
            ArrayList arrayList = new ArrayList();
            ConfigurationSection configurationSection = this.fileConfiguration.getConfigurationSection("ArmorShop.Position");
            if (configurationSection != null) {
                for (Object object92 : configurationSection.getKeys(false)) {
                    arrayList.add(new ArmorHologram(object, (String)object92));
                }
            }
            ArrayList arrayList2 = new ArrayList();
            object92 = this.fileConfiguration.getConfigurationSection("WeaponShop.Position");
            if (object92 != null) {
                for (Object object82 : object92.getKeys(false)) {
                    arrayList2.add(new WeaponHologram(object, (String)object82));
                }
            }
            ArrayList arrayList3 = new ArrayList();
            object82 = this.fileConfiguration.getConfigurationSection("PerkShop.Position");
            if (object82 != null) {
                for (Object object72 : object82.getKeys(false)) {
                    object6 = new PerkHologram(object, (String)object72);
                    if (this.powerSwitchActivated) {
                        ((PerkHologram)object6).setActivated();
                    }
                    arrayList3.add(object6);
                }
            }
            ArrayList arrayList4 = new ArrayList();
            object72 = new PowerSwitchHologram(object);
            if (this.powerSwitchActivated) {
                ((PowerSwitchHologram)object72).setUnlocked();
            }
            arrayList4.add(object72);
            object6 = new ArrayList();
            UltimateMachineHologram ultimateMachineHologram = new UltimateMachineHologram(object);
            if (this.powerSwitchActivated) {
                ultimateMachineHologram.setActivated();
            }
            object6.add(ultimateMachineHologram);
            ArrayList<TeamMachineHologram> arrayList5 = new ArrayList<TeamMachineHologram>();
            ConfigurationSection configurationSection2 = this.fileConfiguration.getConfigurationSection("TeamMachine.Position");
            if (configurationSection2 != null) {
                for (Object object52 : configurationSection2.getKeys(false)) {
                    object42 = new TeamMachineHologram(object, (String)object52);
                    if (this.powerSwitchActivated) {
                        ((TeamMachineHologram)object42).setActivated();
                    }
                    arrayList5.add((TeamMachineHologram)object42);
                }
            }
            this.armorHolograms.put(object.getUniqueId().toString(), arrayList);
            this.weaponHolograms.put(object.getUniqueId().toString(), arrayList2);
            this.perkHolograms.put(object.getUniqueId().toString(), arrayList3);
            this.powerSwitchHolograms.put(object.getUniqueId().toString(), arrayList4);
            this.ultimateMachineHolograms.put(object.getUniqueId().toString(), (List<UltimateMachineHologram>)object6);
            this.teamMachineHolograms.put(object.getUniqueId().toString(), arrayList5);
            this.alivePlayers.add(object.getUniqueId().toString());
            ConfigurationSection configurationSection3 = Main.getInstance().getConfiguration().getFileConfiguration().getConfigurationSection("Effects");
            if (configurationSection3 != null) {
                for (Object object42 : configurationSection3.getKeys(false)) {
                    object3 = PotionEffectType.getByName((String)object42);
                    int n = Main.getInstance().getConfiguration().getFileConfiguration().getInt("Effects." + (String)object42 + ".Amplifier");
                    assert (object3 != null);
                    object.addPotionEffect(new PotionEffect((PotionEffectType)object3, Integer.MAX_VALUE, n, true, false));
                }
            }
            object52 = Main.getInstance().getConfiguration().getWeapon("Knife");
            object42 = Main.getInstance().getConfiguration().getWeapon("Pistol");
            object.getInventory().setItem(0, ((Weapon)object52).getItemStack());
            object.getInventory().setItem(1, ((Weapon)object42).getItemStack());
            object3 = new ArrayList();
            for (Object object22 : this.fileConfiguration.getStringList("InventoryItems.GunSlot.Lores")) {
                object3.add(Configuration.translateTextCodes((String)object22));
            }
            object.getInventory().setItem(2, ItemStackUtils.getItem(versionId >= 13 ? Material.LEGACY_INK_SACK : Material.getMaterial((String)"INK_SACK"), 1, 7, Configuration.translateTextCodes(this.fileConfiguration.getString("InventoryItems.GunSlot.DisplayName").replace("%id%", String.valueOf(2))), (List<String>)object3));
            ArrayList arrayList6 = new ArrayList();
            for (Object object10 : this.powerSwitchActivated ? this.fileConfiguration.getStringList("InventoryItems.ActivePerkSlot.Lores") : this.fileConfiguration.getStringList("InventoryItems.InactivePerkSlot.Lores")) {
                arrayList6.add(Configuration.translateTextCodes((String)object10));
            }
            object.getInventory().setItem(6, ItemStackUtils.getItem(versionId >= 13 ? Material.LEGACY_INK_SACK : Material.getMaterial((String)"INK_SACK"), 1, 8, Configuration.translateTextCodes(this.powerSwitchActivated ? this.fileConfiguration.getString("InventoryItems.ActivePerkSlot.DisplayName").replace("%id%", String.valueOf(1)) : this.fileConfiguration.getString("InventoryItems.InactivePerkSlot.DisplayName").replace("%id%", String.valueOf(1))), arrayList6));
            object.getInventory().setItem(7, ItemStackUtils.getItem(versionId >= 13 ? Material.LEGACY_INK_SACK : Material.getMaterial((String)"INK_SACK"), 1, 8, Configuration.translateTextCodes(this.powerSwitchActivated ? this.fileConfiguration.getString("InventoryItems.ActivePerkSlot.DisplayName").replace("%id%", String.valueOf(2)) : this.fileConfiguration.getString("InventoryItems.InactivePerkSlot.DisplayName").replace("%id%", String.valueOf(2))), arrayList6));
            object.getInventory().setItem(8, ItemStackUtils.getItem(versionId >= 13 ? Material.LEGACY_INK_SACK : Material.getMaterial((String)"INK_SACK"), 1, 8, Configuration.translateTextCodes(this.powerSwitchActivated ? this.fileConfiguration.getString("InventoryItems.ActivePerkSlot.DisplayName").replace("%id%", String.valueOf(3)) : this.fileConfiguration.getString("InventoryItems.InactivePerkSlot.DisplayName").replace("%id%", String.valueOf(3))), arrayList6));
            Main.getInstance().getWeaponHandler().addWeaponSlot(object, 1);
            Main.getInstance().getWeaponHandler().addWeaponSlot(object, 2);
            Main.getInstance().getWeaponHandler().loadWeaponAmmo(object, (Weapon)object42);
            Main.getInstance().getPerkHandler().addPerkSlot(object, 6);
            Main.getInstance().getPerkHandler().addPerkSlot(object, 7);
            Main.getInstance().getPerkHandler().addPerkSlot(object, 8);
            this.playerGold.put(object.getUniqueId().toString(), Main.getInstance().getConfiguration().getInteger("GoldStart.Default"));
            this.playerKills.put(object.getUniqueId().toString(), 0);
            object22 = Main.getInstance().getConfig().getConfigurationSection("GoldStart.Permissions");
            if (object22 != null) {
                Object object10;
                object10 = object22.getKeys(false).iterator();
                while (object10.hasNext()) {
                    String string = (String)object10.next();
                    String string2 = Main.getInstance().getConfig().getString("GoldStart.Permissions." + string + ".PermissionName");
                    int n = Main.getInstance().getConfig().getInt("GoldStart.Permissions." + string + ".GoldValue");
                    assert (string2 != null);
                    if (!object.hasPermission(string2)) continue;
                    this.addGold(object, n);
                }
            }
            if (this.spawnLocation == null) continue;
            object.teleport(this.spawnLocation);
        }
        for (Map.Entry entry : this.inventoryItems.get("InGame").entrySet()) {
            for (Player player : list) {
                player.getInventory().setItem(((Integer)entry.getKey()).intValue(), ((InventoryItem)entry.getValue()).getItemStack());
            }
        }
    }

    public void setPowerSwitchActivated(boolean bl) {
        this.powerSwitchActivated = bl;
    }

    public boolean isPowerSwitchActivated() {
        return this.powerSwitchActivated;
    }

    public void applyScoreboard(Player player) {
        if (!this.inGame) {
            ConfigurationSection configurationSection = this.fileConfiguration.getConfigurationSection("Scoreboard.Lobby");
            assert (configurationSection != null);
            String string = configurationSection.getString("Title");
            assert (string != null);
            GameScoreboard gameScoreboard = new GameScoreboard(Configuration.translateTextCodes(string));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string2 : configurationSection.getKeys(false)) {
                if (!string2.startsWith("Line")) continue;
                String string3 = this.fileConfiguration.getString("Scoreboard.Lobby." + string2);
                assert (string3 != null);
                string3 = Configuration.translateTextCodes(string3);
                arrayList.add(string3.replace("%difficulty%", this.gameDifficulty).replace("%mode%", this.isEndlessMode() ? Main.getInstance().getConfiguration().getMessage("Mode.Endless") : Main.getInstance().getConfiguration().getMessage("Mode.Normal")).replace("%map%", this.mapName).replace("%minPlayers%", String.valueOf(this.minPlayers)).replace("%maxPlayers%", String.valueOf(this.maxPlayers)).replace("%players%", String.valueOf(this.getDisplayedPlayers().size())).replace("%time%", String.valueOf(this.lobbyTime)));
            }
            gameScoreboard.setLines(arrayList);
            gameScoreboard.update();
            gameScoreboard.setScoreboard(player);
            this.gameScoreboards.put(player, gameScoreboard);
        } else {
            ConfigurationSection configurationSection = this.fileConfiguration.getConfigurationSection("Scoreboard.InGame");
            assert (configurationSection != null);
            String string = configurationSection.getString("Title");
            assert (string != null);
            GameScoreboard gameScoreboard = new GameScoreboard(Configuration.translateTextCodes(string));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string4 : configurationSection.getKeys(false)) {
                if (!string4.startsWith("Line")) continue;
                String string5 = this.fileConfiguration.getString("Scoreboard.InGame." + string4);
                assert (string5 != null);
                string5 = Configuration.translateTextCodes(string5);
                String string6 = string5.replace("%total_killed_mobs%", String.valueOf(this.totalkills)).replace("%difficulty%", this.gameDifficulty).replace("%mode%", this.isEndlessMode() ? Main.getInstance().getConfiguration().getMessage("Mode.Endless") : Main.getInstance().getConfiguration().getMessage("Mode.Normal")).replace("%map%", this.mapName).replace("%minPlayers%", String.valueOf(this.minPlayers)).replace("%maxPlayers%", String.valueOf(this.maxPlayers)).replace("%players%", String.valueOf(this.getPlayers().size())).replace("%time%", this.inGameTime).replace("%state%", this.state).replace("%zombies%", String.valueOf(this.zombiesLeft)).replace("%kills%", String.valueOf(this.getKills(player)));
                Iterator<String> iterator = this.playerGold.keySet().iterator();
                for (int i = 1; i <= this.getMaxPlayers() + 15; ++i) {
                    Player player2;
                    Player player3 = player2 = iterator.hasNext() ? Bukkit.getPlayer((UUID)UUID.fromString(iterator.next())) : null;
                    if (player2 != null && Main.getInstance().getConfiguration().getBoolean("FillEmptySlots").booleanValue() && !this.hasPlayer(player2)) {
                        player2 = null;
                    }
                    if (player2 == null) {
                        string6 = string6.replace("%playerGold%", String.valueOf(this.getGold(player))).replace("%displayName_" + i + "%", Main.getInstance().getConfiguration().getMessage("EmptyPlayer")).replace("%playerName_" + i + "%", Main.getInstance().getConfiguration().getMessage("EmptyPlayer")).replace("%gold_" + i + "%", Main.getInstance().getConfiguration().getMessage("DeadState"));
                        continue;
                    }
                    String string7 = player2.getDisplayName();
                    int n = this.fileConfiguration.getInt("Scoreboard.PlayerNameLength");
                    if (string7.length() > n) {
                        string7 = string7.substring(0, n);
                    }
                    String string8 = player2.getName();
                    int n2 = this.fileConfiguration.getInt("Scoreboard.PlayerNameLength");
                    if (string8.length() > n2) {
                        string8 = string8.substring(0, n2);
                    }
                    string6 = string6.replace("%playerGold%", String.valueOf(this.getGold(player))).replace("%displayName_" + i + "%", string7).replace("%playerName_" + i + "%", string8).replace("%gold_" + i + "%", this.hasPlayer(player2) ? (this.isRevivedPlayer(player2) ? Main.getInstance().getConfiguration().getMessage("ReviveState") : String.valueOf(this.getGold(player2))) : Main.getInstance().getConfiguration().getMessage("QuitState"));
                }
                arrayList.add(string6);
            }
            gameScoreboard.setLines(arrayList);
            gameScoreboard.update();
            gameScoreboard.setScoreboard(player);
            this.gameScoreboards.put(player, gameScoreboard);
        }
    }

    private void updateScoreboard() {
        for (Map.Entry<Player, GameScoreboard> entry : this.gameScoreboards.entrySet()) {
            Calendar calendar;
            String string;
            String string2;
            ArrayList<String> arrayList;
            ConfigurationSection configurationSection;
            Player player = entry.getKey();
            GameScoreboard gameScoreboard = entry.getValue();
            if (this.inGame) {
                configurationSection = this.fileConfiguration.getConfigurationSection("Scoreboard.InGame");
                arrayList = new ArrayList<String>();
                assert (configurationSection != null);
                for (String string3 : configurationSection.getKeys(false)) {
                    if (!string3.startsWith("Line")) continue;
                    string2 = this.fileConfiguration.getString("Scoreboard.InGame." + string3);
                    assert (string2 != null);
                    string2 = Configuration.translateTextCodes(string2);
                    string = string2.replace("%total_killed_mobs%", String.valueOf(this.totalkills)).replace("%difficulty%", this.gameDifficulty).replace("%mode%", this.isEndlessMode() ? Main.getInstance().getConfiguration().getMessage("Mode.Endless") : Main.getInstance().getConfiguration().getMessage("Mode.Normal")).replace("%map%", this.mapName).replace("%minPlayers%", String.valueOf(this.minPlayers)).replace("%maxPlayers%", String.valueOf(this.maxPlayers)).replace("%players%", String.valueOf(this.getPlayers().size())).replace("%time%", this.inGameTime).replace("%state%", this.state).replace("%zombies%", String.valueOf(this.zombiesLeft)).replace("%kills%", String.valueOf(this.getKills(player)));
                    calendar = Calendar.getInstance();
                    calendar.setTimeInMillis(System.currentTimeMillis());
                    string = string.replace("%day%", String.valueOf(calendar.get(5)));
                    string = string.replace("%month%", String.valueOf(calendar.get(2) + 1));
                    string = string.replace("%year%", String.valueOf(calendar.get(1)));
                    string = string.replace("%shortYear%", String.valueOf(calendar.get(1)).substring(2));
                    string = string.replace("%hour%", String.valueOf(calendar.get(11)));
                    string = string.replace("%minute%", String.valueOf(calendar.get(12)));
                    string = string.replace("%second%", String.valueOf(calendar.get(13)));
                    Iterator<String> iterator = this.playerGold.keySet().iterator();
                    for (int i = 1; i <= this.getMaxPlayers() + 15; ++i) {
                        Player player2;
                        Player player3 = player2 = iterator.hasNext() ? Bukkit.getPlayer((UUID)UUID.fromString(iterator.next())) : null;
                        if (player2 != null && Main.getInstance().getConfiguration().getBoolean("FillEmptySlots").booleanValue() && !this.hasPlayer(player2)) {
                            player2 = null;
                        }
                        if (player2 == null) {
                            string = string.replace("%playerGold%", String.valueOf(this.getGold(player))).replace("%displayName_" + i + "%", Main.getInstance().getConfiguration().getMessage("EmptyPlayer")).replace("%playerName_" + i + "%", Main.getInstance().getConfiguration().getMessage("EmptyPlayer")).replace("%gold_" + i + "%", Main.getInstance().getConfiguration().getMessage("DeadState"));
                            continue;
                        }
                        String string4 = player2.getDisplayName();
                        int n = this.fileConfiguration.getInt("Scoreboard.PlayerNameLength");
                        if (string4.length() > n) {
                            string4 = string4.substring(0, n);
                        }
                        String string5 = player2.getName();
                        int n2 = this.fileConfiguration.getInt("Scoreboard.PlayerNameLength");
                        if (string5.length() > n2) {
                            string5 = string5.substring(0, n2);
                        }
                        string = string.replace("%playerGold%", String.valueOf(this.getGold(player))).replace("%displayName_" + i + "%", string4).replace("%playerName_" + i + "%", string5).replace("%gold_" + i + "%", this.hasPlayer(player2) ? (this.isDead(player2) ? Main.getInstance().getConfiguration().getMessage("DeadState") : (this.isRevivedPlayer(player2) ? Main.getInstance().getConfiguration().getMessage("ReviveState") : String.valueOf(this.getGold(player2)))) : Main.getInstance().getConfiguration().getMessage("QuitState"));
                    }
                    arrayList.add(string);
                }
                gameScoreboard.setLines(arrayList);
                gameScoreboard.update();
                continue;
            }
            configurationSection = this.fileConfiguration.getConfigurationSection("Scoreboard.Lobby");
            arrayList = new ArrayList();
            assert (configurationSection != null);
            for (String string3 : configurationSection.getKeys(false)) {
                if (!string3.startsWith("Line")) continue;
                string2 = this.fileConfiguration.getString("Scoreboard.Lobby." + string3);
                assert (string2 != null);
                string2 = Configuration.translateTextCodes(string2);
                string = string2.replace("%difficulty%", this.gameDifficulty).replace("%mode%", this.isEndlessMode() ? Main.getInstance().getConfiguration().getMessage("Mode.Endless") : Main.getInstance().getConfiguration().getMessage("Mode.Normal")).replace("%map%", this.mapName).replace("%minPlayers%", String.valueOf(this.minPlayers)).replace("%maxPlayers%", String.valueOf(this.maxPlayers)).replace("%players%", String.valueOf(this.getDisplayedPlayers().size())).replace("%time%", String.valueOf(this.lobbyTime));
                calendar = Calendar.getInstance();
                calendar.setTimeInMillis(System.currentTimeMillis());
                string = string.replace("%day%", String.valueOf(calendar.get(5)));
                string = string.replace("%month%", String.valueOf(calendar.get(2) + 1));
                string = string.replace("%year%", String.valueOf(calendar.get(1)));
                string = string.replace("%shortYear%", String.valueOf(calendar.get(1)).substring(2));
                string = string.replace("%hour%", String.valueOf(calendar.get(11)));
                string = string.replace("%minute%", String.valueOf(calendar.get(12)));
                string = string.replace("%second%", String.valueOf(calendar.get(13)));
                arrayList.add(string);
            }
            gameScoreboard.setLines(arrayList);
            gameScoreboard.update();
        }
    }

    public int getRequiredGold(String string) {
        return this.fileConfiguration.getInt("Door." + string.replace(" ", "_") + ".Gold");
    }

    public void addPowerupHologram(PowerupHologram powerupHologram) {
        for (Player player : this.getDisplayedPlayers()) {
            List<PowerupHologram> list = new ArrayList<PowerupHologram>();
            if (this.powerupHolograms.containsKey(player.getUniqueId().toString())) {
                list = this.getPowerupHolograms(player);
            }
            list.add(powerupHologram);
            this.powerupHolograms.put(player.getUniqueId().toString(), list);
        }
    }

    public void removePowerupHologram(PowerupHologram powerupHologram) {
        for (Player player : this.getDisplayedPlayers()) {
            List<Object> list = new ArrayList();
            if (this.powerupHolograms.containsKey(player.getUniqueId().toString())) {
                list = this.getPowerupHolograms(player);
            }
            powerupHologram.getItemHologram().destroyFrom(player);
            powerupHologram.getHologram().destroyFrom(player);
            list.remove(powerupHologram);
            this.powerupHolograms.put(player.getUniqueId().toString(), list);
        }
    }

    public WeaponsChestHologram getWeaponsChestHologram() {
        return this.weaponsChestHologram;
    }

    public List<PowerupHologram> getPowerupHolograms(Player player) {
        return this.powerupHolograms.get(player.getUniqueId().toString());
    }

    public List<PowerupHologram> getPowerupHolograms() {
        ArrayList<PowerupHologram> arrayList = new ArrayList<PowerupHologram>();
        for (List<PowerupHologram> list : this.powerupHolograms.values()) {
            arrayList.addAll(list);
        }
        return arrayList;
    }

    public List<PowerSwitchHologram> getPowerSwitchHolograms(Player player) {
        return this.powerSwitchHolograms.get(player.getUniqueId().toString());
    }

    public List<PowerSwitchHologram> getPowerSwitchHolograms() {
        ArrayList<PowerSwitchHologram> arrayList = new ArrayList<PowerSwitchHologram>();
        for (List<PowerSwitchHologram> list : this.powerSwitchHolograms.values()) {
            arrayList.addAll(list);
        }
        return arrayList;
    }

    public List<UltimateMachineHologram> getUltimateMachineHolograms(Player player) {
        return this.ultimateMachineHolograms.get(player.getUniqueId().toString());
    }

    public List<UltimateMachineHologram> getUltimateMachineHolograms() {
        ArrayList<UltimateMachineHologram> arrayList = new ArrayList<UltimateMachineHologram>();
        for (List<UltimateMachineHologram> list : this.ultimateMachineHolograms.values()) {
            arrayList.addAll(list);
        }
        return arrayList;
    }

    public List<TeamMachineHologram> getTeamMachineHolograms(Player player) {
        return this.teamMachineHolograms.get(player.getUniqueId().toString());
    }

    public List<TeamMachineHologram> getTeamMachineHolograms() {
        ArrayList<TeamMachineHologram> arrayList = new ArrayList<TeamMachineHologram>();
        for (List<TeamMachineHologram> list : this.teamMachineHolograms.values()) {
            arrayList.addAll(list);
        }
        return arrayList;
    }

    public List<PerkHologram> getPerkHolograms(Player player) {
        return this.perkHolograms.get(player.getUniqueId().toString());
    }

    public List<PerkHologram> getPerkHolograms() {
        ArrayList<PerkHologram> arrayList = new ArrayList<PerkHologram>();
        for (List<PerkHologram> list : this.perkHolograms.values()) {
            arrayList.addAll(list);
        }
        return arrayList;
    }

    public List<WeaponHologram> getWeaponHolograms(Player player) {
        return this.weaponHolograms.get(player.getUniqueId().toString());
    }

    public List<WeaponHologram> getWeaponHolograms() {
        ArrayList<WeaponHologram> arrayList = new ArrayList<WeaponHologram>();
        for (List<WeaponHologram> list : this.weaponHolograms.values()) {
            arrayList.addAll(list);
        }
        return arrayList;
    }

    public List<ArmorHologram> getArmorHolograms(Player player) {
        return this.armorHolograms.get(player.getUniqueId().toString());
    }

    public List<ArmorHologram> getArmorHolograms() {
        ArrayList<ArmorHologram> arrayList = new ArrayList<ArmorHologram>();
        for (List<ArmorHologram> list : this.armorHolograms.values()) {
            arrayList.addAll(list);
        }
        return arrayList;
    }

    public PowerupHologram getPowerupHologram(Player player, Location location) {
        if (this.powerSwitchHolograms.containsKey(player.getUniqueId().toString())) {
            List<PowerupHologram> list = this.powerupHolograms.get(player.getUniqueId().toString());
            for (PowerupHologram powerupHologram : list) {
                if (!powerupHologram.getLocation().equals((Object)location)) continue;
                return powerupHologram;
            }
        }
        return null;
    }

    public PowerSwitchHologram getPowerSwitchHologram(Player player, Location location) {
        if (this.powerSwitchHolograms.containsKey(player.getUniqueId().toString())) {
            List<PowerSwitchHologram> list = this.powerSwitchHolograms.get(player.getUniqueId().toString());
            for (PowerSwitchHologram powerSwitchHologram : list) {
                if (!powerSwitchHologram.getLocations().contains(location)) continue;
                return powerSwitchHologram;
            }
        }
        return null;
    }

    public UltimateMachineHologram getUltimateMachineHologram(Player player, Location location) {
        if (this.ultimateMachineHolograms.containsKey(player.getUniqueId().toString())) {
            List<UltimateMachineHologram> list = this.ultimateMachineHolograms.get(player.getUniqueId().toString());
            for (UltimateMachineHologram ultimateMachineHologram : list) {
                if (!ultimateMachineHologram.getLocations().contains(location)) continue;
                return ultimateMachineHologram;
            }
        }
        return null;
    }

    public TeamMachineHologram getTeamMachineHologram(Player player, Location location) {
        if (this.teamMachineHolograms.containsKey(player.getUniqueId().toString())) {
            List<TeamMachineHologram> list = this.teamMachineHolograms.get(player.getUniqueId().toString());
            for (TeamMachineHologram teamMachineHologram : list) {
                if (!teamMachineHologram.getLocations().contains(location)) continue;
                return teamMachineHologram;
            }
        }
        return null;
    }

    public PerkHologram getPerkHologram(Player player, Location location) {
        if (this.perkHolograms.containsKey(player.getUniqueId().toString())) {
            List<PerkHologram> list = this.perkHolograms.get(player.getUniqueId().toString());
            for (PerkHologram perkHologram : list) {
                if (!perkHologram.getLocations().contains(location)) continue;
                return perkHologram;
            }
        }
        return null;
    }

    public WeaponHologram getWeaponHologram(Player player, Location location) {
        if (this.weaponHolograms.containsKey(player.getUniqueId().toString())) {
            List<WeaponHologram> list = this.weaponHolograms.get(player.getUniqueId().toString());
            for (WeaponHologram weaponHologram : list) {
                if (!weaponHologram.getLocations().contains(location)) continue;
                return weaponHologram;
            }
        }
        return null;
    }

    public ArmorHologram getArmorHologram(Player player, Location location) {
        if (this.armorHolograms.containsKey(player.getUniqueId().toString())) {
            List<ArmorHologram> list = this.armorHolograms.get(player.getUniqueId().toString());
            for (ArmorHologram armorHologram : list) {
                if (!armorHologram.getLocations().contains(location)) continue;
                return armorHologram;
            }
        }
        return null;
    }

    public boolean isDoorUnlockable(Player player, Location location) {
        String string = this.getDoor(player, location);
        if (this.powerSwitchDoors.containsKey(string)) {
            boolean bl = this.powerSwitchDoors.get(string);
            if (bl) {
                return this.isPowerSwitchActivated();
            }
            return true;
        }
        return true;
    }

    public String getDoor(Player player, Location location) {
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Map.Entry<String, List<Location>> entry : this.doorLocations.entrySet()) {
            List<Location> object2 = entry.getValue();
            if (!object2.contains(location)) continue;
            object = (String)entry.getKey();
            arrayList.add((String)object);
        }
        Object object3 = null;
        for (String string : arrayList) {
            if (!this.connectedDoors.containsKey(string)) continue;
            object = this.connectedDoors.get(string);
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Hologram hologram = (Hologram)iterator.next();
                if (object3 == null) {
                    object3 = hologram;
                    continue;
                }
                boolean bl = false;
                Location location2 = hologram.getLocation();
                Location location3 = player.getEyeLocation();
                Vector vector = location2.toVector().subtract(location3.toVector());
                double d = 0.2;
                double d2 = vector.length() - d;
                double d3 = vector.getX() / d2 * d;
                double d4 = vector.getY() / d2 * d;
                double d5 = vector.getZ() / d2 * d;
                Location location4 = location3.clone();
                for (double d6 = 0.0; d6 <= d2; d6 += d) {
                    Location location5 = location4.add(d3, d4, d5);
                    if (location5.getBlock().getType() == Material.AIR) continue;
                    bl = true;
                }
                if (bl) continue;
                object3 = hologram;
            }
        }
        String string = this.getDoorByHologram((Hologram)object3);
        if (string == null && arrayList.size() > 0) {
            string = (String)arrayList.get(0);
        }
        return string;
    }

    public String getDoorByHologram(Hologram hologram) {
        for (Map.Entry<String, Hologram> entry : this.doorHolograms.entrySet()) {
            if (!entry.getValue().equals(hologram)) continue;
            return entry.getKey();
        }
        return null;
    }

    public String getFakeName(String string) {
        String string2 = this.fileConfiguration.getString("Door." + string + ".FakeName");
        if (string2 != null) {
            return string2;
        }
        return string;
    }

    public void unlockDoors() {
        for (String string : this.doorLocations.keySet()) {
            this.unlockDoor(string);
        }
    }

    public boolean unlockDoor(String string) {
        if (this.doorLocations.containsKey(string)) {
            Object object;
            Iterator<Hologram> iterator = this.doorLocations.get(string).iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                this.oldMaterialData.put((Location)object, object.getBlock().getBlockData());
                object.getBlock().setType(Material.AIR);
            }
            if (this.connectedDoors.containsKey(string)) {
                iterator = this.connectedDoors.get(string).iterator();
                while (iterator.hasNext()) {
                    object = iterator.next();
                    ((Hologram)object).destroyFromAll(this);
                }
                this.connectedDoors.remove(string);
            }
            if ((object = this.getOtherDoorByHologram(string, (Hologram)((Object)(iterator = this.doorHolograms.get(string))))) != null) {
                this.connectedDoors.remove(object);
                this.doorHolograms.remove(object);
                if (this.doorLocations.containsKey(object)) {
                    for (Location object2 : this.doorLocations.get(object)) {
                        this.oldMaterialData.put(object2, object2.getBlock().getBlockData());
                        object2.getBlock().setType(Material.AIR);
                    }
                }
            }
            if (iterator != null) {
                ((Hologram)((Object)iterator)).destroyFromAll(this);
            }
            this.doorHolograms.remove(string);
            if (!this.unlockedDoorSpawners.containsKey(string)) {
                List list = this.fileConfiguration.getStringList("Door." + string + ".Spawners");
                ArrayList<Location> arrayList = new ArrayList<Location>();
                Iterator iterator2 = list.iterator();
                while (iterator2.hasNext()) {
                    String string2 = (String)iterator2.next();
                    Location location = new Location(Bukkit.getWorld((String)string2.split(":")[0]), (double)Integer.parseInt(string2.split(":")[1]), (double)Integer.parseInt(string2.split(":")[2]), (double)Integer.parseInt(string2.split(":")[3]));
                    if (this.existAnyLocation(location)) continue;
                    arrayList.add(location);
                }
                if (!arrayList.isEmpty()) {
                    this.unlockedDoorSpawners.put(string, arrayList);
                }
            }
            return true;
        }
        return false;
    }

    public boolean unlockDoor(Player player, String string) {
        if (player == null) {
            this.unlockDoor(string);
            return true;
        }
        if (string != null) {
            int n = this.getRequiredGold(string);
            if (this.getGold(player) >= n) {
                this.playerGold.put(player.getUniqueId().toString(), this.getGold(player) - n);
                this.unlockDoor(string);
                return true;
            }
        }
        return false;
    }

    private boolean existAnyLocation(Location location) {
        for (List<Location> list : this.unlockedDoorSpawners.values()) {
            if (!list.contains(location)) continue;
            return true;
        }
        return false;
    }

    private String getOtherDoorByHologram(String string, Hologram hologram) {
        for (Map.Entry<String, List<Hologram>> entry : this.connectedDoors.entrySet()) {
            if (!entry.getValue().contains(hologram) || entry.getKey().equals(string)) continue;
            return entry.getKey();
        }
        return null;
    }

    public Location getSpawnLocation() {
        return this.spawnLocation;
    }

    public Set<String> getWindowNames() {
        return this.windowBlockLocations.keySet();
    }

    public List<Location> getWindowBlockLocations(String string) {
        if (this.windowBlockLocations.get(string) == null) {
            return new ArrayList<Location>();
        }
        return this.windowBlockLocations.get(string);
    }

    public List<Location> getWindowZombieLocations(String string) {
        if (this.windowZombieLocations.get(string) == null) {
            return new ArrayList<Location>();
        }
        return this.windowZombieLocations.get(string);
    }

    public List<Location> getWindowPlayerLocations(String string) {
        if (this.windowPlayerLocations.get(string) == null) {
            return new ArrayList<Location>();
        }
        return this.windowPlayerLocations.get(string);
    }

    public void sendRepairWindowInformation(Player player) {
        Location location = player.getLocation();
        String object = null;
        for (String object2 : this.getWindowNames()) {
            Location location2 = this.getWindowPlayerLocations(object2);
            boolean bl = false;
            for (Location location3 : location2) {
                if (bl) continue;
                bl = LocationUtils.isSimilar(location, location3);
            }
            if (!bl) continue;
            object = object2;
        }
        if (object != null) {
            boolean bl = true;
            for (Location location2 : this.getWindowBlockLocations(object)) {
                if (location2.getBlock().getType() != Material.AIR && (!Main.getInstance().getConfiguration().getBoolean("Window.BarrierWall").booleanValue() || location2.getBlock().getType() != Material.BARRIER)) continue;
                bl = false;
            }
            if (!bl) {
                ActionBar actionBar = new ActionBar();
                actionBar.setMessage(Main.getInstance().getConfiguration().getMessage("WindowRepairInformation"));
                actionBar.send(player);
            }
        }
    }

    public boolean repairWindow(Player player) {
        Location location = player.getLocation();
        String object = null;
        for (String object2 : this.getWindowNames()) {
            Location location2 = this.getWindowPlayerLocations(object2);
            boolean bl = false;
            for (Location location3 : location2) {
                if (bl) continue;
                bl = LocationUtils.isSimilar(location, location3);
            }
            if (!bl) continue;
            object = object2;
        }
        if (object != null) {
            boolean bl = true;
            for (Location location2 : this.getWindowBlockLocations(object)) {
                if (location2.getBlock().getType() != Material.AIR && (!Main.getInstance().getConfiguration().getBoolean("Window.BarrierWall").booleanValue() || location2.getBlock().getType() != Material.BARRIER)) continue;
                bl = false;
            }
            if (!bl && !this.repairingWindows.containsValue(object)) {
                this.repairingWindows.put(player, object);
                if (EntityUtils.isNearbyEnemy(player.getLocation(), 2)) {
                    String string = Main.getInstance().getConfiguration().getMessage("WindowRepairFailed");
                    if (string != null && !string.isEmpty()) {
                        player.sendMessage(string);
                    }
                } else {
                    String string = Main.getInstance().getConfiguration().getMessage("WindowRepair");
                    if (string != null && !string.isEmpty()) {
                        player.sendMessage(string);
                    }
                }
                return true;
            }
        }
        return false;
    }

    public boolean stopRepairWindow(Player player) {
        if (this.repairingWindows.containsKey(player)) {
            String string = this.repairingWindows.get(player);
            List<Location> list = this.getWindowBlockLocations(string);
            boolean bl = false;
            Object object = list.iterator();
            while (object.hasNext()) {
                Location location = object.next();
                if (location.getBlock().getType() != Material.AIR && (!Main.getInstance().getConfiguration().getBoolean("Window.BarrierWall").booleanValue() || location.getBlock().getType() != Material.BARRIER)) continue;
                bl = true;
            }
            this.repairingWindows.remove(player);
            this.playerRepairDelay.remove(player);
            if (bl && (object = Main.getInstance().getConfiguration().getMessage("WindowRepairStopped")) != null && !((String)object).isEmpty()) {
                player.sendMessage((String)object);
            }
            return bl;
        }
        return false;
    }

    public boolean isRepairing(Player player) {
        return this.repairingWindows.containsKey(player);
    }

    public void repairWindows() {
        for (String string : this.getWindowNames()) {
            List<Location> list = this.getWindowBlockLocations(string);
            for (Location location : list) {
                BlockData blockData;
                if (location.getBlock().getType() != Material.AIR && (!Main.getInstance().getConfiguration().getBoolean("Window.BarrierWall").booleanValue() || location.getBlock().getType() != Material.BARRIER) || (blockData = this.oldMaterialData.get(location)) == null) continue;
                if (versionId >= 13) {
                    location.getBlock().setBlockData(blockData);
                }
                this.oldMaterialData.remove(location);
            }
        }
    }

    public void repair() {
        for (Map.Entry<Location, BlockData> entry : this.oldMaterialData.entrySet()) {
            Location location = entry.getKey();
            BlockData blockData = entry.getValue();
            if (versionId < 13 || blockData == null || location == null) continue;
            location.getBlock().setBlockData(blockData, true);
        }
    }

    public void addResetableMaterialData(Location location, BlockData blockData) {
        this.oldMaterialData.put(location, blockData);
    }

    public void resetGold(String string) {
        if (this.playerGold.containsKey(string)) {
            this.playerGold.put(string, 0);
        }
    }

    public List<String> getGoldPlayers() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(this.playerGold.keySet());
        return arrayList;
    }

    public void addGold(String string, int n) {
        this.playerGold.put(string, this.getGold(string) + n);
    }

    public void addGold(Player player, int n) {
        if (n > 0) {
            String string;
            if (Main.getInstance().getPowerupHandler().isActive(this.arena, PowerupType.DOUBLE_GOLD)) {
                n *= 2;
            }
            if ((string = Main.getInstance().getConfiguration().getMessage("EarnGold")) != null && !string.isEmpty()) {
                player.sendMessage(string.replace("%gold%", String.valueOf(n)));
            }
            this.playerGold.put(player.getUniqueId().toString(), this.getGold(player) + n);
        }
    }

    public void removeGold(Player player, int n) {
        this.playerGold.put(player.getUniqueId().toString(), this.getGold(player) - n);
    }

    public void addKills(Player player, int n) {
        ++this.totalkills;
        this.playerKills.put(player.getUniqueId().toString(), this.getKills(player) + n);
        Bukkit.getPluginManager().callEvent((Event)new ArenaPlayerKillEnemyEvent(player, this.arena));
    }

    public FileConfiguration getFileConfiguration() {
        return this.fileConfiguration;
    }

    public void reloadHolograms(Player player) {
        for (List<Hologram> object : this.connectedDoors.values()) {
            for (Hologram hologram : object) {
                hologram.destroyFrom(Collections.singletonList(player));
                hologram.show(Collections.singletonList(player));
            }
        }
        for (Hologram hologram : this.doorHolograms.values()) {
            hologram.destroyFrom(Collections.singletonList(player));
            hologram.show(Collections.singletonList(player));
        }
        if (this.armorHolograms.containsKey(player.getUniqueId().toString())) {
            for (ArmorHologram armorHologram : this.armorHolograms.get(player.getUniqueId().toString())) {
                if (armorHologram.getItemHologram() != null) {
                    armorHologram.getItemHologram().destroyFrom(player);
                }
                if (armorHologram.getHologram() != null) {
                    armorHologram.getHologram().destroyFrom(player);
                }
                if (armorHologram.getItemHologram() != null) {
                    armorHologram.getItemHologram().show(player);
                }
                if (armorHologram.getHologram() == null) continue;
                armorHologram.getHologram().show(player);
            }
        }
        if (this.weaponHolograms.containsKey(player.getUniqueId().toString())) {
            for (WeaponHologram weaponHologram : this.weaponHolograms.get(player.getUniqueId().toString())) {
                if (weaponHologram.getItemHologram() != null) {
                    weaponHologram.getItemHologram().destroyFrom(player);
                }
                if (weaponHologram.getHologram() != null) {
                    weaponHologram.getHologram().destroyFrom(player);
                }
                if (weaponHologram.getItemHologram() != null) {
                    weaponHologram.getItemHologram().show(player);
                }
                if (weaponHologram.getHologram() == null) continue;
                weaponHologram.getHologram().show(player);
            }
        }
        if (this.weaponsChestHologram != null && this.weaponsChestHologram.getItemHologram() != null) {
            this.weaponsChestHologram.getItemHologram().destroyFrom(player);
            this.weaponsChestHologram.getItemHologram().show(player);
        }
        if (this.perkHolograms.containsKey(player.getUniqueId().toString())) {
            for (PerkHologram perkHologram : this.perkHolograms.get(player.getUniqueId().toString())) {
                if (perkHologram.getHologram() == null) continue;
                perkHologram.getHologram().destroyFrom(player);
                perkHologram.getHologram().show(player);
            }
        }
        if (this.powerSwitchHolograms.containsKey(player.getUniqueId().toString())) {
            for (PowerSwitchHologram powerSwitchHologram : this.powerSwitchHolograms.get(player.getUniqueId().toString())) {
                if (powerSwitchHologram.getHologram() == null) continue;
                powerSwitchHologram.getHologram().destroyFrom(player);
                powerSwitchHologram.getHologram().show(player);
            }
        }
        if (this.ultimateMachineHolograms.containsKey(player.getUniqueId().toString())) {
            for (UltimateMachineHologram ultimateMachineHologram : this.ultimateMachineHolograms.get(player.getUniqueId().toString())) {
                if (ultimateMachineHologram.getHologram() == null) continue;
                ultimateMachineHologram.getHologram().destroyFrom(player);
                ultimateMachineHologram.getHologram().show(player);
            }
        }
        if (this.teamMachineHolograms.containsKey(player.getUniqueId().toString())) {
            for (TeamMachineHologram teamMachineHologram : this.teamMachineHolograms.get(player.getUniqueId().toString())) {
                if (teamMachineHologram.getHologram() == null) continue;
                teamMachineHologram.getHologram().destroyFrom(player);
                teamMachineHologram.getHologram().show(player);
            }
        }
        if (this.powerupHolograms.containsKey(player.getUniqueId().toString())) {
            for (PowerupHologram powerupHologram : this.powerupHolograms.get(player.getUniqueId().toString())) {
                if (powerupHologram.getItemHologram() != null) {
                    powerupHologram.getItemHologram().destroyFrom(player);
                }
                if (powerupHologram.getHologram() != null) {
                    powerupHologram.getHologram().destroyFrom(player);
                }
                if (powerupHologram.getItemHologram() != null) {
                    powerupHologram.getItemHologram().show(player);
                }
                if (powerupHologram.getHologram() == null) continue;
                powerupHologram.getHologram().show(player);
            }
        }
    }

    public void removeHolograms(List<Player> list) {
        for (List<Hologram> object2 : this.connectedDoors.values()) {
            for (Object object : object2) {
                ((Hologram)object).destroyFrom(list);
            }
        }
        for (Hologram hologram : this.doorHolograms.values()) {
            hologram.destroyFrom(list);
        }
        for (RevivePlayer revivePlayer : this.revivePlayers.values()) {
            if (revivePlayer.getHologram() == null) continue;
            revivePlayer.getHologram().destroyFrom(list);
        }
        for (List list2 : this.armorHolograms.values()) {
            for (Object object : list2) {
                if (((ArmorHologram)object).getItemHologram() != null) {
                    ((ArmorHologram)object).getItemHologram().destroyFrom(list);
                }
                if (((ArmorHologram)object).getHologram() == null) continue;
                ((ArmorHologram)object).getHologram().destroyFrom(list);
            }
        }
        for (List list3 : this.weaponHolograms.values()) {
            for (Object object : list3) {
                if (((WeaponHologram)object).getItemHologram() != null) {
                    ((WeaponHologram)object).getItemHologram().destroyFrom(list);
                }
                if (((WeaponHologram)object).getHologram() == null) continue;
                ((WeaponHologram)object).getHologram().destroyFrom(list);
            }
        }
        if (this.weaponsChestHologram != null) {
            if (this.weaponsChestHologram.getItemHologram() != null) {
                this.weaponsChestHologram.getItemHologram().destroyFrom(list);
            }
            if (this.weaponsChestHologram.getHologram() != null) {
                this.weaponsChestHologram.getHologram().destroy();
            }
            this.weaponsChestHologram.closeChest();
        }
        for (List list4 : this.perkHolograms.values()) {
            for (Object object : list4) {
                if (((PerkHologram)object).getHologram() == null) continue;
                ((PerkHologram)object).getHologram().destroyFrom(list);
            }
        }
        for (List list5 : this.powerSwitchHolograms.values()) {
            for (Object object : list5) {
                if (((PowerSwitchHologram)object).getHologram() == null) continue;
                ((PowerSwitchHologram)object).getHologram().destroyFrom(list);
            }
        }
        for (List list6 : this.ultimateMachineHolograms.values()) {
            for (Object object : list6) {
                if (((UltimateMachineHologram)object).getHologram() == null) continue;
                ((UltimateMachineHologram)object).getHologram().destroyFrom(list);
            }
        }
        for (List list7 : this.teamMachineHolograms.values()) {
            for (Object object : list7) {
                if (((TeamMachineHologram)object).getHologram() == null) continue;
                ((TeamMachineHologram)object).getHologram().destroyFrom(list);
            }
        }
        for (List list8 : this.powerupHolograms.values()) {
            for (Object object : list8) {
                if (((PowerupHologram)object).getItemHologram() != null) {
                    ((PowerupHologram)object).getItemHologram().destroyFrom(list);
                }
                if (((PowerupHologram)object).getHologram() == null) continue;
                ((PowerupHologram)object).getHologram().destroyFrom(list);
            }
        }
    }

    public void removeHolograms() {
        ArrayList<Player> arrayList = new ArrayList<Player>();
        arrayList.addAll(this.getDisplayedPlayers());
        this.removeHolograms(arrayList);
        this.connectedDoors.clear();
        this.doorHolograms.clear();
        this.revivePlayers.clear();
        this.armorHolograms.clear();
        this.weaponHolograms.clear();
        this.perkHolograms.clear();
        this.powerSwitchHolograms.clear();
        this.ultimateMachineHolograms.clear();
        this.teamMachineHolograms.clear();
        this.powerupHolograms.clear();
    }

    public String getWindow(Location location) {
        for (Map.Entry<String, List<Location>> entry : this.windowBlockLocations.entrySet()) {
            if (!entry.getValue().contains(location.getBlock().getLocation())) continue;
            return entry.getKey();
        }
        return null;
    }

    public boolean isRevivedPlayer(Player player) {
        return this.revivePlayers.containsKey(player);
    }

    public RevivePlayer getRevivePlayer(Player player) {
        return this.revivePlayers.get(player);
    }

    public void addRevivePlayer(Player player, Entity entity) {
        Bukkit.getPluginManager().callEvent((Event)new ArenaPlayerReviveEvent(player, this.arena));
        player.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, Integer.MAX_VALUE, 0, true, false));
        int n = this.revivePlayers.size() + 1;
        if (n >= this.getAlivePlayers().size()) {
            this.setDead(player);
            this.endGame();
        } else {
            this.revivePlayers.put(player, new RevivePlayer().sendStatus(player, entity));
        }
    }

    public void removeRevivePlayer(Player player, boolean bl) {
        if (this.revivePlayers.containsKey(player)) {
            if (bl) {
                this.revivePlayers.get(player).resetStatus(true);
            }
            this.revivePlayers.remove(player);
        }
    }

    public Map<Player, RevivePlayer> getRevivePlayers() {
        return this.revivePlayers;
    }

    public void setDead(Player player) {
        if (this.isAlive(player)) {
            ItemStack itemStack = ItemStackUtils.getTexturedItem(1, player.getDisplayName(), player.getName());
            if (this.spectatorInventory.contains(itemStack)) {
                this.spectatorInventory.removeItem(new ItemStack[]{itemStack});
            }
            ItemStack[] itemStackArray = this.spectatorInventory.getContents();
            this.spectatorInventory.clear();
            for (ItemStack itemStack2 : itemStackArray) {
                if (itemStack2 == null || this.spectatorInventory.contains(itemStack2)) continue;
                this.spectatorInventory.addItem(new ItemStack[]{itemStack2});
            }
            player.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, Integer.MAX_VALUE, 0, true, false));
            player.setAllowFlight(true);
            player.setFlying(true);
            this.alivePlayers.remove(player.getUniqueId().toString());
            Main.getInstance().getPerkHandler().clearPerks(player);
            this.storedInventory.put(player.getUniqueId().toString(), player.getInventory().getContents());
            player.setExp(0.0f);
            player.setLevel(0);
            player.getInventory().clear();
            for (Map.Entry entry : this.inventoryItems.get("Spectator").entrySet()) {
                player.getInventory().setItem(((Integer)entry.getKey()).intValue(), ((InventoryItem)entry.getValue()).getItemStack());
            }
            player.getInventory().setItem(0, ItemStackUtils.getItem(Material.COMPASS, 1, 0, Main.getInstance().getConfiguration().getMessage("Spectator.Teleporter.ItemName"), new String[0]));
            if (this.alivePlayers.isEmpty()) {
                this.endGame();
            }
            PlayerDisplayer.handleArenaPlayers(player, this.arena);
        }
    }

    public void setAlive(Player player) {
        if (this.isDead(player)) {
            ItemStack itemStack = ItemStackUtils.getTexturedItem(1, player.getDisplayName(), player.getName());
            if (!this.spectatorInventory.contains(itemStack)) {
                this.spectatorInventory.addItem(new ItemStack[]{itemStack});
            }
            ItemStack[] itemStackArray = this.spectatorInventory.getContents();
            this.spectatorInventory.clear();
            Object object = itemStackArray;
            int n = ((ItemStack[])object).length;
            for (int i = 0; i < n; ++i) {
                ItemStack itemStack2 = object[i];
                if (itemStack2 == null || this.spectatorInventory.contains(itemStack2)) continue;
                this.spectatorInventory.addItem(new ItemStack[]{itemStack2});
            }
            this.removeRevivePlayer(player, false);
            if (player.hasPotionEffect(PotionEffectType.INVISIBILITY)) {
                player.removePotionEffect(PotionEffectType.INVISIBILITY);
            }
            if (player.isFlying()) {
                player.setFlying(false);
            }
            if (player.getAllowFlight()) {
                player.setAllowFlight(false);
            }
            PlayerDisplayer.handleArenaPlayers(player, this.arena);
            this.alivePlayers.add(player.getUniqueId().toString());
            player.getInventory().clear();
            if (this.storedInventory.containsKey(player.getUniqueId().toString())) {
                player.getInventory().setContents(this.storedInventory.get(player.getUniqueId().toString()));
            }
            if ((object = Weapon.getWeapon(player.getInventory().getItem(player.getInventory().getHeldItemSlot()))) != null) {
                player.setExp(1.0f);
                n = Main.getInstance().getWeaponHandler().getWeaponAmmo(player, (Weapon)object);
                player.setLevel(n);
            }
            this.storedInventory.remove(player.getUniqueId().toString());
        }
    }

    public void removePlayer(Player player) {
        Iterator<Object> iterator;
        if (this.hasPlayer(player) || this.isDisplayedPlayer(player)) {
            Bukkit.getPluginManager().callEvent((Event)new ArenaPlayerQuitEvent(player, this.arena));
        }
        Main.getInstance().getDisplayBar().removeBar(player);
        if (!this.hasStarted()) {
            if (this.statsHologram != null) {
                this.statsHologram.destroyFrom(player);
            }
            for (Hologram object2 : this.practiceNameHologram) {
                object2.destroyFrom(player);
            }
            iterator = this.practiceHologram.iterator();
            while (iterator.hasNext()) {
                Hologram hologram = iterator.next();
                hologram.destroyFrom(player);
            }
        }
        if (this.isRevivedPlayer(player)) {
            iterator = this.revivePlayers.get(player);
            ((RevivePlayer)((Object)iterator)).resetStatus();
            this.revivePlayers.remove(player);
        }
        if (this.hasPlayer(player)) {
            this.players.remove(player.getUniqueId().toString());
            if (Main.getInstance().getConfiguration().getBoolean("QuitRejoinEnabled").booleanValue() && this.hasStarted()) {
                this.quitPlayers.add(player.getUniqueId().toString());
            }
            if (this.spectatorInventory.contains(iterator = ItemStackUtils.getTexturedItem(1, player.getDisplayName(), player.getName()))) {
                this.spectatorInventory.removeItem(new ItemStack[]{iterator});
            }
            ItemStack[] itemStackArray = this.spectatorInventory.getContents();
            this.spectatorInventory.clear();
            for (ItemStack itemStack : itemStackArray) {
                if (itemStack == null || this.spectatorInventory.contains(itemStack)) continue;
                this.spectatorInventory.addItem(new ItemStack[]{itemStack});
            }
        }
        if (this.isDisplayedPlayer(player)) {
            this.removeDisplayedPlayer(player);
        }
        if (this.isAlive(player) && !this.quitPlayers.contains(player.getUniqueId().toString())) {
            this.alivePlayers.remove(player.getUniqueId().toString());
        }
        this.resetPlayer(player);
        for (PotionEffect potionEffect : player.getActivePotionEffects()) {
            player.removePotionEffect(potionEffect.getType());
        }
        if (this.hasStarted()) {
            this.removeHolograms(Collections.singletonList(player));
        }
        for (RevivePlayer revivePlayer : this.revivePlayers.values()) {
            revivePlayer.resetStatus(player);
        }
        MultiArenaHandler.update(this.getSignLocations(), this.arena);
        this.updateScoreboard();
        if (this.hasStarted() && (this.getPlayers().size() <= 0 || this.getAlivePlayers().size() <= 0)) {
            this.endGame();
        }
        PlayerDisplayer.unHandleArenaPlayers(player, this);
    }

    public void resetPlayer(Player player) {
        PlayerSettings playerSettings = new PlayerSettings(player, this.arena);
        if (this.settings.containsKey(player.getUniqueId().toString())) {
            this.settings.get(player.getUniqueId().toString()).restore();
        }
        this.settings.put(player.getUniqueId().toString(), playerSettings);
    }

    public boolean addDisplayedPlayer(Player player) {
        if (!this.isDisplayedPlayer(player)) {
            this.displayedPlayers.add(player.getUniqueId().toString());
            return true;
        }
        return false;
    }

    public boolean removeDisplayedPlayer(Player player) {
        if (this.isDisplayedPlayer(player)) {
            this.displayedPlayers.remove(player.getUniqueId().toString());
            return true;
        }
        return false;
    }

    public boolean isAlive(Player player) {
        if (this.quitPlayers.contains(player.getUniqueId().toString())) {
            return false;
        }
        return this.alivePlayers.contains(player.getUniqueId().toString());
    }

    public boolean isDead(Player player) {
        if (this.quitPlayers.contains(player.getUniqueId().toString())) {
            return true;
        }
        return !this.alivePlayers.contains(player.getUniqueId().toString());
    }

    public boolean isDisplayedPlayer(Player player) {
        return this.displayedPlayers.contains(player.getUniqueId().toString());
    }

    public boolean hasStopped() {
        return this.stopped;
    }

    public boolean hasStarted() {
        return this.started;
    }

    public boolean hasPlayer(Player player) {
        return this.players.contains(player.getUniqueId().toString());
    }

    public boolean hasDisplayedPlayer(Player player) {
        return this.displayedPlayers.contains(player.getUniqueId().toString());
    }

    public boolean isQuitPlayer(Player player) {
        return this.quitPlayers.contains(player.getUniqueId().toString());
    }

    public int getMinPlayers() {
        return this.minPlayers;
    }

    public int getMaxPlayers() {
        return this.maxPlayers;
    }

    public void sendMessage(String string) {
        for (Player player : this.getDisplayedPlayers()) {
            if (string == null || string.isEmpty()) continue;
            player.sendMessage(string);
        }
    }

    public List<String> getPlayersUUID() {
        return this.players;
    }

    public List<String> getDisplayedPlayersUUID() {
        return this.displayedPlayers;
    }

    public List<String> getAlivePlayersUUID() {
        return this.alivePlayers;
    }

    public List<Player> getPlayers() {
        ArrayList<Player> arrayList = new ArrayList<Player>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (String string : this.players) {
            Player player = Bukkit.getPlayer((UUID)UUID.fromString(string));
            if (player != null) {
                arrayList.add(player);
            }
            if (arrayList2.contains(string)) continue;
            arrayList2.add(string);
        }
        this.players = arrayList2;
        return arrayList;
    }

    public boolean isArenaEmpty() {
        return this.players.size() <= 0;
    }

    public List<Player> getDisplayedPlayers() {
        ArrayList<Player> arrayList = new ArrayList<Player>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (String string : this.displayedPlayers) {
            Player player = Bukkit.getPlayer((UUID)UUID.fromString(string));
            if (player != null) {
                arrayList.add(player);
            }
            if (arrayList2.contains(string)) continue;
            arrayList2.add(string);
        }
        this.displayedPlayers = arrayList2;
        return arrayList;
    }

    public List<Player> getAlivePlayers() {
        ArrayList<Player> arrayList = new ArrayList<Player>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (String string : this.alivePlayers) {
            Player player = Bukkit.getPlayer((UUID)UUID.fromString(string));
            if (player != null) {
                arrayList.add(player);
            }
            if (arrayList2.contains(string)) continue;
            arrayList2.add(string);
        }
        this.alivePlayers = arrayList2;
        return arrayList;
    }

    public String getName() {
        return this.mapName;
    }

    public int getLobbyTime() {
        return this.lobbyTime;
    }

    public String getState() {
        if (Main.getInstance().getConfiguration().getBoolean("MultiArena.Enabled").booleanValue()) {
            return this.gameState;
        }
        return this.getMotdState();
    }

    public String getMotdState() {
        if (this.hasStarted() && !this.hasStopped()) {
            return Configuration.translateTextCodes(Main.getInstance().getConfig().getString("MotdDisplay.InGame").replace("%map%", this.getName()).replace("%time%", this.inGameTime).replace("%players%", String.valueOf(this.getPlayers().size())));
        }
        if (!this.hasStopped()) {
            return Configuration.translateTextCodes(Main.getInstance().getConfig().getString("MotdDisplay.Lobby").replace("%map%", this.getName()).replace("%time%", String.valueOf(this.getLobbyTime())).replace("%players%", String.valueOf(this.getPlayers().size())));
        }
        return Configuration.translateTextCodes(Main.getInstance().getConfig().getString("MotdDisplay.Restarting").replace("%map%", this.getName()).replace("%players%", String.valueOf(this.getPlayers().size())));
    }

    public Map<String, Map<Integer, InventoryItem>> getInventoryItems() {
        return this.inventoryItems;
    }

    public Inventory getSpectatorInventory() {
        return this.spectatorInventory;
    }

    public void updateFile(File file) {
        this.fileConfiguration = YamlConfiguration.loadConfiguration((File)file);
    }

    public List<Location> getSignLocations() {
        ArrayList<Location> arrayList = new ArrayList<Location>();
        for (String string : this.fileConfiguration.getStringList("Signs")) {
            Location location;
            World world = Bukkit.getWorld((String)string.split(":")[0]);
            int n = Integer.parseInt(string.split(":")[1]);
            int n2 = Integer.parseInt(string.split(":")[2]);
            int n3 = Integer.parseInt(string.split(":")[3]);
            if (world == null || !((location = new Location(world, (double)n, (double)n2, (double)n3)).getBlock().getState() instanceof Sign)) continue;
            arrayList.add(location);
        }
        return arrayList;
    }

    public boolean isEndlessMode() {
        return this.endlessMode;
    }

    public int getDifficulty() {
        return this.difficulty;
    }
}

