/*
 * Decompiled with CFR 0.152.
 */
package io.github.battlepass.api;

import io.github.battlepass.BattlePlugin;
import io.github.battlepass.actions.Action;
import io.github.battlepass.api.BattlePassApi;
import io.github.battlepass.api.events.user.UserPassChangeEvent;
import io.github.battlepass.api.events.user.UserRewardReceiveEvent;
import io.github.battlepass.api.events.user.UserTierUpEvent;
import io.github.battlepass.cache.QuestCache;
import io.github.battlepass.cache.RewardCache;
import io.github.battlepass.cache.UserCache;
import io.github.battlepass.exceptions.PassNotFoundException;
import io.github.battlepass.lang.Lang;
import io.github.battlepass.loader.PassLoader;
import io.github.battlepass.objects.pass.PassType;
import io.github.battlepass.objects.pass.Tier;
import io.github.battlepass.objects.reward.Reward;
import io.github.battlepass.objects.user.User;
import java.math.BigInteger;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import java.util.UUID;
import me.hyfe.simplespigot.config.Config;
import me.hyfe.simplespigot.text.replacer.Replacer;
import net.advancedplugins.bp.impl.actions.ActionRegistry;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class BattlePassApiImpl
implements BattlePassApi {
    private final BattlePlugin plugin;
    private final Lang lang;
    private final PassLoader passLoader;
    private final UserCache userCache;
    private final RewardCache rewardCache;
    private final QuestCache questCache;
    private final ActionRegistry actionRegistry;
    private final Config settingsConfig;
    private final Config freePassConfig;
    private final boolean useImprovedTierPoints;
    private final boolean ignoreBlockCache;

    public BattlePassApiImpl(BattlePlugin battlePlugin) {
        this.plugin = battlePlugin;
        this.lang = battlePlugin.getLang();
        this.passLoader = battlePlugin.getPassLoader();
        this.userCache = battlePlugin.getUserCache();
        this.rewardCache = battlePlugin.getRewardCache();
        this.questCache = battlePlugin.getQuestCache();
        this.actionRegistry = battlePlugin.getActionRegistry();
        this.settingsConfig = battlePlugin.getConfig("settings");
        this.freePassConfig = battlePlugin.getPassLoader().passTypeOfId("free").getConfig();
        this.useImprovedTierPoints = this.settingsConfig.bool("fixes.use-improved-tier-points");
        this.ignoreBlockCache = this.settingsConfig.bool("force-skyblock-generator-support");
    }

    @Override
    public ActionRegistry getActionRegistry() {
        return this.actionRegistry;
    }

    @Override
    public Optional<Reward<?>> getReward(String string) {
        return this.rewardCache.get(string);
    }

    @Override
    public boolean hasSeasonEnded() {
        return ZonedDateTime.now().isAfter(this.plugin.getSeasonEndDate());
    }

    @Override
    public boolean hasSeasonStarted() {
        return this.plugin.getSeasonStartDate().isBefore(ZonedDateTime.now().withZoneSameInstant(this.getZone()));
    }

    @Override
    public String getWeekFormatted() {
        String string = "season-finished-message";
        return this.hasSeasonEnded() ? (this.lang.has(string) ? this.lang.external(string).asString() : String.valueOf(this.getCurrentDisplayWeek())) : String.valueOf(this.getCurrentDisplayWeek());
    }

    @Override
    public ZoneId getZone() {
        return ZoneId.of(this.plugin.getConfig("settings").string("current-season.time-zone"));
    }

    @Override
    public long getCurrentWeek() {
        if (!this.hasSeasonStarted()) {
            return -1L;
        }
        ZoneId zoneId = this.getZone();
        long l = ChronoUnit.DAYS.between(this.plugin.getSeasonStartDate(), ZonedDateTime.now().withZoneSameInstant(zoneId));
        return l < 0L ? 0L : l / 7L + 1L;
    }

    @Override
    public long getCurrentDisplayWeek() {
        return Math.min(this.getCurrentWeek(), (long)this.questCache.getMaxWeek());
    }

    @Override
    public ZonedDateTime getSeasonEndDate() {
        return this.plugin.getSeasonEndDate();
    }

    @Override
    public ZonedDateTime getSeasonStartDate() {
        return this.plugin.getSeasonStartDate();
    }

    @Override
    public void setPassId(User user, String string) {
        String string2 = user.getPassId();
        if (string2.equals(string)) {
            return;
        }
        if (!string.equals("free") && !string.equals("premium")) {
            throw new PassNotFoundException(string);
        }
        UserPassChangeEvent userPassChangeEvent2 = new UserPassChangeEvent(user, string);
        this.plugin.runSync(() -> Bukkit.getPluginManager().callEvent((Event)userPassChangeEvent2));
        userPassChangeEvent2.ifNotCancelled(userPassChangeEvent -> {
            user.setPassId(userPassChangeEvent.getNewPassId());
            if (string.equals("free")) {
                user.getPendingTiers().remove("premium");
            }
            if (string.equals("premium")) {
                if (this.freePassConfig.bool("dont-give-premium-free-rewards")) {
                    user.getPendingTiers().remove("free");
                }
                for (int i = 1; i <= user.getTier(); ++i) {
                    this.reward(user, "premium", i, false);
                }
            }
        });
    }

    @Override
    public Tier getTier(int n, String string) {
        if (!string.equals("free") && !string.equals("premium")) {
            throw new PassNotFoundException(string);
        }
        return this.passLoader.getPassTypes().get(string).getTiers().get(n);
    }

    @Override
    public boolean ignoreBlockCache() {
        return this.ignoreBlockCache;
    }

    @Override
    public int getRequiredPoints(int n, String string) {
        PassType passType;
        if (this.useImprovedTierPoints) {
            ++n;
        }
        if ((passType = this.passLoader.getPassTypes().get(string)) == null) {
            throw new PassNotFoundException(string);
        }
        Tier tier = passType.getTiers().get(n);
        return tier == null ? passType.getDefaultPointsRequired() : tier.getRequiredPoints();
    }

    @Override
    public void givePoints(User user, int n) {
        int n2 = this.passLoader.getMaxTier();
        if (user.getTier() >= n2) {
            this.rewardCurrency(user, n);
            return;
        }
        user.updatePoints(bigInteger -> bigInteger.add(BigInteger.valueOf(n)));
        this.updateUserTier(user);
    }

    public void updateUserTier(User user, BigInteger bigInteger2) {
        int n2 = this.passLoader.getMaxTier();
        for (int i = user.getTier() + 1; i <= n2; ++i) {
            int n3 = this.getRequiredPoints(user.getTier(), user.getPassId());
            if (user.getPoints().compareTo(BigInteger.valueOf(n3)) < 0) break;
            user.updatePoints(bigInteger -> bigInteger.subtract(BigInteger.valueOf(n3)));
            Bukkit.getPluginManager().callEvent((Event)new UserTierUpEvent(user, i));
            user.updateTier(n -> n + 1);
            this.reward(user, i, false);
            Player player = Bukkit.getPlayer((UUID)user.getUuid());
            if (player == null) continue;
            Action.executeSimple(player, this.passLoader.getPassTypes().get(user.getPassId()).getTierUpActions(), this.plugin, new Replacer().set("tier", i).set("player", player.getName()));
        }
        if (user.getTier() >= n2) {
            user.updatePoints(bigInteger -> {
                this.rewardCurrency(user, bigInteger.intValue());
                return BigInteger.ZERO;
            });
        }
    }

    @Override
    public void updateUserTier(User user) {
        this.updateUserTier(user, user.getPoints());
    }

    @Override
    public void reward(User user, int n, boolean bl) {
        this.passLoader.getPassTypes().values().stream().map(PassType::getId).forEach(string -> this.reward(user, (String)string, n, bl));
    }

    @Override
    public void reward(User user, String string, int n, boolean bl) {
        boolean bl2 = this.settingsConfig.bool("current-season.auto-receive-rewards");
        Tier tier = this.getTier(n, string);
        if (tier == null) {
            return;
        }
        if (user.hasPassId(string) && (user.getPassId().equals("free") || string.equals("premium") || !this.freePassConfig.bool("dont-give-premium-free-rewards"))) {
            Player player = user.getPlayer();
            if (player == null || !bl && !bl2) {
                user.addPendingTier(string, n);
            } else {
                for (String string2 : tier.getRewardIds()) {
                    Optional optional = this.rewardCache.get(string2);
                    if (!optional.isPresent()) continue;
                    UserRewardReceiveEvent userRewardReceiveEvent2 = new UserRewardReceiveEvent(user, tier, (Reward)optional.get());
                    this.plugin.runSync(() -> Bukkit.getPluginManager().callEvent((Event)userRewardReceiveEvent2));
                    userRewardReceiveEvent2.ifNotCancelled(userRewardReceiveEvent -> ((Reward)optional.get()).reward(player, n));
                }
            }
        }
    }

    @Override
    public void rewardCurrency(User user, int n) {
        String string = this.settingsConfig.string("reward-excess-points.method");
        if (string == null || string.isEmpty() || string.equalsIgnoreCase("none")) {
            return;
        }
        int n2 = n * this.settingsConfig.integer("reward-excess-points.currency-per-point.".concat(user.getPassId()));
        switch (string.toLowerCase()) {
            case "vault": {
                if (this.plugin.getEconomy() == null) break;
                this.plugin.getEconomy().depositPlayer((OfflinePlayer)user.getPlayer(), (double)n2);
                break;
            }
            case "internal": {
                this.plugin.runSync(() -> user.updateCurrency(bigInteger -> bigInteger.add(BigInteger.valueOf(n2))));
                break;
            }
            default: {
                this.plugin.getLogger().severe("Unknown reward method 'reward-excess-points.method'.");
            }
        }
    }
}

