/*
 * Decompiled with CFR 0.152.
 */
package io.github.battlepass.commands.bpadmin;

import io.github.battlepass.BattlePlugin;
import io.github.battlepass.api.events.user.UserLoadEvent;
import io.github.battlepass.cache.UserCache;
import io.github.battlepass.commands.BpSubCommand;
import io.github.battlepass.objects.user.User;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class DeleteUserSub
extends BpSubCommand<CommandSender> {
    private final UserCache userCache;

    public DeleteUserSub(BattlePlugin battlePlugin) {
        super(battlePlugin);
        this.userCache = battlePlugin.getUserCache();
        this.inheritPermission();
        this.addFlats("delete", "user");
        this.addArgument(User.class, "player", (CommandSender commandSender) -> Bukkit.getOnlinePlayers().stream().map(OfflinePlayer::getName).collect(Collectors.toList()), new String[0]);
    }

    @Override
    public void onExecute(CommandSender commandSender, String[] stringArray) {
        Optional optional = (Optional)this.parseArgument(stringArray, 2);
        if (!optional.isPresent()) {
            this.lang.external("could-not-find-user", replacer -> replacer.set("player", stringArray[2])).to(commandSender);
            return;
        }
        User user = (User)optional.get();
        UUID uUID = user.getUuid();
        Player player = user.getPlayer();
        this.userCache.invalidate(uUID);
        Bukkit.getPluginManager().callEvent((Event)new UserLoadEvent(this.userCache.set(uUID, new User(uUID)), true));
        if (player == null) {
            this.lang.local("user-data-deleted-null-player", new Object[0]).to(commandSender);
            return;
        }
        this.lang.local("target-user-data-deleted", new Object[0]).to((CommandSender)player);
        if (!player.equals(commandSender)) {
            this.lang.local("user-data-deleted", player.getName()).to(commandSender);
        }
    }
}

