/*
 * Decompiled with CFR 0.152.
 */
package io.github.battlepass.commands.bpadmin;

import com.google.common.collect.Maps;
import io.github.battlepass.BattlePlugin;
import io.github.battlepass.cache.UserCache;
import io.github.battlepass.commands.BpSubCommand;
import java.math.BigInteger;
import java.util.Map;
import java.util.UUID;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class NewSeasonSub
extends BpSubCommand<CommandSender> {
    private final Map<UUID, Long> confirmations = Maps.newHashMap();
    private final UserCache userCache;

    public NewSeasonSub(BattlePlugin battlePlugin) {
        super(battlePlugin, true);
        this.userCache = battlePlugin.getUserCache();
        this.inheritPermission();
        this.addFlats("new", "season");
    }

    @Override
    public void onExecute(CommandSender commandSender, String[] stringArray) {
        UUID uUID;
        UUID uUID2 = uUID = commandSender instanceof Player ? ((Player)commandSender).getUniqueId() : null;
        if (uUID == null || this.confirmations.containsKey(uUID) && System.currentTimeMillis() - this.confirmations.get(uUID) < 30000L) {
            this.userCache.asyncModifyAll(user -> {
                user.getPendingTiers().clear();
                user.getQuestStore().clear();
                user.updatePoints(bigInteger -> BigInteger.ZERO);
                user.updateTier(n -> 1);
            });
            this.lang.local("new-season-reset", new Object[0]).to(commandSender);
            return;
        }
        this.confirmations.put(uUID, System.currentTimeMillis());
        this.lang.local("confirm-new-season", new Object[0]).to(commandSender);
    }
}

