/*
 * Decompiled with CFR 0.152.
 */
package io.github.battlepass.commands.bpadmin;

import io.github.battlepass.BattlePlugin;
import io.github.battlepass.cache.QuestCache;
import io.github.battlepass.commands.BpSubCommand;
import io.github.battlepass.controller.QuestController;
import io.github.battlepass.enums.Category;
import io.github.battlepass.objects.quests.Quest;
import io.github.battlepass.objects.user.User;
import io.github.battlepass.quests.workers.pipeline.steps.QuestCompletionStep;
import io.github.battlepass.quests.workers.pipeline.steps.QuestValidationStep;
import java.math.BigInteger;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import net.advancedplugins.bp.impl.actions.ActionExecution;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ProgressDailyQuestSub
extends BpSubCommand<CommandSender> {
    private final QuestCache questCache;
    private final QuestController controller;
    private final QuestValidationStep questValidationStep;
    private final QuestCompletionStep questCompletionStep;
    private final boolean blockPermissionEnabled;

    public ProgressDailyQuestSub(BattlePlugin battlePlugin) {
        super(battlePlugin);
        this.questCache = battlePlugin.getQuestCache();
        this.controller = battlePlugin.getQuestController();
        this.questValidationStep = new QuestValidationStep(battlePlugin);
        this.questCompletionStep = new QuestCompletionStep(battlePlugin);
        this.blockPermissionEnabled = battlePlugin.getConfig("settings").bool("enable-ban-permission");
        this.inheritPermission();
        this.addFlats("progress", "daily", "quest");
        this.addArgument(User.class, "player", (CommandSender commandSender) -> Bukkit.getOnlinePlayers().stream().map(OfflinePlayer::getName).collect(Collectors.toList()), new String[0]);
        this.addArgument(String.class, "quest id", new String[0]);
        this.addArgument(BigInteger.class, "amount", new String[0]);
    }

    @Override
    public void onExecute(CommandSender commandSender, String[] stringArray) {
        Optional optional = (Optional)this.parseArgument(stringArray, 3);
        Player player = optional.map(user -> Bukkit.getPlayer((UUID)user.getUuid())).orElse(null);
        String string = (String)this.parseArgument(stringArray, 4);
        BigInteger bigInteger = (BigInteger)this.parseArgument(stringArray, 5);
        if (!optional.isPresent() || player == null) {
            this.lang.external("could-not-find-user", replacer -> replacer.set("player", stringArray[2])).to(commandSender);
            return;
        }
        if (this.blockPermissionEnabled && player.hasPermission("battlepass.block") && !player.hasPermission("battlepass.admin")) {
            this.lang.local("blocked-from-pass", commandSender.getName()).to(commandSender);
            return;
        }
        User user2 = (User)optional.get();
        Quest quest = this.questCache.getQuest(Category.DAILY.id(), string);
        if (quest == null) {
            this.lang.local("invalid-quest-id", stringArray[4], stringArray[3].toLowerCase()).to(commandSender);
            return;
        }
        if (this.controller.isQuestDone(user2, quest)) {
            this.lang.local("quest-already-done", stringArray[2]);
            return;
        }
        if (this.questValidationStep.isQuestPrimarilyValid(user2, quest, bigInteger, false)) {
            ActionExecution actionExecution = new ActionExecution(player, null, bigInteger, false, null);
            actionExecution.setUser(user2);
            this.questCompletionStep.process(actionExecution, quest, this.controller.getQuestProgress(user2, quest), bigInteger);
            this.lang.local("successful-quest-progress", quest.getName()).to(commandSender);
        } else {
            this.lang.local("failed-quest-progress", quest.getName()).to(commandSender);
        }
    }
}

