/*
 * Decompiled with CFR 0.152.
 */
package io.github.battlepass.commands.bpadmin;

import io.github.battlepass.BattlePlugin;
import io.github.battlepass.cache.QuestCache;
import io.github.battlepass.commands.BpSubCommand;
import io.github.battlepass.controller.QuestController;
import io.github.battlepass.enums.Category;
import io.github.battlepass.objects.quests.Quest;
import io.github.battlepass.objects.user.User;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;

public class ResetQuestSub
extends BpSubCommand<CommandSender> {
    private final QuestCache questCache;
    private final QuestController controller;

    public ResetQuestSub(BattlePlugin battlePlugin) {
        super(battlePlugin);
        this.questCache = battlePlugin.getQuestCache();
        this.controller = battlePlugin.getQuestController();
        this.inheritPermission();
        this.addFlats("reset", "quest");
        this.addArgument(User.class, "player", (CommandSender commandSender) -> Bukkit.getOnlinePlayers().stream().map(OfflinePlayer::getName).collect(Collectors.toList()), new String[0]);
        this.addArgument(Integer.class, "week", new String[0]);
        this.addArgument(String.class, "id", new String[0]);
    }

    @Override
    public void onExecute(CommandSender commandSender, String[] stringArray) {
        Optional optional = (Optional)this.parseArgument(stringArray, 2);
        int n = (Integer)this.parseArgument(stringArray, 3);
        String string = (String)this.parseArgument(stringArray, 4);
        if (!optional.isPresent()) {
            this.lang.external("could-not-find-user", replacer -> replacer.set("player", stringArray[2])).to(commandSender);
            return;
        }
        User user = (User)optional.get();
        Quest quest = this.questCache.getQuest(Category.WEEKLY.id(n), string);
        if (quest == null) {
            this.lang.local("invalid-quest-id", stringArray[4], stringArray[3].toLowerCase()).to(commandSender);
            return;
        }
        boolean bl = this.controller.resetQuest(user, quest);
        this.lang.local(bl ? "successful-quest-reset" : "failed-quest-reset", quest.getName(), stringArray[2]).to(commandSender);
    }
}

