/*
 * Decompiled with CFR 0.152.
 */
package io.github.battlepass.commands.bpadmin.setpass;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.github.battlepass.BattlePlugin;
import io.github.battlepass.api.BattlePassApi;
import io.github.battlepass.cache.UserCache;
import io.github.battlepass.commands.BpSubCommand;
import io.github.battlepass.loader.PassLoader;
import io.github.battlepass.objects.pass.PassType;
import io.github.battlepass.objects.user.User;
import java.util.HashSet;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SetPassOnlineSub
extends BpSubCommand<CommandSender> {
    private final UserCache userCache;
    private final PassLoader passLoader;
    private final BattlePassApi api;

    public SetPassOnlineSub(BattlePlugin battlePlugin) {
        super(battlePlugin);
        this.userCache = battlePlugin.getUserCache();
        this.passLoader = battlePlugin.getPassLoader();
        this.api = battlePlugin.getLocalApi();
        this.inheritPermission();
        this.addFlats("set", "pass", "online");
        this.addArgument(String.class, "passId", (CommandSender commandSender) -> Lists.newArrayList((Object[])new String[]{"free", "premium"}), new String[0]);
    }

    @Override
    public void onExecute(CommandSender commandSender, String[] stringArray) {
        String string = (String)this.parseArgument(stringArray, 3);
        PassType passType = this.passLoader.passTypeOfId(string);
        if (passType == null) {
            this.lang.local("invalid-pass-id", string).to(commandSender);
            return;
        }
        if (passType.getRequiredPermission() != null) {
            this.lang.local("failed-set-pass-require-permission", string, passType.getRequiredPermission()).to(commandSender);
            return;
        }
        HashSet hashSet = Sets.newHashSet();
        for (Player player : Bukkit.getOnlinePlayers()) {
            hashSet.add(player.getUniqueId());
        }
        this.lang.local("successful-set-pass-online", string).to(commandSender);
        this.userCache.asyncModifyMultiple(user -> this.api.setPassId((User)user, string), hashSet);
    }
}

