/*
 * Decompiled with CFR 0.152.
 */
package io.github.battlepass.commands.bpadmin.setpass;

import com.google.common.collect.Lists;
import io.github.battlepass.BattlePlugin;
import io.github.battlepass.api.BattlePassApi;
import io.github.battlepass.commands.BpSubCommand;
import io.github.battlepass.loader.PassLoader;
import io.github.battlepass.objects.pass.PassType;
import io.github.battlepass.objects.user.User;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;

public class SetPassSub
extends BpSubCommand<CommandSender> {
    private final BattlePassApi api;
    private final PassLoader passLoader;

    public SetPassSub(BattlePlugin battlePlugin) {
        super(battlePlugin, true);
        this.api = battlePlugin.getLocalApi();
        this.passLoader = battlePlugin.getPassLoader();
        this.inheritPermission();
        this.addFlats("set", "pass");
        this.addArgument(User.class, "player", (CommandSender commandSender) -> Bukkit.getOnlinePlayers().parallelStream().map(OfflinePlayer::getName).collect(Collectors.toList()), new String[0]);
        this.addArgument(String.class, "passId", (CommandSender commandSender) -> Lists.newArrayList((Object[])new String[]{"free", "premium"}), new String[0]);
    }

    @Override
    public void onExecute(CommandSender commandSender, String[] stringArray) {
        Optional optional = (Optional)this.parseArgument(stringArray, 2);
        String string = (String)this.parseArgument(stringArray, 3);
        if (!optional.isPresent()) {
            this.lang.external("could-not-find-user", replacer -> replacer.set("player", stringArray[2])).to(commandSender);
            return;
        }
        User user = (User)optional.get();
        PassType passType = this.passLoader.passTypeOfId(string);
        if (passType == null) {
            this.lang.local("invalid-pass-id", string).to(commandSender);
            return;
        }
        if (passType.getRequiredPermission() != null) {
            if (this.passLoader.passTypeOfId(user.getPassId()) != null) {
                this.lang.local("failed-set-pass-require-permission", user.getPassId(), passType.getRequiredPermission()).to(commandSender);
                return;
            }
            this.lang.local("failed-set-pass-require-permission", string, passType.getRequiredPermission()).to(commandSender);
            return;
        }
        this.api.setPassId(user, string);
        this.lang.local("successful-set-pass", stringArray[2], string).to(commandSender);
    }
}

