/*
 * Decompiled with CFR 0.152.
 */
package io.github.battlepass.controller;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Maps;
import io.github.battlepass.BattlePlugin;
import io.github.battlepass.cache.QuestCache;
import io.github.battlepass.controller.QuestController;
import io.github.battlepass.objects.quests.Quest;
import io.github.battlepass.objects.user.User;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import me.hyfe.simplespigot.tuple.ImmutablePair;

public class UserController {
    private final QuestCache questCache;
    private final QuestController questController;
    private final Cache<UUID, Integer> completedQuests = CacheBuilder.newBuilder().expireAfterWrite(30L, TimeUnit.SECONDS).build();
    private final Map<UUID, Map<String, ImmutablePair<Long, Integer>>> completedQuestsPerWeek = Maps.newHashMap();

    public UserController(BattlePlugin battlePlugin) {
        this.questCache = battlePlugin.getQuestCache();
        this.questController = battlePlugin.getQuestController();
    }

    public int getQuestsDone(User user, boolean bl) {
        int n = 0;
        if (bl) {
            return (Integer)this.completedQuests.get((Object)user.getUuid(), () -> this.getQuestsDone(user, false));
        }
        for (Quest quest : this.questCache.getAllQuests()) {
            if (!this.questController.isQuestDone(user, quest)) continue;
            ++n;
        }
        return n;
    }

    public int getQuestsDone(User user, String string) {
        if (this.completedQuestsPerWeek.containsKey(user.getUuid())) {
            ImmutablePair<Long, Integer> immutablePair = this.completedQuestsPerWeek.get(user.getUuid()).get(string);
            if (immutablePair != null && System.currentTimeMillis() - immutablePair.getKey() < 30000L) {
                return immutablePair.getValue();
            }
            int n = this.getDoneForWeek(user, string);
            this.completedQuestsPerWeek.get(user.getUuid()).put(string, ImmutablePair.of(System.currentTimeMillis(), n));
            return n;
        }
        int n = this.getDoneForWeek(user, string);
        HashMap hashMap = Maps.newHashMap();
        hashMap.put(string, ImmutablePair.of(System.currentTimeMillis(), n));
        this.completedQuestsPerWeek.put(user.getUuid(), hashMap);
        return n;
    }

    private int getDoneForWeek(User user, String string) {
        Map<String, Quest> map = this.questCache.getQuestsVerbatim(string);
        if (map == null) {
            return -1;
        }
        int n = 0;
        for (Quest quest : map.values()) {
            if (!this.questController.isQuestDone(user, quest)) continue;
            ++n;
        }
        return n;
    }
}

