/*
 * Decompiled with CFR 0.152.
 */
package io.github.battlepass.creator;

import io.github.battlepass.BattlePlugin;
import io.github.battlepass.creator.GUICreatorHandler;
import io.github.battlepass.creator.gui.CreatorMenu;
import io.github.battlepass.creator.requests.ChatInputRequest;
import io.github.battlepass.creator.requests.ChatInputType;
import io.github.battlepass.creator.states.EditType;
import io.github.battlepass.creator.states.QuestSetting;
import io.github.battlepass.objects.quests.Quest;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import me.hyfe.simplespigot.config.Config;
import me.hyfe.simplespigot.text.Text;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class GUICreator {
    private UUID editor;
    private Player p;
    private Quest quest;
    private String category;
    private int page;
    private QuestSetting setting = null;
    private EditType editType = EditType.IDLE;
    private ChatInputRequest chatRequest = null;
    private String prefix;

    public GUICreator(Player player) {
        this.editor = player.getUniqueId();
        this.p = player;
        this.init();
    }

    private void init() {
    }

    public void stop() {
    }

    public void addChatRequest(ChatInputRequest chatInputRequest) {
        this.chatRequest = chatInputRequest;
        this.chatRequest.init();
    }

    public boolean hasChatRequest() {
        return this.chatRequest != null;
    }

    public Player getPlayer() {
        return Bukkit.getPlayer((UUID)this.editor);
    }

    public void fulfillChatRequest(final String string) {
        try {
            new BukkitRunnable(){

                public void run() {
                    if (string.equalsIgnoreCase("cancel")) {
                        GUICreator.this.getPlayer().sendMessage(Text.modify("&c&l(!) &cCancelled chat input request"));
                        GUICreator.this.chatRequest = null;
                        GUICreatorHandler.getHandler().openEditor(GUICreator.this.p);
                        return;
                    }
                    ChatInputType chatInputType = GUICreator.this.chatRequest.getType();
                    Config config = GUICreator.this.quest.getConfig();
                    YamlConfiguration yamlConfiguration = GUICreator.this.quest.getConfig().getConfiguration();
                    String string2 = "quests." + GUICreator.this.quest.getId() + "." + GUICreator.this.setting.getPath();
                    boolean bl = true;
                    switch (chatInputType) {
                        case OBJECT: {
                            yamlConfiguration.set(string2, (Object)string);
                            break;
                        }
                        case INT: {
                            yamlConfiguration.set(string2, (Object)Integer.parseInt(string));
                            break;
                        }
                        case LIST: {
                            List<String> list = Arrays.asList(string.split("\\|"));
                            yamlConfiguration.set(string2, list);
                            break;
                        }
                        case DOUBLE: {
                            yamlConfiguration.set(string2, (Object)Double.parseDouble(string));
                            break;
                        }
                        case STRING: {
                            yamlConfiguration.set(string2, (Object)string);
                            break;
                        }
                        case MATERIAL: {
                            Material material = Material.matchMaterial((String)string.toUpperCase(Locale.ROOT));
                            if (material == null) {
                                GUICreator.this.getPlayer().sendMessage(CreatorMenu.color("&a&l(!) &aInvalid material &7" + string + "&a!"));
                                bl = false;
                                break;
                            }
                            yamlConfiguration.set(string2, (Object)material.name());
                            break;
                        }
                        case ENTITY_TYPE: {
                            EntityType entityType = EntityType.fromName((String)string.toUpperCase(Locale.ROOT));
                            if (entityType == null) {
                                GUICreator.this.getPlayer().sendMessage(CreatorMenu.color("&a&l(!) &aInvalid mob type &7" + string + "&a!"));
                                bl = false;
                                break;
                            }
                            yamlConfiguration.set(string2, (Object)entityType.name());
                            break;
                        }
                    }
                    if (bl) {
                        try {
                            yamlConfiguration.save(config.getFile());
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        BattlePlugin.getPlugin().reload();
                    }
                    GUICreator.this.getPlayer().sendMessage(CreatorMenu.color("&a&l(!) &7" + GUICreator.this.setting.getName() + "&a has been updated to '&7" + string + "'&a!"));
                    GUICreator.this.chatRequest = null;
                    GUICreatorHandler.getHandler().openEditor(GUICreator.this.p);
                }
            }.runTask((Plugin)BattlePlugin.getPlugin());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.p.sendMessage("Invalid input - error has been printed to console. Nothing was changed.");
            GUICreatorHandler.getHandler().openEditor(this.p);
        }
    }

    public void createNewQuest() {
        int n = BattlePlugin.getPlugin().getQuestCache().getQuests(this.category).size() + 1;
        Quest quest = BattlePlugin.getPlugin().getQuestCache().getQuests(this.category).values().stream().findAny().get();
        YamlConfiguration yamlConfiguration = quest.getConfig().getConfiguration();
        for (QuestSetting questSetting : QuestSetting.values()) {
            yamlConfiguration.set("quests." + n + "." + questSetting.getPath(), questSetting.getDef());
        }
        try {
            yamlConfiguration.save(quest.getConfig().getFile());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        BattlePlugin.getPlugin().reload();
        this.quest = BattlePlugin.getPlugin().getQuestCache().getQuest(this.category, n + "");
    }

    public void deleteQuest() {
        YamlConfiguration yamlConfiguration = this.quest.getConfig().getConfiguration();
        yamlConfiguration.set("quests." + this.quest.getId(), null);
        try {
            yamlConfiguration.save(this.quest.getConfig().getFile());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        BattlePlugin.getPlugin().reload();
    }

    public Quest getQuest() {
        return this.quest;
    }

    public void setQuest(Quest quest) {
        this.quest = quest;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String string) {
        this.category = string;
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int n) {
        this.page = n;
    }

    public void setSetting(QuestSetting questSetting) {
        this.setting = questSetting;
    }
}

