/*
 * Decompiled with CFR 0.152.
 */
package io.github.battlepass.creator.gui;

import io.github.battlepass.creator.GUICreator;
import io.github.battlepass.creator.GUICreatorHandler;
import io.github.battlepass.creator.gui.CreatorClickEvent;
import io.github.battlepass.creator.gui.CreatorMenu;
import io.github.battlepass.creator.gui.CreatorQuestList;
import io.github.battlepass.creator.requests.ChatInputRequest;
import io.github.battlepass.creator.requests.ChatInputType;
import io.github.battlepass.creator.states.QuestSetting;
import io.github.battlepass.objects.quests.Quest;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import me.hyfe.simplespigot.item.SpigotItem;
import net.advancedplugins.bp.impl.actions.utils.MultiMaterial;
import net.advancedplugins.bp.impl.utils.ASManager;
import net.advancedplugins.bp.impl.utils.items.ItemBuilder;
import net.advancedplugins.bp.impl.utils.nbt.NBTapi;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;

public class CreatorEditQuest
extends CreatorMenu {
    private static CreatorMenu menu;

    public CreatorEditQuest(JavaPlugin javaPlugin) {
        super(javaPlugin);
        menu = this;
        this.setInvName("&aEditing Quest");
    }

    @Override
    void onEditorClick(CreatorClickEvent creatorClickEvent) {
        Player player = creatorClickEvent.getPlayer();
        GUICreator gUICreator = creatorClickEvent.getCreator();
        ItemStack itemStack = creatorClickEvent.getCurrentItem();
        int n = creatorClickEvent.getSlot();
        String string = NBTapi.get("action", itemStack);
        if (string == null || string.isEmpty()) {
            String string2 = NBTapi.get("edit", itemStack);
            if (string2 == null || string2.isEmpty()) {
                return;
            }
            player.closeInventory();
            QuestSetting questSetting = QuestSetting.valueOf(string2);
            player.sendMessage("Editing " + questSetting.getName());
            gUICreator.addChatRequest(new ChatInputRequest(player.getUniqueId(), questSetting.getType(), questSetting.getDesc() + ", value type: &f" + questSetting.getType().getType() + "&e, current value: &f" + CreatorEditQuest.getQuestValue(gUICreator.getQuest(), questSetting) + (questSetting.getLink() == null ? "" : ". &eMore Info:&f " + questSetting.getLink())));
            gUICreator.setSetting(questSetting);
            return;
        }
        if (string.equalsIgnoreCase("back")) {
            gUICreator.setQuest(null);
            CreatorQuestList.open(player);
        } else if (string.equalsIgnoreCase("delete")) {
            gUICreator.deleteQuest();
            CreatorQuestList.open(player);
            player.sendMessage(CreatorEditQuest.color("&c&l(!) &cQuest has been &ndeleted&c."));
        }
    }

    private static Object getQuestValue(Quest quest, QuestSetting questSetting) {
        Object object = quest.getConfig().getConfiguration().get("quests." + quest.getId() + "." + questSetting.getPath());
        if (questSetting.getType().equals((Object)ChatInputType.LIST)) {
            try {
                object = ((List)object).stream().collect(Collectors.joining("&r&f&l|"));
            }
            catch (Exception exception) {
                return new ArrayList();
            }
        }
        return object;
    }

    public static void open(Player player) {
        int n;
        Inventory inventory = Bukkit.createInventory(null, (int)27, (String)menu.getInvName());
        for (n = 0; n < inventory.getSize(); ++n) {
            inventory.setItem(n, SpigotItem.builder().item(MultiMaterial.GRAY_STAINED_GLASS_PANE.getMaterial()).name(" ").build());
        }
        for (n = inventory.getSize() - 9; n < inventory.getSize(); ++n) {
            inventory.setItem(n, new ItemBuilder(ASManager.matchMaterial("STAINED_GLASS_PANE", 1, 15)).setName(" ").toItemStack());
        }
        GUICreator gUICreator = GUICreatorHandler.getHandler().getEditor(player.getUniqueId());
        Quest quest = gUICreator.getQuest();
        for (QuestSetting questSetting : QuestSetting.values()) {
            SpigotItem.Builder builder = SpigotItem.builder().item(questSetting.getMaterial());
            builder.name(CreatorEditQuest.color("&7Edit &e" + questSetting.getName()));
            builder.lore(CreatorEditQuest.color(" &f&o " + questSetting.getDesc()), CreatorEditQuest.color("&7 - &eValue: &7" + CreatorEditQuest.getQuestValue(quest, questSetting)), " ", CreatorEditQuest.color("&e(!) &7&oLeft-Click&7 to edit this value,"), CreatorEditQuest.color("&7more details will be given about this setting."));
            inventory.setItem(questSetting.getSlot(), NBTapi.addNBTTag("edit", questSetting.name(), builder.build()));
        }
        inventory.setItem(inventory.getSize() - 1, NBTapi.addNBTTag("action", "back", SpigotItem.builder().item(Material.matchMaterial((String)"IRON_DOOR")).name(CreatorEditQuest.color("&eGo back to quest view")).build()));
        inventory.setItem(inventory.getSize() - 9, NBTapi.addNBTTag("action", "delete", SpigotItem.builder().item(Material.matchMaterial((String)"BARRIER")).name(CreatorEditQuest.color("&cDelete this quest")).build()));
        player.openInventory(inventory);
    }
}

