/*
 * Decompiled with CFR 0.152.
 */
package io.github.battlepass.hikari.util;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;

public final class FastList<T>
implements List<T>,
RandomAccess,
Serializable {
    private static final long serialVersionUID = -4598088075242913858L;
    private final Class<?> clazz;
    private T[] elementData;
    private int size;

    public FastList(Class<?> clazz) {
        this.elementData = (Object[])Array.newInstance(clazz, 32);
        this.clazz = clazz;
    }

    public FastList(Class<?> clazz, int n) {
        this.elementData = (Object[])Array.newInstance(clazz, n);
        this.clazz = clazz;
    }

    @Override
    public boolean add(T t) {
        if (this.size < this.elementData.length) {
            this.elementData[this.size++] = t;
        } else {
            int n = this.elementData.length;
            int n2 = n << 1;
            Object[] objectArray = (Object[])Array.newInstance(this.clazz, n2);
            System.arraycopy(this.elementData, 0, objectArray, 0, n);
            objectArray[this.size++] = t;
            this.elementData = objectArray;
        }
        return true;
    }

    @Override
    public T get(int n) {
        return this.elementData[n];
    }

    @Override
    public T removeLast() {
        T t = this.elementData[--this.size];
        this.elementData[this.size] = null;
        return t;
    }

    @Override
    public boolean remove(Object object) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (object != this.elementData[i]) continue;
            int n = this.size - i - 1;
            if (n > 0) {
                System.arraycopy(this.elementData, i + 1, this.elementData, i, n);
            }
            this.elementData[--this.size] = null;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.size; ++i) {
            this.elementData[i] = null;
        }
        this.size = 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public T set(int n, T t) {
        T t2 = this.elementData[n];
        this.elementData[n] = t;
        return t2;
    }

    @Override
    public T remove(int n) {
        if (this.size == 0) {
            return null;
        }
        T t = this.elementData[n];
        int n2 = this.size - n - 1;
        if (n2 > 0) {
            System.arraycopy(this.elementData, n + 1, this.elementData, n, n2);
        }
        this.elementData[--this.size] = null;
        return t;
    }

    @Override
    public boolean contains(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private int index;

            @Override
            public boolean hasNext() {
                return this.index < FastList.this.size;
            }

            @Override
            public T next() {
                if (this.index < FastList.this.size) {
                    return FastList.this.elementData[this.index++];
                }
                throw new NoSuchElementException("No more elements in FastList");
            }
        };
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <E> E[] toArray(E[] EArray) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int n, Collection<? extends T> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int n, T t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int indexOf(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int lastIndexOf(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<T> listIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<T> listIterator(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<T> subList(int n, int n2) {
        throw new UnsupportedOperationException();
    }

    public Object clone() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void forEach(Consumer<? super T> consumer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Spliterator<T> spliterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeIf(Predicate<? super T> predicate) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void replaceAll(UnaryOperator<T> unaryOperator) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void sort(Comparator<? super T> comparator) {
        throw new UnsupportedOperationException();
    }
}

