/*
 * Decompiled with CFR 0.152.
 */
package io.github.battlepass.menus.menus.rewards;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.github.battlepass.BattlePlugin;
import io.github.battlepass.api.BattlePassApi;
import io.github.battlepass.cache.RewardCache;
import io.github.battlepass.loader.PassLoader;
import io.github.battlepass.menus.PageMethods;
import io.github.battlepass.menus.UserDependent;
import io.github.battlepass.menus.service.extensions.ConfigMenu;
import io.github.battlepass.objects.pass.PassType;
import io.github.battlepass.objects.pass.Tier;
import io.github.battlepass.objects.user.User;
import io.github.battlepass.quests.workers.reset.DailyQuestReset;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import me.hyfe.simplespigot.config.Config;
import me.hyfe.simplespigot.item.SpigotItem;
import me.hyfe.simplespigot.menu.item.MenuItem;
import me.hyfe.simplespigot.menu.service.MenuService;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class DefaultRewardsMenu
extends ConfigMenu
implements PageMethods,
UserDependent {
    private final BattlePassApi api;
    private final PassLoader passLoader;
    private final RewardCache rewardCache;
    private final DailyQuestReset dailyQuestReset;
    private final List<Integer> freeTierSlots;
    private final List<Integer> premiumTierSlots;
    private final Collection<Integer> progressTrackSlots;
    private final Map<Integer, Set<Integer>> freeCachedPageIndexes = Maps.newHashMap();
    private final Map<Integer, Set<Integer>> premiumCachedPageIndexes = Maps.newHashMap();
    private final boolean autoReceiveRewards;
    private final boolean hideTiersWithoutRewards;
    private final boolean closeOnClaim;
    private final User user;
    private int page = 1;

    public DefaultRewardsMenu(BattlePlugin battlePlugin, Config config, Player player) {
        super(battlePlugin, config, player);
        this.api = battlePlugin.getLocalApi();
        this.passLoader = battlePlugin.getPassLoader();
        this.rewardCache = battlePlugin.getRewardCache();
        this.dailyQuestReset = battlePlugin.getDailyQuestReset();
        this.freeTierSlots = Lists.newArrayList(MenuService.parseSlots(this, this.config, "free-reward-slots"));
        this.premiumTierSlots = Lists.newArrayList(MenuService.parseSlots(this, this.config, "premium-reward-slots"));
        this.progressTrackSlots = MenuService.parseSlots(this, this.config, "progress-track-slots");
        this.autoReceiveRewards = this.plugin.getConfig("settings").bool("current-season.auto-receive-rewards");
        this.closeOnClaim = config.bool("close-on-reward-claim");
        this.hideTiersWithoutRewards = config.bool("hide-tiers-without-rewards");
        this.user = battlePlugin.getUserCache().getOrThrow(player.getUniqueId());
    }

    @Override
    public void redraw() {
        this.drawAndComputePageableItems(() -> this.drawConfigItems(replacer -> replacer.set("daily_time_left", this.dailyQuestReset.asString()).tryAddPapi((OfflinePlayer)this.player)));
    }

    @Override
    public boolean isUserViable() {
        return this.user != null;
    }

    @Override
    public void nextPage(Runnable runnable) {
        boolean bl = false;
        if (this.passLoader.passTypeOfId("free").getTiers().lastKey() >= this.freeTierSlots.size() * this.page + 1) {
            ++this.page;
            runnable.run();
            bl = true;
        }
        if (!bl && this.passLoader.passTypeOfId("premium").getTiers().lastKey() >= this.premiumTierSlots.size() * this.page + 1) {
            ++this.page;
            runnable.run();
        }
    }

    @Override
    public void previousPage(Runnable runnable) {
        --this.page;
        runnable.run();
    }

    @Override
    public int getPage() {
        return this.page;
    }

    private void drawAndComputePageableItems(Runnable runnable) {
        this.freeTierSlots.forEach(n -> this.getInventory().setItem(n.intValue(), null));
        this.premiumTierSlots.forEach(n -> this.getInventory().setItem(n.intValue(), null));
        this.drawRewards("free", this.freeTierSlots, this.freeCachedPageIndexes);
        this.drawRewards("premium", this.premiumTierSlots, this.premiumCachedPageIndexes);
        runnable.run();
        boolean bl = this.config.bool("draw-past-max-tier");
        int n2 = 0;
        for (int n3 : this.progressTrackSlots) {
            int n4 = (this.page - 1) * this.progressTrackSlots.size() + n2 + 1;
            if (n4 > this.passLoader.getMaxTier() && !bl) {
                this.flush(n3);
                continue;
            }
            this.item(MenuItem.builderOf(SpigotItem.toItem(this.config, "static-items.progress-track-".concat(this.user.getTier() < n4 ? "locked" : "unlocked").concat("-item"), replacer -> replacer.set("tier", n4).tryAddPapi((OfflinePlayer)this.player))).rawSlot(n3).build());
            ++n2;
        }
    }

    private void drawRewards(String string, List<Integer> list, Map<Integer, Set<Integer>> map) {
        TreeMap<Integer, Tier> treeMap = this.passLoader.passTypeOfId(string).getTiers();
        PassType passType = this.passLoader.passTypeOfId(string);
        map.computeIfAbsent(this.page, n -> {
            LinkedHashSet linkedHashSet = Sets.newLinkedHashSetWithExpectedSize((int)list.size());
            for (int i = 0; i < list.size(); ++i) {
                int n2 = (this.page - 1) * list.size() + i + 1;
                if (!treeMap.containsKey(n2) || this.hideTiersWithoutRewards && ((Tier)treeMap.get(n2)).getRewardIds().isEmpty()) continue;
                linkedHashSet.add(n2);
            }
            return linkedHashSet;
        });
        for (int n2 : map.get(this.page)) {
            Tier tier = treeMap.get(n2);
            if (tier == null) continue;
            this.item(MenuItem.builderOf(passType.tierToItem(this.plugin, this.rewardCache, this.user, string, tier, this.user.getTier() >= n2)).rawSlot(list.get(n2 - (list.size() * (this.page - 1) + 1))).onClick((menuItem, clickType) -> {
                int n = tier.getTier();
                if (this.user.getPlayer().getInventory().firstEmpty() == -1) {
                    this.plugin.getLang().external("inventory-full").to((CommandSender)this.player);
                } else if (!this.autoReceiveRewards && this.user.hasPendingTier(string, n)) {
                    if (this.closeOnClaim) {
                        this.close();
                    }
                    this.api.reward(this.user, string, tier.getTier(), true);
                    this.user.getPendingTiers(string).remove(n);
                    if (!this.closeOnClaim) {
                        this.redraw();
                    }
                }
            }).build());
        }
    }
}

