/*
 * Decompiled with CFR 0.152.
 */
package io.github.battlepass.menus.service;

import com.google.common.cache.Cache;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.github.battlepass.BattlePlugin;
import io.github.battlepass.actions.Action;
import io.github.battlepass.actions.CommandAction;
import io.github.battlepass.actions.ConsoleCommandAction;
import io.github.battlepass.actions.DynamicAction;
import io.github.battlepass.actions.MenuAction;
import io.github.battlepass.actions.MessageAction;
import io.github.battlepass.actions.SoundAction;
import io.github.battlepass.menus.MenuFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import me.hyfe.simplespigot.config.Config;
import me.hyfe.simplespigot.menu.Menu;
import me.hyfe.simplespigot.menu.item.MenuItem;
import me.hyfe.simplespigot.menu.service.MenuService;
import me.hyfe.simplespigot.text.replacer.Replace;
import me.hyfe.simplespigot.text.replacer.Replacer;
import org.bukkit.entity.Player;

public class MenuIllustrator {
    public void draw(Menu menu, Config config, MenuFactory menuFactory, Player player, Cache<String, Map<Integer, List<Action>>> cache, Map<String, Runnable> map, Replace replace) {
        Function<Integer, List> function = n -> {
            String string = menu.getClass().getSimpleName();
            Map map = (Map)cache.getIfPresent((Object)string);
            if (map != null && map.containsKey(n)) {
                return (List)map.get(n);
            }
            ArrayList arrayList = Lists.newArrayList();
            for (String string2 : config.stringList(String.format("menu.%s.actions", n))) {
                arrayList.add(Action.parse(string2));
            }
            try {
                ((Map)cache.get((Object)string, Maps::newHashMap)).put(n, arrayList);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return arrayList;
        };
        if (config.has("menu")) {
            for (String string : config.keys("menu", false)) {
                for (int n2 : MenuService.parseSlots(menu, config, "menu.", string)) {
                    if (n2 > menu.getRows() * 9 - 1) {
                        if (!menu.getMenuState().isRaw()) continue;
                        BattlePlugin.logger().severe(String.format("The specified slot %d in the menu %s is greater\n then the amount of slots in the menu (%d). Skipping the slot...", n2, menu.getTitle(), menu.getRows() * 9 - 1));
                        continue;
                    }
                    if (menu.getInventory().getItem(n2) != null) continue;
                    MenuItem.builder().rawSlot(n2).item(config, String.format("menu.%s.item", string), replace).onClick((menuItem, clickType) -> {
                        Replacer replacer = new Replacer().set("player", player.getName());
                        for (Action action : (List)function.apply(n2)) {
                            if (action instanceof MenuAction) {
                                ((MenuAction)action).accept(menuFactory, menu, player);
                                continue;
                            }
                            if (action instanceof MessageAction) {
                                ((MessageAction)action).accept(player, null);
                                continue;
                            }
                            if (action instanceof SoundAction) {
                                ((SoundAction)action).accept(player);
                                continue;
                            }
                            if (action instanceof CommandAction) {
                                ((CommandAction)action).accept(player, replacer);
                                continue;
                            }
                            if (action instanceof ConsoleCommandAction) {
                                ((ConsoleCommandAction)action).accept(replacer);
                                continue;
                            }
                            if (!(action instanceof DynamicAction)) continue;
                            for (Map.Entry entry : map.entrySet()) {
                                ((DynamicAction)action).accept((String)entry.getKey(), (Runnable)entry.getValue());
                            }
                        }
                    }).buildTo(menu);
                }
            }
        }
    }
}

