/*
 * Decompiled with CFR 0.152.
 */
package io.github.battlepass.objects.pass;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.github.battlepass.BattlePlugin;
import io.github.battlepass.actions.Action;
import io.github.battlepass.cache.RewardCache;
import io.github.battlepass.objects.pass.Tier;
import io.github.battlepass.objects.user.User;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import me.hyfe.simplespigot.config.Config;
import me.hyfe.simplespigot.item.SpigotItem;
import me.hyfe.simplespigot.text.Text;
import me.hyfe.simplespigot.text.replacer.Replace;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class PassType {
    private final Config config;
    private final String id;
    private final String name;
    private final String requiredPermission;
    private final int defaultPointsRequired;
    private final TreeMap<Integer, Tier> tiers = Maps.newTreeMap();
    private final List<Action> tierUpActions = Lists.newArrayList();

    public PassType(String string, Config config) {
        this.id = string;
        this.config = config;
        this.name = config.string("name");
        this.requiredPermission = config.string("required-permission");
        this.defaultPointsRequired = config.integer("default-points-required");
        for (String string2 : config.keys("tiers", false)) {
            if (!StringUtils.isNumeric((String)string2)) continue;
            int n = Integer.parseInt(string2);
            int n2 = config.has("tiers." + string2 + ".required-points") ? config.integer("tiers." + string2 + ".required-points") : this.defaultPointsRequired;
            List<String> list = config.stringList("tiers." + string2 + ".rewards");
            ItemStack itemStack = SpigotItem.toItem(this.config, "tiers." + string2 + ".locked-tier-item", replacer -> replacer.set("tier", n));
            ItemStack itemStack2 = SpigotItem.toItem(this.config, "tiers." + string2 + ".unlocked-tier-item", replacer -> replacer.set("tier", n));
            ItemStack itemStack3 = SpigotItem.toItem(this.config, "tiers." + string2 + ".claimed-tier-item", replacer -> replacer.set("tier", n));
            ItemStack itemStack4 = SpigotItem.toItem(this.config, "tiers." + string2 + ".doesnt-have-pass-item", replacer -> replacer.set("tier", n));
            this.tiers.put(n, new Tier(n, n2, list, itemStack, itemStack2, itemStack3, itemStack4));
        }
        for (String string2 : config.stringList("tier-up-actions")) {
            this.tierUpActions.add(Action.parse(string2));
        }
    }

    public Config getConfig() {
        return this.config;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getRequiredPermission() {
        return this.requiredPermission;
    }

    public int getDefaultPointsRequired() {
        return this.defaultPointsRequired;
    }

    public BigInteger getTotalPoints(int n) {
        BigInteger bigInteger = BigInteger.ZERO;
        for (int i = 2; i <= n; ++i) {
            bigInteger = bigInteger.add(BigInteger.valueOf(this.tiers.containsKey(i) ? (long)this.tiers.get(i).getRequiredPoints() : (long)this.defaultPointsRequired));
        }
        return bigInteger;
    }

    public TreeMap<Integer, Tier> getTiers() {
        return this.tiers;
    }

    public List<Action> getTierUpActions() {
        return this.tierUpActions;
    }

    public ItemStack tierToItem(BattlePlugin battlePlugin, RewardCache rewardCache, User user, String string, Tier tier, boolean bl) {
        boolean bl2 = user.hasPassId(string) && (string.equals("premium") || user.getPassId().equals("free") || !this.config.bool("dont-give-premium-free-rewards"));
        boolean bl3 = user.getPendingTiers(string) != null && !user.getPendingTiers(string).contains(tier.getTier());
        Replace replace = replacer -> replacer.set("tier", tier.getTier()).set("points", user.getPoints()).set("required_points", battlePlugin.getLocalApi().getRequiredPoints(tier.getTier(), string));
        String string2 = this.config.has("items.".concat("doesnt-have-pass-item")) ? (bl2 ? (bl ? (bl3 ? "claimed-tier-item" : "unlocked-tier-item") : "locked-tier-item") : "doesnt-have-pass-item") : (bl ? (bl3 ? "claimed-tier-item" : "unlocked-tier-item") : "locked-tier-item");
        ItemStack itemStack = SpigotItem.toItem(this.config, "items.".concat(string2), replace);
        ItemStack itemStack2 = tier.getItem(string2);
        if (itemStack2 != null && !itemStack2.getType().equals((Object)Material.DIRT)) {
            itemStack = itemStack2;
        }
        this.updateLore(rewardCache, tier, itemStack);
        return itemStack;
    }

    private void updateLore(RewardCache rewardCache, Tier tier, ItemStack itemStack) {
        if (itemStack.getItemMeta() == null || itemStack.getItemMeta().getLore() == null) {
            return;
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        ArrayList arrayList = Lists.newArrayList();
        for (String string : itemMeta.getLore()) {
            if (string.contains("%lore_addon%")) {
                for (String string2 : tier.getRewardIds()) {
                    rewardCache.get(string2).ifPresent(reward -> arrayList.addAll(Text.modify(reward.getLoreAddon())));
                }
                continue;
            }
            arrayList.add(string);
        }
        itemMeta.setLore((List)arrayList);
        itemStack.setItemMeta(itemMeta);
    }
}

