/*
 * Decompiled with CFR 0.152.
 */
package io.github.battlepass.objects.user;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.github.battlepass.objects.user.QuestStore;
import java.math.BigInteger;
import java.util.Map;
import java.util.TreeSet;
import java.util.UUID;
import java.util.function.IntUnaryOperator;
import java.util.function.UnaryOperator;
import me.hyfe.simplespigot.annotations.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class User {
    private final UUID uuid;
    private final QuestStore questStore;
    private String passId;
    private int tier;
    private BigInteger points;
    private BigInteger currency;
    private boolean bypassLockedWeeks;
    private final Map<String, TreeSet<Integer>> pendingTiers;

    public User(UUID uUID) {
        this(uUID, new QuestStore(), 1, BigInteger.ZERO, BigInteger.ZERO, "free", false, Maps.newHashMap());
    }

    public User(UUID uUID, QuestStore questStore, int n, BigInteger bigInteger, BigInteger bigInteger2, String string, boolean bl, Map<String, TreeSet<Integer>> map) {
        this.uuid = uUID;
        this.questStore = questStore;
        this.tier = n;
        this.passId = string;
        this.points = bigInteger;
        this.currency = bigInteger2;
        this.bypassLockedWeeks = bl;
        this.pendingTiers = map;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    @Nullable
    public Player getPlayer() {
        return Bukkit.getPlayer((UUID)this.uuid);
    }

    public QuestStore getQuestStore() {
        return this.questStore;
    }

    public String getPassId() {
        return this.passId;
    }

    public void setPassId(String string) {
        this.passId = string;
    }

    public boolean hasPassId(String string) {
        return this.passId.equalsIgnoreCase(string) || this.passId.equalsIgnoreCase("premium") && string.equalsIgnoreCase("free");
    }

    public int getTier() {
        return this.tier;
    }

    public int updateTier(IntUnaryOperator intUnaryOperator) {
        this.tier = intUnaryOperator.applyAsInt(this.tier);
        return this.tier;
    }

    public BigInteger getPoints() {
        return this.points;
    }

    public BigInteger updatePoints(UnaryOperator<BigInteger> unaryOperator) {
        this.points = (BigInteger)unaryOperator.apply(this.points);
        return this.points;
    }

    public BigInteger setPoints(UnaryOperator<BigInteger> unaryOperator) {
        this.points = (BigInteger)unaryOperator.apply(BigInteger.ZERO);
        return this.points;
    }

    public BigInteger getCurrency() {
        return this.currency;
    }

    public BigInteger updateCurrency(UnaryOperator<BigInteger> unaryOperator) {
        this.currency = (BigInteger)unaryOperator.apply(this.currency);
        return this.currency;
    }

    public boolean bypassesLockedWeeks() {
        return this.bypassLockedWeeks;
    }

    public boolean toggleBypassLockedWeeks() {
        this.bypassLockedWeeks = !this.bypassLockedWeeks;
        return this.bypassLockedWeeks;
    }

    public Map<String, TreeSet<Integer>> getPendingTiers() {
        return this.pendingTiers;
    }

    public TreeSet<Integer> getPendingTiers(String string) {
        return this.pendingTiers.get(string);
    }

    public boolean hasPendingTier(String string, int n) {
        if (this.pendingTiers.containsKey(string)) {
            return this.pendingTiers.get(string).contains(n);
        }
        return false;
    }

    public void addPendingTier(String string, int n) {
        this.pendingTiers.putIfAbsent(string, Sets.newTreeSet());
        this.pendingTiers.get(string).add(n);
    }
}

