/*
 * Decompiled with CFR 0.152.
 */
package io.github.battlepass.placeholders;

import io.github.battlepass.BattlePlugin;
import io.github.battlepass.api.BattlePassApi;
import io.github.battlepass.cache.QuestCache;
import io.github.battlepass.cache.UserCache;
import io.github.battlepass.controller.UserController;
import io.github.battlepass.lang.Lang;
import io.github.battlepass.loader.PassLoader;
import io.github.battlepass.objects.user.User;
import io.github.battlepass.quests.workers.reset.DailyQuestReset;
import java.text.DecimalFormat;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import me.hyfe.simplespigot.service.simple.Simple;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;

public class PlaceholderApiHook
extends PlaceholderExpansion {
    private Lang lang;
    private BattlePassApi api;
    private UserCache userCache;
    private PassLoader passLoader;
    private QuestCache questCache;
    private DailyQuestReset dailyQuestReset;
    private UserController userController;
    private ZonedDateTime seasonStartDate;
    private ZonedDateTime seasonEndDate;

    public PlaceholderApiHook(BattlePlugin battlePlugin) {
        this.setClassValues(battlePlugin);
        BattlePlugin.logger().info("Register PlaceholderAPI placeholders");
    }

    public String onRequest(OfflinePlayer offlinePlayer, String string) {
        switch (string) {
            case "test": {
                return "successful";
            }
            case "quest_amount": {
                return String.valueOf(this.questCache.getAllQuests().size());
            }
            case "time_to_daily_reset": {
                return this.dailyQuestReset.asString();
            }
            case "week": {
                return String.valueOf(this.api.getCurrentDisplayWeek());
            }
            case "time_to_next_week": {
                return this.api.hasSeasonEnded() ? "00:00" : Simple.time().format(TimeUnit.SECONDS, ChronoUnit.SECONDS.between(ZonedDateTime.now().withZoneSameInstant(this.api.getZone()), this.seasonStartDate.plusWeeks(this.api.getCurrentWeek())));
            }
            case "time_to_season_end": {
                String string2 = "season-finished-message";
                return this.api.hasSeasonEnded() ? (this.lang.has(string2) ? this.lang.external(string2).asString() : "Finished") : Simple.time().format(TimeUnit.SECONDS, ChronoUnit.SECONDS.between(ZonedDateTime.now().withZoneSameInstant(this.api.getZone()), this.seasonEndDate));
            }
        }
        if (offlinePlayer == null) {
            BattlePlugin.logger().warning("Could not get placeholder ".concat(string).concat(" (player null)"));
            return "???";
        }
        Optional optional = this.userCache.getSync(offlinePlayer.getUniqueId());
        if (!optional.isPresent()) {
            return "??? User not present";
        }
        User user = (User)optional.get();
        switch (string) {
            case "points": 
            case "experience": {
                return user.getPoints().toString();
            }
            case "points_formatted": 
            case "experience_formatted": {
                return this.format(user.getPoints().intValue());
            }
            case "tier": {
                return String.valueOf(user.getTier());
            }
            case "pass_type": {
                return this.passLoader.passTypeOfId(user.getPassId()).getName();
            }
            case "pass_id": {
                return user.getPassId();
            }
            case "balance": 
            case "currency": {
                return this.format(user.getCurrency().intValue());
            }
            case "completed_quests": {
                return String.valueOf(this.userController.getQuestsDone(user, true));
            }
            case "next_tier_points_total_free": {
                return this.format(this.api.getRequiredPoints(user.getTier(), "free"));
            }
            case "next_tier_points_required_free": {
                return this.format(this.api.getRequiredPoints(user.getTier(), "free") - user.getPoints().intValue());
            }
            case "next_tier_points_total_premium": {
                return this.format(this.api.getRequiredPoints(user.getTier(), "premium"));
            }
            case "next_tier_points_required_premium": {
                return this.format(this.api.getRequiredPoints(user.getTier(), "premium") - user.getPoints().intValue());
            }
        }
        if (string.startsWith("completed_quests_")) {
            String string3 = string.substring(17).replace(" ", "");
            if (string3.isEmpty()) {
                return "category empty";
            }
            return String.valueOf(this.userController.getQuestsDone(user, string3));
        }
        return "Invalid Placeholder";
    }

    @NotNull
    public String getIdentifier() {
        return "battlepass";
    }

    @NotNull
    public String getAuthor() {
        return "GC";
    }

    @NotNull
    public String getVersion() {
        return "1.1";
    }

    public boolean persist() {
        return true;
    }

    public void tryUnregister() {
    }

    public void setClassValues(BattlePlugin battlePlugin) {
        this.lang = battlePlugin.getLang();
        this.api = battlePlugin.getLocalApi();
        this.userCache = battlePlugin.getUserCache();
        this.passLoader = battlePlugin.getPassLoader();
        this.questCache = battlePlugin.getQuestCache();
        this.dailyQuestReset = battlePlugin.getDailyQuestReset();
        this.userController = battlePlugin.getUserController();
        this.seasonStartDate = battlePlugin.getSeasonStartDate();
        this.seasonEndDate = battlePlugin.getSeasonEndDate();
    }

    private String format(int n) {
        String[] stringArray = new String[]{"", "k", "m", "b", "t", "p", "e"};
        int n2 = 0;
        while (n / 1000 >= 1) {
            n /= 1000;
            ++n2;
        }
        return new DecimalFormat("#.##").format(n).concat(stringArray[n2]);
    }
}

