/*
 * Decompiled with CFR 0.152.
 */
package io.github.battlepass.quests.workers.pipeline.processors;

import io.github.battlepass.BattlePlugin;
import io.github.battlepass.controller.QuestController;
import io.github.battlepass.logger.DebugLogger;
import io.github.battlepass.logger.containers.LogContainer;
import io.github.battlepass.objects.quests.Quest;
import io.github.battlepass.objects.user.User;
import java.math.BigInteger;
import java.util.Collection;
import net.advancedplugins.bp.impl.actions.ActionExecution;
import org.bukkit.entity.Player;

public class AntiAbuseProcessor {
    private final QuestController controller;
    private final DebugLogger debugLogger;

    public AntiAbuseProcessor(BattlePlugin battlePlugin) {
        this.controller = battlePlugin.getQuestController();
        this.debugLogger = battlePlugin.getDebugLogger();
    }

    public void applyMeasures(ActionExecution actionExecution, Collection<Quest> collection) {
        String string = actionExecution.getQuestType();
        Player player = actionExecution.getPlayer();
        User user = (User)actionExecution.getUser();
        for (Quest quest : collection) {
            if (!quest.isAntiAbuse() || this.controller.isQuestDone(user, quest) || !string.equals("block-break") && !string.equals("block-place") || string.equalsIgnoreCase(quest.getType()) || !actionExecution.getQuestResult().isEligible(player, quest.getVariable())) {
                return;
            }
            this.debugLogger.log(LogContainer.of("Anti abuse measures applied for player %battlepass-player% on quest " + quest.getCategoryId() + ":" + quest.getId(), player));
            BigInteger bigInteger = this.controller.getQuestProgress(user, quest);
            if (bigInteger.compareTo(BigInteger.ZERO) <= 0) continue;
            this.controller.setQuestProgress(user, quest, bigInteger.subtract(actionExecution.getProgress()).max(BigInteger.ZERO).min(quest.getRequiredProgress()));
        }
    }
}

