/*
 * Decompiled with CFR 0.152.
 */
package io.github.battlepass.quests.workers.pipeline.steps;

import com.google.common.collect.Sets;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import io.github.battlepass.BattlePlugin;
import io.github.battlepass.api.BattlePassApi;
import io.github.battlepass.api.events.user.UserQuestProgressionEvent;
import io.github.battlepass.controller.QuestController;
import io.github.battlepass.enums.Category;
import io.github.battlepass.logger.DebugLogger;
import io.github.battlepass.logger.containers.LogContainer;
import io.github.battlepass.objects.quests.Quest;
import io.github.battlepass.objects.user.User;
import io.github.battlepass.quests.workers.pipeline.processors.AntiAbuseProcessor;
import io.github.battlepass.quests.workers.pipeline.steps.QuestCompletionStep;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import me.hyfe.simplespigot.config.Config;
import me.hyfe.simplespigot.service.Locks;
import net.advancedplugins.bp.impl.actions.ActionExecution;
import net.advancedplugins.bp.impl.actions.objects.variable.ExecutableActionResult;
import net.advancedplugins.bp.impl.actions.objects.variable.Variable;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class QuestValidationStep {
    private final AntiAbuseProcessor antiAbuseProcessor;
    private final QuestCompletionStep completionStep;
    private final BattlePlugin plugin;
    private final BattlePassApi api;
    private final DebugLogger debugLogger;
    private final QuestController controller;
    private final Set<String> whitelistedWorlds;
    private final Set<String> blacklistedWorlds;
    private final boolean lockPreviousWeeks;
    private final boolean requirePreviousCompletion;
    private final boolean disableDailiesOnSeasonEnd;
    private final boolean disableNormalsOnSeasonEnd;
    private final ReentrantLock questLock = Locks.newReentrantLock();

    public QuestValidationStep(BattlePlugin battlePlugin) {
        Config config = battlePlugin.getConfig("settings");
        this.antiAbuseProcessor = new AntiAbuseProcessor(battlePlugin);
        this.completionStep = new QuestCompletionStep(battlePlugin);
        this.plugin = battlePlugin;
        this.api = battlePlugin.getLocalApi();
        this.controller = battlePlugin.getQuestController();
        this.whitelistedWorlds = Sets.newHashSet(config.stringList("whitelisted-worlds"));
        this.blacklistedWorlds = Sets.newHashSet(config.stringList("blacklisted-worlds"));
        this.lockPreviousWeeks = config.bool("current-season.unlocks.lock-previous-weeks");
        this.requirePreviousCompletion = config.bool("current-season.unlocks.require-previous-completion");
        this.disableDailiesOnSeasonEnd = config.bool("season-finished.stop-daily-quests");
        this.disableNormalsOnSeasonEnd = config.bool("season-finished.stop-other-quests");
        this.debugLogger = battlePlugin.getDebugLogger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processCompletion(ActionExecution actionExecution, Collection<Quest> collection) {
        Player player = actionExecution.getPlayer();
        String string = player.getWorld().getName();
        if (this.areServerQuestsBlocked()) {
            this.debugLogger.log(LogContainer.of("(PIPELINE) Didn't progress for %battlepass-player% as season has ended and dailies & normals are disabled."));
            return;
        }
        if (this.isWorldServerBlocked(string)) {
            return;
        }
        this.antiAbuseProcessor.applyMeasures(actionExecution, collection);
        for (Quest quest : collection) {
            if (!actionExecution.getQuestType().equalsIgnoreCase(quest.getType())) continue;
            if (this.isQuestSeasonEndBlocked(quest)) {
                this.debugLogger.log(LogContainer.of("(PIPELINE) Didn't progress for %battlepass-player% and quests of this type are disabled on season end."));
                continue;
            }
            this.questLock.lock();
            try {
                this.proceed(actionExecution, quest);
            }
            finally {
                this.questLock.unlock();
            }
        }
    }

    public boolean proceed(ActionExecution actionExecution, Quest quest) {
        BigInteger bigInteger = this.controller.getQuestProgress((User)actionExecution.getUser(), quest);
        if (!this.isQuestValid(actionExecution, quest)) {
            return false;
        }
        if (this.isRegionQuestBlocked(actionExecution, quest)) {
            return false;
        }
        Variable variable = quest.getVariable();
        ExecutableActionResult executableActionResult = actionExecution.getQuestResult();
        if (executableActionResult == null || executableActionResult.isEligible(actionExecution.getPlayer(), variable)) {
            UserQuestProgressionEvent userQuestProgressionEvent = new UserQuestProgressionEvent(actionExecution, quest);
            Bukkit.getPluginManager().callEvent((Event)userQuestProgressionEvent);
            if (!userQuestProgressionEvent.isCancelled()) {
                this.completionStep.process(actionExecution, quest, bigInteger, actionExecution.getProgress());
            }
            return true;
        }
        return false;
    }

    public boolean isQuestPrimarilyValid(User user, Quest quest, BigInteger bigInteger, boolean bl) {
        boolean bl2;
        if (this.areServerQuestsBlocked() || this.isQuestSeasonEndBlocked(quest) || this.controller.isQuestDone(user, quest) || bl && this.isProgressIdentical(quest, user, bigInteger) || this.isPassTypeQuestBlocked(quest, user)) {
            return false;
        }
        int n = Category.stripWeek(quest.getCategoryId());
        boolean bl3 = bl2 = n == 0;
        if (!bl2 && !user.bypassesLockedWeeks() && ((long)n > this.api.getCurrentWeek() || this.lockPreviousWeeks && (long)n < this.api.getCurrentWeek())) {
            return false;
        }
        return !this.requirePreviousCompletion || bl2 || user.bypassesLockedWeeks() || !this.isPreviousWeekBlocked(user, n);
    }

    public boolean isQuestValid(ActionExecution actionExecution, Quest quest) {
        if (!this.isQuestPrimarilyValid((User)actionExecution.getUser(), quest, actionExecution.getProgress(), actionExecution.shouldOverrideUpdate())) {
            return false;
        }
        Player player = actionExecution.getPlayer();
        String string = player.getWorld().getName();
        return !this.isWorldQuestBlocked(quest, string);
    }

    private boolean areServerQuestsBlocked() {
        return this.api.hasSeasonEnded() && this.disableDailiesOnSeasonEnd && this.disableNormalsOnSeasonEnd;
    }

    private boolean isWorldServerBlocked(String string) {
        return !this.whitelistedWorlds.isEmpty() && !this.whitelistedWorlds.contains(string) || this.blacklistedWorlds.contains(string);
    }

    private boolean isQuestSeasonEndBlocked(Quest quest) {
        return this.api.hasSeasonEnded() && (quest.getCategoryId().contains("daily") && this.disableDailiesOnSeasonEnd || quest.getCategoryId().contains("week") && this.disableNormalsOnSeasonEnd);
    }

    private boolean isWorldQuestBlocked(Quest quest, String string) {
        return quest.getBlacklistedWorlds().contains(string) || !quest.getWhitelistedWorlds().isEmpty() && !quest.getWhitelistedWorlds().contains(string);
    }

    private boolean isPassTypeQuestBlocked(Quest quest, User user) {
        return quest.getExclusiveTo() != null && !quest.getExclusiveTo().equalsIgnoreCase(user.getPassId());
    }

    private boolean isProgressIdentical(Quest quest, User user, BigInteger bigInteger) {
        return this.controller.getQuestProgress(user, quest).compareTo(bigInteger) == 0;
    }

    private boolean isPreviousWeekBlocked(User user, int n) {
        for (int i = n - 1; i > 0; --i) {
            if (this.controller.isWeekDone(user, i)) continue;
            return true;
        }
        return false;
    }

    private boolean isRegionQuestBlocked(ActionExecution actionExecution, Quest quest) {
        ProtectedRegion protectedRegion;
        User user = (User)actionExecution.getUser();
        if (!this.plugin.getServer().getPluginManager().isPluginEnabled("WorldGuard")) {
            return false;
        }
        if (quest.getWhitelistedRegions().isEmpty() && quest.getBlacklistedRegions().isEmpty()) {
            return false;
        }
        RegionContainer regionContainer = WorldGuard.getInstance().getPlatform().getRegionContainer();
        RegionManager regionManager = regionContainer.get(BukkitAdapter.adapt((World)user.getPlayer().getWorld()));
        ApplicableRegionSet applicableRegionSet = regionContainer.createQuery().getApplicableRegions(BukkitAdapter.adapt((Location)user.getPlayer().getLocation()));
        if (regionManager == null) {
            return false;
        }
        if (!quest.getWhitelistedRegions().isEmpty()) {
            for (String string : quest.getWhitelistedRegions()) {
                protectedRegion = regionManager.getRegion(string);
                if (protectedRegion == null || !applicableRegionSet.getRegions().contains(protectedRegion)) continue;
                return false;
            }
        }
        if (!quest.getBlacklistedRegions().isEmpty()) {
            for (String string : quest.getBlacklistedRegions()) {
                protectedRegion = regionManager.getRegion(string);
                if (protectedRegion == null || !applicableRegionSet.getRegions().contains(protectedRegion)) continue;
                return true;
            }
        }
        return false;
    }
}

