/*
 * Decompiled with CFR 0.152.
 */
package io.github.battlepass.storage;

import io.github.battlepass.BattlePlugin;
import io.github.battlepass.enums.Category;
import io.github.battlepass.objects.quests.Quest;
import io.github.battlepass.quests.workers.reset.DailyQuestReset;
import io.github.battlepass.validator.DailyQuestValidator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import me.hyfe.simplespigot.json.TypeTokens;
import me.hyfe.simplespigot.storage.storage.Storage;
import me.hyfe.simplespigot.storage.storage.load.Deserializer;
import me.hyfe.simplespigot.storage.storage.load.Serializer;

public class DailyQuestStorage
extends Storage<DailyQuestReset> {
    private final BattlePlugin plugin;
    private final DailyQuestValidator validator;

    public DailyQuestStorage(BattlePlugin battlePlugin) {
        super(battlePlugin, backendFactory -> backendFactory.create(battlePlugin.getConfigStore().commons().get("storageMethod"), path -> path.resolve("misc-storage")));
        this.plugin = battlePlugin;
        this.validator = battlePlugin.getDailyQuestValidator();
    }

    @Override
    public Serializer<DailyQuestReset> serializer() {
        return (dailyQuestReset, jsonObject, gson) -> {
            jsonObject.addProperty("current-quests", gson.toJson(dailyQuestReset.getCurrentQuests().stream().map(Quest::getId).collect(Collectors.toList())));
            return jsonObject;
        };
    }

    @Override
    public Deserializer<DailyQuestReset> deserializer() {
        return (jsonObject, gson) -> {
            List list = (List)gson.fromJson(jsonObject.get("current-quests").getAsString(), TypeTokens.findType());
            LinkedList<Quest> linkedList = new LinkedList<Quest>();
            for (String string : list) {
                Quest quest = this.plugin.getQuestCache().getQuest(Category.DAILY.id(), string);
                if (!this.validator.checkQuest(quest)) continue;
                linkedList.add(quest);
            }
            return new DailyQuestReset(this.plugin, linkedList);
        };
    }
}

