/*
 * Decompiled with CFR 0.152.
 */
package me.hyfe.simplespigot.cache;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import me.hyfe.simplespigot.cache.CacheWrapper;
import me.hyfe.simplespigot.plugin.SimplePlugin;

public class FutureCache<K, V>
extends CacheWrapper<K, V> {
    protected final SimplePlugin plugin;

    public FutureCache(SimplePlugin simplePlugin) {
        this.plugin = simplePlugin;
    }

    public CompletableFuture<Optional<V>> get(K k) {
        return this.plugin.asyncCallback(() -> Optional.ofNullable(this.subCache.getIfPresent(k)));
    }

    public CompletableFuture<V> get(K k, Function<K, V> function) {
        return this.plugin.asyncCallback(() -> {
            Object object2 = this.subCache.getIfPresent(k);
            if (object2 == null) {
                this.subCache.put(k, function.apply(k));
            }
            return object2;
        });
    }

    public Optional<V> getSync(K k) {
        return Optional.ofNullable(this.subCache.getIfPresent(k));
    }
}

