/*
 * Decompiled with CFR 0.152.
 */
package me.hyfe.simplespigot.item;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import io.github.battlepass.BattlePlugin;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import me.hyfe.simplespigot.annotations.Nullable;
import me.hyfe.simplespigot.config.Config;
import me.hyfe.simplespigot.text.Text;
import me.hyfe.simplespigot.text.replacer.Replace;
import net.advancedplugins.ae.api.AEAPI;
import net.advancedplugins.bp.impl.actions.utils.MultiMaterial;
import net.advancedplugins.bp.impl.utils.nbt.backend.NBTItem;
import net.advancedplugins.bp.impl.utils.nbt.utils.MinecraftVersion;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class SpigotItem {
    public static Builder builder() {
        return new Builder();
    }

    @Nullable
    public static ItemStack toItemOrDefault(Config config, String string3, Replace replace, ItemStack itemStack) {
        ItemStack itemStack2;
        if (!config.has(string3)) {
            return itemStack;
        }
        UnaryOperator unaryOperator = string2 -> String.format("%s.%s", string3, string2);
        String string4 = config.string((String)unaryOperator.apply("material"));
        boolean bl = false;
        if (string4 != null) {
            String[] stringArray = string4.split(":");
            bl = stringArray[0].equalsIgnoreCase("head") && stringArray.length == 2;
        }
        boolean bl2 = config.getConfiguration().contains((String)unaryOperator.apply("advanced-heads"));
        ItemStack itemStack3 = itemStack2 = bl || bl2 ? null : MultiMaterial.parseItem(string4);
        if (itemStack2 == null && !bl && !bl2) {
            return null;
        }
        Builder builder = SpigotItem.builder().itemStack(itemStack2);
        SpigotItem.validatePath(config, (String)unaryOperator.apply("name"), string -> builder.name(Text.modify(config.string((String)unaryOperator.apply("name")), replace)));
        SpigotItem.validatePath(config, (String)unaryOperator.apply("lore"), string -> builder.lore(Text.modify(config.list((String)string), replace)));
        SpigotItem.validatePath(config, (String)unaryOperator.apply("amount"), string -> builder.amount(config.integer((String)string)));
        SpigotItem.validatePath(config, (String)unaryOperator.apply("rgb"), string -> builder.color(config.string((String)string)));
        SpigotItem.validatePath(config, (String)unaryOperator.apply("customModelData"), string -> builder.customModelData(config.integer((String)string)));
        if (config.bool((String)unaryOperator.apply("glow"))) {
            builder.glow();
        }
        config.stringList((String)unaryOperator.apply("item-flags")).forEach(builder::flag);
        config.stringList((String)unaryOperator.apply("enchants")).forEach(builder::enchant);
        if (bl) {
            String[] stringArray = string4.split(":");
            builder.head(Text.modify(stringArray[1], replace));
        } else if (bl2) {
            // empty if block
        }
        return builder.build();
    }

    @Nullable
    public static ItemStack toItem(Config config, String string, Replace replace) {
        return SpigotItem.toItemOrDefault(config, string, replace, null);
    }

    @Nullable
    public static ItemStack toItem(Config config, String string) {
        return SpigotItem.toItem(config, string, null);
    }

    private static void validatePath(Config config, String string, Consumer<String> consumer) {
        if (config.get(string) != null) {
            consumer.accept(string);
        }
    }

    public static class Builder {
        private ItemStack itemStack = new ItemStack(Material.DIRT);
        private Material material;
        private byte data;
        private int amount = 1;
        private String name;
        private List<String> lore = Lists.newArrayList();
        private Set<ItemFlag> itemFlags = Sets.newHashSet();
        private Map<Enchantment, Integer> enchants = Maps.newHashMap();
        private Map<String, Integer> customEnchants = Maps.newHashMap();
        private boolean doesGlow = false;
        private Color color;
        private int customModelData = 0;
        private String base64Head = null;
        private String ownerHead = null;
        private boolean isHead = false;

        public Builder itemStack(ItemStack itemStack) {
            this.itemStack = itemStack;
            return this;
        }

        public Builder item(Material material, int n) {
            this.material = material;
            this.data = (byte)n;
            return this;
        }

        public Builder item(String string, int n) {
            this.material = Material.matchMaterial((String)string);
            if (this.material == null && MinecraftVersion.isNew()) {
                this.material = Material.matchMaterial((String)string, (boolean)true);
            }
            this.data = (byte)n;
            return this;
        }

        public Builder item(Material material) {
            this.material = material;
            return this;
        }

        public Builder customModelData(int n) {
            this.customModelData = n;
            return this;
        }

        public Builder head(String string) {
            String string2 = MinecraftVersion.isNew() ? "PLAYER_HEAD" : "SKULL_ITEM";
            this.itemStack = new ItemStack(Material.valueOf((String)string2), 1, 3);
            this.data = (byte)3;
            this.isHead = true;
            this.base64Head = string.length() > 16 ? string : null;
            this.ownerHead = string.length() < 17 ? string : null;
            return this;
        }

        public Builder amount(int n) {
            this.amount = n;
            return this;
        }

        public Builder name(String string) {
            this.name = Text.modify(string);
            return this;
        }

        public Builder lore(List<String> list) {
            this.lore = Text.modify(list);
            return this;
        }

        public Builder lore(String ... stringArray) {
            this.lore = Text.modify(Arrays.asList(stringArray));
            return this;
        }

        public Builder flag(ItemFlag itemFlag) {
            this.itemFlags.add(itemFlag);
            return this;
        }

        public Builder flag(String string) {
            try {
                ItemFlag itemFlag = ItemFlag.valueOf((String)string.toUpperCase());
                this.itemFlags.add(itemFlag);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this;
        }

        public Builder enchant(Enchantment enchantment, int n) {
            this.enchants.put(enchantment, n);
            return this;
        }

        public Builder enchant(String string) {
            String[] stringArray = string.split(":");
            if (stringArray.length == 2) {
                String string2 = stringArray[0];
                int n = Integer.parseInt(stringArray[1]);
                if (((BattlePlugin)BattlePlugin.getPlugin(BattlePlugin.class)).getServer().getPluginManager().isPluginEnabled("AdvancedEnchantments") && AEAPI.isAnEnchantment((String)string2)) {
                    this.customEnchants.put(string2, n);
                } else {
                    Enchantment enchantment;
                    Enchantment enchantment2 = enchantment = MinecraftVersion.isNew() ? Enchantment.getByKey((NamespacedKey)NamespacedKey.minecraft((String)string2)) : Enchantment.getByName((String)string2);
                    if (enchantment == null) {
                        return this;
                    }
                    this.enchants.put(enchantment, n);
                }
            }
            return this;
        }

        public Builder glow() {
            this.doesGlow = true;
            return this;
        }

        public Builder color(String string) {
            if (!string.contains(",")) {
                return this;
            }
            String[] stringArray = string.replace(" ", "").split(",");
            if (stringArray.length != 3) {
                return this;
            }
            this.color = Color.fromRGB((int)Integer.parseInt(stringArray[0]), (int)Integer.parseInt(stringArray[1]), (int)Integer.parseInt(stringArray[2]));
            return this;
        }

        public Builder nbt(String string, String string2) {
            NBTItem nBTItem = new NBTItem(this.itemStack);
            nBTItem.setString(string, string2);
            this.itemStack = nBTItem.getItem();
            return this;
        }

        public Builder nbt(String string, boolean bl) {
            NBTItem nBTItem = new NBTItem(this.itemStack);
            nBTItem.setBoolean(string, bl);
            this.itemStack = nBTItem.getItem();
            return this;
        }

        public Builder nbt(String string, byte by) {
            NBTItem nBTItem = new NBTItem(this.itemStack);
            nBTItem.setByte(string, by);
            this.itemStack = nBTItem.getItem();
            return this;
        }

        public Builder nbt(String string, byte[] byArray) {
            NBTItem nBTItem = new NBTItem(this.itemStack);
            nBTItem.setByteArray(string, byArray);
            this.itemStack = nBTItem.getItem();
            return this;
        }

        public Builder nbt(String string, short s) {
            NBTItem nBTItem = new NBTItem(this.itemStack);
            nBTItem.setShort(string, s);
            this.itemStack = nBTItem.getItem();
            return this;
        }

        public Builder nbt(String string, int n) {
            NBTItem nBTItem = new NBTItem(this.itemStack);
            nBTItem.setInteger(string, n);
            this.itemStack = nBTItem.getItem();
            return this;
        }

        public Builder nbt(String string, int[] nArray) {
            NBTItem nBTItem = new NBTItem(this.itemStack);
            nBTItem.setIntArray(string, nArray);
            this.itemStack = nBTItem.getItem();
            return this;
        }

        public Builder nbt(String string, long l) {
            NBTItem nBTItem = new NBTItem(this.itemStack);
            nBTItem.setLong(string, l);
            this.itemStack = nBTItem.getItem();
            return this;
        }

        public Builder nbt(String string, float f) {
            NBTItem nBTItem = new NBTItem(this.itemStack);
            nBTItem.setFloat(string, Float.valueOf(f));
            this.itemStack = nBTItem.getItem();
            return this;
        }

        public Builder nbt(String string, double d) {
            NBTItem nBTItem = new NBTItem(this.itemStack);
            nBTItem.setDouble(string, d);
            this.itemStack = nBTItem.getItem();
            return this;
        }

        public Builder nbt(String string, Object object) {
            NBTItem nBTItem = new NBTItem(this.itemStack);
            nBTItem.setObject(string, object);
            this.itemStack = nBTItem.getItem();
            return this;
        }

        public ItemStack build() {
            return this.build(null);
        }

        public ItemStack build(UnaryOperator<NBTItem> unaryOperator) {
            if (this.material != null) {
                this.itemStack = new ItemStack(this.material, this.amount, (short)this.data);
            }
            if (this.amount > 0) {
                this.itemStack.setAmount(this.amount);
            }
            if (this.itemStack.getItemMeta() == null) {
                return this.itemStack;
            }
            ItemMeta itemMeta = this.itemStack.getItemMeta();
            this.itemStack.setItemMeta(this.createMeta(itemMeta));
            if (this.isHead) {
                SkullMeta skullMeta = (SkullMeta)this.itemStack.getItemMeta();
                if (this.base64Head != null) {
                    GameProfile object = new GameProfile(UUID.randomUUID(), "");
                    object.getProperties().put((Object)"textures", (Object)new Property("textures", this.base64Head));
                    Field field = null;
                    try {
                        field = skullMeta.getClass().getDeclaredField("profile");
                        field.setAccessible(true);
                        field.set(skullMeta, object);
                    }
                    catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException exception) {
                        exception.printStackTrace();
                    }
                } else {
                    skullMeta.setOwner(this.ownerHead);
                }
                this.itemStack.setItemMeta((ItemMeta)skullMeta);
            }
            if (!this.customEnchants.isEmpty()) {
                for (Map.Entry entry : this.customEnchants.entrySet()) {
                    AEAPI.applyEnchant((String)((String)entry.getKey()), (int)((Integer)entry.getValue()), (ItemStack)this.itemStack);
                }
            }
            if (unaryOperator == null) {
                return this.itemStack;
            }
            return ((NBTItem)unaryOperator.apply(new NBTItem(this.itemStack))).getItem();
        }

        public ItemMeta createMeta(ItemMeta itemMeta) {
            if (this.name != null) {
                itemMeta.setDisplayName(this.name);
            }
            if (this.customModelData != 0 && MinecraftVersion.isNew()) {
                itemMeta.setCustomModelData(Integer.valueOf(this.customModelData));
            }
            if (!(this.lore.isEmpty() || this.lore.get(0).isEmpty() && this.lore.size() < 2)) {
                itemMeta.setLore(this.lore);
            }
            if (!this.itemFlags.isEmpty()) {
                for (ItemFlag object : this.itemFlags) {
                    itemMeta.addItemFlags(new ItemFlag[]{object});
                }
            }
            if (!this.enchants.isEmpty()) {
                for (Map.Entry entry : this.enchants.entrySet()) {
                    itemMeta.addEnchant((Enchantment)entry.getKey(), ((Integer)entry.getValue()).intValue(), true);
                }
            }
            if (this.doesGlow) {
                itemMeta.addEnchant(Enchantment.DURABILITY, 1, true);
                itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            }
            if (this.color != null && itemMeta instanceof LeatherArmorMeta) {
                ((LeatherArmorMeta)itemMeta).setColor(this.color);
            }
            return itemMeta;
        }
    }
}

