/*
 * Decompiled with CFR 0.152.
 */
package me.hyfe.simplespigot.menu;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.hyfe.simplespigot.menu.item.MenuItem;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public abstract class Menu
implements InventoryHolder {
    protected final Player player;
    private String title;
    private int rows;
    private Inventory inventory;
    private MenuState menuState;
    private Runnable closeAction;
    private Map<Integer, MenuItem> menuItems = Maps.newHashMap();
    private BukkitTask updater;

    public Menu(Player player, String string, int n) {
        this.player = player;
        this.menuState = MenuState.RAW;
        this.title = string;
        this.rows = n;
    }

    public abstract void redraw();

    public Inventory getInventory() {
        return this.inventory;
    }

    public void show() {
        if (this.menuState.isRaw()) {
            this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)(this.rows * 9), (String)this.title);
            this.redraw();
            this.menuState = MenuState.ACTIVE;
        }
        this.player.openInventory(this.inventory);
    }

    public void close() {
        this.player.closeInventory();
    }

    public void preTitle(String string) {
        this.title = string;
    }

    public void preRows(int n) {
        this.rows = n;
    }

    public MenuItem getMenuItem(int n) {
        return this.menuItems.get(n);
    }

    public Runnable getCloseAction() {
        return this.closeAction;
    }

    public void setCloseAction(Runnable runnable) {
        this.closeAction = runnable;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public int getRows() {
        return this.rows;
    }

    public MenuState getMenuState() {
        return this.menuState;
    }

    public void addUpdater(Plugin plugin, int n) {
        this.updater = Bukkit.getScheduler().runTaskTimer(plugin, () -> {
            if (this.inventory.getHolder() != null && this.inventory.getHolder().equals(this.player.getOpenInventory().getTopInventory().getHolder())) {
                this.redraw();
            } else {
                this.updater.cancel();
            }
        }, 0L, (long)n);
    }

    public void flush() {
        for (int n : this.menuItems.keySet()) {
            this.inventory.setItem(n, null);
        }
        this.menuItems.clear();
    }

    public void flush(int n, int n2) {
        this.flush(this.gridToSlot(n, n2));
    }

    public void flush(int n) {
        if (!this.menuItems.containsKey(n)) {
            return;
        }
        this.menuItems.remove(n);
        this.inventory.setItem(n, null);
    }

    public void enduringRun(Runnable runnable) {
        if (this.menuState.isRaw()) {
            runnable.run();
        }
    }

    public <T> T enduringSupply(Supplier<T> supplier) {
        if (this.menuState.isRaw()) {
            return supplier.get();
        }
        return null;
    }

    public void item(MenuItem menuItem) {
        int n = this.gridToSlot(menuItem.getSlot(), menuItem.getRow());
        this.menuItems.put(n, menuItem);
        this.inventory.setItem(n, menuItem.getItemStack());
    }

    public Optional<Integer> firstEmpty() {
        int n = this.inventory.firstEmpty();
        return n < 0 ? Optional.empty() : Optional.of(n);
    }

    public void loopEmptyRawSlots(Consumer<Integer> consumer) {
        while (this.firstEmpty().isPresent()) {
            consumer.accept(this.firstEmpty().get());
        }
    }

    private int gridToSlot(int n, int n2) {
        return 9 * (n2 - 1) + (n - 1);
    }

    public static enum MenuState {
        RAW,
        ACTIVE;


        public boolean isRaw() {
            return this.equals((Object)RAW);
        }

        public boolean isActive() {
            return this.equals((Object)ACTIVE);
        }
    }
}

