/*
 * Decompiled with CFR 0.152.
 */
package me.hyfe.simplespigot.menu.listener;

import me.hyfe.simplespigot.menu.Menu;
import me.hyfe.simplespigot.menu.item.MenuItem;
import me.hyfe.simplespigot.menu.item.click.ClickAction;
import me.hyfe.simplespigot.menu.item.click.ClickType;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;

public class MenuListener
implements Listener {
    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOW)
    public void onInventoryClick(InventoryClickEvent inventoryClickEvent) {
        Inventory inventory = inventoryClickEvent.getInventory();
        InventoryAction inventoryAction = inventoryClickEvent.getAction();
        if (inventory.getHolder() instanceof Menu) {
            Menu menu = (Menu)inventory.getHolder();
            inventoryClickEvent.setCancelled(true);
            int n = inventoryClickEvent.getRawSlot();
            if (n < inventory.getSize() && !inventoryAction.equals((Object)InventoryAction.NOTHING)) {
                MenuItem menuItem = menu.getMenuItem(n);
                if (menuItem == null) {
                    return;
                }
                ClickAction clickAction = menuItem.getClickAction();
                if (clickAction == null) {
                    return;
                }
                clickAction.onClick(menuItem, ClickType.parse(inventoryAction));
            }
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onInventoryClose(InventoryCloseEvent inventoryCloseEvent) {
        Inventory inventory = inventoryCloseEvent.getInventory();
        if (inventory.getHolder() instanceof Menu) {
            Menu menu = (Menu)inventory.getHolder();
            Runnable runnable = menu.getCloseAction();
            if (runnable == null) {
                return;
            }
            runnable.run();
        }
    }
}

