/*
 * Decompiled with CFR 0.152.
 */
package me.hyfe.simplespigot.menu.service;

import com.google.common.base.Splitter;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.function.BiFunction;
import me.hyfe.simplespigot.config.Config;
import me.hyfe.simplespigot.menu.Menu;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class MenuService {
    public static Set<Integer> parseSlots(Menu menu, Config config, String string) {
        return MenuService.parseSlots(menu, config, "", string);
    }

    public static Set<Integer> parseSlots(Menu menu, Config config, String string, String string2) {
        Stack<Integer> stack = new Stack<Integer>();
        if (StringUtils.isNumeric((String)string2)) {
            return Sets.newHashSet((Object[])new Integer[]{Integer.parseInt(string2)});
        }
        String string3 = config.string(String.format("%s.slots", string.concat(string2))).replace(" ", "");
        Set<Integer> set = MenuService.parseSlots(menu, string3);
        if (set != null) {
            return set;
        }
        List list = Splitter.on((String)",").omitEmptyStrings().splitToList((CharSequence)string3);
        if (list.size() > 0) {
            for (String string4 : list) {
                Set<Integer> set2;
                if (StringUtils.isNumeric((String)string4)) {
                    stack.add(Integer.parseInt(string4));
                }
                if ((set2 = MenuService.parseSlots(menu, string4)) == null) continue;
                stack.addAll(set2);
            }
            return Sets.newLinkedHashSet(stack);
        }
        return Sets.newHashSet(stack);
    }

    public static Set<Integer> parseSlots(Menu menu, String string2) {
        BiFunction<Menu, String, String> biFunction = (menu2, string) -> string.equalsIgnoreCase("end") || string.equalsIgnoreCase("start") ? Integer.toString(string.equalsIgnoreCase("end") ? menu.getRows() * 9 - 1 : 0) : string;
        BiFunction<Menu, Integer, Integer> biFunction2 = (menu2, n) -> n < 0 ? 0 : Math.min(n, menu.getRows() * 9 - 1);
        LinkedHashSet linkedHashSet = Sets.newLinkedHashSet();
        String string3 = string2.replace(" ", "");
        if (string3.equalsIgnoreCase("fill")) {
            for (int i = 0; i < menu.getInventory().getSize(); ++i) {
                ItemStack itemStack = menu.getInventory().getItem(i);
                if (itemStack != null && !itemStack.getType().equals((Object)Material.AIR)) continue;
                linkedHashSet.add(i);
            }
            return linkedHashSet;
        }
        if (string3.equalsIgnoreCase("border")) {
            linkedHashSet.addAll(MenuService.getBorderSlots(menu));
            return linkedHashSet;
        }
        List list = Splitter.on((String)"...").omitEmptyStrings().splitToList((CharSequence)string3);
        if (list.size() == 2) {
            String string4 = biFunction.apply(menu, (String)list.get(0));
            String string5 = biFunction.apply(menu, (String)list.get(1));
            if (StringUtils.isNumeric((String)string4) && StringUtils.isNumeric((String)string5)) {
                for (int i = biFunction2.apply(menu, Integer.parseInt(string4)).intValue(); i <= biFunction2.apply(menu, Integer.parseInt(string5)); ++i) {
                    linkedHashSet.add(i);
                }
                return linkedHashSet;
            }
        }
        return null;
    }

    private static Set<Integer> getBorderSlots(Menu menu) {
        HashSet hashSet = Sets.newHashSet();
        if (menu.getRows() < 3) {
            Bukkit.getLogger().warning("You cannot use the border slot type with a menu with less than 3 rows.");
        } else {
            ItemStack itemStack;
            int n;
            for (n = 0; n < 9; ++n) {
                itemStack = menu.getInventory().getItem(n);
                if (itemStack != null && !itemStack.getType().equals((Object)Material.AIR)) continue;
                hashSet.add(n);
            }
            for (n = (menu.getRows() - 1) * 9; n < menu.getRows() * 9 - 1; ++n) {
                itemStack = menu.getInventory().getItem(n);
                if (itemStack != null && !itemStack.getType().equals((Object)Material.AIR)) continue;
                hashSet.add(n);
            }
            for (n = 9; n < menu.getRows() * 9; n += 9) {
                itemStack = menu.getInventory().getItem(n);
                if (itemStack != null && !itemStack.getType().equals((Object)Material.AIR)) continue;
                hashSet.add(n);
            }
            for (n = 8; n < menu.getRows() * 9; n += 9) {
                itemStack = menu.getInventory().getItem(n);
                if (itemStack != null && !itemStack.getType().equals((Object)Material.AIR)) continue;
                hashSet.add(n);
            }
        }
        return hashSet;
    }
}

