/*
 * Decompiled with CFR 0.152.
 */
package me.hyfe.simplespigot.service.simple.services;

import java.util.concurrent.TimeUnit;

public class TimeService {
    private final SimpleTimeFormat defaultFormat = new SimpleTimeFormat("%dy %dmo %dw %dd %dh %dm %ds", "%dmo %dw %dd %dh %dm %ds", "%dw %dd %dh %dm %ds", "%dd %dh %dm %ds", "%dh %dm %ds", "%dm %ds", "%ds");

    public String format(TimeUnit timeUnit, long l) {
        return this.format(this.defaultFormat, timeUnit, l);
    }

    public String format(SimpleTimeFormat simpleTimeFormat, TimeUnit timeUnit, long l) {
        long l2 = timeUnit.toSeconds(l);
        long l3 = l2 / 31536000L;
        long l4 = l2 % 31536000L / 2592000L;
        long l5 = l2 % 2592000L / 604800L;
        long l6 = l2 % 604800L / 86400L;
        long l7 = l2 % 86400L / 3600L;
        long l8 = l2 % 3600L / 60L;
        long l9 = l2 % 60L;
        if (l3 >= 1L) {
            return String.format(simpleTimeFormat.getYearsMonths(), l3, l4, l5, l6, l7, l8, l9);
        }
        if (l4 >= 1L) {
            return String.format(simpleTimeFormat.getMonthsWeeks(), l4, l5, l6, l7, l8, l9);
        }
        if (l5 >= 1L) {
            return String.format(simpleTimeFormat.getWeeksDays(), l5, l6, l7, l8, l9);
        }
        if (l6 >= 1L) {
            return String.format(simpleTimeFormat.getDaysHours(), l6, l7, l8, l9);
        }
        if (l7 >= 1L) {
            return String.format(simpleTimeFormat.getHoursMinutes(), l7, l8, l9);
        }
        if (l8 >= 1L) {
            return String.format(simpleTimeFormat.getMinutesSeconds(), l8, l9);
        }
        return String.format(simpleTimeFormat.getSeconds(), l9);
    }

    public static class SimpleTimeFormat {
        private final String yearsMonths;
        private final String monthsWeeks;
        private final String weeksDays;
        private final String daysHours;
        private final String hoursMinutes;
        private final String minutesSeconds;
        private final String seconds;

        public SimpleTimeFormat(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
            this.yearsMonths = string;
            this.monthsWeeks = string2;
            this.weeksDays = string3;
            this.daysHours = string4;
            this.hoursMinutes = string5;
            this.minutesSeconds = string6;
            this.seconds = string7;
        }

        public String getYearsMonths() {
            return this.yearsMonths;
        }

        public String getMonthsWeeks() {
            return this.monthsWeeks;
        }

        public String getWeeksDays() {
            return this.weeksDays;
        }

        public String getDaysHours() {
            return this.daysHours;
        }

        public String getHoursMinutes() {
            return this.hoursMinutes;
        }

        public String getMinutesSeconds() {
            return this.minutesSeconds;
        }

        public String getSeconds() {
            return this.seconds;
        }
    }
}

