/*
 * Decompiled with CFR 0.152.
 */
package me.hyfe.simplespigot.text.json;

import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import me.hyfe.simplespigot.text.json.ArrayWrapper;
import me.hyfe.simplespigot.text.json.JsonRepresentedObject;
import me.hyfe.simplespigot.text.json.JsonString;
import me.hyfe.simplespigot.text.json.MessagePart;
import me.hyfe.simplespigot.text.json.TextualComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.configuration.serialization.ConfigurationSerialization;
import org.bukkit.entity.Player;

public class JsonMessage
implements JsonRepresentedObject,
Cloneable,
Iterable<MessagePart>,
ConfigurationSerializable {
    private static JsonParser _stringParser = new JsonParser();
    private List<MessagePart> messageParts = new ArrayList<MessagePart>();
    private String jsonString;
    private boolean dirty;

    public JsonMessage(String string) {
        this(TextualComponent.rawText(string));
    }

    public JsonMessage(TextualComponent textualComponent) {
        this.messageParts.add(new MessagePart(textualComponent));
        this.jsonString = null;
        this.dirty = false;
    }

    public JsonMessage() {
        this((TextualComponent)null);
    }

    public static JsonMessage deserialize(Map<String, Object> map) {
        JsonMessage jsonMessage = new JsonMessage();
        jsonMessage.messageParts = (List)map.get("messageParts");
        jsonMessage.jsonString = map.containsKey("JSON") ? map.get("JSON").toString() : null;
        jsonMessage.dirty = !map.containsKey("JSON");
        return jsonMessage;
    }

    public static JsonMessage deserialize(String string) {
        JsonObject jsonObject = _stringParser.parse(string).getAsJsonObject();
        JsonArray jsonArray = jsonObject.getAsJsonArray("extra");
        JsonMessage jsonMessage = new JsonMessage();
        jsonMessage.messageParts.clear();
        for (JsonElement jsonElement : jsonArray) {
            MessagePart messagePart = new MessagePart();
            JsonObject jsonObject2 = jsonElement.getAsJsonObject();
            for (Map.Entry entry : jsonObject2.entrySet()) {
                Object object;
                if (TextualComponent.isTextKey((String)entry.getKey())) {
                    object = Maps.newHashMap();
                    object.put("key", entry.getKey());
                    if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                        object.put("value", ((JsonElement)entry.getValue()).getAsString());
                    } else {
                        for (Map.Entry entry2 : ((JsonElement)entry.getValue()).getAsJsonObject().entrySet()) {
                            object.put("value." + (String)entry2.getKey(), ((JsonElement)entry2.getValue()).getAsString());
                        }
                    }
                    messagePart.setText(TextualComponent.deserialize((Map<String, Object>)object));
                    continue;
                }
                if (MessagePart.stylesToNames.inverse().containsKey(entry.getKey())) {
                    if (!((JsonElement)entry.getValue()).getAsBoolean()) continue;
                    messagePart.getStyles().add((ChatColor)MessagePart.stylesToNames.inverse().get(entry.getKey()));
                    continue;
                }
                if (((String)entry.getKey()).equals("color")) {
                    messagePart.setColor(ChatColor.valueOf((String)((JsonElement)entry.getValue()).getAsString().toUpperCase()));
                    continue;
                }
                if (((String)entry.getKey()).equals("clickEvent")) {
                    object = ((JsonElement)entry.getValue()).getAsJsonObject();
                    messagePart.setClickActionName(object.get("action").getAsString());
                    messagePart.setClickActionData(object.get("value").getAsString());
                    continue;
                }
                if (((String)entry.getKey()).equals("hoverEvent")) {
                    object = ((JsonElement)entry.getValue()).getAsJsonObject();
                    messagePart.setHoverActionName(object.get("action").getAsString());
                    if (object.get("value").isJsonPrimitive()) {
                        messagePart.setHoverActionData(new JsonString(object.get("value").getAsString()));
                        continue;
                    }
                    messagePart.setHoverActionData(JsonMessage.deserialize(object.get("value").toString()));
                    continue;
                }
                if (((String)entry.getKey()).equals("insertion")) {
                    messagePart.setInsertionData(((JsonElement)entry.getValue()).getAsString());
                    continue;
                }
                if (!((String)entry.getKey()).equals("with")) continue;
                for (JsonElement jsonElement2 : ((JsonElement)entry.getValue()).getAsJsonArray()) {
                    if (jsonElement2.isJsonPrimitive()) {
                        messagePart.getTranslationReplacements().add(new JsonString(jsonElement2.getAsString()));
                        continue;
                    }
                    messagePart.getTranslationReplacements().add(JsonMessage.deserialize(jsonElement2.toString()));
                }
            }
            jsonMessage.messageParts.add(messagePart);
        }
        return jsonMessage;
    }

    public JsonMessage clone() {
        JsonMessage jsonMessage = (JsonMessage)super.clone();
        jsonMessage.messageParts = new ArrayList<MessagePart>(this.messageParts.size());
        for (int i = 0; i < this.messageParts.size(); ++i) {
            jsonMessage.messageParts.add(i, this.messageParts.get(i).clone());
        }
        jsonMessage.dirty = false;
        jsonMessage.jsonString = null;
        return jsonMessage;
    }

    public JsonMessage text(String string) {
        MessagePart messagePart = this.latest();
        messagePart.setText(TextualComponent.rawText(string));
        this.dirty = true;
        return this;
    }

    public JsonMessage text(TextualComponent textualComponent) {
        MessagePart messagePart = this.latest();
        messagePart.setText(textualComponent);
        this.dirty = true;
        return this;
    }

    public JsonMessage color(ChatColor chatColor) {
        this.latest().setColor(chatColor);
        this.dirty = true;
        return this;
    }

    public JsonMessage style(ChatColor ... chatColorArray) {
        for (ChatColor chatColor : chatColorArray) {
            if (chatColor.isFormat()) continue;
            throw new IllegalArgumentException(chatColor.name() + " is not a style");
        }
        this.latest().getStyles().addAll(Arrays.asList(chatColorArray));
        this.dirty = true;
        return this;
    }

    public JsonMessage file(String string) {
        this.onClick("open_file", string);
        return this;
    }

    public JsonMessage link(String string) {
        this.onClick("open_url", string);
        return this;
    }

    public JsonMessage suggest(String string) {
        this.onClick("suggest_command", string);
        return this;
    }

    public JsonMessage insert(String string) {
        this.latest().setInsertionData(string);
        this.dirty = true;
        return this;
    }

    public JsonMessage command(String string) {
        this.onClick("run_command", string);
        return this;
    }

    public JsonMessage achievementTooltip(String string) {
        this.onHover("show_achievement", new JsonString("achievement." + string));
        return this;
    }

    public JsonMessage tooltip(String string) {
        this.onHover("show_text", new JsonString(string));
        return this;
    }

    public JsonMessage tooltip(Iterable<String> iterable) {
        this.tooltip(ArrayWrapper.toArray(iterable, String.class));
        return this;
    }

    public JsonMessage tooltip(String ... stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuilder.append(stringArray[i]);
            if (i == stringArray.length - 1) continue;
            stringBuilder.append('\n');
        }
        this.tooltip(stringBuilder.toString());
        return this;
    }

    public JsonMessage formattedTooltip(JsonMessage jsonMessage) {
        for (MessagePart messagePart : jsonMessage.messageParts) {
            if (messagePart.getClickActionData() != null && messagePart.getClickActionName() != null) {
                throw new IllegalArgumentException("The tooltip text cannot have click data.");
            }
            if (messagePart.getHoverActionData() == null || messagePart.getHoverActionName() == null) continue;
            throw new IllegalArgumentException("The tooltip text cannot have a tooltip.");
        }
        this.onHover("show_text", jsonMessage);
        return this;
    }

    public JsonMessage formattedTooltip(JsonMessage ... jsonMessageArray) {
        if (jsonMessageArray.length < 1) {
            this.onHover(null, null);
            return this;
        }
        JsonMessage jsonMessage = new JsonMessage();
        jsonMessage.messageParts.clear();
        for (int i = 0; i < jsonMessageArray.length; ++i) {
            try {
                for (MessagePart messagePart : jsonMessageArray[i]) {
                    if (messagePart.getClickActionData() != null && messagePart.getClickActionName() != null) {
                        throw new IllegalArgumentException("The tooltip text cannot have click data.");
                    }
                    if (messagePart.getHoverActionData() != null && messagePart.getHoverActionName() != null) {
                        throw new IllegalArgumentException("The tooltip text cannot have a tooltip.");
                    }
                    if (!messagePart.hasText()) continue;
                    jsonMessage.messageParts.add(messagePart.clone());
                }
                if (i == jsonMessageArray.length - 1) continue;
                jsonMessage.messageParts.add(new MessagePart(TextualComponent.rawText("\n")));
                continue;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                Bukkit.getLogger().log(Level.WARNING, "Failed to clone object", cloneNotSupportedException);
                return this;
            }
        }
        return this.formattedTooltip(jsonMessage.messageParts.isEmpty() ? null : jsonMessage);
    }

    public JsonMessage formattedTooltip(Iterable<JsonMessage> iterable) {
        return this.formattedTooltip(ArrayWrapper.toArray(iterable, JsonMessage.class));
    }

    public JsonMessage translationReplacements(String ... stringArray) {
        for (String string : stringArray) {
            this.latest().getTranslationReplacements().add(new JsonString(string));
        }
        this.dirty = true;
        return this;
    }

    public JsonMessage translationReplacements(JsonMessage ... jsonMessageArray) {
        for (JsonMessage jsonMessage : jsonMessageArray) {
            this.latest().getTranslationReplacements().add(jsonMessage);
        }
        this.dirty = true;
        return this;
    }

    public JsonMessage translationReplacements(Iterable<JsonMessage> iterable) {
        return this.translationReplacements(ArrayWrapper.toArray(iterable, JsonMessage.class));
    }

    public JsonMessage then(String string) {
        return this.then(TextualComponent.rawText(string));
    }

    public JsonMessage then(TextualComponent textualComponent) {
        if (!this.latest().hasText()) {
            throw new IllegalStateException("previous message part has no text");
        }
        this.messageParts.add(new MessagePart(textualComponent));
        this.dirty = true;
        return this;
    }

    public JsonMessage then() {
        if (!this.latest().hasText()) {
            throw new IllegalStateException("previous message part has no text");
        }
        this.messageParts.add(new MessagePart());
        this.dirty = true;
        return this;
    }

    @Override
    public void writeJson(JsonWriter jsonWriter) {
        if (this.messageParts.size() == 1) {
            this.latest().writeJson(jsonWriter);
        } else {
            jsonWriter.beginObject().name("text").value("").name("extra").beginArray();
            for (MessagePart messagePart : this) {
                messagePart.writeJson(jsonWriter);
            }
            jsonWriter.endArray().endObject();
        }
    }

    public String toJSONString() {
        if (!this.dirty && this.jsonString != null) {
            return this.jsonString;
        }
        StringWriter stringWriter = new StringWriter();
        JsonWriter jsonWriter = new JsonWriter((Writer)stringWriter);
        try {
            this.writeJson(jsonWriter);
            jsonWriter.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException("invalid message");
        }
        this.jsonString = stringWriter.toString();
        this.dirty = false;
        return this.jsonString;
    }

    public void send(Player player) {
        this.send((CommandSender)player, this.toJSONString());
    }

    private void send(CommandSender commandSender, String string) {
        if (!(commandSender instanceof Player)) {
            commandSender.sendMessage(this.toOldMessageFormat());
            return;
        }
        Player player = (Player)commandSender;
        Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)("tellraw " + player.getName() + " " + string));
    }

    public void send(CommandSender commandSender) {
        this.send(commandSender, this.toJSONString());
    }

    public void send(Iterable<? extends CommandSender> iterable) {
        String string = this.toJSONString();
        for (CommandSender commandSender : iterable) {
            this.send(commandSender, string);
        }
    }

    public String toOldMessageFormat() {
        StringBuilder stringBuilder = new StringBuilder();
        for (MessagePart messagePart : this) {
            stringBuilder.append((Object)(messagePart.getColor() == null ? "" : messagePart.getColor()));
            for (ChatColor chatColor : messagePart.getStyles()) {
                stringBuilder.append(chatColor);
            }
            stringBuilder.append(messagePart.getText());
        }
        return stringBuilder.toString();
    }

    private MessagePart latest() {
        return this.messageParts.get(this.messageParts.size() - 1);
    }

    private void onClick(String string, String string2) {
        MessagePart messagePart = this.latest();
        messagePart.setClickActionName(string);
        messagePart.setClickActionData(string2);
        this.dirty = true;
    }

    private void onHover(String string, JsonRepresentedObject jsonRepresentedObject) {
        MessagePart messagePart = this.latest();
        messagePart.setHoverActionName(string);
        messagePart.setHoverActionData(jsonRepresentedObject);
        this.dirty = true;
    }

    public Map<String, Object> serialize() {
        HashMap hashMap = Maps.newHashMap();
        hashMap.put("messageParts", this.messageParts);
        return hashMap;
    }

    @Override
    public Iterator<MessagePart> iterator() {
        return this.messageParts.iterator();
    }

    static {
        ConfigurationSerialization.registerClass(JsonMessage.class);
    }
}

