/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.bp.impl.actions;

import java.math.BigInteger;
import java.util.function.UnaryOperator;
import javax.annotation.CheckReturnValue;
import net.advancedplugins.bp.impl.actions.ActionExecution;
import net.advancedplugins.bp.impl.actions.ActionRegistry;
import net.advancedplugins.bp.impl.actions.containers.ActionContainer;
import net.advancedplugins.bp.impl.actions.containers.ExternalActionContainer;
import net.advancedplugins.bp.impl.actions.objects.variable.ActionResult;
import net.advancedplugins.bp.impl.actions.objects.variable.ExecutableActionResult;
import net.advancedplugins.bp.impl.utils.ASManager;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ActionExecutionBuilder {
    private final String questType;
    private Player player;
    private BigInteger progress;
    private boolean overrideUpdate;
    private ExecutableActionResult questResult;
    private final ActionContainer container;

    public ActionExecutionBuilder(ActionContainer actionContainer, String string) {
        this.questType = string;
        this.container = actionContainer;
    }

    public void buildAndExecute() {
        if (this.player != null) {
            ActionExecution actionExecution = this.build();
            ActionRegistry.getRegistry().getReader().onAction(actionExecution);
        }
    }

    @CheckReturnValue
    public static ActionExecutionBuilder of(ActionContainer actionContainer, String string) {
        String string2 = actionContainer instanceof ExternalActionContainer ? ((ExternalActionContainer)actionContainer).getPrefix().concat(string) : string;
        return new ActionExecutionBuilder(actionContainer, string2);
    }

    public ActionExecution build() {
        String string = "QuestExecution Build -> %s must be set.";
        if (this.player == null) {
            throw new IllegalStateException(String.format(string, "Player"));
        }
        if (this.questType == null || this.questType.isEmpty()) {
            throw new IllegalStateException(String.format(string, "Quest type"));
        }
        if (this.progress == null) {
            throw new IllegalStateException(String.format(string, "Progress"));
        }
        if (this.questResult == null) {
            this.questResult = new ExecutableActionResult().root("none");
        }
        return new ActionExecution(this.player, this.questType, this.progress, this.overrideUpdate, this.questResult);
    }

    public ActionExecutionBuilder player(Player player) {
        this.player = player;
        return this;
    }

    @Deprecated
    public ActionExecutionBuilder questResult(UnaryOperator<ActionResult> unaryOperator) {
        this.questResult = (ExecutableActionResult)unaryOperator.apply(new ExecutableActionResult());
        return this;
    }

    public ActionExecutionBuilder root(String string) {
        if (this.questResult == null) {
            this.questResult = new ExecutableActionResult();
        }
        this.questResult.root(string);
        return this;
    }

    public ActionExecutionBuilder root(Block block) {
        ASManager.notNull(block, "Quest execution blocks");
        if (this.questResult == null) {
            this.questResult = new ExecutableActionResult();
        }
        this.questResult.root(block);
        return this;
    }

    public ActionExecutionBuilder root(ItemStack itemStack) {
        ASManager.notNull(itemStack, "Quest execution items");
        if (this.questResult == null) {
            this.questResult = new ExecutableActionResult();
        }
        this.questResult.root(itemStack);
        return this;
    }

    public ActionExecutionBuilder subRoot(String string, String string2) {
        if (this.questResult == null) {
            this.questResult = new ExecutableActionResult();
        }
        this.questResult.subRoot(string, string2);
        return this;
    }

    public ActionExecutionBuilder subRoot(ItemStack itemStack) {
        ASManager.notNull(itemStack, "Quest execution sub root items");
        return this.subRoot("item", itemStack.getType().toString());
    }

    public ActionExecutionBuilder progressSingle() {
        return this.progress(BigInteger.ONE);
    }

    public ActionExecutionBuilder progress(BigInteger bigInteger) {
        ASManager.notNull(bigInteger, "Quest execution progress");
        this.progress = bigInteger;
        return this;
    }

    public ActionExecutionBuilder progress(int n) {
        ASManager.notNull(n, "Quest execution progress");
        this.progress = BigInteger.valueOf(n);
        return this;
    }

    public ActionExecutionBuilder overrideUpdate() {
        this.overrideUpdate = true;
        return this;
    }
}

