/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.bp.impl.actions;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.plotsquared.core.api.PlotAPI;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import net.advancedplugins.bp.impl.actions.ActionsReader;
import net.advancedplugins.bp.impl.actions.containers.ActionContainer;
import net.advancedplugins.bp.impl.actions.containers.ExternalActionContainer;
import net.advancedplugins.bp.impl.actions.external.ASkyblockQuests;
import net.advancedplugins.bp.impl.actions.external.AdvancedEnchantmentsQuests;
import net.advancedplugins.bp.impl.actions.external.AuctionHouseKludgeQuests;
import net.advancedplugins.bp.impl.actions.external.AutoSellQuests;
import net.advancedplugins.bp.impl.actions.external.BedWars1058Quests;
import net.advancedplugins.bp.impl.actions.external.BenzimmerKothQuests;
import net.advancedplugins.bp.impl.actions.external.BuildBattleTigerQuests;
import net.advancedplugins.bp.impl.actions.external.ChatReactionQuests;
import net.advancedplugins.bp.impl.actions.external.CitizensQuests;
import net.advancedplugins.bp.impl.actions.external.ClansQuests;
import net.advancedplugins.bp.impl.actions.external.ClueScrollsQuests;
import net.advancedplugins.bp.impl.actions.external.CrateReloadedQuests;
import net.advancedplugins.bp.impl.actions.external.CratesPlusQuests;
import net.advancedplugins.bp.impl.actions.external.CrazyCratesQuestsNew;
import net.advancedplugins.bp.impl.actions.external.CrazyEnvoyQuests;
import net.advancedplugins.bp.impl.actions.external.DiscordMinecraftQuests;
import net.advancedplugins.bp.impl.actions.external.ExcellentCratesQuest;
import net.advancedplugins.bp.impl.actions.external.JobsQuests;
import net.advancedplugins.bp.impl.actions.external.LandsQuests;
import net.advancedplugins.bp.impl.actions.external.LobbyPresentsPoompkQuests;
import net.advancedplugins.bp.impl.actions.external.MBedwarsQuests;
import net.advancedplugins.bp.impl.actions.external.MMOCoreQuests;
import net.advancedplugins.bp.impl.actions.external.MMOItemsQuests;
import net.advancedplugins.bp.impl.actions.external.MoneyHuntersProQuests;
import net.advancedplugins.bp.impl.actions.external.MoneyHuntersQuests;
import net.advancedplugins.bp.impl.actions.external.MythicMobsQuests;
import net.advancedplugins.bp.impl.actions.external.PlaceholderApiQuests;
import net.advancedplugins.bp.impl.actions.external.PlotSquaredQuests;
import net.advancedplugins.bp.impl.actions.external.ProCosmeticsQuests;
import net.advancedplugins.bp.impl.actions.external.ShopGuiPlusQuests;
import net.advancedplugins.bp.impl.actions.external.ShopkeepersQuests;
import net.advancedplugins.bp.impl.actions.external.SkillApiQuests;
import net.advancedplugins.bp.impl.actions.external.StrikePracticeQuests;
import net.advancedplugins.bp.impl.actions.external.SubsideKothQuests;
import net.advancedplugins.bp.impl.actions.external.SuperiorSkyblockQuests;
import net.advancedplugins.bp.impl.actions.external.TheLabQuests;
import net.advancedplugins.bp.impl.actions.external.TokenEnchantQuests;
import net.advancedplugins.bp.impl.actions.external.USkyBlockQuests;
import net.advancedplugins.bp.impl.actions.external.UltraSkyWarsQuests;
import net.advancedplugins.bp.impl.actions.external.VotifierQuests;
import net.advancedplugins.bp.impl.actions.external.chestshop.ChestShopQuests;
import net.advancedplugins.bp.impl.actions.external.mcmmo.McMMOQuests;
import net.advancedplugins.bp.impl.actions.internal.BlockBreakAction;
import net.advancedplugins.bp.impl.actions.internal.BlockPlaceQuest;
import net.advancedplugins.bp.impl.actions.internal.BrewingQuest;
import net.advancedplugins.bp.impl.actions.internal.BucketPlaceQuest;
import net.advancedplugins.bp.impl.actions.internal.ChatQuest;
import net.advancedplugins.bp.impl.actions.internal.ClickQuest;
import net.advancedplugins.bp.impl.actions.internal.ConsumeQuest;
import net.advancedplugins.bp.impl.actions.internal.CraftQuest;
import net.advancedplugins.bp.impl.actions.internal.DamageQuest;
import net.advancedplugins.bp.impl.actions.internal.DeathAction;
import net.advancedplugins.bp.impl.actions.internal.EnchantQuests;
import net.advancedplugins.bp.impl.actions.internal.EntityBreedQuest;
import net.advancedplugins.bp.impl.actions.internal.ExecuteCommandQuest;
import net.advancedplugins.bp.impl.actions.internal.FishingQuest;
import net.advancedplugins.bp.impl.actions.internal.GainExpQuest;
import net.advancedplugins.bp.impl.actions.internal.HarvestCropsQuest;
import net.advancedplugins.bp.impl.actions.internal.HoneyExtractQuests;
import net.advancedplugins.bp.impl.actions.internal.ItemBreakQuest;
import net.advancedplugins.bp.impl.actions.internal.KillMobQuest;
import net.advancedplugins.bp.impl.actions.internal.KillPlayerQuest;
import net.advancedplugins.bp.impl.actions.internal.LoginQuest;
import net.advancedplugins.bp.impl.actions.internal.MilkQuest;
import net.advancedplugins.bp.impl.actions.internal.MovementQuests;
import net.advancedplugins.bp.impl.actions.internal.PlantCropsQuest;
import net.advancedplugins.bp.impl.actions.internal.PlayTimeQuest;
import net.advancedplugins.bp.impl.actions.internal.ProjectileQuest;
import net.advancedplugins.bp.impl.actions.internal.RegenerateQuest;
import net.advancedplugins.bp.impl.actions.internal.RideMobQuest;
import net.advancedplugins.bp.impl.actions.internal.ShearSheepQuest;
import net.advancedplugins.bp.impl.actions.internal.SmeltQuest;
import net.advancedplugins.bp.impl.actions.internal.TameQuest;
import net.advancedplugins.bp.impl.actions.utils.BlockCache;
import net.advancedplugins.bp.impl.actions.utils.Instantiator;
import net.advancedplugins.bp.impl.utils.PluginVersion;
import net.advancedplugins.bp.impl.utils.nbt.utils.MinecraftVersion;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitTask;

public class ActionRegistry {
    private final JavaPlugin plugin;
    private final PluginManager manager;
    private List<String> disabledHooks = new LinkedList<String>();
    private final Set<String> registeredHooks = Sets.newHashSet();
    private final Map<String, ImmutablePair<AtomicInteger, BukkitTask>> attempts = Maps.newHashMap();
    private static ActionRegistry registry;
    private final ActionsReader reader;
    private static final BlockCache blockCache;
    private static boolean ignoreBlockCache;
    private boolean enablePlaytime = true;

    public ActionRegistry(JavaPlugin javaPlugin, ActionsReader actionsReader, boolean bl, Set<String> set) {
        this.plugin = javaPlugin;
        this.manager = Bukkit.getPluginManager();
        this.reader = actionsReader;
        ignoreBlockCache = bl;
        registry = this;
        this.placeholderAPI(set);
    }

    public void register() {
        this.quest(BlockBreakAction::new, BlockPlaceQuest::new, ChatQuest::new, ClickQuest::new, ConsumeQuest::new, BucketPlaceQuest::new, CraftQuest::new, DamageQuest::new, DeathAction::new, EnchantQuests::new, ExecuteCommandQuest::new, FishingQuest::new, GainExpQuest::new, HoneyExtractQuests::new, ItemBreakQuest::new, KillMobQuest::new, KillPlayerQuest::new, LoginQuest::new, MilkQuest::new, MovementQuests::new, ProjectileQuest::new, RegenerateQuest::new, RideMobQuest::new, ShearSheepQuest::new, SmeltQuest::new, TameQuest::new);
        if (MinecraftVersion.isNew()) {
            this.quest(EntityBreedQuest::new, HarvestCropsQuest::new, PlantCropsQuest::new, BrewingQuest::new);
        }
        if (this.enablePlaytime) {
            new PlayTimeQuest(this.plugin);
        }
        this.hook("AdvancedEnchantments", AdvancedEnchantmentsQuests::new);
        this.hook("McMMO", McMMOQuests::new, (PluginVersion pluginVersion) -> pluginVersion.getMajor() >= 2);
        this.hook("ASkyblock", ASkyblockQuests::new);
        this.hook("AuctionHouse", AuctionHouseKludgeQuests::new, "klugemonkey");
        this.hook("AutoSell", AutoSellQuests::new, "extended_clip");
        this.hook("BedWars1058", BedWars1058Quests::new);
        this.hook("KOTH", BenzimmerKothQuests::new, "benzimmer123");
        this.hook("BuildBattle", BuildBattleTigerQuests::new, "Tigerpanzer");
        this.hook("ChatReaction", ChatReactionQuests::new);
        this.hook("ChestShop", ChestShopQuests::new, "https://github.com/ChestShop-authors/ChestShop-3/contributors", pluginVersion -> pluginVersion.getMajor() >= 3 && pluginVersion.getMinor() > 9);
        this.hook("Citizens", CitizensQuests::new);
        this.hook("Clans", ClansQuests::new);
        this.hook("ClueScrolls", ClueScrollsQuests::new);
        this.hook("CrateReloaded", CrateReloadedQuests::new);
        this.hook("CratesPlus", CratesPlusQuests::new);
        this.hook("CrazyCrates", CrazyCratesQuestsNew::new, (PluginVersion pluginVersion) -> pluginVersion.getMajor() >= 1 && pluginVersion.getMinor() >= 12);
        this.hook("DiscordMinecraft", DiscordMinecraftQuests::new);
        this.hook("ExcellentCrates", ExcellentCratesQuest::new, "NightExpress");
        this.hook("Jobs", JobsQuests::new);
        this.hook("Lands", LandsQuests::new);
        this.hook("LobbyPresents", LobbyPresentsPoompkQuests::new, "poompk");
        this.hook("KoTH", SubsideKothQuests::new, "SubSide");
        if (Bukkit.getPluginManager().isPluginEnabled("MoneyHunters")) {
            if (Bukkit.getPluginManager().getPlugin("MoneyHunters").getDescription().getVersion().endsWith("Pro")) {
                this.hook("MoneyHunters", MoneyHuntersProQuests::new);
            } else {
                this.hook("MoneyHunters", MoneyHuntersQuests::new);
            }
        }
        this.hook("MythicMobs", MythicMobsQuests::new, (PluginVersion pluginVersion) -> pluginVersion.getMajor() >= 5);
        this.hook("PlotSquared", PlotSquaredQuests::new);
        this.hook("ProCosmetics", ProCosmeticsQuests::new);
        this.hook("ShopGuiPlus", ShopGuiPlusQuests::new);
        this.hook("CrazyEnvoy", null, (PluginVersion pluginVersion) -> false);
        this.hook("CrazyEnvoys", CrazyEnvoyQuests::new, (PluginVersion pluginVersion) -> pluginVersion.getMajor() >= 1 && pluginVersion.getMinor() >= 5);
        this.hook("Shopkeepers", ShopkeepersQuests::new, "nisovin");
        this.hook("SkillAPI", SkillApiQuests::new);
        this.hook("StrikePractice", StrikePracticeQuests::new);
        this.hook("SuperiorSkyblock2", SuperiorSkyblockQuests::new);
        this.hook("TheLab", TheLabQuests::new);
        this.hook("TokenEnchant", TokenEnchantQuests::new);
        this.hook("UltraSkyWars", UltraSkyWarsQuests::new, "Leonardo0013YT");
        this.hook("uSkyBlock", USkyBlockQuests::new);
        this.hook("Votifier", VotifierQuests::new);
        this.hook("MMOCore", MMOCoreQuests::new);
        this.hook("MMOItems", MMOItemsQuests::new);
        this.hook("MBedwars", MBedwarsQuests::new);
        this.plugin.getLogger().info("Enabled " + this.getRegisteredHooks().size() + " actions.");
    }

    public Set<String> getRegisteredHooks() {
        return this.registeredHooks;
    }

    public List<String> getDisabledHooks() {
        return this.disabledHooks;
    }

    public void disableHook(String string) {
        this.disabledHooks.add(string.toLowerCase());
    }

    @SafeVarargs
    public final void quest(Instantiator<ActionContainer> ... instantiatorArray) {
        for (Instantiator<ActionContainer> instantiator : instantiatorArray) {
            Bukkit.getPluginManager().registerEvents((Listener)instantiator.init(this.plugin), (Plugin)this.plugin);
        }
    }

    public boolean hook(String string, Instantiator<ExternalActionContainer> instantiator, String string2) {
        if (this.isHookDisabled(string)) {
            return false;
        }
        Plugin plugin = this.manager.getPlugin(string);
        if (plugin != null && plugin.isEnabled()) {
            if (!this.isHookDisabled(string) && (string2.isEmpty() || plugin.getDescription().getAuthors().contains(string2))) {
                if (string.equalsIgnoreCase("PlotSquared")) {
                    int n = Integer.parseInt(plugin.getDescription().getVersion().replaceAll("[^0-9]", "").substring(0, 1));
                    if (n >= 6) {
                        try {
                            Class<?> clazz = Class.forName("com.plotsquared.core.PlotAPI");
                            Object obj = clazz.newInstance();
                            Method method = obj.getClass().getMethod("registerListener", Object.class);
                            method.invoke(obj, instantiator.init(this.plugin));
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    } else if (n >= 5) {
                        PlotAPI plotAPI = new PlotAPI();
                        plotAPI.registerListener((Object)instantiator.init(this.plugin));
                    } else {
                        this.manager.registerEvents((Listener)instantiator.init(this.plugin), (Plugin)this.plugin);
                    }
                } else {
                    this.manager.registerEvents((Listener)instantiator.init(this.plugin), (Plugin)this.plugin);
                }
                plugin.getLogger().info("Hooked into ".concat(string));
                this.registeredHooks.add(string);
            }
            return true;
        }
        return false;
    }

    public boolean hook(String string, Instantiator<ExternalActionContainer> instantiator, String string2, Predicate<PluginVersion> predicate) {
        if (this.isHookDisabled(string)) {
            return false;
        }
        Plugin plugin = this.manager.getPlugin(string);
        if (plugin != null && plugin.isEnabled()) {
            if (!this.isHookDisabled(string) && (string2.isEmpty() || plugin.getDescription().getAuthors().contains(string2))) {
                PluginVersion pluginVersion = this.extractVersion(plugin);
                plugin.getLogger().info("Using internal version as " + pluginVersion.toString() + " for loading " + string + ".");
                if (predicate.test(pluginVersion)) {
                    this.manager.registerEvents((Listener)instantiator.init(this.plugin), (Plugin)this.plugin);
                    plugin.getLogger().info("Hooked into ".concat(string));
                    this.registeredHooks.add(string);
                } else {
                    plugin.getLogger().info(string.concat(" was present but its version is not supported."));
                }
            }
            return true;
        }
        return false;
    }

    public boolean hook(String string, Instantiator<ExternalActionContainer> instantiator, Predicate<PluginVersion> predicate) {
        return this.hook(string, instantiator, "", predicate);
    }

    public boolean placeholderAPI(Set<String> set) {
        if (this.isHookDisabled("placeholderapi")) {
            return false;
        }
        if (Bukkit.getPluginManager().isPluginEnabled((Plugin)this.plugin)) {
            this.registeredHooks.add("PlaceholderAPI");
            new PlaceholderApiQuests(this.plugin, set);
            return true;
        }
        this.runRepeatingCheck("PlaceholderAPI", () -> {
            if (this.placeholderAPI(set)) {
                ((BukkitTask)this.attempts.get("PlaceholderAPI").getValue()).cancel();
            }
        });
        return false;
    }

    private void runRepeatingCheck(String string, Runnable runnable) {
        if (this.attempts.containsKey(string)) {
            return;
        }
        BukkitTask bukkitTask = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            int n = ((AtomicInteger)this.attempts.get(string).getKey()).incrementAndGet();
            if (n > 60) {
                ((BukkitTask)this.attempts.get(string).getValue()).cancel();
            }
            runnable.run();
        }, 200L, 200L);
        this.attempts.put(string, (ImmutablePair<AtomicInteger, BukkitTask>)ImmutablePair.of((Object)new AtomicInteger(), (Object)bukkitTask));
    }

    public boolean isHookDisabled(String string) {
        return this.getDisabledHooks().contains(string.toLowerCase());
    }

    private PluginVersion extractVersion(Plugin plugin) {
        int n;
        String string = plugin.getDescription().getVersion().split(" ")[0];
        String[] stringArray = string.split("\\.");
        int n2 = 0;
        int n3 = 0;
        switch (stringArray.length) {
            case 2: {
                n = this.entryToVersionNumber(stringArray[0]);
                n2 = this.entryToVersionNumber(stringArray[1]);
                break;
            }
            case 1: {
                n = this.entryToVersionNumber(stringArray[0]);
                break;
            }
            default: {
                n = this.entryToVersionNumber(stringArray[0]);
                n2 = this.entryToVersionNumber(stringArray[1]);
                n3 = this.entryToVersionNumber(stringArray[2]);
            }
        }
        return new PluginVersion().setMajor(n).setMinor(n2).setBugfix(n3);
    }

    public void hook(String string, Instantiator<ExternalActionContainer> instantiator) {
        this.hook(string, instantiator, "");
    }

    private int entryToVersionNumber(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (char c : string.toCharArray()) {
            if (!Character.isDigit(c)) break;
            stringBuilder.append(c);
        }
        if (stringBuilder.toString().isEmpty()) {
            return 0;
        }
        return Integer.parseInt(stringBuilder.toString());
    }

    public static ActionRegistry getRegistry() {
        return registry;
    }

    public ActionsReader getReader() {
        return this.reader;
    }

    public static BlockCache getBlockCache() {
        return blockCache;
    }

    public static boolean isIgnoreBlockCache() {
        return ignoreBlockCache;
    }

    public boolean isEnablePlaytime() {
        return this.enablePlaytime;
    }

    public void setEnablePlaytime(boolean bl) {
        this.enablePlaytime = bl;
    }

    static {
        blockCache = new BlockCache();
        ignoreBlockCache = false;
    }
}

