/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.bp.impl.actions.external;

import com.spawnchunk.auctionhouse.events.AuctionItemEvent;
import com.spawnchunk.auctionhouse.events.ItemAction;
import net.advancedplugins.bp.impl.actions.external.executor.ActionQuestExecutor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;

public class AuctionHouseKludgeQuests
extends ActionQuestExecutor {
    public AuctionHouseKludgeQuests(JavaPlugin javaPlugin) {
        super(javaPlugin, "auctionhouse_kludge");
    }

    @EventHandler(ignoreCancelled=true)
    public void onAuctionItemInteract(AuctionItemEvent auctionItemEvent) {
        Player player = auctionItemEvent.getSeller().getPlayer();
        int n = Math.round(auctionItemEvent.getPrice());
        ItemAction itemAction = auctionItemEvent.getItemAction();
        ItemStack itemStack = auctionItemEvent.getItem();
        if (player == null || itemAction == null) {
            return;
        }
        switch (itemAction) {
            case ITEM_LISTED: {
                this.execute("list", player, itemStack.getAmount(), actionResult -> actionResult.root(itemStack));
                this.execute("list_singular", player, actionResult -> actionResult.root(itemStack));
                break;
            }
            case ITEM_SOLD: {
                Player player2 = auctionItemEvent.getBuyer().getPlayer();
                if (player2 == null) {
                    return;
                }
                this.execute("buy_singular", player2, actionResult -> actionResult.root(itemStack));
                this.execute("sell_singular", player, actionResult -> actionResult.root(itemStack));
                this.execute("buy", player2, itemStack.getAmount(), actionResult -> actionResult.root(itemStack));
                this.execute("sell", player, itemStack.getAmount(), actionResult -> actionResult.root(itemStack));
                this.execute("profit", player, n, actionResult -> actionResult.root(itemStack));
                this.execute("spend", player2, n, actionResult -> actionResult.root(itemStack));
            }
        }
    }
}

