/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.bp.impl.actions.external;

import com.google.common.eventbus.Subscribe;
import com.plotsquared.core.events.PlayerAutoPlotEvent;
import com.plotsquared.core.events.PlayerClaimPlotEvent;
import com.plotsquared.core.events.PlayerEnterPlotEvent;
import com.plotsquared.core.events.PlayerPlotTrustedEvent;
import com.plotsquared.core.events.PlayerTeleportToPlotEvent;
import com.plotsquared.core.events.PlotRateEvent;
import java.util.Set;
import java.util.UUID;
import net.advancedplugins.bp.impl.actions.external.executor.ActionQuestExecutor;
import net.advancedplugins.bp.impl.actions.objects.variable.ActionResult;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class PlotSquaredQuests
extends ActionQuestExecutor {
    public PlotSquaredQuests(JavaPlugin javaPlugin) {
        super(javaPlugin, "plotsquared");
    }

    @Subscribe
    public void onPlayerAutoPlot(PlayerAutoPlotEvent playerAutoPlotEvent) {
        Player player = Bukkit.getPlayer((UUID)playerAutoPlotEvent.getPlayer().getUUID());
        this.execute("claim", player, actionResult -> actionResult.root("auto"));
    }

    @Subscribe
    public void onPlotClaim(PlayerClaimPlotEvent playerClaimPlotEvent) {
        Player player = Bukkit.getPlayer((UUID)playerClaimPlotEvent.getPlotPlayer().getUUID());
        this.execute("claim", player, actionResult -> actionResult.root("manual"));
    }

    @Subscribe
    public void onPlotEnter(PlayerEnterPlotEvent playerEnterPlotEvent) {
        Player player = Bukkit.getPlayer((UUID)playerEnterPlotEvent.getPlotPlayer().getUUID());
        Set set = playerEnterPlotEvent.getPlot().getOwners();
        if (set.size() == 1) {
            String string = Bukkit.getOfflinePlayer((UUID)((UUID)set.toArray()[0])).getName();
            this.execute("visit", player, actionResult -> actionResult.root(string));
            return;
        }
        this.execute("visit", player, ActionResult::none);
    }

    @Subscribe
    public void onPlotTrust(PlayerPlotTrustedEvent playerPlotTrustedEvent) {
        Player player = Bukkit.getPlayer((UUID)playerPlotTrustedEvent.getInitiator().getUUID());
        Player player2 = Bukkit.getPlayer((UUID)playerPlotTrustedEvent.getPlayer());
        this.execute("trust_player", player, ActionResult::none);
        this.execute("become_trusted", player2, ActionResult::none);
    }

    @Subscribe
    public void onPlotRate(PlotRateEvent plotRateEvent) {
        Player player = Bukkit.getPlayer((UUID)plotRateEvent.getRater().getUUID());
        this.execute("rate", player, ActionResult::none);
    }

    @Subscribe
    public void onTeleportToPlot(PlayerTeleportToPlotEvent playerTeleportToPlotEvent) {
        Player player = Bukkit.getPlayer((UUID)playerTeleportToPlotEvent.getPlotPlayer().getUUID());
        Set set = playerTeleportToPlotEvent.getPlot().getOwners();
        if (set.size() == 1) {
            String string = Bukkit.getOfflinePlayer((UUID)((UUID)set.toArray()[0])).getName();
            this.execute("teleport", player, actionResult -> actionResult.root(string));
            return;
        }
        this.execute("teleport", player, ActionResult::none);
    }
}

