/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.bp.impl.actions.external;

import com.sucy.skill.api.enums.ManaCost;
import com.sucy.skill.api.event.PlayerClassChangeEvent;
import com.sucy.skill.api.event.PlayerLevelUpEvent;
import com.sucy.skill.api.event.PlayerManaLossEvent;
import com.sucy.skill.api.event.PlayerSkillUnlockEvent;
import com.sucy.skill.api.event.PlayerSkillUpgradeEvent;
import com.sucy.skill.api.event.TrueDamageEvent;
import com.sucy.skill.api.skills.Skill;
import net.advancedplugins.bp.impl.actions.external.executor.ActionQuestExecutor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.plugin.java.JavaPlugin;

public class SkillApiQuests
extends ActionQuestExecutor {
    public SkillApiQuests(JavaPlugin javaPlugin) {
        super(javaPlugin, "skillapi");
    }

    @EventHandler(ignoreCancelled=true)
    public void onDamageDeal(TrueDamageEvent trueDamageEvent) {
        if (!(trueDamageEvent.getDamager() instanceof Player)) {
            return;
        }
        Player player = (Player)trueDamageEvent.getDamager();
        int n = (int)Math.round(trueDamageEvent.getDamage());
        Skill skill = trueDamageEvent.getSkill();
        String string = skill.getName();
        int n2 = skill.getCombo();
        this.execute("damage", player, n, actionResult -> actionResult.root(string));
        this.execute("combo", player, n2, actionResult -> actionResult.root(string), replacer -> replacer, true);
    }

    @EventHandler(ignoreCancelled=true)
    public void onSkillUpgrade(PlayerSkillUpgradeEvent playerSkillUpgradeEvent) {
        Player player = playerSkillUpgradeEvent.getPlayerData().getPlayer();
        String string = playerSkillUpgradeEvent.getUpgradedSkill().getData().getName();
        this.execute("upgrade", player, actionResult -> actionResult.root(string));
    }

    @EventHandler(ignoreCancelled=true)
    public void onSkillUnlock(PlayerSkillUnlockEvent playerSkillUnlockEvent) {
        Player player = playerSkillUnlockEvent.getPlayerData().getPlayer();
        String string = playerSkillUnlockEvent.getUnlockedSkill().getData().getName();
        this.execute("unlock", player, actionResult -> actionResult.root(string));
    }

    @EventHandler(ignoreCancelled=true)
    public void onManaLoss(PlayerManaLossEvent playerManaLossEvent) {
        Player player = playerManaLossEvent.getPlayerData().getPlayer();
        int n = (int)Math.round(playerManaLossEvent.getAmount());
        ManaCost manaCost = playerManaLossEvent.getSource();
        this.execute("loose_mana", player, n, actionResult -> actionResult.root(manaCost.toString()));
    }

    @EventHandler(ignoreCancelled=true)
    public void onLevelUp(PlayerLevelUpEvent playerLevelUpEvent) {
        Player player = playerLevelUpEvent.getPlayerData().getPlayer();
        int n = playerLevelUpEvent.getLevel();
        this.execute("reach_level", player, n, actionResult -> actionResult, replacer -> replacer, true);
    }

    @EventHandler(ignoreCancelled=true)
    public void onClassChange(PlayerClassChangeEvent playerClassChangeEvent) {
        Player player = playerClassChangeEvent.getPlayerData().getPlayer();
        String string = playerClassChangeEvent.getNewClass().getName();
        this.execute("change_class", player, actionResult -> actionResult.root(string));
    }
}

