/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.bp.impl.actions.internal;

import net.advancedplugins.bp.impl.actions.ActionRegistry;
import net.advancedplugins.bp.impl.actions.containers.ActionContainer;
import net.advancedplugins.bp.impl.utils.nbt.utils.MinecraftVersion;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.plugin.java.JavaPlugin;

public class BlockBreakAction
extends ActionContainer {
    private final JavaPlugin plugin;

    public BlockBreakAction(JavaPlugin javaPlugin) {
        super(javaPlugin);
        this.plugin = javaPlugin;
    }

    @EventHandler(ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent blockBreakEvent) {
        Player player = blockBreakEvent.getPlayer();
        Block block = blockBreakEvent.getBlock();
        if (block.hasMetadata("fakeBreak")) {
            return;
        }
        if (block.getType() == Material.FIRE || MinecraftVersion.getVersion().getVersionId() >= MinecraftVersion.MC1_16_R1.getVersionId() && block.getType() == Material.SOUL_FIRE) {
            return;
        }
        if (!ActionRegistry.isIgnoreBlockCache() && ActionRegistry.getBlockCache().removeIfExists(block.getLocation())) {
            return;
        }
        this.executionBuilder("block-break").player(player).root(block).progressSingle().buildAndExecute();
    }
}

